/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.convert;

import java.io.Serializable;
import org.bdgenomics.convert.ConversionException;
import org.bdgenomics.convert.ConversionStringency;
import org.bdgenomics.convert.Converter;
import org.slf4j.Logger;

public abstract class AbstractConverter<S, T>
implements Converter<S, T>,
Serializable {
    private final Class<?> sourceClass;
    private final Class<?> targetClass;

    protected AbstractConverter(Class<?> sourceClass, Class<?> targetClass) {
        if (sourceClass == null) {
            throw new NullPointerException("sourceClass must not be null");
        }
        if (targetClass == null) {
            throw new NullPointerException("targetClass must not be null");
        }
        this.sourceClass = sourceClass;
        this.targetClass = targetClass;
    }

    @Override
    public final Class<?> getSourceClass() {
        return this.sourceClass;
    }

    @Override
    public final Class<?> getTargetClass() {
        return this.targetClass;
    }

    protected final void checkNotNull(Object value) {
        if (value == null) {
            throw new NullPointerException("value must not be null");
        }
    }

    protected final void checkNotNull(Converter<?, ?> converter) {
        if (converter == null) {
            throw new NullPointerException("converter must not be null");
        }
    }

    protected final void checkNotNull(ConversionStringency stringency, Logger logger) {
        if (stringency == null) {
            throw new NullPointerException("stringency must not be null");
        }
        if (logger == null) {
            throw new NullPointerException("logger must not be null");
        }
    }

    protected final void warnOrThrow(S source, String message, Throwable cause, ConversionStringency stringency, Logger logger) throws ConversionException {
        this.checkNotNull(stringency, logger);
        if (stringency.isLenient()) {
            if (cause != null) {
                logger.warn(String.format("could not convert %s to %s, %s", this.sourceClass.toString(), this.targetClass.toString(), message), cause);
            } else {
                logger.warn("could not convert {} to {}, {}", new Object[]{this.sourceClass.toString(), this.targetClass.toString(), message});
            }
        } else if (stringency.isStrict()) {
            throw new ConversionException(String.format("could not convert %s to %s, %s", this.sourceClass.toString(), this.targetClass.toString(), message), cause, source, this.sourceClass, this.targetClass);
        }
    }
}

