/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.convert;

public final class ConversionException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final Object source;
    private final Class<?> sourceClass;
    private final Class<?> targetClass;

    public ConversionException(String message, Object source, Class<?> sourceClass, Class<?> targetClass) {
        this(message, null, source, sourceClass, targetClass);
    }

    public ConversionException(Throwable cause, Object source, Class<?> sourceClass, Class<?> targetClass) {
        this(null, cause, source, sourceClass, targetClass);
    }

    public ConversionException(String message, Throwable cause, Object source, Class<?> sourceClass, Class<?> targetClass) {
        super(message, cause);
        if (sourceClass == null) {
            throw new NullPointerException("sourceClass must not be null");
        }
        if (targetClass == null) {
            throw new NullPointerException("targetClass must not be null");
        }
        this.source = source;
        this.sourceClass = sourceClass;
        this.targetClass = targetClass;
    }

    public Object getSource() {
        return this.source;
    }

    public Class<?> getSourceClass() {
        return this.sourceClass;
    }

    public Class<?> getTargetClass() {
        return this.targetClass;
    }
}

