/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.convert.bdgenomics;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import org.bdgenomics.convert.Converter;
import org.bdgenomics.convert.bdgenomics.DbxrefToString;
import org.bdgenomics.convert.bdgenomics.ImpactToString;
import org.bdgenomics.convert.bdgenomics.OntologyTermToString;
import org.bdgenomics.convert.bdgenomics.ReadToSequence;
import org.bdgenomics.convert.bdgenomics.ReadToSlice;
import org.bdgenomics.convert.bdgenomics.SequenceToRead;
import org.bdgenomics.convert.bdgenomics.SequenceToSlice;
import org.bdgenomics.convert.bdgenomics.SliceToRead;
import org.bdgenomics.convert.bdgenomics.SliceToSequence;
import org.bdgenomics.convert.bdgenomics.StrandToString;
import org.bdgenomics.convert.bdgenomics.StringToDbxref;
import org.bdgenomics.convert.bdgenomics.StringToImpact;
import org.bdgenomics.convert.bdgenomics.StringToOntologyTerm;
import org.bdgenomics.convert.bdgenomics.StringToStrand;
import org.bdgenomics.convert.bdgenomics.StringToTranscriptEffect;
import org.bdgenomics.convert.bdgenomics.StringToVariantAnnotationMessage;
import org.bdgenomics.convert.bdgenomics.TranscriptEffectToString;
import org.bdgenomics.convert.bdgenomics.VariantAnnotationMessageToString;
import org.bdgenomics.formats.avro.Dbxref;
import org.bdgenomics.formats.avro.Impact;
import org.bdgenomics.formats.avro.OntologyTerm;
import org.bdgenomics.formats.avro.Read;
import org.bdgenomics.formats.avro.Sequence;
import org.bdgenomics.formats.avro.Slice;
import org.bdgenomics.formats.avro.Strand;
import org.bdgenomics.formats.avro.TranscriptEffect;
import org.bdgenomics.formats.avro.VariantAnnotationMessage;

public final class BdgenomicsModule
extends AbstractModule {
    @Override
    protected void configure() {
    }

    @Provides
    @Singleton
    Converter<String, Dbxref> createStringToDbxref() {
        return new StringToDbxref();
    }

    @Provides
    @Singleton
    Converter<Dbxref, String> createDbxrefToString() {
        return new DbxrefToString();
    }

    @Provides
    @Singleton
    Converter<String, Impact> createStringToImpact() {
        return new StringToImpact();
    }

    @Provides
    @Singleton
    Converter<Impact, String> createImpactToString() {
        return new ImpactToString();
    }

    @Provides
    @Singleton
    Converter<String, OntologyTerm> createStringToOntologyTerm() {
        return new StringToOntologyTerm();
    }

    @Provides
    @Singleton
    Converter<OntologyTerm, String> createOntologyTermToString() {
        return new OntologyTermToString();
    }

    @Provides
    @Singleton
    Converter<String, Strand> createStringToStrand() {
        return new StringToStrand();
    }

    @Provides
    @Singleton
    Converter<Strand, String> createStrandToString() {
        return new StrandToString();
    }

    @Provides
    @Singleton
    Converter<String, TranscriptEffect> createStringToTranscriptEffect(Converter<String, Impact> impactConverter, Converter<String, VariantAnnotationMessage> variantAnnotationMessageConverter) {
        return new StringToTranscriptEffect(impactConverter, variantAnnotationMessageConverter);
    }

    @Provides
    @Singleton
    Converter<TranscriptEffect, String> createTranscriptEffectToString(Converter<Impact, String> impactConverter, Converter<VariantAnnotationMessage, String> variantAnnotationMessageConverter) {
        return new TranscriptEffectToString(impactConverter, variantAnnotationMessageConverter);
    }

    @Provides
    @Singleton
    Converter<String, VariantAnnotationMessage> createStringToVariantAnnotationMessage() {
        return new StringToVariantAnnotationMessage();
    }

    @Provides
    @Singleton
    Converter<VariantAnnotationMessage, String> createVariantAnnotationMessageToString() {
        return new VariantAnnotationMessageToString();
    }

    @Provides
    @Singleton
    Converter<Read, Sequence> createReadToSequence() {
        return new ReadToSequence();
    }

    @Provides
    @Singleton
    Converter<Read, Slice> createReadToSlice() {
        return new ReadToSlice();
    }

    @Provides
    @Singleton
    Converter<Sequence, Read> createSequenceToRead() {
        return new SequenceToRead();
    }

    @Provides
    @Singleton
    Converter<Sequence, Slice> createSequenceToSlice() {
        return new SequenceToSlice();
    }

    @Provides
    @Singleton
    Converter<Slice, Read> createSliceToRead() {
        return new SliceToRead();
    }

    @Provides
    @Singleton
    Converter<Slice, Sequence> createSliceToSequence() {
        return new SliceToSequence();
    }
}

