/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.convert.bdgenomics;

import org.bdgenomics.convert.AbstractConverter;
import org.bdgenomics.convert.ConversionException;
import org.bdgenomics.convert.ConversionStringency;
import org.bdgenomics.formats.avro.Read;
import org.bdgenomics.formats.avro.Slice;
import org.bdgenomics.formats.avro.Strand;
import org.slf4j.Logger;

final class ReadToSlice
extends AbstractConverter<Read, Slice> {
    ReadToSlice() {
        super(Read.class, Slice.class);
    }

    @Override
    public Slice convert(Read read, ConversionStringency stringency, Logger logger) throws ConversionException {
        if (read == null) {
            this.warnOrThrow(read, "must not be null", null, stringency, logger);
            return null;
        }
        return Slice.newBuilder().setName(read.getName()).setDescription(read.getDescription()).setAlphabet(read.getAlphabet()).setSequence(read.getSequence()).setLength(read.getLength()).setStart(0L).setEnd(read.getLength()).setStrand(Strand.INDEPENDENT).setAttributes(read.getAttributes()).build();
    }
}

