/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.convert.bdgenomics;

import org.bdgenomics.convert.AbstractConverter;
import org.bdgenomics.convert.ConversionException;
import org.bdgenomics.convert.ConversionStringency;
import org.bdgenomics.formats.avro.Read;
import org.bdgenomics.formats.avro.Sequence;
import org.slf4j.Logger;

final class SequenceToRead
extends AbstractConverter<Sequence, Read> {
    SequenceToRead() {
        super(Sequence.class, Read.class);
    }

    @Override
    public Read convert(Sequence sequence, ConversionStringency stringency, Logger logger) throws ConversionException {
        if (sequence == null) {
            this.warnOrThrow(sequence, "must not be null", null, stringency, logger);
            return null;
        }
        return Read.newBuilder().setName(sequence.getName()).setDescription(sequence.getDescription()).setAlphabet(sequence.getAlphabet()).setSequence(sequence.getSequence()).setLength(sequence.getLength()).setQualityScores(SequenceToRead.unknownQualityScores(sequence.getLength() == null ? 0 : sequence.getLength().intValue())).setAttributes(sequence.getAttributes()).build();
    }

    static String unknownQualityScores(int length) {
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            sb.append("B");
        }
        return sb.toString();
    }
}

