/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.convert.bdgenomics;

import org.bdgenomics.convert.AbstractConverter;
import org.bdgenomics.convert.ConversionException;
import org.bdgenomics.convert.ConversionStringency;
import org.bdgenomics.formats.avro.Sequence;
import org.bdgenomics.formats.avro.Slice;
import org.bdgenomics.formats.avro.Strand;
import org.slf4j.Logger;

final class SequenceToSlice
extends AbstractConverter<Sequence, Slice> {
    SequenceToSlice() {
        super(Sequence.class, Slice.class);
    }

    @Override
    public Slice convert(Sequence sequence, ConversionStringency stringency, Logger logger) throws ConversionException {
        if (sequence == null) {
            this.warnOrThrow(sequence, "must not be null", null, stringency, logger);
            return null;
        }
        return Slice.newBuilder().setName(sequence.getName()).setDescription(sequence.getDescription()).setAlphabet(sequence.getAlphabet()).setSequence(sequence.getSequence()).setLength(sequence.getLength()).setStart(0L).setEnd(sequence.getLength()).setStrand(Strand.INDEPENDENT).setAttributes(sequence.getAttributes()).build();
    }
}

