/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.convert.bdgenomics;

import org.bdgenomics.convert.AbstractConverter;
import org.bdgenomics.convert.ConversionException;
import org.bdgenomics.convert.ConversionStringency;
import org.bdgenomics.formats.avro.Read;
import org.bdgenomics.formats.avro.Slice;
import org.slf4j.Logger;

final class SliceToRead
extends AbstractConverter<Slice, Read> {
    SliceToRead() {
        super(Slice.class, Read.class);
    }

    @Override
    public Read convert(Slice slice, ConversionStringency stringency, Logger logger) throws ConversionException {
        if (slice == null) {
            this.warnOrThrow(slice, "must not be null", null, stringency, logger);
            return null;
        }
        return Read.newBuilder().setName(slice.getName()).setDescription(slice.getDescription()).setAlphabet(slice.getAlphabet()).setSequence(slice.getSequence()).setLength(slice.getLength()).setQualityScores(SliceToRead.unknownQualityScores(slice.getLength() == null ? 0 : slice.getLength().intValue())).setAttributes(slice.getAttributes()).build();
    }

    static String unknownQualityScores(int length) {
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            sb.append("B");
        }
        return sb.toString();
    }
}

