/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.convert.bdgenomics;

import org.bdgenomics.convert.AbstractConverter;
import org.bdgenomics.convert.ConversionException;
import org.bdgenomics.convert.ConversionStringency;
import org.bdgenomics.formats.avro.Strand;
import org.slf4j.Logger;

final class StrandToString
extends AbstractConverter<Strand, String> {
    StrandToString() {
        super(Strand.class, String.class);
    }

    @Override
    public String convert(Strand strand, ConversionStringency stringency, Logger logger) throws ConversionException {
        if (strand == null) {
            this.warnOrThrow(strand, "must not be null", null, stringency, logger);
            return null;
        }
        switch (strand) {
            case FORWARD: {
                return "+";
            }
            case REVERSE: {
                return "-";
            }
            case INDEPENDENT: {
                return ".";
            }
            case UNKNOWN: {
                return "?";
            }
        }
        return "";
    }
}

