/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.convert.bdgenomics;

import org.bdgenomics.convert.AbstractConverter;
import org.bdgenomics.convert.ConversionException;
import org.bdgenomics.convert.ConversionStringency;
import org.bdgenomics.formats.avro.Strand;
import org.slf4j.Logger;

final class StringToStrand
extends AbstractConverter<String, Strand> {
    StringToStrand() {
        super(String.class, Strand.class);
    }

    @Override
    public Strand convert(String value, ConversionStringency stringency, Logger logger) throws ConversionException {
        if (value == null) {
            this.warnOrThrow(value, "must not be null", null, stringency, logger);
            return null;
        }
        if ("+".equals(value)) {
            return Strand.FORWARD;
        }
        if ("-".equals(value)) {
            return Strand.REVERSE;
        }
        if (".".equals(value)) {
            return Strand.INDEPENDENT;
        }
        if ("?".equals(value)) {
            return Strand.UNKNOWN;
        }
        this.warnOrThrow(value, "incorrectly formatted Strand, should be one of { +, -, ., ? }", null, stringency, logger);
        return null;
    }
}

