/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.convert.bdgenomics;

import java.util.List;
import java.util.stream.Collectors;
import org.bdgenomics.convert.AbstractConverter;
import org.bdgenomics.convert.ConversionException;
import org.bdgenomics.convert.ConversionStringency;
import org.bdgenomics.convert.Converter;
import org.bdgenomics.formats.avro.Impact;
import org.bdgenomics.formats.avro.TranscriptEffect;
import org.bdgenomics.formats.avro.VariantAnnotationMessage;
import org.biojava.nbio.adam.shaded.com.google.common.base.Splitter;
import org.slf4j.Logger;

final class StringToTranscriptEffect
extends AbstractConverter<String, TranscriptEffect> {
    private final Converter<String, Impact> impactConverter;
    private final Converter<String, VariantAnnotationMessage> variantAnnotationMessageConverter;

    StringToTranscriptEffect(Converter<String, Impact> impactConverter, Converter<String, VariantAnnotationMessage> variantAnnotationMessageConverter) {
        super(String.class, TranscriptEffect.class);
        this.checkNotNull(impactConverter);
        this.checkNotNull(variantAnnotationMessageConverter);
        this.impactConverter = impactConverter;
        this.variantAnnotationMessageConverter = variantAnnotationMessageConverter;
    }

    @Override
    public TranscriptEffect convert(String value, ConversionStringency stringency, Logger logger) throws ConversionException {
        if (value == null) {
            this.warnOrThrow(value, "must not be null", null, stringency, logger);
            return null;
        }
        List<String> tokens = Splitter.on("|").splitToList(value);
        if (tokens.size() != 16) {
            this.warnOrThrow(value, "value must have sixteen fields ( Allele | Annotation | Annotation_Impact | Gene_Name | Gene_ID | Feature_Type | Feature_ID | Transcript_BioType | Rank / Total | HGVS.c | HGVS.p | cDNA.pos / cDNA.length | CDS.pos / CDS.length | AA.pos / AA.length | Distance | MESSAGES / WARNINGS / INFO)", null, stringency, logger);
            return null;
        }
        TranscriptEffect transcriptEffect = null;
        try {
            String alternateAllele = StringToTranscriptEffect.emptyToNull(tokens.get(0));
            List<String> effects = this.splitEffects(tokens.get(1));
            String impact = StringToTranscriptEffect.emptyToNull(tokens.get(2));
            String geneName = StringToTranscriptEffect.emptyToNull(tokens.get(3));
            String geneId = StringToTranscriptEffect.emptyToNull(tokens.get(4));
            String featureType = StringToTranscriptEffect.emptyToNull(tokens.get(5));
            String featureId = StringToTranscriptEffect.emptyToNull(tokens.get(6));
            String biotype = StringToTranscriptEffect.emptyToNull(tokens.get(7));
            Integer rank = StringToTranscriptEffect.numerator(tokens.get(8));
            Integer total = StringToTranscriptEffect.denominator(tokens.get(8));
            String transcriptHgvs = StringToTranscriptEffect.emptyToNull(tokens.get(9));
            String proteinHgvs = StringToTranscriptEffect.emptyToNull(tokens.get(10));
            Integer cdnaPosition = StringToTranscriptEffect.numerator(tokens.get(11));
            Integer cdnaLength = StringToTranscriptEffect.denominator(tokens.get(11));
            Integer cdsPosition = StringToTranscriptEffect.numerator(tokens.get(12));
            Integer cdsLength = StringToTranscriptEffect.denominator(tokens.get(12));
            Integer proteinPosition = StringToTranscriptEffect.numerator(tokens.get(13));
            Integer proteinLength = StringToTranscriptEffect.denominator(tokens.get(13));
            Integer distance = StringToTranscriptEffect.emptyToNullInteger(tokens.get(14));
            List<VariantAnnotationMessage> messages = this.splitMessages(tokens.get(15), stringency, logger);
            transcriptEffect = TranscriptEffect.newBuilder().setAlternateAllele(alternateAllele).setEffects(effects).setImpact(impact == null ? null : this.impactConverter.convert(impact, stringency, logger)).setGeneName(geneName).setGeneId(geneId).setFeatureType(featureType).setFeatureId(featureId).setBiotype(biotype).setRank(rank).setTotal(total).setTranscriptHgvs(transcriptHgvs).setProteinHgvs(proteinHgvs).setCdnaPosition(cdnaPosition).setCdnaLength(cdnaLength).setCodingSequencePosition(cdsPosition).setCodingSequenceLength(cdsLength).setProteinPosition(proteinPosition).setProteinLength(proteinLength).setDistance(distance).setMessages(messages).build();
        }
        catch (NumberFormatException e) {
            this.warnOrThrow(value, "could not parse transcript effect", e, stringency, logger);
        }
        return transcriptEffect;
    }

    List<String> splitEffects(String s2) {
        return Splitter.on("&").omitEmptyStrings().splitToList(s2);
    }

    List<VariantAnnotationMessage> splitMessages(String s2, ConversionStringency stringency, Logger logger) throws ConversionException {
        return Splitter.on("&").omitEmptyStrings().splitToList(s2).stream().map(m3 -> this.variantAnnotationMessageConverter.convert((String)m3, stringency, logger)).collect(Collectors.toList());
    }

    static String emptyToNull(String s2) {
        return "".equals(s2) ? null : s2;
    }

    static Integer emptyToNullInteger(String s2) {
        return "".equals(s2) ? null : Integer.valueOf(Integer.parseInt(s2));
    }

    static Integer numerator(String s2) {
        if ("".equals(s2)) {
            return null;
        }
        String[] tokens = s2.split("/");
        return StringToTranscriptEffect.emptyToNullInteger(tokens[0]);
    }

    static Integer denominator(String s2) {
        if ("".equals(s2)) {
            return null;
        }
        String[] tokens = s2.split("/");
        return tokens.length < 2 ? null : StringToTranscriptEffect.emptyToNullInteger(tokens[1]);
    }
}

