/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.convert.bdgenomics;

import java.util.HashMap;
import java.util.Map;
import org.bdgenomics.convert.AbstractConverter;
import org.bdgenomics.convert.ConversionException;
import org.bdgenomics.convert.ConversionStringency;
import org.bdgenomics.formats.avro.VariantAnnotationMessage;
import org.biojava.nbio.adam.shaded.com.google.common.collect.ImmutableMap;
import org.slf4j.Logger;

final class StringToVariantAnnotationMessage
extends AbstractConverter<String, VariantAnnotationMessage> {
    private static final Map<String, VariantAnnotationMessage> MESSAGES;

    StringToVariantAnnotationMessage() {
        super(String.class, VariantAnnotationMessage.class);
    }

    @Override
    public VariantAnnotationMessage convert(String value, ConversionStringency stringency, Logger logger) throws ConversionException {
        if (value == null) {
            this.warnOrThrow(value, "must not be null", null, stringency, logger);
            return null;
        }
        VariantAnnotationMessage message = MESSAGES.get(value);
        if (message == null) {
            this.warnOrThrow(value, "incorrectly formatted VariantAnnotationMessage", null, stringency, logger);
        }
        return message;
    }

    static {
        HashMap<String, VariantAnnotationMessage> messages = new HashMap<String, VariantAnnotationMessage>();
        for (VariantAnnotationMessage message : VariantAnnotationMessage.values()) {
            messages.put(message.name(), message);
        }
        messages.put("E1", VariantAnnotationMessage.ERROR_CHROMOSOME_NOT_FOUND);
        messages.put("E2", VariantAnnotationMessage.ERROR_OUT_OF_CHROMOSOME_RANGE);
        messages.put("W1", VariantAnnotationMessage.WARNING_REF_DOES_NOT_MATCH_GENOME);
        messages.put("W2", VariantAnnotationMessage.WARNING_SEQUENCE_NOT_AVAILABLE);
        messages.put("W3", VariantAnnotationMessage.WARNING_TRANSCRIPT_INCOMPLETE);
        messages.put("W4", VariantAnnotationMessage.WARNING_TRANSCRIPT_MULTIPLE_STOP_CODONS);
        messages.put("W5", VariantAnnotationMessage.WARNING_TRANSCRIPT_NO_START_CODON);
        messages.put("I1", VariantAnnotationMessage.INFO_REALIGN_3_PRIME);
        messages.put("I2", VariantAnnotationMessage.INFO_COMPOUND_ANNOTATION);
        messages.put("I3", VariantAnnotationMessage.INFO_NON_REFERENCE_ANNOTATION);
        MESSAGES = ImmutableMap.copyOf(messages);
    }
}

