/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.convert.bdgenomics;

import java.util.List;
import java.util.stream.Collectors;
import org.bdgenomics.convert.AbstractConverter;
import org.bdgenomics.convert.ConversionException;
import org.bdgenomics.convert.ConversionStringency;
import org.bdgenomics.convert.Converter;
import org.bdgenomics.formats.avro.Impact;
import org.bdgenomics.formats.avro.TranscriptEffect;
import org.bdgenomics.formats.avro.VariantAnnotationMessage;
import org.biojava.nbio.adam.shaded.com.google.common.base.Joiner;
import org.slf4j.Logger;

final class TranscriptEffectToString
extends AbstractConverter<TranscriptEffect, String> {
    private final Converter<Impact, String> impactConverter;
    private final Converter<VariantAnnotationMessage, String> variantAnnotationMessageConverter;

    TranscriptEffectToString(Converter<Impact, String> impactConverter, Converter<VariantAnnotationMessage, String> variantAnnotationMessageConverter) {
        super(TranscriptEffect.class, String.class);
        this.checkNotNull(impactConverter);
        this.checkNotNull(variantAnnotationMessageConverter);
        this.impactConverter = impactConverter;
        this.variantAnnotationMessageConverter = variantAnnotationMessageConverter;
    }

    @Override
    public String convert(TranscriptEffect transcriptEffect, ConversionStringency stringency, Logger logger) throws ConversionException {
        if (transcriptEffect == null) {
            this.warnOrThrow(transcriptEffect, "must not be null", null, stringency, logger);
            return null;
        }
        String impact = transcriptEffect.getImpact() == null ? null : this.impactConverter.convert(transcriptEffect.getImpact(), stringency, logger);
        List messages = transcriptEffect.getMessages().stream().map(m3 -> this.variantAnnotationMessageConverter.convert((VariantAnnotationMessage)((Object)m3), stringency, logger)).collect(Collectors.toList());
        try {
            return Joiner.on("|").join(TranscriptEffectToString.nullToEmpty(transcriptEffect.getAlternateAllele()), Joiner.on("&").join(transcriptEffect.getEffects()), TranscriptEffectToString.nullToEmpty(impact), TranscriptEffectToString.nullToEmpty(transcriptEffect.getGeneName()), TranscriptEffectToString.nullToEmpty(transcriptEffect.getGeneId()), TranscriptEffectToString.nullToEmpty(transcriptEffect.getFeatureType()), TranscriptEffectToString.nullToEmpty(transcriptEffect.getFeatureId()), TranscriptEffectToString.nullToEmpty(transcriptEffect.getBiotype()), TranscriptEffectToString.nullToEmpty(transcriptEffect.getRank(), transcriptEffect.getTotal()), TranscriptEffectToString.nullToEmpty(transcriptEffect.getTranscriptHgvs()), TranscriptEffectToString.nullToEmpty(transcriptEffect.getProteinHgvs()), TranscriptEffectToString.nullToEmpty(transcriptEffect.getCdnaPosition(), transcriptEffect.getCdnaLength()), TranscriptEffectToString.nullToEmpty(transcriptEffect.getCodingSequencePosition(), transcriptEffect.getCodingSequenceLength()), TranscriptEffectToString.nullToEmpty(transcriptEffect.getProteinPosition(), transcriptEffect.getProteinLength()), TranscriptEffectToString.nullToEmpty(transcriptEffect.getDistance()), Joiner.on("&").join(messages));
        }
        catch (NumberFormatException e) {
            this.warnOrThrow(transcriptEffect, e.getMessage(), e, stringency, logger);
            return null;
        }
    }

    private static String nullToEmpty(String s2) {
        return s2 == null ? "" : s2;
    }

    private static String nullToEmpty(Integer i) {
        return i == null ? "" : i.toString();
    }

    private static String nullToEmpty(Integer a, Integer b) {
        if (a == null && b != null) {
            throw new NumberFormatException(String.format("invalid fraction ?/%d, missing numerator", b));
        }
        StringBuilder sb = new StringBuilder();
        sb.append(TranscriptEffectToString.nullToEmpty(a));
        if (b != null) {
            sb.append("/");
            sb.append(b.toString());
        }
        return sb.toString();
    }
}

