/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.convert.bdgenomics;

import org.bdgenomics.convert.AbstractConverter;
import org.bdgenomics.convert.ConversionException;
import org.bdgenomics.convert.ConversionStringency;
import org.bdgenomics.formats.avro.VariantAnnotationMessage;
import org.slf4j.Logger;

final class VariantAnnotationMessageToString
extends AbstractConverter<VariantAnnotationMessage, String> {
    VariantAnnotationMessageToString() {
        super(VariantAnnotationMessage.class, String.class);
    }

    @Override
    public String convert(VariantAnnotationMessage variantAnnotationMessage, ConversionStringency stringency, Logger logger) throws ConversionException {
        if (variantAnnotationMessage == null) {
            this.warnOrThrow(variantAnnotationMessage, "must not be null", null, stringency, logger);
            return null;
        }
        switch (variantAnnotationMessage) {
            case ERROR_CHROMOSOME_NOT_FOUND: {
                return "E1";
            }
            case ERROR_OUT_OF_CHROMOSOME_RANGE: {
                return "E2";
            }
            case WARNING_REF_DOES_NOT_MATCH_GENOME: {
                return "W1";
            }
            case WARNING_SEQUENCE_NOT_AVAILABLE: {
                return "W2";
            }
            case WARNING_TRANSCRIPT_INCOMPLETE: {
                return "W3";
            }
            case WARNING_TRANSCRIPT_MULTIPLE_STOP_CODONS: {
                return "W4";
            }
            case WARNING_TRANSCRIPT_NO_START_CODON: {
                return "W5";
            }
            case INFO_REALIGN_3_PRIME: {
                return "I1";
            }
            case INFO_COMPOUND_ANNOTATION: {
                return "I2";
            }
            case INFO_NON_REFERENCE_ANNOTATION: {
                return "I3";
            }
        }
        return variantAnnotationMessage.toString();
    }
}

