/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.formats.avro;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class Alignment
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -2824763386024894843L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"Alignment\",\"namespace\":\"org.bdgenomics.formats.avro\",\"doc\":\"Alignment.\",\"fields\":[{\"name\":\"referenceName\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The reference for this alignment. If the read is unaligned, this\\n   field should be null. SAM column 3 field RNAME.\",\"default\":null},{\"name\":\"start\",\"type\":[\"null\",\"long\"],\"doc\":\"Start position for this alignment, in zero-based coordinate system\\n   with closed-open intervals. Should be null if the read is unaligned.\\n   SAM column 4 field POS converted to zero-based coordinate system,\\n   closed-open intervals.\",\"default\":null},{\"name\":\"originalStart\",\"type\":[\"null\",\"long\"],\"doc\":\"Original start position for this alignment, before local realignment,\\n   in zero-based coordinate system with closed-open intervals. Should be\\n   null if the read is unaligned. SAM optional field reserved tag OP\\n   converted to zero-based coordinate system, closed-open intervals.\",\"default\":null},{\"name\":\"end\",\"type\":[\"null\",\"long\"],\"doc\":\"End position for this alignment, in zero-based coordinate system with\\n   closed-open intervals. Should be null if the read is unaligned.\",\"default\":null},{\"name\":\"mappingQuality\",\"type\":[\"null\",\"int\"],\"doc\":\"Global mapping quality for this alignment. SAM column 5 field MAPQ.\",\"default\":null},{\"name\":\"readName\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Name of the read for this alignment. This should be unique within the read\\n   group that the read is from, and can be used to identify other reads that\\n   are derived from a single fragment. SAM column 5 field QNAME.\",\"default\":null},{\"name\":\"sequence\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Sequence of the read for this alignment. If the read has been hard clipped,\\n   this may not represent all the bases in the original read. SAM column 10\\n   field SEQ.\",\"default\":null},{\"name\":\"qualityScores\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Per-base quality scores of the read for this alignment. If the read has\\n   been hard clipped, this may not represent all the bases in the original\\n   read. Additionally, if the error scores have been recalibrated, this field\\n   will not contain the original base quality scores. SAM column 11 field QUAL.\",\"default\":null},{\"name\":\"cigar\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Compact Ideosyncratic Gapped Alignment Report (CIGAR) string that\\n   describes the local alignment of the read for this alignment. SAM column\\n   6 field CIGAR.\\n\\n   Contains {length, operator} pairs for all contiguous alignment operations.\\n   The operators include:\\n\\n   * M, ALIGNMENT_MATCH: An alignment match indicates that a sequence can be\\n     aligned to the reference without evidence of an INDEL. Unlike the\\n     SEQUENCE_MATCH and SEQUENCE_MISMATCH operators, the ALIGNMENT_MATCH\\n     operator does not indicate whether the reference and read sequences are an\\n     exact match.\\n   * I, INSERT: The insert operator indicates that the read contains evidence of\\n     bases being inserted into the reference.\\n   * D, DELETE: The delete operator indicates that the read contains evidence of\\n     bases being deleted from the reference.\\n   * N, SKIP: The skip operator indicates that this read skips a long segment of\\n     the reference, but the bases have not been deleted. This operator is\\n     commonly used when working with RNA-seq data, where reads may skip long\\n     segments of the reference between exons.\\n   * S, CLIP_SOFT: The soft clip operator indicates that bases at the start/end\\n     of a read have not been considered during alignment. This may occur if the\\n     majority of a read maps, except for low quality bases at the start/end of\\n     a read. Bases that are soft clipped will still be stored in the read.\\n   * H, CLIP_HARD: The hard clip operator indicates that bases at the start/end of\\n     a read have been omitted from this alignment. This may occur if this linear\\n     alignment is part of a chimeric alignment, or if the read has been trimmed\\n     (e.g., during error correction, or to trim poly-A tails for RNA-seq).\\n   * P, PAD: The pad operator indicates that there is padding in an alignment.\\n   * =, SEQUENCE_MATCH: This operator indicates that this portion of the aligned\\n     sequence exactly matches the reference (e.g., all bases are equal to the\\n     reference bases).\\n   * X, SEQUENCE_MISMATCH: This operator indicates that this portion of the\\n     aligned sequence is an alignment match to the reference, but a sequence\\n     mismatch (e.g., the bases are not equal to the reference). This can\\n     indicate a SNP or a read error.\",\"default\":null},{\"name\":\"originalCigar\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Original CIGAR string that describes the local alignment of the read for\\n   this alignment, before local realignment. SAM optional field reserved tag\\n   OC.\",\"default\":null},{\"name\":\"basesTrimmedFromStart\",\"type\":[\"int\",\"null\"],\"doc\":\"Number of bases in the read for this alignment that have been trimmed from\\n   the start of the read. By default, this is equal to 0. If the value is\\n   non-zero, that means that the start of the read has been hard-clipped.\",\"default\":0},{\"name\":\"basesTrimmedFromEnd\",\"type\":[\"int\",\"null\"],\"doc\":\"Number of bases in the read for this alignment that have been trimmed from\\n   the end of the read. By default, this is equal to 0. If the value is\\n   non-zero, that means that the end of the read has been hard-clipped.\",\"default\":0},{\"name\":\"readPaired\",\"type\":[\"boolean\",\"null\"],\"doc\":\"True if the read for this alignment has a mate. Defaults to false.\",\"default\":false},{\"name\":\"properPair\",\"type\":[\"boolean\",\"null\"],\"doc\":\"True if the read for this alignment and its mate are a proper pair.\\n   Defaults to false.\",\"default\":false},{\"name\":\"readMapped\",\"type\":[\"boolean\",\"null\"],\"doc\":\"True if the read for this alignment has been mapped. Defaults to false.\",\"default\":false},{\"name\":\"mateMapped\",\"type\":[\"boolean\",\"null\"],\"doc\":\"True if the mate of the read for this alignment has been mapped.\\n   Defaults to false.\",\"default\":false},{\"name\":\"failedVendorQualityChecks\",\"type\":[\"boolean\",\"null\"],\"doc\":\"True if the read for this alignent failed vendor quality checks.\\n   Defaults to false.\",\"default\":false},{\"name\":\"duplicateRead\",\"type\":[\"boolean\",\"null\"],\"doc\":\"True if the read for this alignment has been marked as duplicate.\\n   Defaults to false.\",\"default\":false},{\"name\":\"readNegativeStrand\",\"type\":[\"boolean\",\"null\"],\"doc\":\"True if this alignment is mapped as a reverse compliment.\\n   Defaults to false.\",\"default\":false},{\"name\":\"mateNegativeStrand\",\"type\":[\"boolean\",\"null\"],\"doc\":\"True if the mate pair for this alignment is mapped as a reverse\\n   compliment. Defaults to false.\",\"default\":false},{\"name\":\"primaryAlignment\",\"type\":[\"boolean\",\"null\"],\"doc\":\"True if this alignment is either the best linear alignment, or the first\\n   linear alignment in a chimeric alignment. Defaults to false.\",\"default\":false},{\"name\":\"secondaryAlignment\",\"type\":[\"boolean\",\"null\"],\"doc\":\"True if this alignment is a lower quality linear alignment for a\\n   multiply-mapped read. Defaults to false.\",\"default\":false},{\"name\":\"supplementaryAlignment\",\"type\":[\"boolean\",\"null\"],\"doc\":\"True if this alignment is a non-primary linear alignment in a chimeric\\n   alignment. Defaults to false.\",\"default\":false},{\"name\":\"mismatchingPositions\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Mismatching positions for this alignment. SAM optional field reserved tag\\n   MD.\\n\\n   Format (not enforced here): [0-9]+(([A-Z]|\\\\^[A-Z]+)[0-9]+)*\",\"default\":null},{\"name\":\"originalQualityScores\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Original per-base quality scores of the read for this alignment, before\\n   recalibration. SAM optional field reserved tag OQ.\",\"default\":null},{\"name\":\"readGroupId\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Read group identifier for the read for this alignment. Join with\\n   ReadGroup.id for read grou", new String[]{"p metadata.\",\"default\":null},{\"name\":\"readGroupSampleId\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Read group sample identifier for the read for this alignment. Join with\\n   ReadGroup.sampleId for read group metadata or Sample.id for sample metadata.\",\"default\":null},{\"name\":\"mateAlignmentStart\",\"type\":[\"null\",\"long\"],\"doc\":\"Start position of the mate of the read for this alignment, in zero-based\\n   coordinate system with closed-open intervals. Should be set to null if the\\n   mate is unaligned, or if the mate does not exist. SAM column 8 field PNEXT\\n   converted to zero-based coordinate system, closed-open intervals.\",\"default\":null},{\"name\":\"mateReferenceName\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Reference for the mate of the read for this alignment. Should be set to\\n   null if the mate is unaligned, or if the mate does not exist. SAM column 7\\n   field RNEXT.\",\"default\":null},{\"name\":\"insertSize\",\"type\":[\"null\",\"long\"],\"doc\":\"Insert size between the read for this alignment and its mate, derived from\\n   alignment, if the reads have been aligned. Should be set to null if the mate\\n   is unaligned, or if the mate does not exist.\",\"default\":null},{\"name\":\"readInFragment\",\"type\":[\"int\",\"null\"],\"doc\":\"Index of the read for this alignment within an array of fragments.\\n   Defaults to zero.\",\"default\":0},{\"name\":\"attributes\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Additional alignment attributes that do not fit into the standard fields\\n   above, flattened into a string.\",\"default\":null}]}"});
    private static SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<Alignment> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<Alignment> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    @Deprecated
    public String referenceName;
    @Deprecated
    public Long start;
    @Deprecated
    public Long originalStart;
    @Deprecated
    public Long end;
    @Deprecated
    public Integer mappingQuality;
    @Deprecated
    public String readName;
    @Deprecated
    public String sequence;
    @Deprecated
    public String qualityScores;
    @Deprecated
    public String cigar;
    @Deprecated
    public String originalCigar;
    @Deprecated
    public Integer basesTrimmedFromStart;
    @Deprecated
    public Integer basesTrimmedFromEnd;
    @Deprecated
    public Boolean readPaired;
    @Deprecated
    public Boolean properPair;
    @Deprecated
    public Boolean readMapped;
    @Deprecated
    public Boolean mateMapped;
    @Deprecated
    public Boolean failedVendorQualityChecks;
    @Deprecated
    public Boolean duplicateRead;
    @Deprecated
    public Boolean readNegativeStrand;
    @Deprecated
    public Boolean mateNegativeStrand;
    @Deprecated
    public Boolean primaryAlignment;
    @Deprecated
    public Boolean secondaryAlignment;
    @Deprecated
    public Boolean supplementaryAlignment;
    @Deprecated
    public String mismatchingPositions;
    @Deprecated
    public String originalQualityScores;
    @Deprecated
    public String readGroupId;
    @Deprecated
    public String readGroupSampleId;
    @Deprecated
    public Long mateAlignmentStart;
    @Deprecated
    public String mateReferenceName;
    @Deprecated
    public Long insertSize;
    @Deprecated
    public Integer readInFragment;
    @Deprecated
    public String attributes;
    private static final DatumWriter<Alignment> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<Alignment> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageDecoder<Alignment> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<Alignment> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static Alignment fromByteBuffer(ByteBuffer b) throws IOException {
        return (Alignment)((Object)DECODER.decode(b));
    }

    public Alignment() {
    }

    public Alignment(String referenceName, Long start, Long originalStart, Long end, Integer mappingQuality, String readName, String sequence, String qualityScores, String cigar, String originalCigar, Integer basesTrimmedFromStart, Integer basesTrimmedFromEnd, Boolean readPaired, Boolean properPair, Boolean readMapped, Boolean mateMapped, Boolean failedVendorQualityChecks, Boolean duplicateRead, Boolean readNegativeStrand, Boolean mateNegativeStrand, Boolean primaryAlignment, Boolean secondaryAlignment, Boolean supplementaryAlignment, String mismatchingPositions, String originalQualityScores, String readGroupId, String readGroupSampleId, Long mateAlignmentStart, String mateReferenceName, Long insertSize, Integer readInFragment, String attributes) {
        this.referenceName = referenceName;
        this.start = start;
        this.originalStart = originalStart;
        this.end = end;
        this.mappingQuality = mappingQuality;
        this.readName = readName;
        this.sequence = sequence;
        this.qualityScores = qualityScores;
        this.cigar = cigar;
        this.originalCigar = originalCigar;
        this.basesTrimmedFromStart = basesTrimmedFromStart;
        this.basesTrimmedFromEnd = basesTrimmedFromEnd;
        this.readPaired = readPaired;
        this.properPair = properPair;
        this.readMapped = readMapped;
        this.mateMapped = mateMapped;
        this.failedVendorQualityChecks = failedVendorQualityChecks;
        this.duplicateRead = duplicateRead;
        this.readNegativeStrand = readNegativeStrand;
        this.mateNegativeStrand = mateNegativeStrand;
        this.primaryAlignment = primaryAlignment;
        this.secondaryAlignment = secondaryAlignment;
        this.supplementaryAlignment = supplementaryAlignment;
        this.mismatchingPositions = mismatchingPositions;
        this.originalQualityScores = originalQualityScores;
        this.readGroupId = readGroupId;
        this.readGroupSampleId = readGroupSampleId;
        this.mateAlignmentStart = mateAlignmentStart;
        this.mateReferenceName = mateReferenceName;
        this.insertSize = insertSize;
        this.readInFragment = readInFragment;
        this.attributes = attributes;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.referenceName;
            }
            case 1: {
                return this.start;
            }
            case 2: {
                return this.originalStart;
            }
            case 3: {
                return this.end;
            }
            case 4: {
                return this.mappingQuality;
            }
            case 5: {
                return this.readName;
            }
            case 6: {
                return this.sequence;
            }
            case 7: {
                return this.qualityScores;
            }
            case 8: {
                return this.cigar;
            }
            case 9: {
                return this.originalCigar;
            }
            case 10: {
                return this.basesTrimmedFromStart;
            }
            case 11: {
                return this.basesTrimmedFromEnd;
            }
            case 12: {
                return this.readPaired;
            }
            case 13: {
                return this.properPair;
            }
            case 14: {
                return this.readMapped;
            }
            case 15: {
                return this.mateMapped;
            }
            case 16: {
                return this.failedVendorQualityChecks;
            }
            case 17: {
                return this.duplicateRead;
            }
            case 18: {
                return this.readNegativeStrand;
            }
            case 19: {
                return this.mateNegativeStrand;
            }
            case 20: {
                return this.primaryAlignment;
            }
            case 21: {
                return this.secondaryAlignment;
            }
            case 22: {
                return this.supplementaryAlignment;
            }
            case 23: {
                return this.mismatchingPositions;
            }
            case 24: {
                return this.originalQualityScores;
            }
            case 25: {
                return this.readGroupId;
            }
            case 26: {
                return this.readGroupSampleId;
            }
            case 27: {
                return this.mateAlignmentStart;
            }
            case 28: {
                return this.mateReferenceName;
            }
            case 29: {
                return this.insertSize;
            }
            case 30: {
                return this.readInFragment;
            }
            case 31: {
                return this.attributes;
            }
        }
        throw new AvroRuntimeException("Bad index");
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.referenceName = (String)value$;
                break;
            }
            case 1: {
                this.start = (Long)value$;
                break;
            }
            case 2: {
                this.originalStart = (Long)value$;
                break;
            }
            case 3: {
                this.end = (Long)value$;
                break;
            }
            case 4: {
                this.mappingQuality = (Integer)value$;
                break;
            }
            case 5: {
                this.readName = (String)value$;
                break;
            }
            case 6: {
                this.sequence = (String)value$;
                break;
            }
            case 7: {
                this.qualityScores = (String)value$;
                break;
            }
            case 8: {
                this.cigar = (String)value$;
                break;
            }
            case 9: {
                this.originalCigar = (String)value$;
                break;
            }
            case 10: {
                this.basesTrimmedFromStart = (Integer)value$;
                break;
            }
            case 11: {
                this.basesTrimmedFromEnd = (Integer)value$;
                break;
            }
            case 12: {
                this.readPaired = (Boolean)value$;
                break;
            }
            case 13: {
                this.properPair = (Boolean)value$;
                break;
            }
            case 14: {
                this.readMapped = (Boolean)value$;
                break;
            }
            case 15: {
                this.mateMapped = (Boolean)value$;
                break;
            }
            case 16: {
                this.failedVendorQualityChecks = (Boolean)value$;
                break;
            }
            case 17: {
                this.duplicateRead = (Boolean)value$;
                break;
            }
            case 18: {
                this.readNegativeStrand = (Boolean)value$;
                break;
            }
            case 19: {
                this.mateNegativeStrand = (Boolean)value$;
                break;
            }
            case 20: {
                this.primaryAlignment = (Boolean)value$;
                break;
            }
            case 21: {
                this.secondaryAlignment = (Boolean)value$;
                break;
            }
            case 22: {
                this.supplementaryAlignment = (Boolean)value$;
                break;
            }
            case 23: {
                this.mismatchingPositions = (String)value$;
                break;
            }
            case 24: {
                this.originalQualityScores = (String)value$;
                break;
            }
            case 25: {
                this.readGroupId = (String)value$;
                break;
            }
            case 26: {
                this.readGroupSampleId = (String)value$;
                break;
            }
            case 27: {
                this.mateAlignmentStart = (Long)value$;
                break;
            }
            case 28: {
                this.mateReferenceName = (String)value$;
                break;
            }
            case 29: {
                this.insertSize = (Long)value$;
                break;
            }
            case 30: {
                this.readInFragment = (Integer)value$;
                break;
            }
            case 31: {
                this.attributes = (String)value$;
                break;
            }
            default: {
                throw new AvroRuntimeException("Bad index");
            }
        }
    }

    public String getReferenceName() {
        return this.referenceName;
    }

    public void setReferenceName(String value) {
        this.referenceName = value;
    }

    public Long getStart() {
        return this.start;
    }

    public void setStart(Long value) {
        this.start = value;
    }

    public Long getOriginalStart() {
        return this.originalStart;
    }

    public void setOriginalStart(Long value) {
        this.originalStart = value;
    }

    public Long getEnd() {
        return this.end;
    }

    public void setEnd(Long value) {
        this.end = value;
    }

    public Integer getMappingQuality() {
        return this.mappingQuality;
    }

    public void setMappingQuality(Integer value) {
        this.mappingQuality = value;
    }

    public String getReadName() {
        return this.readName;
    }

    public void setReadName(String value) {
        this.readName = value;
    }

    public String getSequence() {
        return this.sequence;
    }

    public void setSequence(String value) {
        this.sequence = value;
    }

    public String getQualityScores() {
        return this.qualityScores;
    }

    public void setQualityScores(String value) {
        this.qualityScores = value;
    }

    public String getCigar() {
        return this.cigar;
    }

    public void setCigar(String value) {
        this.cigar = value;
    }

    public String getOriginalCigar() {
        return this.originalCigar;
    }

    public void setOriginalCigar(String value) {
        this.originalCigar = value;
    }

    public Integer getBasesTrimmedFromStart() {
        return this.basesTrimmedFromStart;
    }

    public void setBasesTrimmedFromStart(Integer value) {
        this.basesTrimmedFromStart = value;
    }

    public Integer getBasesTrimmedFromEnd() {
        return this.basesTrimmedFromEnd;
    }

    public void setBasesTrimmedFromEnd(Integer value) {
        this.basesTrimmedFromEnd = value;
    }

    public Boolean getReadPaired() {
        return this.readPaired;
    }

    public void setReadPaired(Boolean value) {
        this.readPaired = value;
    }

    public Boolean getProperPair() {
        return this.properPair;
    }

    public void setProperPair(Boolean value) {
        this.properPair = value;
    }

    public Boolean getReadMapped() {
        return this.readMapped;
    }

    public void setReadMapped(Boolean value) {
        this.readMapped = value;
    }

    public Boolean getMateMapped() {
        return this.mateMapped;
    }

    public void setMateMapped(Boolean value) {
        this.mateMapped = value;
    }

    public Boolean getFailedVendorQualityChecks() {
        return this.failedVendorQualityChecks;
    }

    public void setFailedVendorQualityChecks(Boolean value) {
        this.failedVendorQualityChecks = value;
    }

    public Boolean getDuplicateRead() {
        return this.duplicateRead;
    }

    public void setDuplicateRead(Boolean value) {
        this.duplicateRead = value;
    }

    public Boolean getReadNegativeStrand() {
        return this.readNegativeStrand;
    }

    public void setReadNegativeStrand(Boolean value) {
        this.readNegativeStrand = value;
    }

    public Boolean getMateNegativeStrand() {
        return this.mateNegativeStrand;
    }

    public void setMateNegativeStrand(Boolean value) {
        this.mateNegativeStrand = value;
    }

    public Boolean getPrimaryAlignment() {
        return this.primaryAlignment;
    }

    public void setPrimaryAlignment(Boolean value) {
        this.primaryAlignment = value;
    }

    public Boolean getSecondaryAlignment() {
        return this.secondaryAlignment;
    }

    public void setSecondaryAlignment(Boolean value) {
        this.secondaryAlignment = value;
    }

    public Boolean getSupplementaryAlignment() {
        return this.supplementaryAlignment;
    }

    public void setSupplementaryAlignment(Boolean value) {
        this.supplementaryAlignment = value;
    }

    public String getMismatchingPositions() {
        return this.mismatchingPositions;
    }

    public void setMismatchingPositions(String value) {
        this.mismatchingPositions = value;
    }

    public String getOriginalQualityScores() {
        return this.originalQualityScores;
    }

    public void setOriginalQualityScores(String value) {
        this.originalQualityScores = value;
    }

    public String getReadGroupId() {
        return this.readGroupId;
    }

    public void setReadGroupId(String value) {
        this.readGroupId = value;
    }

    public String getReadGroupSampleId() {
        return this.readGroupSampleId;
    }

    public void setReadGroupSampleId(String value) {
        this.readGroupSampleId = value;
    }

    public Long getMateAlignmentStart() {
        return this.mateAlignmentStart;
    }

    public void setMateAlignmentStart(Long value) {
        this.mateAlignmentStart = value;
    }

    public String getMateReferenceName() {
        return this.mateReferenceName;
    }

    public void setMateReferenceName(String value) {
        this.mateReferenceName = value;
    }

    public Long getInsertSize() {
        return this.insertSize;
    }

    public void setInsertSize(Long value) {
        this.insertSize = value;
    }

    public Integer getReadInFragment() {
        return this.readInFragment;
    }

    public void setReadInFragment(Integer value) {
        this.readInFragment = value;
    }

    public String getAttributes() {
        return this.attributes;
    }

    public void setAttributes(String value) {
        this.attributes = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        return new Builder(other);
    }

    public static Builder newBuilder(Alignment other) {
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    public static class Builder
    extends SpecificRecordBuilderBase<Alignment>
    implements RecordBuilder<Alignment> {
        private String referenceName;
        private Long start;
        private Long originalStart;
        private Long end;
        private Integer mappingQuality;
        private String readName;
        private String sequence;
        private String qualityScores;
        private String cigar;
        private String originalCigar;
        private Integer basesTrimmedFromStart;
        private Integer basesTrimmedFromEnd;
        private Boolean readPaired;
        private Boolean properPair;
        private Boolean readMapped;
        private Boolean mateMapped;
        private Boolean failedVendorQualityChecks;
        private Boolean duplicateRead;
        private Boolean readNegativeStrand;
        private Boolean mateNegativeStrand;
        private Boolean primaryAlignment;
        private Boolean secondaryAlignment;
        private Boolean supplementaryAlignment;
        private String mismatchingPositions;
        private String originalQualityScores;
        private String readGroupId;
        private String readGroupSampleId;
        private Long mateAlignmentStart;
        private String mateReferenceName;
        private Long insertSize;
        private Integer readInFragment;
        private String attributes;

        private Builder() {
            super(SCHEMA$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.referenceName)) {
                this.referenceName = (String)this.data().deepCopy(this.fields()[0].schema(), (Object)other.referenceName);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.start)) {
                this.start = (Long)this.data().deepCopy(this.fields()[1].schema(), (Object)other.start);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.originalStart)) {
                this.originalStart = (Long)this.data().deepCopy(this.fields()[2].schema(), (Object)other.originalStart);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.end)) {
                this.end = (Long)this.data().deepCopy(this.fields()[3].schema(), (Object)other.end);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.mappingQuality)) {
                this.mappingQuality = (Integer)this.data().deepCopy(this.fields()[4].schema(), (Object)other.mappingQuality);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.readName)) {
                this.readName = (String)this.data().deepCopy(this.fields()[5].schema(), (Object)other.readName);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.sequence)) {
                this.sequence = (String)this.data().deepCopy(this.fields()[6].schema(), (Object)other.sequence);
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.qualityScores)) {
                this.qualityScores = (String)this.data().deepCopy(this.fields()[7].schema(), (Object)other.qualityScores);
                this.fieldSetFlags()[7] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.cigar)) {
                this.cigar = (String)this.data().deepCopy(this.fields()[8].schema(), (Object)other.cigar);
                this.fieldSetFlags()[8] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.originalCigar)) {
                this.originalCigar = (String)this.data().deepCopy(this.fields()[9].schema(), (Object)other.originalCigar);
                this.fieldSetFlags()[9] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)other.basesTrimmedFromStart)) {
                this.basesTrimmedFromStart = (Integer)this.data().deepCopy(this.fields()[10].schema(), (Object)other.basesTrimmedFromStart);
                this.fieldSetFlags()[10] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)other.basesTrimmedFromEnd)) {
                this.basesTrimmedFromEnd = (Integer)this.data().deepCopy(this.fields()[11].schema(), (Object)other.basesTrimmedFromEnd);
                this.fieldSetFlags()[11] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[12], (Object)other.readPaired)) {
                this.readPaired = (Boolean)this.data().deepCopy(this.fields()[12].schema(), (Object)other.readPaired);
                this.fieldSetFlags()[12] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[13], (Object)other.properPair)) {
                this.properPair = (Boolean)this.data().deepCopy(this.fields()[13].schema(), (Object)other.properPair);
                this.fieldSetFlags()[13] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[14], (Object)other.readMapped)) {
                this.readMapped = (Boolean)this.data().deepCopy(this.fields()[14].schema(), (Object)other.readMapped);
                this.fieldSetFlags()[14] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[15], (Object)other.mateMapped)) {
                this.mateMapped = (Boolean)this.data().deepCopy(this.fields()[15].schema(), (Object)other.mateMapped);
                this.fieldSetFlags()[15] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[16], (Object)other.failedVendorQualityChecks)) {
                this.failedVendorQualityChecks = (Boolean)this.data().deepCopy(this.fields()[16].schema(), (Object)other.failedVendorQualityChecks);
                this.fieldSetFlags()[16] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[17], (Object)other.duplicateRead)) {
                this.duplicateRead = (Boolean)this.data().deepCopy(this.fields()[17].schema(), (Object)other.duplicateRead);
                this.fieldSetFlags()[17] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[18], (Object)other.readNegativeStrand)) {
                this.readNegativeStrand = (Boolean)this.data().deepCopy(this.fields()[18].schema(), (Object)other.readNegativeStrand);
                this.fieldSetFlags()[18] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[19], (Object)other.mateNegativeStrand)) {
                this.mateNegativeStrand = (Boolean)this.data().deepCopy(this.fields()[19].schema(), (Object)other.mateNegativeStrand);
                this.fieldSetFlags()[19] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[20], (Object)other.primaryAlignment)) {
                this.primaryAlignment = (Boolean)this.data().deepCopy(this.fields()[20].schema(), (Object)other.primaryAlignment);
                this.fieldSetFlags()[20] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[21], (Object)other.secondaryAlignment)) {
                this.secondaryAlignment = (Boolean)this.data().deepCopy(this.fields()[21].schema(), (Object)other.secondaryAlignment);
                this.fieldSetFlags()[21] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[22], (Object)other.supplementaryAlignment)) {
                this.supplementaryAlignment = (Boolean)this.data().deepCopy(this.fields()[22].schema(), (Object)other.supplementaryAlignment);
                this.fieldSetFlags()[22] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[23], (Object)other.mismatchingPositions)) {
                this.mismatchingPositions = (String)this.data().deepCopy(this.fields()[23].schema(), (Object)other.mismatchingPositions);
                this.fieldSetFlags()[23] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[24], (Object)other.originalQualityScores)) {
                this.originalQualityScores = (String)this.data().deepCopy(this.fields()[24].schema(), (Object)other.originalQualityScores);
                this.fieldSetFlags()[24] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[25], (Object)other.readGroupId)) {
                this.readGroupId = (String)this.data().deepCopy(this.fields()[25].schema(), (Object)other.readGroupId);
                this.fieldSetFlags()[25] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[26], (Object)other.readGroupSampleId)) {
                this.readGroupSampleId = (String)this.data().deepCopy(this.fields()[26].schema(), (Object)other.readGroupSampleId);
                this.fieldSetFlags()[26] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[27], (Object)other.mateAlignmentStart)) {
                this.mateAlignmentStart = (Long)this.data().deepCopy(this.fields()[27].schema(), (Object)other.mateAlignmentStart);
                this.fieldSetFlags()[27] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[28], (Object)other.mateReferenceName)) {
                this.mateReferenceName = (String)this.data().deepCopy(this.fields()[28].schema(), (Object)other.mateReferenceName);
                this.fieldSetFlags()[28] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[29], (Object)other.insertSize)) {
                this.insertSize = (Long)this.data().deepCopy(this.fields()[29].schema(), (Object)other.insertSize);
                this.fieldSetFlags()[29] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[30], (Object)other.readInFragment)) {
                this.readInFragment = (Integer)this.data().deepCopy(this.fields()[30].schema(), (Object)other.readInFragment);
                this.fieldSetFlags()[30] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[31], (Object)other.attributes)) {
                this.attributes = (String)this.data().deepCopy(this.fields()[31].schema(), (Object)other.attributes);
                this.fieldSetFlags()[31] = true;
            }
        }

        private Builder(Alignment other) {
            super(SCHEMA$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.referenceName)) {
                this.referenceName = (String)this.data().deepCopy(this.fields()[0].schema(), (Object)other.referenceName);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.start)) {
                this.start = (Long)this.data().deepCopy(this.fields()[1].schema(), (Object)other.start);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.originalStart)) {
                this.originalStart = (Long)this.data().deepCopy(this.fields()[2].schema(), (Object)other.originalStart);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.end)) {
                this.end = (Long)this.data().deepCopy(this.fields()[3].schema(), (Object)other.end);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.mappingQuality)) {
                this.mappingQuality = (Integer)this.data().deepCopy(this.fields()[4].schema(), (Object)other.mappingQuality);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.readName)) {
                this.readName = (String)this.data().deepCopy(this.fields()[5].schema(), (Object)other.readName);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.sequence)) {
                this.sequence = (String)this.data().deepCopy(this.fields()[6].schema(), (Object)other.sequence);
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.qualityScores)) {
                this.qualityScores = (String)this.data().deepCopy(this.fields()[7].schema(), (Object)other.qualityScores);
                this.fieldSetFlags()[7] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.cigar)) {
                this.cigar = (String)this.data().deepCopy(this.fields()[8].schema(), (Object)other.cigar);
                this.fieldSetFlags()[8] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.originalCigar)) {
                this.originalCigar = (String)this.data().deepCopy(this.fields()[9].schema(), (Object)other.originalCigar);
                this.fieldSetFlags()[9] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)other.basesTrimmedFromStart)) {
                this.basesTrimmedFromStart = (Integer)this.data().deepCopy(this.fields()[10].schema(), (Object)other.basesTrimmedFromStart);
                this.fieldSetFlags()[10] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)other.basesTrimmedFromEnd)) {
                this.basesTrimmedFromEnd = (Integer)this.data().deepCopy(this.fields()[11].schema(), (Object)other.basesTrimmedFromEnd);
                this.fieldSetFlags()[11] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[12], (Object)other.readPaired)) {
                this.readPaired = (Boolean)this.data().deepCopy(this.fields()[12].schema(), (Object)other.readPaired);
                this.fieldSetFlags()[12] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[13], (Object)other.properPair)) {
                this.properPair = (Boolean)this.data().deepCopy(this.fields()[13].schema(), (Object)other.properPair);
                this.fieldSetFlags()[13] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[14], (Object)other.readMapped)) {
                this.readMapped = (Boolean)this.data().deepCopy(this.fields()[14].schema(), (Object)other.readMapped);
                this.fieldSetFlags()[14] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[15], (Object)other.mateMapped)) {
                this.mateMapped = (Boolean)this.data().deepCopy(this.fields()[15].schema(), (Object)other.mateMapped);
                this.fieldSetFlags()[15] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[16], (Object)other.failedVendorQualityChecks)) {
                this.failedVendorQualityChecks = (Boolean)this.data().deepCopy(this.fields()[16].schema(), (Object)other.failedVendorQualityChecks);
                this.fieldSetFlags()[16] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[17], (Object)other.duplicateRead)) {
                this.duplicateRead = (Boolean)this.data().deepCopy(this.fields()[17].schema(), (Object)other.duplicateRead);
                this.fieldSetFlags()[17] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[18], (Object)other.readNegativeStrand)) {
                this.readNegativeStrand = (Boolean)this.data().deepCopy(this.fields()[18].schema(), (Object)other.readNegativeStrand);
                this.fieldSetFlags()[18] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[19], (Object)other.mateNegativeStrand)) {
                this.mateNegativeStrand = (Boolean)this.data().deepCopy(this.fields()[19].schema(), (Object)other.mateNegativeStrand);
                this.fieldSetFlags()[19] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[20], (Object)other.primaryAlignment)) {
                this.primaryAlignment = (Boolean)this.data().deepCopy(this.fields()[20].schema(), (Object)other.primaryAlignment);
                this.fieldSetFlags()[20] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[21], (Object)other.secondaryAlignment)) {
                this.secondaryAlignment = (Boolean)this.data().deepCopy(this.fields()[21].schema(), (Object)other.secondaryAlignment);
                this.fieldSetFlags()[21] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[22], (Object)other.supplementaryAlignment)) {
                this.supplementaryAlignment = (Boolean)this.data().deepCopy(this.fields()[22].schema(), (Object)other.supplementaryAlignment);
                this.fieldSetFlags()[22] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[23], (Object)other.mismatchingPositions)) {
                this.mismatchingPositions = (String)this.data().deepCopy(this.fields()[23].schema(), (Object)other.mismatchingPositions);
                this.fieldSetFlags()[23] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[24], (Object)other.originalQualityScores)) {
                this.originalQualityScores = (String)this.data().deepCopy(this.fields()[24].schema(), (Object)other.originalQualityScores);
                this.fieldSetFlags()[24] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[25], (Object)other.readGroupId)) {
                this.readGroupId = (String)this.data().deepCopy(this.fields()[25].schema(), (Object)other.readGroupId);
                this.fieldSetFlags()[25] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[26], (Object)other.readGroupSampleId)) {
                this.readGroupSampleId = (String)this.data().deepCopy(this.fields()[26].schema(), (Object)other.readGroupSampleId);
                this.fieldSetFlags()[26] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[27], (Object)other.mateAlignmentStart)) {
                this.mateAlignmentStart = (Long)this.data().deepCopy(this.fields()[27].schema(), (Object)other.mateAlignmentStart);
                this.fieldSetFlags()[27] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[28], (Object)other.mateReferenceName)) {
                this.mateReferenceName = (String)this.data().deepCopy(this.fields()[28].schema(), (Object)other.mateReferenceName);
                this.fieldSetFlags()[28] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[29], (Object)other.insertSize)) {
                this.insertSize = (Long)this.data().deepCopy(this.fields()[29].schema(), (Object)other.insertSize);
                this.fieldSetFlags()[29] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[30], (Object)other.readInFragment)) {
                this.readInFragment = (Integer)this.data().deepCopy(this.fields()[30].schema(), (Object)other.readInFragment);
                this.fieldSetFlags()[30] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[31], (Object)other.attributes)) {
                this.attributes = (String)this.data().deepCopy(this.fields()[31].schema(), (Object)other.attributes);
                this.fieldSetFlags()[31] = true;
            }
        }

        public String getReferenceName() {
            return this.referenceName;
        }

        public Builder setReferenceName(String value) {
            this.validate(this.fields()[0], value);
            this.referenceName = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasReferenceName() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearReferenceName() {
            this.referenceName = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public Long getStart() {
            return this.start;
        }

        public Builder setStart(Long value) {
            this.validate(this.fields()[1], value);
            this.start = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasStart() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearStart() {
            this.start = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public Long getOriginalStart() {
            return this.originalStart;
        }

        public Builder setOriginalStart(Long value) {
            this.validate(this.fields()[2], value);
            this.originalStart = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasOriginalStart() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearOriginalStart() {
            this.originalStart = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public Long getEnd() {
            return this.end;
        }

        public Builder setEnd(Long value) {
            this.validate(this.fields()[3], value);
            this.end = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasEnd() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearEnd() {
            this.end = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public Integer getMappingQuality() {
            return this.mappingQuality;
        }

        public Builder setMappingQuality(Integer value) {
            this.validate(this.fields()[4], value);
            this.mappingQuality = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasMappingQuality() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearMappingQuality() {
            this.mappingQuality = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public String getReadName() {
            return this.readName;
        }

        public Builder setReadName(String value) {
            this.validate(this.fields()[5], value);
            this.readName = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasReadName() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearReadName() {
            this.readName = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public String getSequence() {
            return this.sequence;
        }

        public Builder setSequence(String value) {
            this.validate(this.fields()[6], value);
            this.sequence = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasSequence() {
            return this.fieldSetFlags()[6];
        }

        public Builder clearSequence() {
            this.sequence = null;
            this.fieldSetFlags()[6] = false;
            return this;
        }

        public String getQualityScores() {
            return this.qualityScores;
        }

        public Builder setQualityScores(String value) {
            this.validate(this.fields()[7], value);
            this.qualityScores = value;
            this.fieldSetFlags()[7] = true;
            return this;
        }

        public boolean hasQualityScores() {
            return this.fieldSetFlags()[7];
        }

        public Builder clearQualityScores() {
            this.qualityScores = null;
            this.fieldSetFlags()[7] = false;
            return this;
        }

        public String getCigar() {
            return this.cigar;
        }

        public Builder setCigar(String value) {
            this.validate(this.fields()[8], value);
            this.cigar = value;
            this.fieldSetFlags()[8] = true;
            return this;
        }

        public boolean hasCigar() {
            return this.fieldSetFlags()[8];
        }

        public Builder clearCigar() {
            this.cigar = null;
            this.fieldSetFlags()[8] = false;
            return this;
        }

        public String getOriginalCigar() {
            return this.originalCigar;
        }

        public Builder setOriginalCigar(String value) {
            this.validate(this.fields()[9], value);
            this.originalCigar = value;
            this.fieldSetFlags()[9] = true;
            return this;
        }

        public boolean hasOriginalCigar() {
            return this.fieldSetFlags()[9];
        }

        public Builder clearOriginalCigar() {
            this.originalCigar = null;
            this.fieldSetFlags()[9] = false;
            return this;
        }

        public Integer getBasesTrimmedFromStart() {
            return this.basesTrimmedFromStart;
        }

        public Builder setBasesTrimmedFromStart(Integer value) {
            this.validate(this.fields()[10], value);
            this.basesTrimmedFromStart = value;
            this.fieldSetFlags()[10] = true;
            return this;
        }

        public boolean hasBasesTrimmedFromStart() {
            return this.fieldSetFlags()[10];
        }

        public Builder clearBasesTrimmedFromStart() {
            this.basesTrimmedFromStart = null;
            this.fieldSetFlags()[10] = false;
            return this;
        }

        public Integer getBasesTrimmedFromEnd() {
            return this.basesTrimmedFromEnd;
        }

        public Builder setBasesTrimmedFromEnd(Integer value) {
            this.validate(this.fields()[11], value);
            this.basesTrimmedFromEnd = value;
            this.fieldSetFlags()[11] = true;
            return this;
        }

        public boolean hasBasesTrimmedFromEnd() {
            return this.fieldSetFlags()[11];
        }

        public Builder clearBasesTrimmedFromEnd() {
            this.basesTrimmedFromEnd = null;
            this.fieldSetFlags()[11] = false;
            return this;
        }

        public Boolean getReadPaired() {
            return this.readPaired;
        }

        public Builder setReadPaired(Boolean value) {
            this.validate(this.fields()[12], value);
            this.readPaired = value;
            this.fieldSetFlags()[12] = true;
            return this;
        }

        public boolean hasReadPaired() {
            return this.fieldSetFlags()[12];
        }

        public Builder clearReadPaired() {
            this.readPaired = null;
            this.fieldSetFlags()[12] = false;
            return this;
        }

        public Boolean getProperPair() {
            return this.properPair;
        }

        public Builder setProperPair(Boolean value) {
            this.validate(this.fields()[13], value);
            this.properPair = value;
            this.fieldSetFlags()[13] = true;
            return this;
        }

        public boolean hasProperPair() {
            return this.fieldSetFlags()[13];
        }

        public Builder clearProperPair() {
            this.properPair = null;
            this.fieldSetFlags()[13] = false;
            return this;
        }

        public Boolean getReadMapped() {
            return this.readMapped;
        }

        public Builder setReadMapped(Boolean value) {
            this.validate(this.fields()[14], value);
            this.readMapped = value;
            this.fieldSetFlags()[14] = true;
            return this;
        }

        public boolean hasReadMapped() {
            return this.fieldSetFlags()[14];
        }

        public Builder clearReadMapped() {
            this.readMapped = null;
            this.fieldSetFlags()[14] = false;
            return this;
        }

        public Boolean getMateMapped() {
            return this.mateMapped;
        }

        public Builder setMateMapped(Boolean value) {
            this.validate(this.fields()[15], value);
            this.mateMapped = value;
            this.fieldSetFlags()[15] = true;
            return this;
        }

        public boolean hasMateMapped() {
            return this.fieldSetFlags()[15];
        }

        public Builder clearMateMapped() {
            this.mateMapped = null;
            this.fieldSetFlags()[15] = false;
            return this;
        }

        public Boolean getFailedVendorQualityChecks() {
            return this.failedVendorQualityChecks;
        }

        public Builder setFailedVendorQualityChecks(Boolean value) {
            this.validate(this.fields()[16], value);
            this.failedVendorQualityChecks = value;
            this.fieldSetFlags()[16] = true;
            return this;
        }

        public boolean hasFailedVendorQualityChecks() {
            return this.fieldSetFlags()[16];
        }

        public Builder clearFailedVendorQualityChecks() {
            this.failedVendorQualityChecks = null;
            this.fieldSetFlags()[16] = false;
            return this;
        }

        public Boolean getDuplicateRead() {
            return this.duplicateRead;
        }

        public Builder setDuplicateRead(Boolean value) {
            this.validate(this.fields()[17], value);
            this.duplicateRead = value;
            this.fieldSetFlags()[17] = true;
            return this;
        }

        public boolean hasDuplicateRead() {
            return this.fieldSetFlags()[17];
        }

        public Builder clearDuplicateRead() {
            this.duplicateRead = null;
            this.fieldSetFlags()[17] = false;
            return this;
        }

        public Boolean getReadNegativeStrand() {
            return this.readNegativeStrand;
        }

        public Builder setReadNegativeStrand(Boolean value) {
            this.validate(this.fields()[18], value);
            this.readNegativeStrand = value;
            this.fieldSetFlags()[18] = true;
            return this;
        }

        public boolean hasReadNegativeStrand() {
            return this.fieldSetFlags()[18];
        }

        public Builder clearReadNegativeStrand() {
            this.readNegativeStrand = null;
            this.fieldSetFlags()[18] = false;
            return this;
        }

        public Boolean getMateNegativeStrand() {
            return this.mateNegativeStrand;
        }

        public Builder setMateNegativeStrand(Boolean value) {
            this.validate(this.fields()[19], value);
            this.mateNegativeStrand = value;
            this.fieldSetFlags()[19] = true;
            return this;
        }

        public boolean hasMateNegativeStrand() {
            return this.fieldSetFlags()[19];
        }

        public Builder clearMateNegativeStrand() {
            this.mateNegativeStrand = null;
            this.fieldSetFlags()[19] = false;
            return this;
        }

        public Boolean getPrimaryAlignment() {
            return this.primaryAlignment;
        }

        public Builder setPrimaryAlignment(Boolean value) {
            this.validate(this.fields()[20], value);
            this.primaryAlignment = value;
            this.fieldSetFlags()[20] = true;
            return this;
        }

        public boolean hasPrimaryAlignment() {
            return this.fieldSetFlags()[20];
        }

        public Builder clearPrimaryAlignment() {
            this.primaryAlignment = null;
            this.fieldSetFlags()[20] = false;
            return this;
        }

        public Boolean getSecondaryAlignment() {
            return this.secondaryAlignment;
        }

        public Builder setSecondaryAlignment(Boolean value) {
            this.validate(this.fields()[21], value);
            this.secondaryAlignment = value;
            this.fieldSetFlags()[21] = true;
            return this;
        }

        public boolean hasSecondaryAlignment() {
            return this.fieldSetFlags()[21];
        }

        public Builder clearSecondaryAlignment() {
            this.secondaryAlignment = null;
            this.fieldSetFlags()[21] = false;
            return this;
        }

        public Boolean getSupplementaryAlignment() {
            return this.supplementaryAlignment;
        }

        public Builder setSupplementaryAlignment(Boolean value) {
            this.validate(this.fields()[22], value);
            this.supplementaryAlignment = value;
            this.fieldSetFlags()[22] = true;
            return this;
        }

        public boolean hasSupplementaryAlignment() {
            return this.fieldSetFlags()[22];
        }

        public Builder clearSupplementaryAlignment() {
            this.supplementaryAlignment = null;
            this.fieldSetFlags()[22] = false;
            return this;
        }

        public String getMismatchingPositions() {
            return this.mismatchingPositions;
        }

        public Builder setMismatchingPositions(String value) {
            this.validate(this.fields()[23], value);
            this.mismatchingPositions = value;
            this.fieldSetFlags()[23] = true;
            return this;
        }

        public boolean hasMismatchingPositions() {
            return this.fieldSetFlags()[23];
        }

        public Builder clearMismatchingPositions() {
            this.mismatchingPositions = null;
            this.fieldSetFlags()[23] = false;
            return this;
        }

        public String getOriginalQualityScores() {
            return this.originalQualityScores;
        }

        public Builder setOriginalQualityScores(String value) {
            this.validate(this.fields()[24], value);
            this.originalQualityScores = value;
            this.fieldSetFlags()[24] = true;
            return this;
        }

        public boolean hasOriginalQualityScores() {
            return this.fieldSetFlags()[24];
        }

        public Builder clearOriginalQualityScores() {
            this.originalQualityScores = null;
            this.fieldSetFlags()[24] = false;
            return this;
        }

        public String getReadGroupId() {
            return this.readGroupId;
        }

        public Builder setReadGroupId(String value) {
            this.validate(this.fields()[25], value);
            this.readGroupId = value;
            this.fieldSetFlags()[25] = true;
            return this;
        }

        public boolean hasReadGroupId() {
            return this.fieldSetFlags()[25];
        }

        public Builder clearReadGroupId() {
            this.readGroupId = null;
            this.fieldSetFlags()[25] = false;
            return this;
        }

        public String getReadGroupSampleId() {
            return this.readGroupSampleId;
        }

        public Builder setReadGroupSampleId(String value) {
            this.validate(this.fields()[26], value);
            this.readGroupSampleId = value;
            this.fieldSetFlags()[26] = true;
            return this;
        }

        public boolean hasReadGroupSampleId() {
            return this.fieldSetFlags()[26];
        }

        public Builder clearReadGroupSampleId() {
            this.readGroupSampleId = null;
            this.fieldSetFlags()[26] = false;
            return this;
        }

        public Long getMateAlignmentStart() {
            return this.mateAlignmentStart;
        }

        public Builder setMateAlignmentStart(Long value) {
            this.validate(this.fields()[27], value);
            this.mateAlignmentStart = value;
            this.fieldSetFlags()[27] = true;
            return this;
        }

        public boolean hasMateAlignmentStart() {
            return this.fieldSetFlags()[27];
        }

        public Builder clearMateAlignmentStart() {
            this.mateAlignmentStart = null;
            this.fieldSetFlags()[27] = false;
            return this;
        }

        public String getMateReferenceName() {
            return this.mateReferenceName;
        }

        public Builder setMateReferenceName(String value) {
            this.validate(this.fields()[28], value);
            this.mateReferenceName = value;
            this.fieldSetFlags()[28] = true;
            return this;
        }

        public boolean hasMateReferenceName() {
            return this.fieldSetFlags()[28];
        }

        public Builder clearMateReferenceName() {
            this.mateReferenceName = null;
            this.fieldSetFlags()[28] = false;
            return this;
        }

        public Long getInsertSize() {
            return this.insertSize;
        }

        public Builder setInsertSize(Long value) {
            this.validate(this.fields()[29], value);
            this.insertSize = value;
            this.fieldSetFlags()[29] = true;
            return this;
        }

        public boolean hasInsertSize() {
            return this.fieldSetFlags()[29];
        }

        public Builder clearInsertSize() {
            this.insertSize = null;
            this.fieldSetFlags()[29] = false;
            return this;
        }

        public Integer getReadInFragment() {
            return this.readInFragment;
        }

        public Builder setReadInFragment(Integer value) {
            this.validate(this.fields()[30], value);
            this.readInFragment = value;
            this.fieldSetFlags()[30] = true;
            return this;
        }

        public boolean hasReadInFragment() {
            return this.fieldSetFlags()[30];
        }

        public Builder clearReadInFragment() {
            this.readInFragment = null;
            this.fieldSetFlags()[30] = false;
            return this;
        }

        public String getAttributes() {
            return this.attributes;
        }

        public Builder setAttributes(String value) {
            this.validate(this.fields()[31], value);
            this.attributes = value;
            this.fieldSetFlags()[31] = true;
            return this;
        }

        public boolean hasAttributes() {
            return this.fieldSetFlags()[31];
        }

        public Builder clearAttributes() {
            this.attributes = null;
            this.fieldSetFlags()[31] = false;
            return this;
        }

        public Alignment build() {
            try {
                Alignment record = new Alignment();
                record.referenceName = this.fieldSetFlags()[0] ? this.referenceName : (String)this.defaultValue(this.fields()[0]);
                record.start = this.fieldSetFlags()[1] ? this.start : (Long)this.defaultValue(this.fields()[1]);
                record.originalStart = this.fieldSetFlags()[2] ? this.originalStart : (Long)this.defaultValue(this.fields()[2]);
                record.end = this.fieldSetFlags()[3] ? this.end : (Long)this.defaultValue(this.fields()[3]);
                record.mappingQuality = this.fieldSetFlags()[4] ? this.mappingQuality : (Integer)this.defaultValue(this.fields()[4]);
                record.readName = this.fieldSetFlags()[5] ? this.readName : (String)this.defaultValue(this.fields()[5]);
                record.sequence = this.fieldSetFlags()[6] ? this.sequence : (String)this.defaultValue(this.fields()[6]);
                record.qualityScores = this.fieldSetFlags()[7] ? this.qualityScores : (String)this.defaultValue(this.fields()[7]);
                record.cigar = this.fieldSetFlags()[8] ? this.cigar : (String)this.defaultValue(this.fields()[8]);
                record.originalCigar = this.fieldSetFlags()[9] ? this.originalCigar : (String)this.defaultValue(this.fields()[9]);
                record.basesTrimmedFromStart = this.fieldSetFlags()[10] ? this.basesTrimmedFromStart : (Integer)this.defaultValue(this.fields()[10]);
                record.basesTrimmedFromEnd = this.fieldSetFlags()[11] ? this.basesTrimmedFromEnd : (Integer)this.defaultValue(this.fields()[11]);
                record.readPaired = this.fieldSetFlags()[12] ? this.readPaired : (Boolean)this.defaultValue(this.fields()[12]);
                record.properPair = this.fieldSetFlags()[13] ? this.properPair : (Boolean)this.defaultValue(this.fields()[13]);
                record.readMapped = this.fieldSetFlags()[14] ? this.readMapped : (Boolean)this.defaultValue(this.fields()[14]);
                record.mateMapped = this.fieldSetFlags()[15] ? this.mateMapped : (Boolean)this.defaultValue(this.fields()[15]);
                record.failedVendorQualityChecks = this.fieldSetFlags()[16] ? this.failedVendorQualityChecks : (Boolean)this.defaultValue(this.fields()[16]);
                record.duplicateRead = this.fieldSetFlags()[17] ? this.duplicateRead : (Boolean)this.defaultValue(this.fields()[17]);
                record.readNegativeStrand = this.fieldSetFlags()[18] ? this.readNegativeStrand : (Boolean)this.defaultValue(this.fields()[18]);
                record.mateNegativeStrand = this.fieldSetFlags()[19] ? this.mateNegativeStrand : (Boolean)this.defaultValue(this.fields()[19]);
                record.primaryAlignment = this.fieldSetFlags()[20] ? this.primaryAlignment : (Boolean)this.defaultValue(this.fields()[20]);
                record.secondaryAlignment = this.fieldSetFlags()[21] ? this.secondaryAlignment : (Boolean)this.defaultValue(this.fields()[21]);
                record.supplementaryAlignment = this.fieldSetFlags()[22] ? this.supplementaryAlignment : (Boolean)this.defaultValue(this.fields()[22]);
                record.mismatchingPositions = this.fieldSetFlags()[23] ? this.mismatchingPositions : (String)this.defaultValue(this.fields()[23]);
                record.originalQualityScores = this.fieldSetFlags()[24] ? this.originalQualityScores : (String)this.defaultValue(this.fields()[24]);
                record.readGroupId = this.fieldSetFlags()[25] ? this.readGroupId : (String)this.defaultValue(this.fields()[25]);
                record.readGroupSampleId = this.fieldSetFlags()[26] ? this.readGroupSampleId : (String)this.defaultValue(this.fields()[26]);
                record.mateAlignmentStart = this.fieldSetFlags()[27] ? this.mateAlignmentStart : (Long)this.defaultValue(this.fields()[27]);
                record.mateReferenceName = this.fieldSetFlags()[28] ? this.mateReferenceName : (String)this.defaultValue(this.fields()[28]);
                record.insertSize = this.fieldSetFlags()[29] ? this.insertSize : (Long)this.defaultValue(this.fields()[29]);
                record.readInFragment = this.fieldSetFlags()[30] ? this.readInFragment : (Integer)this.defaultValue(this.fields()[30]);
                record.attributes = this.fieldSetFlags()[31] ? this.attributes : (String)this.defaultValue(this.fields()[31]);
                return record;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

