/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.formats.avro;

import org.apache.avro.Protocol;
import org.apache.avro.specific.AvroGenerated;

@AvroGenerated
public interface BDG {
    public static final Protocol PROTOCOL = Protocol.parse((String)"{\"protocol\":\"BDG\",\"namespace\":\"org.bdgenomics.formats.avro\",\"doc\":\"* Licensed to Big Data Genomics (BDG) under one\\n * or more contributor license agreements.  See the NOTICE file\\n * distributed with this work for additional information\\n * regarding copyright ownership.  The BDG licenses this file\\n * to you under the Apache License, Version 2.0 (the\\n * \\\"License\\\"); you may not use this file except in compliance\\n * with the License.  You may obtain a copy of the License at\\n *\\n *     http://www.apache.org/licenses/LICENSE-2.0\\n *\\n * Unless required by applicable law or agreed to in writing, software\\n * distributed under the License is distributed on an \\\"AS IS\\\" BASIS,\\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\\n * See the License for the specific language governing permissions and\\n * limitations under the License.\",\"types\":[{\"type\":\"record\",\"name\":\"Reference\",\"doc\":\"A reference is a canonical assembled contig, intended to act as a\\n reference coordinate space for other genomic annotations. A single\\n reference might represent the human chromosome 1, for instance.\",\"fields\":[{\"name\":\"name\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The name of this reference in the assembly (e.g., \\\"1\\\").\",\"default\":null},{\"name\":\"length\",\"type\":[\"null\",\"long\"],\"doc\":\"The length of the sequence for this reference.\",\"default\":null},{\"name\":\"md5\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The MD5 checksum uniquely representing this reference as a lower-case\\n   hexadecimal string, calculated as the MD5 of the upper-case sequence\\n   excluding all whitespace characters (equivalent to SQ:M5 in SAM).\",\"default\":null},{\"name\":\"sourceUri\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The URI from which the reference sequence was obtained.\",\"default\":null},{\"name\":\"assembly\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The name of the assembly for this reference (e.g., \\\"hg19\\\").\",\"default\":null},{\"name\":\"sourceAccessions\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},\"doc\":\"All known corresponding accession IDs for this reference in INSDC\\n   (GenBank/ENA/DDBJ), which must include a version number, e.g. GCF_000001405.26.\",\"default\":[]},{\"name\":\"species\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The species that this reference is for.\",\"default\":null},{\"name\":\"index\",\"type\":[\"null\",\"int\"],\"doc\":\"Optional zero-based index of this reference in a SAM file header that it was\\n   read from; helps output SAMs/BAMs with headers in the same order as they\\n   started with, before a conversion to ADAM.\",\"default\":null}]},{\"type\":\"record\",\"name\":\"ProcessingStep\",\"doc\":\"Description of a computational processing step. SAM header record type @PG.\",\"fields\":[{\"name\":\"id\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The identifier of this processing step. SAM tag ID for header record type\\n   @PG.\",\"default\":null},{\"name\":\"programName\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The name of the program used to run this processing step. SAM tag PN for\\n   header record type @PG.\",\"default\":null},{\"name\":\"commandLine\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The command line used to run this processing step. SAM tag CL for header\\n   record type @PG.\",\"default\":null},{\"name\":\"previousId\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Previous processing step identifier. Omit if this is the first step. SAM\\n   tag PP for header record type @PG.\",\"default\":null},{\"name\":\"description\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The description of this processing step. SAM tag DS for header record type\\n   @PG.\",\"default\":null},{\"name\":\"version\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The version of the program that was run in this processing step. SAM tag VN\\n   for header record type @PG.\",\"default\":null}]},{\"type\":\"record\",\"name\":\"ReadGroup\",\"doc\":\"Read group. SAM header record type @RG.\",\"fields\":[{\"name\":\"id\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Read group identifier. SAM tag ID for header record type @RG.\",\"default\":null},{\"name\":\"sequencingCenter\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Name of sequencing center producing the reads in this read group. SAM tag\\n   CN for header record type @RG.\",\"default\":null},{\"name\":\"description\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Description for this read group. SAM tag DS for header record type @RG.\",\"default\":null},{\"name\":\"runDateEpoch\",\"type\":[\"null\",\"long\"],\"doc\":\"Date when the sequencing run for this read group was performed. SAM tag DT\\n   for header record type @RG.\",\"default\":null},{\"name\":\"flowOrder\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Flow order for the reads in this read group. The array of nucleotide bases\\n   that correspond to the nucleotides used for each flow of each read. Multi-base\\n   flows are encoded in IUPAC format, and non-nucleotide flows by various other\\n   characters. SAM tag FO for header record type @RG.\\n\\n   Format (not enforced here): /\\\\*|[ACMGRSVTWYHKDBN]+/\",\"default\":null},{\"name\":\"keySequence\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The array of nucleotide bases that correspond to the key sequence of each\\n   read in this read group. SAM tag KS for header record type @RG.\",\"default\":null},{\"name\":\"library\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Library for this read group. SAM tag LB for header record type @RG.\",\"default\":null},{\"name\":\"predictedMedianInsertSize\",\"type\":[\"null\",\"int\"],\"doc\":\"Predicted median insert size for this read group. SAM tag PI for header\\n   record type @RG.\",\"default\":null},{\"name\":\"platform\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Platform or technology used to produce the reads in this read group. SAM\\n   tag PL for header record type @RG.\\n\\n   Valid values from the SAM specification (not enforced here):\\n   CAPILLARY, LS454, ILLUMINA, SOLID, HELICOS, IONTORRENT, ONT, and PACBIO.\",\"default\":null},{\"name\":\"platformModel\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Platform model for this read group, further details of the platform or\\n   technology used. SAM tag PM for header record type @RG.\",\"default\":null},{\"name\":\"platformUnit\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Platform unit (e.g. flowcell-barcode.lane for Illumina or slide for SOLiD)\\n   for this read group. SAM tag PU for header record type @RG.\",\"default\":null},{\"name\":\"sampleId\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Sample identifier for this read group. Use pool name where a pool is being\\n   sequenced. Join with Sample.id for sample metadata. SAM tag SM for\\n   header record type @RG.\",\"default\":null},{\"name\":\"processingSteps\",\"type\":{\"type\":\"array\",\"items\":\"ProcessingStep\"},\"doc\":\"Processing steps that have been applied to this read group. SAM tag PG for\\n   header record type @RG.\",\"default\":[]}]},{\"type\":\"record\",\"name\":\"Alignment\",\"doc\":\"Alignment.\",\"fields\":[{\"name\":\"referenceName\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The reference for this alignment. If the read is unaligned, this\\n   field should be null. SAM column 3 field RNAME.\",\"default\":null},{\"name\":\"start\",\"type\":[\"null\",\"long\"],\"doc\":\"Start position for this alignment, in zero-based coordinate system\\n   with closed-open intervals. Should be null if the read is unaligned.\\n   SAM column 4 field POS converted to zero-based coordinate system,\\n   closed-open intervals.\",\"default\":null},{\"name\":\"originalStart\",\"type\":[\"null\",\"long\"],\"doc\":\"Original start position for this alignment, before local realignment,\\n   in zero-based coordinate system with closed-open intervals. Should be\\n   null if the read is unaligned. SAM optional field reserved tag OP\\n   converted to zero-bas", (String[])new String[]{"ed coordinate system, closed-open intervals.\",\"default\":null},{\"name\":\"end\",\"type\":[\"null\",\"long\"],\"doc\":\"End position for this alignment, in zero-based coordinate system with\\n   closed-open intervals. Should be null if the read is unaligned.\",\"default\":null},{\"name\":\"mappingQuality\",\"type\":[\"null\",\"int\"],\"doc\":\"Global mapping quality for this alignment. SAM column 5 field MAPQ.\",\"default\":null},{\"name\":\"readName\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Name of the read for this alignment. This should be unique within the read\\n   group that the read is from, and can be used to identify other reads that\\n   are derived from a single fragment. SAM column 5 field QNAME.\",\"default\":null},{\"name\":\"sequence\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Sequence of the read for this alignment. If the read has been hard clipped,\\n   this may not represent all the bases in the original read. SAM column 10\\n   field SEQ.\",\"default\":null},{\"name\":\"qualityScores\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Per-base quality scores of the read for this alignment. If the read has\\n   been hard clipped, this may not represent all the bases in the original\\n   read. Additionally, if the error scores have been recalibrated, this field\\n   will not contain the original base quality scores. SAM column 11 field QUAL.\",\"default\":null},{\"name\":\"cigar\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Compact Ideosyncratic Gapped Alignment Report (CIGAR) string that\\n   describes the local alignment of the read for this alignment. SAM column\\n   6 field CIGAR.\\n\\n   Contains {length, operator} pairs for all contiguous alignment operations.\\n   The operators include:\\n\\n   * M, ALIGNMENT_MATCH: An alignment match indicates that a sequence can be\\n     aligned to the reference without evidence of an INDEL. Unlike the\\n     SEQUENCE_MATCH and SEQUENCE_MISMATCH operators, the ALIGNMENT_MATCH\\n     operator does not indicate whether the reference and read sequences are an\\n     exact match.\\n   * I, INSERT: The insert operator indicates that the read contains evidence of\\n     bases being inserted into the reference.\\n   * D, DELETE: The delete operator indicates that the read contains evidence of\\n     bases being deleted from the reference.\\n   * N, SKIP: The skip operator indicates that this read skips a long segment of\\n     the reference, but the bases have not been deleted. This operator is\\n     commonly used when working with RNA-seq data, where reads may skip long\\n     segments of the reference between exons.\\n   * S, CLIP_SOFT: The soft clip operator indicates that bases at the start/end\\n     of a read have not been considered during alignment. This may occur if the\\n     majority of a read maps, except for low quality bases at the start/end of\\n     a read. Bases that are soft clipped will still be stored in the read.\\n   * H, CLIP_HARD: The hard clip operator indicates that bases at the start/end of\\n     a read have been omitted from this alignment. This may occur if this linear\\n     alignment is part of a chimeric alignment, or if the read has been trimmed\\n     (e.g., during error correction, or to trim poly-A tails for RNA-seq).\\n   * P, PAD: The pad operator indicates that there is padding in an alignment.\\n   * =, SEQUENCE_MATCH: This operator indicates that this portion of the aligned\\n     sequence exactly matches the reference (e.g., all bases are equal to the\\n     reference bases).\\n   * X, SEQUENCE_MISMATCH: This operator indicates that this portion of the\\n     aligned sequence is an alignment match to the reference, but a sequence\\n     mismatch (e.g., the bases are not equal to the reference). This can\\n     indicate a SNP or a read error.\",\"default\":null},{\"name\":\"originalCigar\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Original CIGAR string that describes the local alignment of the read for\\n   this alignment, before local realignment. SAM optional field reserved tag\\n   OC.\",\"default\":null},{\"name\":\"basesTrimmedFromStart\",\"type\":[\"int\",\"null\"],\"doc\":\"Number of bases in the read for this alignment that have been trimmed from\\n   the start of the read. By default, this is equal to 0. If the value is\\n   non-zero, that means that the start of the read has been hard-clipped.\",\"default\":0},{\"name\":\"basesTrimmedFromEnd\",\"type\":[\"int\",\"null\"],\"doc\":\"Number of bases in the read for this alignment that have been trimmed from\\n   the end of the read. By default, this is equal to 0. If the value is\\n   non-zero, that means that the end of the read has been hard-clipped.\",\"default\":0},{\"name\":\"readPaired\",\"type\":[\"boolean\",\"null\"],\"doc\":\"True if the read for this alignment has a mate. Defaults to false.\",\"default\":false},{\"name\":\"properPair\",\"type\":[\"boolean\",\"null\"],\"doc\":\"True if the read for this alignment and its mate are a proper pair.\\n   Defaults to false.\",\"default\":false},{\"name\":\"readMapped\",\"type\":[\"boolean\",\"null\"],\"doc\":\"True if the read for this alignment has been mapped. Defaults to false.\",\"default\":false},{\"name\":\"mateMapped\",\"type\":[\"boolean\",\"null\"],\"doc\":\"True if the mate of the read for this alignment has been mapped.\\n   Defaults to false.\",\"default\":false},{\"name\":\"failedVendorQualityChecks\",\"type\":[\"boolean\",\"null\"],\"doc\":\"True if the read for this alignent failed vendor quality checks.\\n   Defaults to false.\",\"default\":false},{\"name\":\"duplicateRead\",\"type\":[\"boolean\",\"null\"],\"doc\":\"True if the read for this alignment has been marked as duplicate.\\n   Defaults to false.\",\"default\":false},{\"name\":\"readNegativeStrand\",\"type\":[\"boolean\",\"null\"],\"doc\":\"True if this alignment is mapped as a reverse compliment.\\n   Defaults to false.\",\"default\":false},{\"name\":\"mateNegativeStrand\",\"type\":[\"boolean\",\"null\"],\"doc\":\"True if the mate pair for this alignment is mapped as a reverse\\n   compliment. Defaults to false.\",\"default\":false},{\"name\":\"primaryAlignment\",\"type\":[\"boolean\",\"null\"],\"doc\":\"True if this alignment is either the best linear alignment, or the first\\n   linear alignment in a chimeric alignment. Defaults to false.\",\"default\":false},{\"name\":\"secondaryAlignment\",\"type\":[\"boolean\",\"null\"],\"doc\":\"True if this alignment is a lower quality linear alignment for a\\n   multiply-mapped read. Defaults to false.\",\"default\":false},{\"name\":\"supplementaryAlignment\",\"type\":[\"boolean\",\"null\"],\"doc\":\"True if this alignment is a non-primary linear alignment in a chimeric\\n   alignment. Defaults to false.\",\"default\":false},{\"name\":\"mismatchingPositions\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Mismatching positions for this alignment. SAM optional field reserved tag\\n   MD.\\n\\n   Format (not enforced here): [0-9]+(([A-Z]|\\\\^[A-Z]+)[0-9]+)*\",\"default\":null},{\"name\":\"originalQualityScores\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Original per-base quality scores of the read for this alignment, before\\n   recalibration. SAM optional field reserved tag OQ.\",\"default\":null},{\"name\":\"readGroupId\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Read group identifier for the read for this alignment. Join with\\n   ReadGroup.id for read group metadata.\",\"default\":null},{\"name\":\"readGroupSampleId\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Read group sample identifier for the read for this alignment. Join with\\n   ReadGroup.sampleId for read group metadata or Sample.id for sample metadata.\",\"default\":null},{\"name\":\"mateAlignmentStart\",\"type\":[\"null\",\"long\"],\"doc\":\"Start position of the mate of the read for this alignment, in zero-based\\n   coordinate system with closed-open intervals. Should be set to null if the\\n   mate is unaligned, or if the mate does not exist. SAM column 8 field PNEXT\\n   converted to zero-based coordinate system, closed-open intervals.\",\"default\":null},{\"name\":\"mateReferenceName\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Reference for the mate of the read for this alignment. Should be set to\\n   null if the mate is unaligned, or if the mate does not exist. SAM column 7\\n   fi", "eld RNEXT.\",\"default\":null},{\"name\":\"insertSize\",\"type\":[\"null\",\"long\"],\"doc\":\"Insert size between the read for this alignment and its mate, derived from\\n   alignment, if the reads have been aligned. Should be set to null if the mate\\n   is unaligned, or if the mate does not exist.\",\"default\":null},{\"name\":\"readInFragment\",\"type\":[\"int\",\"null\"],\"doc\":\"Index of the read for this alignment within an array of fragments.\\n   Defaults to zero.\",\"default\":0},{\"name\":\"attributes\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Additional alignment attributes that do not fit into the standard fields\\n   above, flattened into a string.\",\"default\":null}]},{\"type\":\"record\",\"name\":\"Fragment\",\"doc\":\"The DNA fragment that was targeted by the sequencer, resulting in\\n one or more reads.\",\"fields\":[{\"name\":\"name\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Name of this fragment.\",\"default\":null},{\"name\":\"readGroupId\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Read group identifier for this fragment. Join with ReadGroup.id for read\\n   group metadata.\",\"default\":null},{\"name\":\"insertSize\",\"type\":[\"null\",\"int\"],\"doc\":\"Insert size for this fragment, derived from alignment, if the reads have\\n   been aligned.\",\"default\":null},{\"name\":\"alignments\",\"type\":{\"type\":\"array\",\"items\":\"Alignment\"},\"doc\":\"Reads from this fragment.\",\"default\":[]}]},{\"type\":\"enum\",\"name\":\"VariantAnnotationMessage\",\"doc\":\"An alternative reference sequence was used to calculate this annotation\\n   (e.g. cancer sample comparing somatic vs. germline). Message code I3.\",\"symbols\":[\"ERROR_CHROMOSOME_NOT_FOUND\",\"ERROR_OUT_OF_CHROMOSOME_RANGE\",\"WARNING_REF_DOES_NOT_MATCH_GENOME\",\"WARNING_SEQUENCE_NOT_AVAILABLE\",\"WARNING_TRANSCRIPT_INCOMPLETE\",\"WARNING_TRANSCRIPT_MULTIPLE_STOP_CODONS\",\"WARNING_TRANSCRIPT_NO_START_CODON\",\"INFO_REALIGN_3_PRIME\",\"INFO_COMPOUND_ANNOTATION\",\"INFO_NON_REFERENCE_ANNOTATION\"]},{\"type\":\"enum\",\"name\":\"Impact\",\"doc\":\"Modifier impact.\",\"symbols\":[\"HIGH\",\"MODERATE\",\"LOW\",\"MODIFIER\"]},{\"type\":\"enum\",\"name\":\"Strand\",\"doc\":\"Strandedness is relevant, but unknown (\\\"?\\\").\",\"symbols\":[\"FORWARD\",\"REVERSE\",\"INDEPENDENT\",\"UNKNOWN\"]},{\"type\":\"record\",\"name\":\"TranscriptEffect\",\"doc\":\"Annotation of a variant in the context of a feature, typically a transcript.\",\"fields\":[{\"name\":\"alternateAllele\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Alternate allele for this variant annotation.\",\"default\":null},{\"name\":\"effects\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},\"doc\":\"One or more annotations (also referred to as effects or consequences) of the\\n   variant in the context of the feature identified by featureId. Must be\\n   Sequence Ontology (SO, see http://www.sequenceontology.org) term names, e.g.\\n   stop_gained, missense_variant, synonymous_variant, upstream_gene_variant.\",\"default\":[]},{\"name\":\"impact\",\"type\":[\"null\",\"Impact\"],\"doc\":\"Putative impact of the annotation; a simple estimation of putative impact/\\n   deleteriousness.\",\"default\":null},{\"name\":\"geneName\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Common gene name (HGNC), e.g. BRCA2. May be closest gene if annotation\\n   is intergenic.\",\"default\":null},{\"name\":\"geneId\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Gene identifier, e.g. Ensembl Gene identifier, ENSG00000139618. May be\\n   closest gene if annotation is intergenic.\",\"default\":null},{\"name\":\"featureType\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Feature type, may use Sequence Ontology term names. Typically transcript.\",\"default\":null},{\"name\":\"featureId\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Feature identifier, e.g. Ensembl Transcript identifier and version, ENST00000380152.7.\",\"default\":null},{\"name\":\"biotype\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Feature biotype, e.g. Protein coding or Non coding. See http://vega.sanger.ac.uk/info/about/gene_and_transcript_types.html.\",\"default\":null},{\"name\":\"strand\",\"type\":[\"null\",\"Strand\"],\"doc\":\"Feature strand, if known.\",\"default\":null},{\"name\":\"rank\",\"type\":[\"null\",\"int\"],\"doc\":\"Intron or exon rank.\",\"default\":null},{\"name\":\"total\",\"type\":[\"null\",\"int\"],\"doc\":\"Total number of introns or exons.\",\"default\":null},{\"name\":\"genomicHgvs\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"HGVS.g description of the variant. See http://www.hgvs.org/mutnomen/recs-DNA.html.\",\"default\":null},{\"name\":\"transcriptHgvs\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"HGVS.c description of the variant. See http://www.hgvs.org/mutnomen/recs-DNA.html.\",\"default\":null},{\"name\":\"proteinHgvs\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"HGVS.p description of the variant, if coding. See http://www.hgvs.org/mutnomen/recs-prot.html.\",\"default\":null},{\"name\":\"cdnaPosition\",\"type\":[\"null\",\"int\"],\"doc\":\"cDNA sequence position (one based).\",\"default\":null},{\"name\":\"cdnaLength\",\"type\":[\"null\",\"int\"],\"doc\":\"cDNA sequence length in base pairs (one based).\",\"default\":null},{\"name\":\"codingSequencePosition\",\"type\":[\"null\",\"int\"],\"doc\":\"Coding sequence position (one based, includes START and STOP codons).\",\"default\":null},{\"name\":\"codingSequenceLength\",\"type\":[\"null\",\"int\"],\"doc\":\"Coding sequence length in base pairs (one based, includes START and STOP codons).\",\"default\":null},{\"name\":\"referenceCodingSequence\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Coding sequence for the reference allele.\",\"default\":null},{\"name\":\"alternateCodingSequence\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Coding sequence of this alternate allele.\",\"default\":null},{\"name\":\"proteinPosition\",\"type\":[\"null\",\"int\"],\"doc\":\"Protein sequence position (one based, includes START but not STOP).\",\"default\":null},{\"name\":\"proteinLength\",\"type\":[\"null\",\"int\"],\"doc\":\"Protein sequence length in amino acids (one based, includes START but not STOP).\",\"default\":null},{\"name\":\"referenceProteinSequence\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Protein sequence for the reference allele.\",\"default\":null},{\"name\":\"alternateProteinSequence\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Protein sequence of this alternate allele.\",\"default\":null},{\"name\":\"distance\",\"type\":[\"null\",\"int\"],\"doc\":\"Distance in base pairs to the feature.\",\"default\":null},{\"name\":\"messages\",\"type\":{\"type\":\"array\",\"items\":\"VariantAnnotationMessage\"},\"doc\":\"Zero or more errors, warnings, or informative messages regarding variant annotation accuracy.\",\"default\":[]}]},{\"type\":\"record\",\"name\":\"VariantAnnotation\",\"doc\":\"Variant annotation.\",\"fields\":[{\"name\":\"ancestralAllele\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Ancestral allele, VCF INFO reserved key AA, Number=1, shared across all alternate\\n   alleles in the same VCF record.\",\"default\":null},{\"name\":\"alleleCount\",\"type\":[\"null\",\"int\"],\"doc\":\"Allele count, VCF INFO reserved key AC, Number=A, split for multi-allelic sites into\\n   a single integer value.\",\"default\":null},{\"name\":\"readDepth\",\"type\":[\"null\",\"int\"],\"doc\":\"Total read depth, VCF INFO reserved key AD, Number=R, split for multi-allelic\\n   sites into single integer values for the reference allele (referenceReadDepth) and\\n   the alternate allele (readDepth, this field).\",\"default\":null},{\"name\":\"forwardReadDepth\",\"type\":[\"null\",\"int\"],\"doc\":\"Forward strand read depth, VCF INFO reserved key ADF, Number=R, split for\\n   multi-allelic sites into single integer values for the reference allele\\n   (referenceForwardReadDepth) and the alternate allele (forwardReadDepth, this field).\",\"default\":null},{\"name\":\"reverseReadDepth\",\"type\":[\"null\",\"int\"],\"doc\":\"Reverse strand read depth, VCF INFO reserved key ADR, Number=R, split for\\n   multi-allelic sites into single integer values for the reference allele\\n   (referenceReverseReadDepth) and the alternate allele (reverseReadDepth, this field).\",\"default\":null},{\"name\":\"referenceReadDepth\",\"type\":[\"null\",\"int\"],\"doc\":\"Tot", "al read depth, VCF INFO reserved key AD, Number=R, split for multi-allelic\\n   sites into single integer values for the reference allele (referenceReadDepth, this field)\\n   and the alternate allele (readDepth).\",\"default\":null},{\"name\":\"referenceForwardReadDepth\",\"type\":[\"null\",\"int\"],\"doc\":\"Forward strand read depth, VCF INFO reserved key ADF, Number=R, split for\\n   multi-allelic sites into single integer values for the reference allele\\n   (referenceForwardReadDepth, this field) and the alternate allele (forwardReadDepth).\",\"default\":null},{\"name\":\"referenceReverseReadDepth\",\"type\":[\"null\",\"int\"],\"doc\":\"Reverse strand read depth, VCF INFO reserved key ADR, Number=R, split for\\n   multi-allelic sites into single integer values for the reference allele\\n   (referenceReverseReadDepth, this field) and the alternate allele (reverseReadDepth).\",\"default\":null},{\"name\":\"alleleFrequency\",\"type\":[\"null\",\"float\"],\"doc\":\"Minor allele frequency, VCF INFO reserved key AF, Number=A, split for multi-allelic\\n   sites into a single float value. Use this when frequencies are estimated from primary\\n   data, not calculated from called genotypes.\",\"default\":null},{\"name\":\"cigar\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"CIGAR string describing how to align an alternate allele to the reference\\n   allele, VCF INFO reserved key CIGAR, Number=A, split for multi-allelic sites into\\n   a single string value.\",\"default\":null},{\"name\":\"dbSnp\",\"type\":[\"null\",\"boolean\"],\"doc\":\"Membership in dbSNP, VCF INFO reserved key DB, Number=0. Until Number=A and\\n   Number=R flags are supported by the VCF specification, this value is shared\\n   across all alternate alleles in the same VCF record.\",\"default\":null},{\"name\":\"hapMap2\",\"type\":[\"null\",\"boolean\"],\"doc\":\"Membership in HapMap2, VCF INFO reserved key H2, Number=0. Until Number=A and\\n   Number=R flags are supported by the VCF specification, this value is shared\\n   across all alternate alleles in the same VCF record.\",\"default\":null},{\"name\":\"hapMap3\",\"type\":[\"null\",\"boolean\"],\"doc\":\"Membership in HapMap3, VCF INFO reserved key H3, Number=0. Until Number=A and\\n   Number=R flags are supported by the VCF specification, this value is shared\\n   across all alternate alleles in the same VCF record.\",\"default\":null},{\"name\":\"validated\",\"type\":[\"null\",\"boolean\"],\"doc\":\"Validated by follow up experiment, VCF INFO reserved key VALIDATED, Number=0.\\n   Until Number=A and Number=R flags are supported by the VCF specification, this\\n   value is shared across all alternate alleles in the same VCF record.\",\"default\":null},{\"name\":\"thousandGenomes\",\"type\":[\"null\",\"boolean\"],\"doc\":\"Membership in 1000 Genomes, VCF INFO reserved key 1000G, Number=0. Until\\n   Number=A and Number=R flags are supported by the VCF specification, this\\n   value is shared across all alternate alleles in the same VCF record.\",\"default\":null},{\"name\":\"somatic\",\"type\":[\"boolean\",\"null\"],\"doc\":\"True if this variant call is somatic; in this case, the reference allele will\\n   have been observed in another sample. VCF INFO reserved key \\\"SOMATIC\\\", Number=0.\\n   Until Number=A and Number=R flags are supported by the VCF specification, this value\\n   is shared across all alleles in the same VCF record.\",\"default\":false},{\"name\":\"transcriptEffects\",\"type\":{\"type\":\"array\",\"items\":\"TranscriptEffect\"},\"doc\":\"Zero or more transcript effects, predicted by a tool such as SnpEff or Ensembl VEP,\\n   one per transcript (or other feature). VCF INFO key ANN, split for multi-allelic\\n   sites. See http://snpeff.sourceforge.net/VCFannotationformat_v1.0.pdf.\",\"default\":[]},{\"name\":\"attributes\",\"type\":{\"type\":\"map\",\"values\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"avro.java.string\":\"String\"},\"doc\":\"Additional variant attributes that do not fit into the standard fields above.\\n   The values are stored as strings, even for flag, integer, and float types. VCF\\n   INFO key values with Number=., Number=0, Number=1, and Number=[n] are shared across\\n   all alternate alleles in the same VCF record. VCF INFO key values with Number=A are\\n   split for multi-allelic sites into a single value. VCF INFO key values with Number=R\\n   are split into an array of two values, [reference allele, alternate allele], separated\\n   by commas, e.g. \\\"0,1\\\".\",\"default\":{}}]},{\"type\":\"record\",\"name\":\"Variant\",\"doc\":\"Variant.\",\"fields\":[{\"name\":\"referenceName\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The reference this variant exists on. VCF column 1 \\\"CONTIG\\\".\",\"default\":null},{\"name\":\"start\",\"type\":[\"null\",\"long\"],\"doc\":\"The zero-based start position of this variant on the reference.\\n   VCF column 2 \\\"POS\\\" converted to zero-based coordinate system, closed-open intervals.\",\"default\":null},{\"name\":\"end\",\"type\":[\"null\",\"long\"],\"doc\":\"The zero-based, exclusive end position of this variant on the reference.\\n   Calculated by start + referenceAllele.length().\",\"default\":null},{\"name\":\"names\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},\"doc\":\"Zero or more unique names or identifiers for this variant. If this is a dbSNP\\n   variant it is encouraged to use the rs number(s). VCF column 3 \\\"ID\\\" shared across\\n   all alleles in the same VCF record.\",\"default\":[]},{\"name\":\"splitFromMultiAllelic\",\"type\":[\"boolean\",\"null\"],\"doc\":\"We split multi-allelic VCF lines into multiple single-alternate records.\\n   This bit is set if that happened for this record.\",\"default\":false},{\"name\":\"referenceAllele\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"A string describing the reference allele at this site. VCF column 4 \\\"REF\\\".\",\"default\":null},{\"name\":\"alternateAllele\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"A string describing the alternate allele at this site. VCF column 5 \\\"ALT\\\" split\\n   for multi-allelic sites.\",\"default\":null},{\"name\":\"quality\",\"type\":[\"null\",\"double\"],\"doc\":\"The Phred scaled probability that this allele is variant. VCF column 6 \\\"QUAL\\\".\\n   If this record is multi-allelic, this value may be incorrect.\",\"default\":null},{\"name\":\"filtersApplied\",\"type\":[\"null\",\"boolean\"],\"doc\":\"True if filters were applied for this variant. VCF column 7 \\\"FILTER\\\" any value other\\n   than the missing value.\",\"default\":null},{\"name\":\"filtersPassed\",\"type\":[\"null\",\"boolean\"],\"doc\":\"True if all filters for this variant passed. VCF column 7 \\\"FILTER\\\" value PASS.\",\"default\":null},{\"name\":\"filtersFailed\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},\"doc\":\"Zero or more filters that failed for this variant. VCF column 7 \\\"FILTER\\\" shared across\\n   all alleles in the same VCF record.\",\"default\":[]},{\"name\":\"annotation\",\"type\":[\"null\",\"VariantAnnotation\"],\"doc\":\"Annotation for this variant, if any.\",\"default\":null}]},{\"type\":\"enum\",\"name\":\"GenotypeAllele\",\"doc\":\"The genotype could not be called.\",\"symbols\":[\"REF\",\"ALT\",\"OTHER_ALT\",\"NO_CALL\"]},{\"type\":\"enum\",\"name\":\"GenotypeType\",\"doc\":\"The genotype could not be called at this site.\",\"symbols\":[\"HOM_REF\",\"HET\",\"HOM_ALT\",\"NO_CALL\"]},{\"type\":\"record\",\"name\":\"VariantCallingAnnotations\",\"doc\":\"This record represents all stats that, inside a VCF, are stored outside of the\\n sample but are computed based on the samples. For instance, MAPQ0 is an aggregate\\n stat computed from all samples and stored inside the INFO line.\",\"fields\":[{\"name\":\"filtersApplied\",\"type\":[\"null\",\"boolean\"],\"doc\":\"True if filters were applied for this genotype call. FORMAT field \\\"FT\\\" any value other\\n   than the missing value.\",\"default\":null},{\"name\":\"filtersPassed\",\"type\":[\"null\",\"boolean\"],\"doc\":\"True if all filters for this genotype call passed. FORMAT field \\\"FT\\\" value PASS.\",\"default\":null},{\"name\":\"filtersFailed\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},\"doc\":\"Zero or more filters that failed for this genotype call from FORMAT field \\\"FT\\\".\",\"default\":[]},{\"name\":\"downsampled\",\"type\":[\"null\",\"boolean\"],\"doc\":\"True if the reads covering this site were randomly downsampled to reduce coverage.\",\"default\":null},{\"name\":\"baseQRankSum\",\"type\":[\"null\",\"float\"],\"doc\":\"The Wilcoxon rank-sum", " test statistic of the base quality scores. The base quality\\n   scores are separated by whether or not the base supports the reference or the\\n   alternate allele.\",\"default\":null},{\"name\":\"fisherStrandBiasPValue\",\"type\":[\"null\",\"float\"],\"doc\":\"The Fisher's exact test score for the strand bias of the reference and alternate\\n   alleles. Stored as a phred scaled probability. Thus, if:\\n\\n   * a = The number of positive strand reads covering the reference allele\\n   * b = The number of positive strand reads covering the alternate allele\\n   * c = The number of negative strand reads covering the reference allele\\n   * d = The number of negative strand reads covering the alternate allele\\n\\n   This value takes the score:\\n   \\n   -10 log((a + b)! * (c + d)! * (a + c)! * (b + d)! / (a! b! c! d! n!)\\n\\n   Where n = a + b + c + d.\",\"default\":null},{\"name\":\"rmsMapQ\",\"type\":[\"null\",\"float\"],\"doc\":\"The root mean square of the mapping qualities of reads covering this site.\",\"default\":null},{\"name\":\"mapq0Reads\",\"type\":[\"null\",\"int\"],\"doc\":\"The number of reads at this site with mapping quality equal to 0.\",\"default\":null},{\"name\":\"mqRankSum\",\"type\":[\"null\",\"float\"],\"doc\":\"The Wilcoxon rank-sum test statistic of the mapping quality scores. The mapping\\n   quality scores are separated by whether or not the read supported the reference or the\\n   alternate allele.\",\"default\":null},{\"name\":\"readPositionRankSum\",\"type\":[\"null\",\"float\"],\"doc\":\"The Wilcoxon rank-sum test statistic of the position of the base in the read at this site.\\n   The positions are separated by whether or not the base supports the reference or the\\n   alternate allele.\",\"default\":null},{\"name\":\"genotypePriors\",\"type\":{\"type\":\"array\",\"items\":\"float\"},\"doc\":\"The log scale prior probabilities of the various genotype states at this site.\\n   The number of elements in this array should be equal to the ploidy at this\\n   site, plus 1.\",\"default\":[]},{\"name\":\"genotypePosteriors\",\"type\":{\"type\":\"array\",\"items\":\"float\"},\"doc\":\"The log scaled posterior probabilities of the various genotype states at this site,\\n   in this sample. The number of elements in this array should be equal to the ploidy at\\n   this site, plus 1.\",\"default\":[]},{\"name\":\"vqslod\",\"type\":[\"null\",\"float\"],\"doc\":\"The log-odds ratio of being a true vs. false variant under a trained statistical model.\\n   This model can be a multivariate Gaussian mixture, support vector machine, etc.\",\"default\":null},{\"name\":\"culprit\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"If known, the feature that contributed the most to this variant being classified as\\n   a false variant.\",\"default\":null},{\"name\":\"attributes\",\"type\":{\"type\":\"map\",\"values\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"avro.java.string\":\"String\"},\"doc\":\"Additional feature info that doesn't fit into the standard fields above.\\n   They are all encoded as (string, string) key-value pairs.\",\"default\":{}}]},{\"type\":\"record\",\"name\":\"Genotype\",\"doc\":\"Genotype.\",\"fields\":[{\"name\":\"variant\",\"type\":[\"null\",\"Variant\"],\"doc\":\"The variant called at this site.\",\"default\":null},{\"name\":\"referenceName\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The reference that this genotype's variant exists on.\",\"default\":null},{\"name\":\"start\",\"type\":[\"null\",\"long\"],\"doc\":\"The zero-based start position of this genotype's variant on the reference.\",\"default\":null},{\"name\":\"end\",\"type\":[\"null\",\"long\"],\"doc\":\"The zero-based, exclusive end position of this genotype's variant on the reference.\",\"default\":null},{\"name\":\"variantCallingAnnotations\",\"type\":[\"null\",\"VariantCallingAnnotations\"],\"doc\":\"Statistics collected at this site, if available.\",\"default\":null},{\"name\":\"sampleId\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The unique identifier for this sample. Join with Sample.id for sample metadata.\",\"default\":null},{\"name\":\"sampleDescription\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"A description of this sample.\",\"default\":null},{\"name\":\"processingDescription\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"A string describing the provenance of this sample and the processing applied\\n   in genotyping this sample.\",\"default\":null},{\"name\":\"alleles\",\"type\":{\"type\":\"array\",\"items\":\"GenotypeAllele\"},\"doc\":\"An array describing the genotype called at this site. The length of this\\n   array is equal to the ploidy of the sample at this site. This array may\\n   reference OTHER_ALT alleles if this site is multi-allelic in this sample.\",\"default\":[]},{\"name\":\"expectedAlleleDosage\",\"type\":[\"null\",\"float\"],\"doc\":\"The expected dosage of the alternate allele in this sample.\",\"default\":null},{\"name\":\"referenceReadDepth\",\"type\":[\"null\",\"int\"],\"doc\":\"The number of reads that show evidence for the reference at this site.\",\"default\":null},{\"name\":\"alternateReadDepth\",\"type\":[\"null\",\"int\"],\"doc\":\"The number of reads that show evidence for this alternate allele at this site.\",\"default\":null},{\"name\":\"readDepth\",\"type\":[\"null\",\"int\"],\"doc\":\"The total number of reads at this site. May not equal (alternateReadDepth +\\n   referenceReadDepth) if this site shows evidence of multiple alternate alleles.\\n   Analogous to VCF's DP.\",\"default\":null},{\"name\":\"minReadDepth\",\"type\":[\"null\",\"int\"],\"doc\":\"The minimum number of reads seen at this site across samples when joint\\n   calling variants. Analogous to VCF's MIN_DP.\",\"default\":null},{\"name\":\"genotypeQuality\",\"type\":[\"null\",\"int\"],\"doc\":\"The phred-scaled probability that we're correct for this genotype call.\\n   Analogous to VCF's GQ.\",\"default\":null},{\"name\":\"genotypeLikelihoods\",\"type\":{\"type\":\"array\",\"items\":\"double\"},\"doc\":\"Log scaled likelihoods that we have n copies of this alternate allele.\\n   The number of elements in this array should be equal to the ploidy at this\\n   site, plus 1. Analogous to VCF's PL.\",\"default\":[]},{\"name\":\"nonReferenceLikelihoods\",\"type\":{\"type\":\"array\",\"items\":\"double\"},\"doc\":\"Log scaled likelihoods that we have n non-reference alleles at this site.\\n   The number of elements in this array should be equal to the ploidy at this\\n   site, plus 1.\",\"default\":[]},{\"name\":\"strandBiasComponents\",\"type\":{\"type\":\"array\",\"items\":\"int\"},\"doc\":\"Component statistics which comprise the Fisher's Exact Test to detect strand bias.\\n   If populated, this element should have length 4.\",\"default\":[]},{\"name\":\"splitFromMultiAllelic\",\"type\":[\"boolean\",\"null\"],\"doc\":\"We split multi-allelic VCF lines into multiple single-alternate records.\\n   This bit is set if that happened for this record.\",\"default\":false},{\"name\":\"phased\",\"type\":[\"boolean\",\"null\"],\"doc\":\"True if this genotype is phased.\",\"default\":false},{\"name\":\"phaseSetId\",\"type\":[\"null\",\"int\"],\"doc\":\"The ID of this phase set, if this genotype is phased. Should only be populated\\n   if phased == true; else should be null.\",\"default\":null},{\"name\":\"phaseQuality\",\"type\":[\"null\",\"int\"],\"doc\":\"Phred scaled quality score for the phasing of this genotype, if this genotype\\n   is phased. Should only be populated if phased == true; else should be null.\",\"default\":null}]},{\"type\":\"record\",\"name\":\"Dbxref\",\"doc\":\"Database cross reference in GFF3 style DBTAG:ID format.\",\"fields\":[{\"name\":\"db\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Database tag in GFF3 style DBTAG:ID format, e.g. EMBL in EMBL:AA816246.\",\"default\":null},{\"name\":\"accession\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Accession number in GFF3 style DBTAG:ID format, e.g. AA816246 in EMBL:AA816246.\",\"default\":null}]},{\"type\":\"record\",\"name\":\"OntologyTerm\",\"doc\":\"Ontology term cross reference in GFF3 style DBTAG:ID format.\",\"fields\":[{\"name\":\"db\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Ontology abbreviation in GFF3 style DBTAG:ID format, e.g. GO in GO:0046703.\",\"default\":null},{\"name\":\"accession\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Ontology term accession number or identifer in GFF3 style DBTAG:ID format,\\n   e.g. 0046703 in GO:0046703.\",\"default\":null}]},{\"type\":\"record\",\"name\":\"Feature\",\"doc\":\"Feature, such as those represe", "nted in native file formats BED, GFF2/GTF,\\n GFF3, IntervalList, and NarrowPeak.\",\"fields\":[{\"name\":\"featureId\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Identifier for this feature. ID tag in GFF3.\",\"default\":null},{\"name\":\"sampleId\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Sample identifier for this feature. Join with Sample.id for sample metadata.\\n   sampleId tag in GFF3.\",\"default\":null},{\"name\":\"name\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Display name for this feature, e.g. DVL1. Name tag in GFF3, optional column 4 \\\"name\\\"\\n   in BED format.\",\"default\":null},{\"name\":\"source\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Source of this feature, typically the algorithm or operating procedure that generated\\n   this feature, e.g. GeneWise. Column 2 \\\"source\\\" in GFF3.\",\"default\":null},{\"name\":\"featureType\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Feature type, constrained by some formats to a term from the Sequence Ontology (SO),\\n   e.g. gene, mRNA, exon, or a SO accession number (SO:0000704, SO:0000234, SO:0000147,\\n   respectively). Column 3 \\\"type\\\" in GFF3.\",\"default\":null},{\"name\":\"referenceName\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Reference this feature is located on. Column 1 \\\"seqid\\\" in GFF3, column 1 \\\"chrom\\\"\\n   in BED format.\",\"default\":null},{\"name\":\"start\",\"type\":[\"null\",\"long\"],\"doc\":\"Start position for this feature, in zero-based coordinate system with closed-open\\n   intervals. This may require conversion from the coordinate system of the native\\n   file format. Column 4 \\\"start\\\" in GFF3, column 2 \\\"chromStart\\\" in BED format.\",\"default\":null},{\"name\":\"end\",\"type\":[\"null\",\"long\"],\"doc\":\"End position for this feature, in zero-based coordinate system with closed-open\\n   intervals. This may require conversion from the coordinate system of the native\\n   file format. Column 5 \\\"end\\\" in GFF3, column 3 \\\"chromEnd\\\" in BED format.\",\"default\":null},{\"name\":\"strand\",\"type\":[\"null\",\"Strand\"],\"doc\":\"Strand for this feature. Column 7 \\\"strand\\\" in GFF3, optional column 6 \\\"strand\\\"\\n   in BED format.\",\"default\":null},{\"name\":\"phase\",\"type\":[\"null\",\"int\"],\"doc\":\"For features of type \\\"CDS\\\", the phase indicates where the feature begins with reference\\n   to the reading frame. The phase is one of the integers 0, 1, or 2, indicating the number\\n   of bases that should be removed from the beginning of this feature to reach the first base\\n   of the next codon. Column 8 \\\"phase\\\" in GFF3.\",\"default\":null},{\"name\":\"frame\",\"type\":[\"null\",\"int\"],\"doc\":\"For features of type \\\"CDS\\\", the frame indicates whether the first base of the CDS segment is\\n   the first (frame 0), second (frame 1) or third (frame 2) in the codon of the ORF. Column 8\\n   \\\"frame\\\" in GFF2/GTF format.\",\"default\":null},{\"name\":\"score\",\"type\":[\"null\",\"double\"],\"doc\":\"Score for this feature. Column 6 \\\"score\\\" in GFF3, optional column 5\\n   \\\"score\\\" in BED format.\",\"default\":null},{\"name\":\"geneId\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Gene identifier, e.g. ENSG00000107404. gene_id tag in GFF2/GTF.\",\"default\":null},{\"name\":\"transcriptId\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Transcript identifier, e.g. ENST00000378891. transcript_id tag in GFF2/GTF.\",\"default\":null},{\"name\":\"exonId\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Exon identifier, e.g. ENSE00001479184. exon_id tag in GFF2/GTF.\",\"default\":null},{\"name\":\"aliases\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},\"doc\":\"Secondary names or identifiers for this feature. Alias tag in GFF3.\",\"default\":[]},{\"name\":\"parentIds\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},\"doc\":\"Parent feature identifiers. Parent tag in GFF3.\",\"default\":[]},{\"name\":\"target\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Target of a nucleotide-to-nucleotide or protein-to-nucleotide alignment\\n   feature. The format of the value is \\\"target_id start end [strand]\\\", where\\n   strand is optional and may be \\\"+\\\" or \\\"-\\\". Target tag in GFF3.\",\"default\":null},{\"name\":\"gap\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Alignment of the feature to the target in CIGAR format. Gap tag in GFF3.\",\"default\":null},{\"name\":\"derivesFrom\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Used to disambiguate the relationship between one feature and another when\\n   the relationship is a temporal one rather than a purely structural \\\"part of\\\"\\n   one. Derives_from tag in GFF3.\",\"default\":null},{\"name\":\"notes\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},\"doc\":\"Notes or comments for this feature. Note tag in GFF3.\",\"default\":[]},{\"name\":\"dbxrefs\",\"type\":{\"type\":\"array\",\"items\":\"Dbxref\"},\"doc\":\"Database cross references for this feature. Dbxref tag in GFF3.\",\"default\":[]},{\"name\":\"ontologyTerms\",\"type\":{\"type\":\"array\",\"items\":\"OntologyTerm\"},\"doc\":\"Ontology term cross references for this feature. Ontology_term tag in GFF3.\",\"default\":[]},{\"name\":\"circular\",\"type\":[\"null\",\"boolean\"],\"doc\":\"True if this feature is circular. Is_circular tag in GFF3.\",\"default\":null},{\"name\":\"attributes\",\"type\":{\"type\":\"map\",\"values\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"avro.java.string\":\"String\"},\"doc\":\"Additional feature attributes. Column 9 \\\"attributes\\\" in GFF3, excepting those\\n   reserved tags parsed into other fields, such as parentIds, dbxrefs, and ontologyTerms.\",\"default\":{}}]},{\"type\":\"record\",\"name\":\"Sample\",\"doc\":\"Sample.\",\"fields\":[{\"name\":\"id\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Identifier for this sample, e.g. IDENTIFIERS &rarr; PRIMARY_ID or other\\n   subelements of IDENTIFERS in SRA metadata, sample tag SM in read group @RG header lines\\n   in SAM/BAM files, or sample ID from the header or ##SAMPLE=&lt;ID=S_ID meta-information\\n   lines in VCF files.\",\"default\":null},{\"name\":\"name\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Descriptive name for this sample, e.g. SAMPLE_NAME &rarr; TAXON_ID, COMMON_NAME,\\n   INDIVIDUAL_NAME, or other subelements of SAMPLE_NAME in SRA metadata.\",\"default\":null},{\"name\":\"attributes\",\"type\":{\"type\":\"map\",\"values\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"avro.java.string\":\"String\"},\"doc\":\"Map of attributes. Common attributes may include: SRA metadata not mentioned above,\\n   e.g. SAMPLE &rarr; TITLE, SAMPLE &rarr; DESCRIPTION, and SAMPLE_ATTRIBUTES; ENA default\\n   sample checklist attributes such as cell_type, dev_stage, and germline; and Genomes,\\n   Mixture, and Description from sample meta-information lines in VCF files.\",\"default\":{}},{\"name\":\"processingSteps\",\"type\":{\"type\":\"array\",\"items\":\"ProcessingStep\"},\"doc\":\"The processing steps that have been applied to this sample.\",\"default\":[]}]},{\"type\":\"enum\",\"name\":\"Alphabet\",\"doc\":\"Protein alphabet.\",\"symbols\":[\"DNA\",\"RNA\",\"PROTEIN\"]},{\"type\":\"record\",\"name\":\"Sequence\",\"doc\":\"Contiguous sequence from an alphabet, e.g. a DNA contig, an RNA transcript,\\n or a protein translation.\",\"fields\":[{\"name\":\"name\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Name of this sequence.\",\"default\":null},{\"name\":\"description\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Description for this sequence.\",\"default\":null},{\"name\":\"alphabet\",\"type\":[\"Alphabet\",\"null\"],\"doc\":\"Alphabet for this sequence, defaults to Alphabet.DNA.\",\"default\":\"DNA\"},{\"name\":\"sequence\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Sequence.\",\"default\":null},{\"name\":\"length\",\"type\":[\"null\",\"long\"],\"doc\":\"Length of this sequence.\",\"default\":null},{\"name\":\"sampleId\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Sample identifier for this sequence. Join with Sample.id for sample metadata.\",\"default\":null},{\"name\":\"attributes\",\"type\":{\"type\":\"map\",\"values\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"avro.java.string\":\"String\"},\"doc\":\"Map of", " attributes.\",\"default\":{}}]},{\"type\":\"record\",\"name\":\"Slice\",\"doc\":\"View of a contiguous region of a sequence.\",\"fields\":[{\"name\":\"name\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Name of the sequence this slice views.\",\"default\":null},{\"name\":\"description\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Description for the sequence this slice views.\",\"default\":null},{\"name\":\"alphabet\",\"type\":[\"Alphabet\",\"null\"],\"doc\":\"Alphabet for the sequence this slice views, defaults to Alphabet.DNA.\",\"default\":\"DNA\"},{\"name\":\"sequence\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Sequence for this slice.\",\"default\":null},{\"name\":\"start\",\"type\":[\"null\",\"long\"],\"doc\":\"Start position for this slice on the sequence this slice views, in zero-based coordinate\\n   system with closed-open intervals.\",\"default\":null},{\"name\":\"end\",\"type\":[\"null\",\"long\"],\"doc\":\"End position for this slice on the sequence this slice views, in zero-based coordinate\\n   system with closed-open intervals.\",\"default\":null},{\"name\":\"strand\",\"type\":[\"Strand\",\"null\"],\"doc\":\"Strand for this slice, if any, defaults to Strand.INDEPENDENT.\",\"default\":\"INDEPENDENT\"},{\"name\":\"length\",\"type\":[\"null\",\"long\"],\"doc\":\"Length of this slice.\",\"default\":null},{\"name\":\"totalLength\",\"type\":[\"null\",\"long\"],\"doc\":\"Length of the sequence this slice views.\",\"default\":null},{\"name\":\"index\",\"type\":[\"null\",\"int\"],\"doc\":\"Index of this slice in a set of slices that covers the sequence this slice views, if any.\",\"default\":null},{\"name\":\"slices\",\"type\":[\"null\",\"int\"],\"doc\":\"Number of slices in a set of slices that covers the sequence this slice views, if any.\",\"default\":null},{\"name\":\"sampleId\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Sample identifier for this slice. Join with Sample.id for sample metadata.\",\"default\":null},{\"name\":\"attributes\",\"type\":{\"type\":\"map\",\"values\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"avro.java.string\":\"String\"},\"doc\":\"Map of attributes.\",\"default\":{}}]},{\"type\":\"record\",\"name\":\"Read\",\"doc\":\"Sequence with quality scores.\",\"fields\":[{\"name\":\"name\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Name of this read.\",\"default\":null},{\"name\":\"description\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Description for this read.\",\"default\":null},{\"name\":\"alphabet\",\"type\":[\"Alphabet\",\"null\"],\"doc\":\"Alphabet for this read, defaults to Alphabet.DNA.\",\"default\":\"DNA\"},{\"name\":\"sequence\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Sequence for this read.\",\"default\":null},{\"name\":\"length\",\"type\":[\"null\",\"long\"],\"doc\":\"Length of this read.\",\"default\":null},{\"name\":\"qualityScores\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Quality scores for this read, in Sanger format, encoding\\n   Phred quality scores from 0 to 93 using ASCII values 33 to 126.\",\"default\":null},{\"name\":\"sampleId\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Sample identifier for this read. Join with Sample.id for sample metadata.\",\"default\":null},{\"name\":\"attributes\",\"type\":{\"type\":\"map\",\"values\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"avro.java.string\":\"String\"},\"doc\":\"Map of attributes.\",\"default\":{}}]}],\"messages\":{}}"});

    public static interface Callback
    extends BDG {
        public static final Protocol PROTOCOL = PROTOCOL;
    }
}

