/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.formats.avro;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class Dbxref
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -85743622064731592L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"Dbxref\",\"namespace\":\"org.bdgenomics.formats.avro\",\"doc\":\"Database cross reference in GFF3 style DBTAG:ID format.\",\"fields\":[{\"name\":\"db\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Database tag in GFF3 style DBTAG:ID format, e.g. EMBL in EMBL:AA816246.\",\"default\":null},{\"name\":\"accession\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Accession number in GFF3 style DBTAG:ID format, e.g. AA816246 in EMBL:AA816246.\",\"default\":null}]}");
    private static SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<Dbxref> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<Dbxref> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    @Deprecated
    public String db;
    @Deprecated
    public String accession;
    private static final DatumWriter<Dbxref> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<Dbxref> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageDecoder<Dbxref> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<Dbxref> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static Dbxref fromByteBuffer(ByteBuffer b) throws IOException {
        return (Dbxref)((Object)DECODER.decode(b));
    }

    public Dbxref() {
    }

    public Dbxref(String db, String accession) {
        this.db = db;
        this.accession = accession;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.db;
            }
            case 1: {
                return this.accession;
            }
        }
        throw new AvroRuntimeException("Bad index");
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.db = (String)value$;
                break;
            }
            case 1: {
                this.accession = (String)value$;
                break;
            }
            default: {
                throw new AvroRuntimeException("Bad index");
            }
        }
    }

    public String getDb() {
        return this.db;
    }

    public void setDb(String value) {
        this.db = value;
    }

    public String getAccession() {
        return this.accession;
    }

    public void setAccession(String value) {
        this.accession = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        return new Builder(other);
    }

    public static Builder newBuilder(Dbxref other) {
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    public static class Builder
    extends SpecificRecordBuilderBase<Dbxref>
    implements RecordBuilder<Dbxref> {
        private String db;
        private String accession;

        private Builder() {
            super(SCHEMA$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.db)) {
                this.db = (String)this.data().deepCopy(this.fields()[0].schema(), (Object)other.db);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.accession)) {
                this.accession = (String)this.data().deepCopy(this.fields()[1].schema(), (Object)other.accession);
                this.fieldSetFlags()[1] = true;
            }
        }

        private Builder(Dbxref other) {
            super(SCHEMA$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.db)) {
                this.db = (String)this.data().deepCopy(this.fields()[0].schema(), (Object)other.db);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.accession)) {
                this.accession = (String)this.data().deepCopy(this.fields()[1].schema(), (Object)other.accession);
                this.fieldSetFlags()[1] = true;
            }
        }

        public String getDb() {
            return this.db;
        }

        public Builder setDb(String value) {
            this.validate(this.fields()[0], value);
            this.db = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasDb() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearDb() {
            this.db = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public String getAccession() {
            return this.accession;
        }

        public Builder setAccession(String value) {
            this.validate(this.fields()[1], value);
            this.accession = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasAccession() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearAccession() {
            this.accession = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public Dbxref build() {
            try {
                Dbxref record = new Dbxref();
                record.db = this.fieldSetFlags()[0] ? this.db : (String)this.defaultValue(this.fields()[0]);
                record.accession = this.fieldSetFlags()[1] ? this.accession : (String)this.defaultValue(this.fields()[1]);
                return record;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

