/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.formats.avro;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.bdgenomics.formats.avro.Dbxref;
import org.bdgenomics.formats.avro.OntologyTerm;
import org.bdgenomics.formats.avro.Strand;

@AvroGenerated
public class Feature
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 5754783011182420776L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"Feature\",\"namespace\":\"org.bdgenomics.formats.avro\",\"doc\":\"Feature, such as those represented in native file formats BED, GFF2/GTF,\\n GFF3, IntervalList, and NarrowPeak.\",\"fields\":[{\"name\":\"featureId\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Identifier for this feature. ID tag in GFF3.\",\"default\":null},{\"name\":\"sampleId\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Sample identifier for this feature. Join with Sample.id for sample metadata.\\n   sampleId tag in GFF3.\",\"default\":null},{\"name\":\"name\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Display name for this feature, e.g. DVL1. Name tag in GFF3, optional column 4 \\\"name\\\"\\n   in BED format.\",\"default\":null},{\"name\":\"source\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Source of this feature, typically the algorithm or operating procedure that generated\\n   this feature, e.g. GeneWise. Column 2 \\\"source\\\" in GFF3.\",\"default\":null},{\"name\":\"featureType\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Feature type, constrained by some formats to a term from the Sequence Ontology (SO),\\n   e.g. gene, mRNA, exon, or a SO accession number (SO:0000704, SO:0000234, SO:0000147,\\n   respectively). Column 3 \\\"type\\\" in GFF3.\",\"default\":null},{\"name\":\"referenceName\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Reference this feature is located on. Column 1 \\\"seqid\\\" in GFF3, column 1 \\\"chrom\\\"\\n   in BED format.\",\"default\":null},{\"name\":\"start\",\"type\":[\"null\",\"long\"],\"doc\":\"Start position for this feature, in zero-based coordinate system with closed-open\\n   intervals. This may require conversion from the coordinate system of the native\\n   file format. Column 4 \\\"start\\\" in GFF3, column 2 \\\"chromStart\\\" in BED format.\",\"default\":null},{\"name\":\"end\",\"type\":[\"null\",\"long\"],\"doc\":\"End position for this feature, in zero-based coordinate system with closed-open\\n   intervals. This may require conversion from the coordinate system of the native\\n   file format. Column 5 \\\"end\\\" in GFF3, column 3 \\\"chromEnd\\\" in BED format.\",\"default\":null},{\"name\":\"strand\",\"type\":[\"null\",{\"type\":\"enum\",\"name\":\"Strand\",\"doc\":\"Strandedness is relevant, but unknown (\\\"?\\\").\",\"symbols\":[\"FORWARD\",\"REVERSE\",\"INDEPENDENT\",\"UNKNOWN\"]}],\"doc\":\"Strand for this feature. Column 7 \\\"strand\\\" in GFF3, optional column 6 \\\"strand\\\"\\n   in BED format.\",\"default\":null},{\"name\":\"phase\",\"type\":[\"null\",\"int\"],\"doc\":\"For features of type \\\"CDS\\\", the phase indicates where the feature begins with reference\\n   to the reading frame. The phase is one of the integers 0, 1, or 2, indicating the number\\n   of bases that should be removed from the beginning of this feature to reach the first base\\n   of the next codon. Column 8 \\\"phase\\\" in GFF3.\",\"default\":null},{\"name\":\"frame\",\"type\":[\"null\",\"int\"],\"doc\":\"For features of type \\\"CDS\\\", the frame indicates whether the first base of the CDS segment is\\n   the first (frame 0), second (frame 1) or third (frame 2) in the codon of the ORF. Column 8\\n   \\\"frame\\\" in GFF2/GTF format.\",\"default\":null},{\"name\":\"score\",\"type\":[\"null\",\"double\"],\"doc\":\"Score for this feature. Column 6 \\\"score\\\" in GFF3, optional column 5\\n   \\\"score\\\" in BED format.\",\"default\":null},{\"name\":\"geneId\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Gene identifier, e.g. ENSG00000107404. gene_id tag in GFF2/GTF.\",\"default\":null},{\"name\":\"transcriptId\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Transcript identifier, e.g. ENST00000378891. transcript_id tag in GFF2/GTF.\",\"default\":null},{\"name\":\"exonId\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Exon identifier, e.g. ENSE00001479184. exon_id tag in GFF2/GTF.\",\"default\":null},{\"name\":\"aliases\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},\"doc\":\"Secondary names or identifiers for this feature. Alias tag in GFF3.\",\"default\":[]},{\"name\":\"parentIds\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},\"doc\":\"Parent feature identifiers. Parent tag in GFF3.\",\"default\":[]},{\"name\":\"target\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Target of a nucleotide-to-nucleotide or protein-to-nucleotide alignment\\n   feature. The format of the value is \\\"target_id start end [strand]\\\", where\\n   strand is optional and may be \\\"+\\\" or \\\"-\\\". Target tag in GFF3.\",\"default\":null},{\"name\":\"gap\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Alignment of the feature to the target in CIGAR format. Gap tag in GFF3.\",\"default\":null},{\"name\":\"derivesFrom\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Used to disambiguate the relationship between one feature and another when\\n   the relationship is a temporal one rather than a purely structural \\\"part of\\\"\\n   one. Derives_from tag in GFF3.\",\"default\":null},{\"name\":\"notes\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},\"doc\":\"Notes or comments for this feature. Note tag in GFF3.\",\"default\":[]},{\"name\":\"dbxrefs\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"record\",\"name\":\"Dbxref\",\"doc\":\"Database cross reference in GFF3 style DBTAG:ID format.\",\"fields\":[{\"name\":\"db\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Database tag in GFF3 style DBTAG:ID format, e.g. EMBL in EMBL:AA816246.\",\"default\":null},{\"name\":\"accession\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Accession number in GFF3 style DBTAG:ID format, e.g. AA816246 in EMBL:AA816246.\",\"default\":null}]}},\"doc\":\"Database cross references for this feature. Dbxref tag in GFF3.\",\"default\":[]},{\"name\":\"ontologyTerms\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"record\",\"name\":\"OntologyTerm\",\"doc\":\"Ontology term cross reference in GFF3 style DBTAG:ID format.\",\"fields\":[{\"name\":\"db\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Ontology abbreviation in GFF3 style DBTAG:ID format, e.g. GO in GO:0046703.\",\"default\":null},{\"name\":\"accession\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Ontology term accession number or identifer in GFF3 style DBTAG:ID format,\\n   e.g. 0046703 in GO:0046703.\",\"default\":null}]}},\"doc\":\"Ontology term cross references for this feature. Ontology_term tag in GFF3.\",\"default\":[]},{\"name\":\"circular\",\"type\":[\"null\",\"boolean\"],\"doc\":\"True if this feature is circular. Is_circular tag in GFF3.\",\"default\":null},{\"name\":\"attributes\",\"type\":{\"type\":\"map\",\"values\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"avro.java.string\":\"String\"},\"doc\":\"Additional feature attributes. Column 9 \\\"attributes\\\" in GFF3, excepting those\\n   reserved tags parsed into other fields, such as parentIds, dbxrefs, and ontologyTerms.\",\"default\":{}}]}");
    private static SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<Feature> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<Feature> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    @Deprecated
    public String featureId;
    @Deprecated
    public String sampleId;
    @Deprecated
    public String name;
    @Deprecated
    public String source;
    @Deprecated
    public String featureType;
    @Deprecated
    public String referenceName;
    @Deprecated
    public Long start;
    @Deprecated
    public Long end;
    @Deprecated
    public Strand strand;
    @Deprecated
    public Integer phase;
    @Deprecated
    public Integer frame;
    @Deprecated
    public Double score;
    @Deprecated
    public String geneId;
    @Deprecated
    public String transcriptId;
    @Deprecated
    public String exonId;
    @Deprecated
    public List<String> aliases;
    @Deprecated
    public List<String> parentIds;
    @Deprecated
    public String target;
    @Deprecated
    public String gap;
    @Deprecated
    public String derivesFrom;
    @Deprecated
    public List<String> notes;
    @Deprecated
    public List<Dbxref> dbxrefs;
    @Deprecated
    public List<OntologyTerm> ontologyTerms;
    @Deprecated
    public Boolean circular;
    @Deprecated
    public Map<String, String> attributes;
    private static final DatumWriter<Feature> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<Feature> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageDecoder<Feature> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<Feature> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static Feature fromByteBuffer(ByteBuffer b) throws IOException {
        return (Feature)((Object)DECODER.decode(b));
    }

    public Feature() {
    }

    public Feature(String featureId, String sampleId, String name, String source, String featureType, String referenceName, Long start, Long end, Strand strand, Integer phase, Integer frame, Double score, String geneId, String transcriptId, String exonId, List<String> aliases, List<String> parentIds, String target, String gap, String derivesFrom, List<String> notes, List<Dbxref> dbxrefs, List<OntologyTerm> ontologyTerms, Boolean circular, Map<String, String> attributes) {
        this.featureId = featureId;
        this.sampleId = sampleId;
        this.name = name;
        this.source = source;
        this.featureType = featureType;
        this.referenceName = referenceName;
        this.start = start;
        this.end = end;
        this.strand = strand;
        this.phase = phase;
        this.frame = frame;
        this.score = score;
        this.geneId = geneId;
        this.transcriptId = transcriptId;
        this.exonId = exonId;
        this.aliases = aliases;
        this.parentIds = parentIds;
        this.target = target;
        this.gap = gap;
        this.derivesFrom = derivesFrom;
        this.notes = notes;
        this.dbxrefs = dbxrefs;
        this.ontologyTerms = ontologyTerms;
        this.circular = circular;
        this.attributes = attributes;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.featureId;
            }
            case 1: {
                return this.sampleId;
            }
            case 2: {
                return this.name;
            }
            case 3: {
                return this.source;
            }
            case 4: {
                return this.featureType;
            }
            case 5: {
                return this.referenceName;
            }
            case 6: {
                return this.start;
            }
            case 7: {
                return this.end;
            }
            case 8: {
                return this.strand;
            }
            case 9: {
                return this.phase;
            }
            case 10: {
                return this.frame;
            }
            case 11: {
                return this.score;
            }
            case 12: {
                return this.geneId;
            }
            case 13: {
                return this.transcriptId;
            }
            case 14: {
                return this.exonId;
            }
            case 15: {
                return this.aliases;
            }
            case 16: {
                return this.parentIds;
            }
            case 17: {
                return this.target;
            }
            case 18: {
                return this.gap;
            }
            case 19: {
                return this.derivesFrom;
            }
            case 20: {
                return this.notes;
            }
            case 21: {
                return this.dbxrefs;
            }
            case 22: {
                return this.ontologyTerms;
            }
            case 23: {
                return this.circular;
            }
            case 24: {
                return this.attributes;
            }
        }
        throw new AvroRuntimeException("Bad index");
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.featureId = (String)value$;
                break;
            }
            case 1: {
                this.sampleId = (String)value$;
                break;
            }
            case 2: {
                this.name = (String)value$;
                break;
            }
            case 3: {
                this.source = (String)value$;
                break;
            }
            case 4: {
                this.featureType = (String)value$;
                break;
            }
            case 5: {
                this.referenceName = (String)value$;
                break;
            }
            case 6: {
                this.start = (Long)value$;
                break;
            }
            case 7: {
                this.end = (Long)value$;
                break;
            }
            case 8: {
                this.strand = (Strand)((Object)value$);
                break;
            }
            case 9: {
                this.phase = (Integer)value$;
                break;
            }
            case 10: {
                this.frame = (Integer)value$;
                break;
            }
            case 11: {
                this.score = (Double)value$;
                break;
            }
            case 12: {
                this.geneId = (String)value$;
                break;
            }
            case 13: {
                this.transcriptId = (String)value$;
                break;
            }
            case 14: {
                this.exonId = (String)value$;
                break;
            }
            case 15: {
                this.aliases = (List)value$;
                break;
            }
            case 16: {
                this.parentIds = (List)value$;
                break;
            }
            case 17: {
                this.target = (String)value$;
                break;
            }
            case 18: {
                this.gap = (String)value$;
                break;
            }
            case 19: {
                this.derivesFrom = (String)value$;
                break;
            }
            case 20: {
                this.notes = (List)value$;
                break;
            }
            case 21: {
                this.dbxrefs = (List)value$;
                break;
            }
            case 22: {
                this.ontologyTerms = (List)value$;
                break;
            }
            case 23: {
                this.circular = (Boolean)value$;
                break;
            }
            case 24: {
                this.attributes = (Map)value$;
                break;
            }
            default: {
                throw new AvroRuntimeException("Bad index");
            }
        }
    }

    public String getFeatureId() {
        return this.featureId;
    }

    public void setFeatureId(String value) {
        this.featureId = value;
    }

    public String getSampleId() {
        return this.sampleId;
    }

    public void setSampleId(String value) {
        this.sampleId = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String value) {
        this.source = value;
    }

    public String getFeatureType() {
        return this.featureType;
    }

    public void setFeatureType(String value) {
        this.featureType = value;
    }

    public String getReferenceName() {
        return this.referenceName;
    }

    public void setReferenceName(String value) {
        this.referenceName = value;
    }

    public Long getStart() {
        return this.start;
    }

    public void setStart(Long value) {
        this.start = value;
    }

    public Long getEnd() {
        return this.end;
    }

    public void setEnd(Long value) {
        this.end = value;
    }

    public Strand getStrand() {
        return this.strand;
    }

    public void setStrand(Strand value) {
        this.strand = value;
    }

    public Integer getPhase() {
        return this.phase;
    }

    public void setPhase(Integer value) {
        this.phase = value;
    }

    public Integer getFrame() {
        return this.frame;
    }

    public void setFrame(Integer value) {
        this.frame = value;
    }

    public Double getScore() {
        return this.score;
    }

    public void setScore(Double value) {
        this.score = value;
    }

    public String getGeneId() {
        return this.geneId;
    }

    public void setGeneId(String value) {
        this.geneId = value;
    }

    public String getTranscriptId() {
        return this.transcriptId;
    }

    public void setTranscriptId(String value) {
        this.transcriptId = value;
    }

    public String getExonId() {
        return this.exonId;
    }

    public void setExonId(String value) {
        this.exonId = value;
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public void setAliases(List<String> value) {
        this.aliases = value;
    }

    public List<String> getParentIds() {
        return this.parentIds;
    }

    public void setParentIds(List<String> value) {
        this.parentIds = value;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String value) {
        this.target = value;
    }

    public String getGap() {
        return this.gap;
    }

    public void setGap(String value) {
        this.gap = value;
    }

    public String getDerivesFrom() {
        return this.derivesFrom;
    }

    public void setDerivesFrom(String value) {
        this.derivesFrom = value;
    }

    public List<String> getNotes() {
        return this.notes;
    }

    public void setNotes(List<String> value) {
        this.notes = value;
    }

    public List<Dbxref> getDbxrefs() {
        return this.dbxrefs;
    }

    public void setDbxrefs(List<Dbxref> value) {
        this.dbxrefs = value;
    }

    public List<OntologyTerm> getOntologyTerms() {
        return this.ontologyTerms;
    }

    public void setOntologyTerms(List<OntologyTerm> value) {
        this.ontologyTerms = value;
    }

    public Boolean getCircular() {
        return this.circular;
    }

    public void setCircular(Boolean value) {
        this.circular = value;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> value) {
        this.attributes = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        return new Builder(other);
    }

    public static Builder newBuilder(Feature other) {
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    public static class Builder
    extends SpecificRecordBuilderBase<Feature>
    implements RecordBuilder<Feature> {
        private String featureId;
        private String sampleId;
        private String name;
        private String source;
        private String featureType;
        private String referenceName;
        private Long start;
        private Long end;
        private Strand strand;
        private Integer phase;
        private Integer frame;
        private Double score;
        private String geneId;
        private String transcriptId;
        private String exonId;
        private List<String> aliases;
        private List<String> parentIds;
        private String target;
        private String gap;
        private String derivesFrom;
        private List<String> notes;
        private List<Dbxref> dbxrefs;
        private List<OntologyTerm> ontologyTerms;
        private Boolean circular;
        private Map<String, String> attributes;

        private Builder() {
            super(SCHEMA$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.featureId)) {
                this.featureId = (String)this.data().deepCopy(this.fields()[0].schema(), (Object)other.featureId);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.sampleId)) {
                this.sampleId = (String)this.data().deepCopy(this.fields()[1].schema(), (Object)other.sampleId);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.name)) {
                this.name = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.name);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.source)) {
                this.source = (String)this.data().deepCopy(this.fields()[3].schema(), (Object)other.source);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.featureType)) {
                this.featureType = (String)this.data().deepCopy(this.fields()[4].schema(), (Object)other.featureType);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.referenceName)) {
                this.referenceName = (String)this.data().deepCopy(this.fields()[5].schema(), (Object)other.referenceName);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.start)) {
                this.start = (Long)this.data().deepCopy(this.fields()[6].schema(), (Object)other.start);
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.end)) {
                this.end = (Long)this.data().deepCopy(this.fields()[7].schema(), (Object)other.end);
                this.fieldSetFlags()[7] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)((Object)other.strand))) {
                this.strand = (Strand)((Object)this.data().deepCopy(this.fields()[8].schema(), (Object)other.strand));
                this.fieldSetFlags()[8] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.phase)) {
                this.phase = (Integer)this.data().deepCopy(this.fields()[9].schema(), (Object)other.phase);
                this.fieldSetFlags()[9] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)other.frame)) {
                this.frame = (Integer)this.data().deepCopy(this.fields()[10].schema(), (Object)other.frame);
                this.fieldSetFlags()[10] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)other.score)) {
                this.score = (Double)this.data().deepCopy(this.fields()[11].schema(), (Object)other.score);
                this.fieldSetFlags()[11] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[12], (Object)other.geneId)) {
                this.geneId = (String)this.data().deepCopy(this.fields()[12].schema(), (Object)other.geneId);
                this.fieldSetFlags()[12] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[13], (Object)other.transcriptId)) {
                this.transcriptId = (String)this.data().deepCopy(this.fields()[13].schema(), (Object)other.transcriptId);
                this.fieldSetFlags()[13] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[14], (Object)other.exonId)) {
                this.exonId = (String)this.data().deepCopy(this.fields()[14].schema(), (Object)other.exonId);
                this.fieldSetFlags()[14] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[15], other.aliases)) {
                this.aliases = (List)this.data().deepCopy(this.fields()[15].schema(), other.aliases);
                this.fieldSetFlags()[15] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[16], other.parentIds)) {
                this.parentIds = (List)this.data().deepCopy(this.fields()[16].schema(), other.parentIds);
                this.fieldSetFlags()[16] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[17], (Object)other.target)) {
                this.target = (String)this.data().deepCopy(this.fields()[17].schema(), (Object)other.target);
                this.fieldSetFlags()[17] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[18], (Object)other.gap)) {
                this.gap = (String)this.data().deepCopy(this.fields()[18].schema(), (Object)other.gap);
                this.fieldSetFlags()[18] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[19], (Object)other.derivesFrom)) {
                this.derivesFrom = (String)this.data().deepCopy(this.fields()[19].schema(), (Object)other.derivesFrom);
                this.fieldSetFlags()[19] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[20], other.notes)) {
                this.notes = (List)this.data().deepCopy(this.fields()[20].schema(), other.notes);
                this.fieldSetFlags()[20] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[21], other.dbxrefs)) {
                this.dbxrefs = (List)this.data().deepCopy(this.fields()[21].schema(), other.dbxrefs);
                this.fieldSetFlags()[21] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[22], other.ontologyTerms)) {
                this.ontologyTerms = (List)this.data().deepCopy(this.fields()[22].schema(), other.ontologyTerms);
                this.fieldSetFlags()[22] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[23], (Object)other.circular)) {
                this.circular = (Boolean)this.data().deepCopy(this.fields()[23].schema(), (Object)other.circular);
                this.fieldSetFlags()[23] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[24], other.attributes)) {
                this.attributes = (Map)this.data().deepCopy(this.fields()[24].schema(), other.attributes);
                this.fieldSetFlags()[24] = true;
            }
        }

        private Builder(Feature other) {
            super(SCHEMA$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.featureId)) {
                this.featureId = (String)this.data().deepCopy(this.fields()[0].schema(), (Object)other.featureId);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.sampleId)) {
                this.sampleId = (String)this.data().deepCopy(this.fields()[1].schema(), (Object)other.sampleId);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.name)) {
                this.name = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.name);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.source)) {
                this.source = (String)this.data().deepCopy(this.fields()[3].schema(), (Object)other.source);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.featureType)) {
                this.featureType = (String)this.data().deepCopy(this.fields()[4].schema(), (Object)other.featureType);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.referenceName)) {
                this.referenceName = (String)this.data().deepCopy(this.fields()[5].schema(), (Object)other.referenceName);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.start)) {
                this.start = (Long)this.data().deepCopy(this.fields()[6].schema(), (Object)other.start);
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.end)) {
                this.end = (Long)this.data().deepCopy(this.fields()[7].schema(), (Object)other.end);
                this.fieldSetFlags()[7] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)((Object)other.strand))) {
                this.strand = (Strand)((Object)this.data().deepCopy(this.fields()[8].schema(), (Object)other.strand));
                this.fieldSetFlags()[8] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.phase)) {
                this.phase = (Integer)this.data().deepCopy(this.fields()[9].schema(), (Object)other.phase);
                this.fieldSetFlags()[9] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)other.frame)) {
                this.frame = (Integer)this.data().deepCopy(this.fields()[10].schema(), (Object)other.frame);
                this.fieldSetFlags()[10] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)other.score)) {
                this.score = (Double)this.data().deepCopy(this.fields()[11].schema(), (Object)other.score);
                this.fieldSetFlags()[11] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[12], (Object)other.geneId)) {
                this.geneId = (String)this.data().deepCopy(this.fields()[12].schema(), (Object)other.geneId);
                this.fieldSetFlags()[12] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[13], (Object)other.transcriptId)) {
                this.transcriptId = (String)this.data().deepCopy(this.fields()[13].schema(), (Object)other.transcriptId);
                this.fieldSetFlags()[13] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[14], (Object)other.exonId)) {
                this.exonId = (String)this.data().deepCopy(this.fields()[14].schema(), (Object)other.exonId);
                this.fieldSetFlags()[14] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[15], other.aliases)) {
                this.aliases = (List)this.data().deepCopy(this.fields()[15].schema(), other.aliases);
                this.fieldSetFlags()[15] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[16], other.parentIds)) {
                this.parentIds = (List)this.data().deepCopy(this.fields()[16].schema(), other.parentIds);
                this.fieldSetFlags()[16] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[17], (Object)other.target)) {
                this.target = (String)this.data().deepCopy(this.fields()[17].schema(), (Object)other.target);
                this.fieldSetFlags()[17] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[18], (Object)other.gap)) {
                this.gap = (String)this.data().deepCopy(this.fields()[18].schema(), (Object)other.gap);
                this.fieldSetFlags()[18] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[19], (Object)other.derivesFrom)) {
                this.derivesFrom = (String)this.data().deepCopy(this.fields()[19].schema(), (Object)other.derivesFrom);
                this.fieldSetFlags()[19] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[20], other.notes)) {
                this.notes = (List)this.data().deepCopy(this.fields()[20].schema(), other.notes);
                this.fieldSetFlags()[20] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[21], other.dbxrefs)) {
                this.dbxrefs = (List)this.data().deepCopy(this.fields()[21].schema(), other.dbxrefs);
                this.fieldSetFlags()[21] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[22], other.ontologyTerms)) {
                this.ontologyTerms = (List)this.data().deepCopy(this.fields()[22].schema(), other.ontologyTerms);
                this.fieldSetFlags()[22] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[23], (Object)other.circular)) {
                this.circular = (Boolean)this.data().deepCopy(this.fields()[23].schema(), (Object)other.circular);
                this.fieldSetFlags()[23] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[24], other.attributes)) {
                this.attributes = (Map)this.data().deepCopy(this.fields()[24].schema(), other.attributes);
                this.fieldSetFlags()[24] = true;
            }
        }

        public String getFeatureId() {
            return this.featureId;
        }

        public Builder setFeatureId(String value) {
            this.validate(this.fields()[0], value);
            this.featureId = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasFeatureId() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearFeatureId() {
            this.featureId = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public String getSampleId() {
            return this.sampleId;
        }

        public Builder setSampleId(String value) {
            this.validate(this.fields()[1], value);
            this.sampleId = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasSampleId() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearSampleId() {
            this.sampleId = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String value) {
            this.validate(this.fields()[2], value);
            this.name = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasName() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearName() {
            this.name = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public String getSource() {
            return this.source;
        }

        public Builder setSource(String value) {
            this.validate(this.fields()[3], value);
            this.source = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasSource() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearSource() {
            this.source = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public String getFeatureType() {
            return this.featureType;
        }

        public Builder setFeatureType(String value) {
            this.validate(this.fields()[4], value);
            this.featureType = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasFeatureType() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearFeatureType() {
            this.featureType = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public String getReferenceName() {
            return this.referenceName;
        }

        public Builder setReferenceName(String value) {
            this.validate(this.fields()[5], value);
            this.referenceName = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasReferenceName() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearReferenceName() {
            this.referenceName = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public Long getStart() {
            return this.start;
        }

        public Builder setStart(Long value) {
            this.validate(this.fields()[6], value);
            this.start = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasStart() {
            return this.fieldSetFlags()[6];
        }

        public Builder clearStart() {
            this.start = null;
            this.fieldSetFlags()[6] = false;
            return this;
        }

        public Long getEnd() {
            return this.end;
        }

        public Builder setEnd(Long value) {
            this.validate(this.fields()[7], value);
            this.end = value;
            this.fieldSetFlags()[7] = true;
            return this;
        }

        public boolean hasEnd() {
            return this.fieldSetFlags()[7];
        }

        public Builder clearEnd() {
            this.end = null;
            this.fieldSetFlags()[7] = false;
            return this;
        }

        public Strand getStrand() {
            return this.strand;
        }

        public Builder setStrand(Strand value) {
            this.validate(this.fields()[8], (Object)value);
            this.strand = value;
            this.fieldSetFlags()[8] = true;
            return this;
        }

        public boolean hasStrand() {
            return this.fieldSetFlags()[8];
        }

        public Builder clearStrand() {
            this.strand = null;
            this.fieldSetFlags()[8] = false;
            return this;
        }

        public Integer getPhase() {
            return this.phase;
        }

        public Builder setPhase(Integer value) {
            this.validate(this.fields()[9], value);
            this.phase = value;
            this.fieldSetFlags()[9] = true;
            return this;
        }

        public boolean hasPhase() {
            return this.fieldSetFlags()[9];
        }

        public Builder clearPhase() {
            this.phase = null;
            this.fieldSetFlags()[9] = false;
            return this;
        }

        public Integer getFrame() {
            return this.frame;
        }

        public Builder setFrame(Integer value) {
            this.validate(this.fields()[10], value);
            this.frame = value;
            this.fieldSetFlags()[10] = true;
            return this;
        }

        public boolean hasFrame() {
            return this.fieldSetFlags()[10];
        }

        public Builder clearFrame() {
            this.frame = null;
            this.fieldSetFlags()[10] = false;
            return this;
        }

        public Double getScore() {
            return this.score;
        }

        public Builder setScore(Double value) {
            this.validate(this.fields()[11], value);
            this.score = value;
            this.fieldSetFlags()[11] = true;
            return this;
        }

        public boolean hasScore() {
            return this.fieldSetFlags()[11];
        }

        public Builder clearScore() {
            this.score = null;
            this.fieldSetFlags()[11] = false;
            return this;
        }

        public String getGeneId() {
            return this.geneId;
        }

        public Builder setGeneId(String value) {
            this.validate(this.fields()[12], value);
            this.geneId = value;
            this.fieldSetFlags()[12] = true;
            return this;
        }

        public boolean hasGeneId() {
            return this.fieldSetFlags()[12];
        }

        public Builder clearGeneId() {
            this.geneId = null;
            this.fieldSetFlags()[12] = false;
            return this;
        }

        public String getTranscriptId() {
            return this.transcriptId;
        }

        public Builder setTranscriptId(String value) {
            this.validate(this.fields()[13], value);
            this.transcriptId = value;
            this.fieldSetFlags()[13] = true;
            return this;
        }

        public boolean hasTranscriptId() {
            return this.fieldSetFlags()[13];
        }

        public Builder clearTranscriptId() {
            this.transcriptId = null;
            this.fieldSetFlags()[13] = false;
            return this;
        }

        public String getExonId() {
            return this.exonId;
        }

        public Builder setExonId(String value) {
            this.validate(this.fields()[14], value);
            this.exonId = value;
            this.fieldSetFlags()[14] = true;
            return this;
        }

        public boolean hasExonId() {
            return this.fieldSetFlags()[14];
        }

        public Builder clearExonId() {
            this.exonId = null;
            this.fieldSetFlags()[14] = false;
            return this;
        }

        public List<String> getAliases() {
            return this.aliases;
        }

        public Builder setAliases(List<String> value) {
            this.validate(this.fields()[15], value);
            this.aliases = value;
            this.fieldSetFlags()[15] = true;
            return this;
        }

        public boolean hasAliases() {
            return this.fieldSetFlags()[15];
        }

        public Builder clearAliases() {
            this.aliases = null;
            this.fieldSetFlags()[15] = false;
            return this;
        }

        public List<String> getParentIds() {
            return this.parentIds;
        }

        public Builder setParentIds(List<String> value) {
            this.validate(this.fields()[16], value);
            this.parentIds = value;
            this.fieldSetFlags()[16] = true;
            return this;
        }

        public boolean hasParentIds() {
            return this.fieldSetFlags()[16];
        }

        public Builder clearParentIds() {
            this.parentIds = null;
            this.fieldSetFlags()[16] = false;
            return this;
        }

        public String getTarget() {
            return this.target;
        }

        public Builder setTarget(String value) {
            this.validate(this.fields()[17], value);
            this.target = value;
            this.fieldSetFlags()[17] = true;
            return this;
        }

        public boolean hasTarget() {
            return this.fieldSetFlags()[17];
        }

        public Builder clearTarget() {
            this.target = null;
            this.fieldSetFlags()[17] = false;
            return this;
        }

        public String getGap() {
            return this.gap;
        }

        public Builder setGap(String value) {
            this.validate(this.fields()[18], value);
            this.gap = value;
            this.fieldSetFlags()[18] = true;
            return this;
        }

        public boolean hasGap() {
            return this.fieldSetFlags()[18];
        }

        public Builder clearGap() {
            this.gap = null;
            this.fieldSetFlags()[18] = false;
            return this;
        }

        public String getDerivesFrom() {
            return this.derivesFrom;
        }

        public Builder setDerivesFrom(String value) {
            this.validate(this.fields()[19], value);
            this.derivesFrom = value;
            this.fieldSetFlags()[19] = true;
            return this;
        }

        public boolean hasDerivesFrom() {
            return this.fieldSetFlags()[19];
        }

        public Builder clearDerivesFrom() {
            this.derivesFrom = null;
            this.fieldSetFlags()[19] = false;
            return this;
        }

        public List<String> getNotes() {
            return this.notes;
        }

        public Builder setNotes(List<String> value) {
            this.validate(this.fields()[20], value);
            this.notes = value;
            this.fieldSetFlags()[20] = true;
            return this;
        }

        public boolean hasNotes() {
            return this.fieldSetFlags()[20];
        }

        public Builder clearNotes() {
            this.notes = null;
            this.fieldSetFlags()[20] = false;
            return this;
        }

        public List<Dbxref> getDbxrefs() {
            return this.dbxrefs;
        }

        public Builder setDbxrefs(List<Dbxref> value) {
            this.validate(this.fields()[21], value);
            this.dbxrefs = value;
            this.fieldSetFlags()[21] = true;
            return this;
        }

        public boolean hasDbxrefs() {
            return this.fieldSetFlags()[21];
        }

        public Builder clearDbxrefs() {
            this.dbxrefs = null;
            this.fieldSetFlags()[21] = false;
            return this;
        }

        public List<OntologyTerm> getOntologyTerms() {
            return this.ontologyTerms;
        }

        public Builder setOntologyTerms(List<OntologyTerm> value) {
            this.validate(this.fields()[22], value);
            this.ontologyTerms = value;
            this.fieldSetFlags()[22] = true;
            return this;
        }

        public boolean hasOntologyTerms() {
            return this.fieldSetFlags()[22];
        }

        public Builder clearOntologyTerms() {
            this.ontologyTerms = null;
            this.fieldSetFlags()[22] = false;
            return this;
        }

        public Boolean getCircular() {
            return this.circular;
        }

        public Builder setCircular(Boolean value) {
            this.validate(this.fields()[23], value);
            this.circular = value;
            this.fieldSetFlags()[23] = true;
            return this;
        }

        public boolean hasCircular() {
            return this.fieldSetFlags()[23];
        }

        public Builder clearCircular() {
            this.circular = null;
            this.fieldSetFlags()[23] = false;
            return this;
        }

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public Builder setAttributes(Map<String, String> value) {
            this.validate(this.fields()[24], value);
            this.attributes = value;
            this.fieldSetFlags()[24] = true;
            return this;
        }

        public boolean hasAttributes() {
            return this.fieldSetFlags()[24];
        }

        public Builder clearAttributes() {
            this.attributes = null;
            this.fieldSetFlags()[24] = false;
            return this;
        }

        public Feature build() {
            try {
                Feature record = new Feature();
                record.featureId = this.fieldSetFlags()[0] ? this.featureId : (String)this.defaultValue(this.fields()[0]);
                record.sampleId = this.fieldSetFlags()[1] ? this.sampleId : (String)this.defaultValue(this.fields()[1]);
                record.name = this.fieldSetFlags()[2] ? this.name : (String)this.defaultValue(this.fields()[2]);
                record.source = this.fieldSetFlags()[3] ? this.source : (String)this.defaultValue(this.fields()[3]);
                record.featureType = this.fieldSetFlags()[4] ? this.featureType : (String)this.defaultValue(this.fields()[4]);
                record.referenceName = this.fieldSetFlags()[5] ? this.referenceName : (String)this.defaultValue(this.fields()[5]);
                record.start = this.fieldSetFlags()[6] ? this.start : (Long)this.defaultValue(this.fields()[6]);
                record.end = this.fieldSetFlags()[7] ? this.end : (Long)this.defaultValue(this.fields()[7]);
                record.strand = this.fieldSetFlags()[8] ? this.strand : (Strand)((Object)this.defaultValue(this.fields()[8]));
                record.phase = this.fieldSetFlags()[9] ? this.phase : (Integer)this.defaultValue(this.fields()[9]);
                record.frame = this.fieldSetFlags()[10] ? this.frame : (Integer)this.defaultValue(this.fields()[10]);
                record.score = this.fieldSetFlags()[11] ? this.score : (Double)this.defaultValue(this.fields()[11]);
                record.geneId = this.fieldSetFlags()[12] ? this.geneId : (String)this.defaultValue(this.fields()[12]);
                record.transcriptId = this.fieldSetFlags()[13] ? this.transcriptId : (String)this.defaultValue(this.fields()[13]);
                record.exonId = this.fieldSetFlags()[14] ? this.exonId : (String)this.defaultValue(this.fields()[14]);
                record.aliases = this.fieldSetFlags()[15] ? this.aliases : (List)this.defaultValue(this.fields()[15]);
                record.parentIds = this.fieldSetFlags()[16] ? this.parentIds : (List)this.defaultValue(this.fields()[16]);
                record.target = this.fieldSetFlags()[17] ? this.target : (String)this.defaultValue(this.fields()[17]);
                record.gap = this.fieldSetFlags()[18] ? this.gap : (String)this.defaultValue(this.fields()[18]);
                record.derivesFrom = this.fieldSetFlags()[19] ? this.derivesFrom : (String)this.defaultValue(this.fields()[19]);
                record.notes = this.fieldSetFlags()[20] ? this.notes : (List)this.defaultValue(this.fields()[20]);
                record.dbxrefs = this.fieldSetFlags()[21] ? this.dbxrefs : (List)this.defaultValue(this.fields()[21]);
                record.ontologyTerms = this.fieldSetFlags()[22] ? this.ontologyTerms : (List)this.defaultValue(this.fields()[22]);
                record.circular = this.fieldSetFlags()[23] ? this.circular : (Boolean)this.defaultValue(this.fields()[23]);
                record.attributes = this.fieldSetFlags()[24] ? this.attributes : (Map)this.defaultValue(this.fields()[24]);
                return record;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

