/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.formats.avro;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.bdgenomics.formats.avro.Alignment;

@AvroGenerated
public class Fragment
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 7736344041596024721L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"Fragment\",\"namespace\":\"org.bdgenomics.formats.avro\",\"doc\":\"The DNA fragment that was targeted by the sequencer, resulting in\\n one or more reads.\",\"fields\":[{\"name\":\"name\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Name of this fragment.\",\"default\":null},{\"name\":\"readGroupId\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Read group identifier for this fragment. Join with ReadGroup.id for read\\n   group metadata.\",\"default\":null},{\"name\":\"insertSize\",\"type\":[\"null\",\"int\"],\"doc\":\"Insert size for this fragment, derived from alignment, if the reads have\\n   been aligned.\",\"default\":null},{\"name\":\"alignments\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"record\",\"name\":\"Alignment\",\"doc\":\"Alignment.\",\"fields\":[{\"name\":\"referenceName\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The reference for this alignment. If the read is unaligned, this\\n   field should be null. SAM column 3 field RNAME.\",\"default\":null},{\"name\":\"start\",\"type\":[\"null\",\"long\"],\"doc\":\"Start position for this alignment, in zero-based coordinate system\\n   with closed-open intervals. Should be null if the read is unaligned.\\n   SAM column 4 field POS converted to zero-based coordinate system,\\n   closed-open intervals.\",\"default\":null},{\"name\":\"originalStart\",\"type\":[\"null\",\"long\"],\"doc\":\"Original start position for this alignment, before local realignment,\\n   in zero-based coordinate system with closed-open intervals. Should be\\n   null if the read is unaligned. SAM optional field reserved tag OP\\n   converted to zero-based coordinate system, closed-open intervals.\",\"default\":null},{\"name\":\"end\",\"type\":[\"null\",\"long\"],\"doc\":\"End position for this alignment, in zero-based coordinate system with\\n   closed-open intervals. Should be null if the read is unaligned.\",\"default\":null},{\"name\":\"mappingQuality\",\"type\":[\"null\",\"int\"],\"doc\":\"Global mapping quality for this alignment. SAM column 5 field MAPQ.\",\"default\":null},{\"name\":\"readName\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Name of the read for this alignment. This should be unique within the read\\n   group that the read is from, and can be used to identify other reads that\\n   are derived from a single fragment. SAM column 5 field QNAME.\",\"default\":null},{\"name\":\"sequence\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Sequence of the read for this alignment. If the read has been hard clipped,\\n   this may not represent all the bases in the original read. SAM column 10\\n   field SEQ.\",\"default\":null},{\"name\":\"qualityScores\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Per-base quality scores of the read for this alignment. If the read has\\n   been hard clipped, this may not represent all the bases in the original\\n   read. Additionally, if the error scores have been recalibrated, this field\\n   will not contain the original base quality scores. SAM column 11 field QUAL.\",\"default\":null},{\"name\":\"cigar\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Compact Ideosyncratic Gapped Alignment Report (CIGAR) string that\\n   describes the local alignment of the read for this alignment. SAM column\\n   6 field CIGAR.\\n\\n   Contains {length, operator} pairs for all contiguous alignment operations.\\n   The operators include:\\n\\n   * M, ALIGNMENT_MATCH: An alignment match indicates that a sequence can be\\n     aligned to the reference without evidence of an INDEL. Unlike the\\n     SEQUENCE_MATCH and SEQUENCE_MISMATCH operators, the ALIGNMENT_MATCH\\n     operator does not indicate whether the reference and read sequences are an\\n     exact match.\\n   * I, INSERT: The insert operator indicates that the read contains evidence of\\n     bases being inserted into the reference.\\n   * D, DELETE: The delete operator indicates that the read contains evidence of\\n     bases being deleted from the reference.\\n   * N, SKIP: The skip operator indicates that this read skips a long segment of\\n     the reference, but the bases have not been deleted. This operator is\\n     commonly used when working with RNA-seq data, where reads may skip long\\n     segments of the reference between exons.\\n   * S, CLIP_SOFT: The soft clip operator indicates that bases at the start/end\\n     of a read have not been considered during alignment. This may occur if the\\n     majority of a read maps, except for low quality bases at the start/end of\\n     a read. Bases that are soft clipped will still be stored in the read.\\n   * H, CLIP_HARD: The hard clip operator indicates that bases at the start/end of\\n     a read have been omitted from this alignment. This may occur if this linear\\n     alignment is part of a chimeric alignment, or if the read has been trimmed\\n     (e.g., during error correction, or to trim poly-A tails for RNA-seq).\\n   * P, PAD: The pad operator indicates that there is padding in an alignment.\\n   * =, SEQUENCE_MATCH: This operator indicates that this portion of the aligned\\n     sequence exactly matches the reference (e.g., all bases are equal to the\\n     reference bases).\\n   * X, SEQUENCE_MISMATCH: This operator indicates that this portion of the\\n     aligned sequence is an alignment match to the reference, but a sequence\\n     mismatch (e.g., the bases are not equal to the reference). This can\\n     indicate a SNP or a read error.\",\"default\":null},{\"name\":\"originalCigar\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Original CIGAR string that describes the local alignment of the read for\\n   this alignment, before local realignment. SAM optional field reserved tag\\n   OC.\",\"default\":null},{\"name\":\"basesTrimmedFromStart\",\"type\":[\"int\",\"null\"],\"doc\":\"Number of bases in the read for this alignment that have been trimmed from\\n   the start of the read. By default, this is equal to 0. If the value is\\n   non-zero, that means that the start of the read has been hard-clipped.\",\"default\":0},{\"name\":\"basesTrimmedFromEnd\",\"type\":[\"int\",\"null\"],\"doc\":\"Number of bases in the read for this alignment that have been trimmed from\\n   the end of the read. By default, this is equal to 0. If the value is\\n   non-zero, that means that the end of the read has been hard-clipped.\",\"default\":0},{\"name\":\"readPaired\",\"type\":[\"boolean\",\"null\"],\"doc\":\"True if the read for this alignment has a mate. Defaults to false.\",\"default\":false},{\"name\":\"properPair\",\"type\":[\"boolean\",\"null\"],\"doc\":\"True if the read for this alignment and its mate are a proper pair.\\n   Defaults to false.\",\"default\":false},{\"name\":\"readMapped\",\"type\":[\"boolean\",\"null\"],\"doc\":\"True if the read for this alignment has been mapped. Defaults to false.\",\"default\":false},{\"name\":\"mateMapped\",\"type\":[\"boolean\",\"null\"],\"doc\":\"True if the mate of the read for this alignment has been mapped.\\n   Defaults to false.\",\"default\":false},{\"name\":\"failedVendorQualityChecks\",\"type\":[\"boolean\",\"null\"],\"doc\":\"True if the read for this alignent failed vendor quality checks.\\n   Defaults to false.\",\"default\":false},{\"name\":\"duplicateRead\",\"type\":[\"boolean\",\"null\"],\"doc\":\"True if the read for this alignment has been marked as duplicate.\\n   Defaults to false.\",\"default\":false},{\"name\":\"readNegativeStrand\",\"type\":[\"boolean\",\"null\"],\"doc\":\"True if this alignment is mapped as a reverse compliment.\\n   Defaults to false.\",\"default\":false},{\"name\":\"mateNegativeStrand\",\"type\":[\"boolean\",\"null\"],\"doc\":\"True if the mate pair for this alignment is mapped as a reverse\\n   compliment. Defaults to false.\",\"default\":false},{\"name\":\"primaryAlignment\",\"type\":[\"boolean\",\"null\"],\"doc\":\"True if this alignment is either the best linear alignment, or the first\\n   linear alignment in a chimeric alignment. Defaults to false.\",\"default\":false},{\"name\":\"secondaryAlignment\",\"type\":[\"boolean\",\"null\"],\"doc\":\"True if this alignment is a lower quality linear alignment for a\\n   multiply-mapped read. Defaults to false.\",\"default\":false},{\"name\":\"supplementaryAlignment\",\"type\":[\"boolean\",\"null\"],\"doc\":\"True if this alignment is a non-primary linear alignment in a chimeric\\n   alignment. Defaults to false.\",\"default\":false},{\"name\":\"mismatchingPo", new String[]{"sitions\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Mismatching positions for this alignment. SAM optional field reserved tag\\n   MD.\\n\\n   Format (not enforced here): [0-9]+(([A-Z]|\\\\^[A-Z]+)[0-9]+)*\",\"default\":null},{\"name\":\"originalQualityScores\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Original per-base quality scores of the read for this alignment, before\\n   recalibration. SAM optional field reserved tag OQ.\",\"default\":null},{\"name\":\"readGroupId\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Read group identifier for the read for this alignment. Join with\\n   ReadGroup.id for read group metadata.\",\"default\":null},{\"name\":\"readGroupSampleId\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Read group sample identifier for the read for this alignment. Join with\\n   ReadGroup.sampleId for read group metadata or Sample.id for sample metadata.\",\"default\":null},{\"name\":\"mateAlignmentStart\",\"type\":[\"null\",\"long\"],\"doc\":\"Start position of the mate of the read for this alignment, in zero-based\\n   coordinate system with closed-open intervals. Should be set to null if the\\n   mate is unaligned, or if the mate does not exist. SAM column 8 field PNEXT\\n   converted to zero-based coordinate system, closed-open intervals.\",\"default\":null},{\"name\":\"mateReferenceName\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Reference for the mate of the read for this alignment. Should be set to\\n   null if the mate is unaligned, or if the mate does not exist. SAM column 7\\n   field RNEXT.\",\"default\":null},{\"name\":\"insertSize\",\"type\":[\"null\",\"long\"],\"doc\":\"Insert size between the read for this alignment and its mate, derived from\\n   alignment, if the reads have been aligned. Should be set to null if the mate\\n   is unaligned, or if the mate does not exist.\",\"default\":null},{\"name\":\"readInFragment\",\"type\":[\"int\",\"null\"],\"doc\":\"Index of the read for this alignment within an array of fragments.\\n   Defaults to zero.\",\"default\":0},{\"name\":\"attributes\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Additional alignment attributes that do not fit into the standard fields\\n   above, flattened into a string.\",\"default\":null}]}},\"doc\":\"Reads from this fragment.\",\"default\":[]}]}"});
    private static SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<Fragment> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<Fragment> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    @Deprecated
    public String name;
    @Deprecated
    public String readGroupId;
    @Deprecated
    public Integer insertSize;
    @Deprecated
    public List<Alignment> alignments;
    private static final DatumWriter<Fragment> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<Fragment> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageDecoder<Fragment> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<Fragment> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static Fragment fromByteBuffer(ByteBuffer b) throws IOException {
        return (Fragment)((Object)DECODER.decode(b));
    }

    public Fragment() {
    }

    public Fragment(String name, String readGroupId, Integer insertSize, List<Alignment> alignments) {
        this.name = name;
        this.readGroupId = readGroupId;
        this.insertSize = insertSize;
        this.alignments = alignments;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.name;
            }
            case 1: {
                return this.readGroupId;
            }
            case 2: {
                return this.insertSize;
            }
            case 3: {
                return this.alignments;
            }
        }
        throw new AvroRuntimeException("Bad index");
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.name = (String)value$;
                break;
            }
            case 1: {
                this.readGroupId = (String)value$;
                break;
            }
            case 2: {
                this.insertSize = (Integer)value$;
                break;
            }
            case 3: {
                this.alignments = (List)value$;
                break;
            }
            default: {
                throw new AvroRuntimeException("Bad index");
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getReadGroupId() {
        return this.readGroupId;
    }

    public void setReadGroupId(String value) {
        this.readGroupId = value;
    }

    public Integer getInsertSize() {
        return this.insertSize;
    }

    public void setInsertSize(Integer value) {
        this.insertSize = value;
    }

    public List<Alignment> getAlignments() {
        return this.alignments;
    }

    public void setAlignments(List<Alignment> value) {
        this.alignments = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        return new Builder(other);
    }

    public static Builder newBuilder(Fragment other) {
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    public static class Builder
    extends SpecificRecordBuilderBase<Fragment>
    implements RecordBuilder<Fragment> {
        private String name;
        private String readGroupId;
        private Integer insertSize;
        private List<Alignment> alignments;

        private Builder() {
            super(SCHEMA$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.name)) {
                this.name = (String)this.data().deepCopy(this.fields()[0].schema(), (Object)other.name);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.readGroupId)) {
                this.readGroupId = (String)this.data().deepCopy(this.fields()[1].schema(), (Object)other.readGroupId);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.insertSize)) {
                this.insertSize = (Integer)this.data().deepCopy(this.fields()[2].schema(), (Object)other.insertSize);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], other.alignments)) {
                this.alignments = (List)this.data().deepCopy(this.fields()[3].schema(), other.alignments);
                this.fieldSetFlags()[3] = true;
            }
        }

        private Builder(Fragment other) {
            super(SCHEMA$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.name)) {
                this.name = (String)this.data().deepCopy(this.fields()[0].schema(), (Object)other.name);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.readGroupId)) {
                this.readGroupId = (String)this.data().deepCopy(this.fields()[1].schema(), (Object)other.readGroupId);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.insertSize)) {
                this.insertSize = (Integer)this.data().deepCopy(this.fields()[2].schema(), (Object)other.insertSize);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], other.alignments)) {
                this.alignments = (List)this.data().deepCopy(this.fields()[3].schema(), other.alignments);
                this.fieldSetFlags()[3] = true;
            }
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String value) {
            this.validate(this.fields()[0], value);
            this.name = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasName() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearName() {
            this.name = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public String getReadGroupId() {
            return this.readGroupId;
        }

        public Builder setReadGroupId(String value) {
            this.validate(this.fields()[1], value);
            this.readGroupId = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasReadGroupId() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearReadGroupId() {
            this.readGroupId = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public Integer getInsertSize() {
            return this.insertSize;
        }

        public Builder setInsertSize(Integer value) {
            this.validate(this.fields()[2], value);
            this.insertSize = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasInsertSize() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearInsertSize() {
            this.insertSize = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public List<Alignment> getAlignments() {
            return this.alignments;
        }

        public Builder setAlignments(List<Alignment> value) {
            this.validate(this.fields()[3], value);
            this.alignments = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasAlignments() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearAlignments() {
            this.alignments = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public Fragment build() {
            try {
                Fragment record = new Fragment();
                record.name = this.fieldSetFlags()[0] ? this.name : (String)this.defaultValue(this.fields()[0]);
                record.readGroupId = this.fieldSetFlags()[1] ? this.readGroupId : (String)this.defaultValue(this.fields()[1]);
                record.insertSize = this.fieldSetFlags()[2] ? this.insertSize : (Integer)this.defaultValue(this.fields()[2]);
                record.alignments = this.fieldSetFlags()[3] ? this.alignments : (List)this.defaultValue(this.fields()[3]);
                return record;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

