/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.formats.avro;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.bdgenomics.formats.avro.GenotypeAllele;
import org.bdgenomics.formats.avro.Variant;
import org.bdgenomics.formats.avro.VariantCallingAnnotations;

@AvroGenerated
public class Genotype
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 1387007561614920686L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"Genotype\",\"namespace\":\"org.bdgenomics.formats.avro\",\"doc\":\"Genotype.\",\"fields\":[{\"name\":\"variant\",\"type\":[\"null\",{\"type\":\"record\",\"name\":\"Variant\",\"doc\":\"Variant.\",\"fields\":[{\"name\":\"referenceName\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The reference this variant exists on. VCF column 1 \\\"CONTIG\\\".\",\"default\":null},{\"name\":\"start\",\"type\":[\"null\",\"long\"],\"doc\":\"The zero-based start position of this variant on the reference.\\n   VCF column 2 \\\"POS\\\" converted to zero-based coordinate system, closed-open intervals.\",\"default\":null},{\"name\":\"end\",\"type\":[\"null\",\"long\"],\"doc\":\"The zero-based, exclusive end position of this variant on the reference.\\n   Calculated by start + referenceAllele.length().\",\"default\":null},{\"name\":\"names\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},\"doc\":\"Zero or more unique names or identifiers for this variant. If this is a dbSNP\\n   variant it is encouraged to use the rs number(s). VCF column 3 \\\"ID\\\" shared across\\n   all alleles in the same VCF record.\",\"default\":[]},{\"name\":\"splitFromMultiAllelic\",\"type\":[\"boolean\",\"null\"],\"doc\":\"We split multi-allelic VCF lines into multiple single-alternate records.\\n   This bit is set if that happened for this record.\",\"default\":false},{\"name\":\"referenceAllele\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"A string describing the reference allele at this site. VCF column 4 \\\"REF\\\".\",\"default\":null},{\"name\":\"alternateAllele\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"A string describing the alternate allele at this site. VCF column 5 \\\"ALT\\\" split\\n   for multi-allelic sites.\",\"default\":null},{\"name\":\"quality\",\"type\":[\"null\",\"double\"],\"doc\":\"The Phred scaled probability that this allele is variant. VCF column 6 \\\"QUAL\\\".\\n   If this record is multi-allelic, this value may be incorrect.\",\"default\":null},{\"name\":\"filtersApplied\",\"type\":[\"null\",\"boolean\"],\"doc\":\"True if filters were applied for this variant. VCF column 7 \\\"FILTER\\\" any value other\\n   than the missing value.\",\"default\":null},{\"name\":\"filtersPassed\",\"type\":[\"null\",\"boolean\"],\"doc\":\"True if all filters for this variant passed. VCF column 7 \\\"FILTER\\\" value PASS.\",\"default\":null},{\"name\":\"filtersFailed\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},\"doc\":\"Zero or more filters that failed for this variant. VCF column 7 \\\"FILTER\\\" shared across\\n   all alleles in the same VCF record.\",\"default\":[]},{\"name\":\"annotation\",\"type\":[\"null\",{\"type\":\"record\",\"name\":\"VariantAnnotation\",\"doc\":\"Variant annotation.\",\"fields\":[{\"name\":\"ancestralAllele\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Ancestral allele, VCF INFO reserved key AA, Number=1, shared across all alternate\\n   alleles in the same VCF record.\",\"default\":null},{\"name\":\"alleleCount\",\"type\":[\"null\",\"int\"],\"doc\":\"Allele count, VCF INFO reserved key AC, Number=A, split for multi-allelic sites into\\n   a single integer value.\",\"default\":null},{\"name\":\"readDepth\",\"type\":[\"null\",\"int\"],\"doc\":\"Total read depth, VCF INFO reserved key AD, Number=R, split for multi-allelic\\n   sites into single integer values for the reference allele (referenceReadDepth) and\\n   the alternate allele (readDepth, this field).\",\"default\":null},{\"name\":\"forwardReadDepth\",\"type\":[\"null\",\"int\"],\"doc\":\"Forward strand read depth, VCF INFO reserved key ADF, Number=R, split for\\n   multi-allelic sites into single integer values for the reference allele\\n   (referenceForwardReadDepth) and the alternate allele (forwardReadDepth, this field).\",\"default\":null},{\"name\":\"reverseReadDepth\",\"type\":[\"null\",\"int\"],\"doc\":\"Reverse strand read depth, VCF INFO reserved key ADR, Number=R, split for\\n   multi-allelic sites into single integer values for the reference allele\\n   (referenceReverseReadDepth) and the alternate allele (reverseReadDepth, this field).\",\"default\":null},{\"name\":\"referenceReadDepth\",\"type\":[\"null\",\"int\"],\"doc\":\"Total read depth, VCF INFO reserved key AD, Number=R, split for multi-allelic\\n   sites into single integer values for the reference allele (referenceReadDepth, this field)\\n   and the alternate allele (readDepth).\",\"default\":null},{\"name\":\"referenceForwardReadDepth\",\"type\":[\"null\",\"int\"],\"doc\":\"Forward strand read depth, VCF INFO reserved key ADF, Number=R, split for\\n   multi-allelic sites into single integer values for the reference allele\\n   (referenceForwardReadDepth, this field) and the alternate allele (forwardReadDepth).\",\"default\":null},{\"name\":\"referenceReverseReadDepth\",\"type\":[\"null\",\"int\"],\"doc\":\"Reverse strand read depth, VCF INFO reserved key ADR, Number=R, split for\\n   multi-allelic sites into single integer values for the reference allele\\n   (referenceReverseReadDepth, this field) and the alternate allele (reverseReadDepth).\",\"default\":null},{\"name\":\"alleleFrequency\",\"type\":[\"null\",\"float\"],\"doc\":\"Minor allele frequency, VCF INFO reserved key AF, Number=A, split for multi-allelic\\n   sites into a single float value. Use this when frequencies are estimated from primary\\n   data, not calculated from called genotypes.\",\"default\":null},{\"name\":\"cigar\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"CIGAR string describing how to align an alternate allele to the reference\\n   allele, VCF INFO reserved key CIGAR, Number=A, split for multi-allelic sites into\\n   a single string value.\",\"default\":null},{\"name\":\"dbSnp\",\"type\":[\"null\",\"boolean\"],\"doc\":\"Membership in dbSNP, VCF INFO reserved key DB, Number=0. Until Number=A and\\n   Number=R flags are supported by the VCF specification, this value is shared\\n   across all alternate alleles in the same VCF record.\",\"default\":null},{\"name\":\"hapMap2\",\"type\":[\"null\",\"boolean\"],\"doc\":\"Membership in HapMap2, VCF INFO reserved key H2, Number=0. Until Number=A and\\n   Number=R flags are supported by the VCF specification, this value is shared\\n   across all alternate alleles in the same VCF record.\",\"default\":null},{\"name\":\"hapMap3\",\"type\":[\"null\",\"boolean\"],\"doc\":\"Membership in HapMap3, VCF INFO reserved key H3, Number=0. Until Number=A and\\n   Number=R flags are supported by the VCF specification, this value is shared\\n   across all alternate alleles in the same VCF record.\",\"default\":null},{\"name\":\"validated\",\"type\":[\"null\",\"boolean\"],\"doc\":\"Validated by follow up experiment, VCF INFO reserved key VALIDATED, Number=0.\\n   Until Number=A and Number=R flags are supported by the VCF specification, this\\n   value is shared across all alternate alleles in the same VCF record.\",\"default\":null},{\"name\":\"thousandGenomes\",\"type\":[\"null\",\"boolean\"],\"doc\":\"Membership in 1000 Genomes, VCF INFO reserved key 1000G, Number=0. Until\\n   Number=A and Number=R flags are supported by the VCF specification, this\\n   value is shared across all alternate alleles in the same VCF record.\",\"default\":null},{\"name\":\"somatic\",\"type\":[\"boolean\",\"null\"],\"doc\":\"True if this variant call is somatic; in this case, the reference allele will\\n   have been observed in another sample. VCF INFO reserved key \\\"SOMATIC\\\", Number=0.\\n   Until Number=A and Number=R flags are supported by the VCF specification, this value\\n   is shared across all alleles in the same VCF record.\",\"default\":false},{\"name\":\"transcriptEffects\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"record\",\"name\":\"TranscriptEffect\",\"doc\":\"Annotation of a variant in the context of a feature, typically a transcript.\",\"fields\":[{\"name\":\"alternateAllele\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Alternate allele for this variant annotation.\",\"default\":null},{\"name\":\"effects\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},\"doc\":\"One or more annotations (also referred to as effects or consequences) of the\\n   variant in the context of the feature identified by featureId. Must be\\n   Sequence Ontology (SO, see http://www.sequenceontology.org) term names, e.g.\\n   stop_gained, missense_variant, synonymous_variant, upstream_gene_variant.\",\"default\":[]},{\"name\":\"impact\",\"type\":[\"null\",{\"type\":\"enum\",\"name\":\"Impact\",\"doc\":\"Modifier impact.\",\"symbols\"", new String[]{":[\"HIGH\",\"MODERATE\",\"LOW\",\"MODIFIER\"]}],\"doc\":\"Putative impact of the annotation; a simple estimation of putative impact/\\n   deleteriousness.\",\"default\":null},{\"name\":\"geneName\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Common gene name (HGNC), e.g. BRCA2. May be closest gene if annotation\\n   is intergenic.\",\"default\":null},{\"name\":\"geneId\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Gene identifier, e.g. Ensembl Gene identifier, ENSG00000139618. May be\\n   closest gene if annotation is intergenic.\",\"default\":null},{\"name\":\"featureType\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Feature type, may use Sequence Ontology term names. Typically transcript.\",\"default\":null},{\"name\":\"featureId\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Feature identifier, e.g. Ensembl Transcript identifier and version, ENST00000380152.7.\",\"default\":null},{\"name\":\"biotype\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Feature biotype, e.g. Protein coding or Non coding. See http://vega.sanger.ac.uk/info/about/gene_and_transcript_types.html.\",\"default\":null},{\"name\":\"strand\",\"type\":[\"null\",{\"type\":\"enum\",\"name\":\"Strand\",\"doc\":\"Strandedness is relevant, but unknown (\\\"?\\\").\",\"symbols\":[\"FORWARD\",\"REVERSE\",\"INDEPENDENT\",\"UNKNOWN\"]}],\"doc\":\"Feature strand, if known.\",\"default\":null},{\"name\":\"rank\",\"type\":[\"null\",\"int\"],\"doc\":\"Intron or exon rank.\",\"default\":null},{\"name\":\"total\",\"type\":[\"null\",\"int\"],\"doc\":\"Total number of introns or exons.\",\"default\":null},{\"name\":\"genomicHgvs\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"HGVS.g description of the variant. See http://www.hgvs.org/mutnomen/recs-DNA.html.\",\"default\":null},{\"name\":\"transcriptHgvs\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"HGVS.c description of the variant. See http://www.hgvs.org/mutnomen/recs-DNA.html.\",\"default\":null},{\"name\":\"proteinHgvs\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"HGVS.p description of the variant, if coding. See http://www.hgvs.org/mutnomen/recs-prot.html.\",\"default\":null},{\"name\":\"cdnaPosition\",\"type\":[\"null\",\"int\"],\"doc\":\"cDNA sequence position (one based).\",\"default\":null},{\"name\":\"cdnaLength\",\"type\":[\"null\",\"int\"],\"doc\":\"cDNA sequence length in base pairs (one based).\",\"default\":null},{\"name\":\"codingSequencePosition\",\"type\":[\"null\",\"int\"],\"doc\":\"Coding sequence position (one based, includes START and STOP codons).\",\"default\":null},{\"name\":\"codingSequenceLength\",\"type\":[\"null\",\"int\"],\"doc\":\"Coding sequence length in base pairs (one based, includes START and STOP codons).\",\"default\":null},{\"name\":\"referenceCodingSequence\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Coding sequence for the reference allele.\",\"default\":null},{\"name\":\"alternateCodingSequence\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Coding sequence of this alternate allele.\",\"default\":null},{\"name\":\"proteinPosition\",\"type\":[\"null\",\"int\"],\"doc\":\"Protein sequence position (one based, includes START but not STOP).\",\"default\":null},{\"name\":\"proteinLength\",\"type\":[\"null\",\"int\"],\"doc\":\"Protein sequence length in amino acids (one based, includes START but not STOP).\",\"default\":null},{\"name\":\"referenceProteinSequence\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Protein sequence for the reference allele.\",\"default\":null},{\"name\":\"alternateProteinSequence\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Protein sequence of this alternate allele.\",\"default\":null},{\"name\":\"distance\",\"type\":[\"null\",\"int\"],\"doc\":\"Distance in base pairs to the feature.\",\"default\":null},{\"name\":\"messages\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"enum\",\"name\":\"VariantAnnotationMessage\",\"doc\":\"An alternative reference sequence was used to calculate this annotation\\n   (e.g. cancer sample comparing somatic vs. germline). Message code I3.\",\"symbols\":[\"ERROR_CHROMOSOME_NOT_FOUND\",\"ERROR_OUT_OF_CHROMOSOME_RANGE\",\"WARNING_REF_DOES_NOT_MATCH_GENOME\",\"WARNING_SEQUENCE_NOT_AVAILABLE\",\"WARNING_TRANSCRIPT_INCOMPLETE\",\"WARNING_TRANSCRIPT_MULTIPLE_STOP_CODONS\",\"WARNING_TRANSCRIPT_NO_START_CODON\",\"INFO_REALIGN_3_PRIME\",\"INFO_COMPOUND_ANNOTATION\",\"INFO_NON_REFERENCE_ANNOTATION\"]}},\"doc\":\"Zero or more errors, warnings, or informative messages regarding variant annotation accuracy.\",\"default\":[]}]}},\"doc\":\"Zero or more transcript effects, predicted by a tool such as SnpEff or Ensembl VEP,\\n   one per transcript (or other feature). VCF INFO key ANN, split for multi-allelic\\n   sites. See http://snpeff.sourceforge.net/VCFannotationformat_v1.0.pdf.\",\"default\":[]},{\"name\":\"attributes\",\"type\":{\"type\":\"map\",\"values\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"avro.java.string\":\"String\"},\"doc\":\"Additional variant attributes that do not fit into the standard fields above.\\n   The values are stored as strings, even for flag, integer, and float types. VCF\\n   INFO key values with Number=., Number=0, Number=1, and Number=[n] are shared across\\n   all alternate alleles in the same VCF record. VCF INFO key values with Number=A are\\n   split for multi-allelic sites into a single value. VCF INFO key values with Number=R\\n   are split into an array of two values, [reference allele, alternate allele], separated\\n   by commas, e.g. \\\"0,1\\\".\",\"default\":{}}]}],\"doc\":\"Annotation for this variant, if any.\",\"default\":null}]}],\"doc\":\"The variant called at this site.\",\"default\":null},{\"name\":\"referenceName\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The reference that this genotype's variant exists on.\",\"default\":null},{\"name\":\"start\",\"type\":[\"null\",\"long\"],\"doc\":\"The zero-based start position of this genotype's variant on the reference.\",\"default\":null},{\"name\":\"end\",\"type\":[\"null\",\"long\"],\"doc\":\"The zero-based, exclusive end position of this genotype's variant on the reference.\",\"default\":null},{\"name\":\"variantCallingAnnotations\",\"type\":[\"null\",{\"type\":\"record\",\"name\":\"VariantCallingAnnotations\",\"doc\":\"This record represents all stats that, inside a VCF, are stored outside of the\\n sample but are computed based on the samples. For instance, MAPQ0 is an aggregate\\n stat computed from all samples and stored inside the INFO line.\",\"fields\":[{\"name\":\"filtersApplied\",\"type\":[\"null\",\"boolean\"],\"doc\":\"True if filters were applied for this genotype call. FORMAT field \\\"FT\\\" any value other\\n   than the missing value.\",\"default\":null},{\"name\":\"filtersPassed\",\"type\":[\"null\",\"boolean\"],\"doc\":\"True if all filters for this genotype call passed. FORMAT field \\\"FT\\\" value PASS.\",\"default\":null},{\"name\":\"filtersFailed\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},\"doc\":\"Zero or more filters that failed for this genotype call from FORMAT field \\\"FT\\\".\",\"default\":[]},{\"name\":\"downsampled\",\"type\":[\"null\",\"boolean\"],\"doc\":\"True if the reads covering this site were randomly downsampled to reduce coverage.\",\"default\":null},{\"name\":\"baseQRankSum\",\"type\":[\"null\",\"float\"],\"doc\":\"The Wilcoxon rank-sum test statistic of the base quality scores. The base quality\\n   scores are separated by whether or not the base supports the reference or the\\n   alternate allele.\",\"default\":null},{\"name\":\"fisherStrandBiasPValue\",\"type\":[\"null\",\"float\"],\"doc\":\"The Fisher's exact test score for the strand bias of the reference and alternate\\n   alleles. Stored as a phred scaled probability. Thus, if:\\n\\n   * a = The number of positive strand reads covering the reference allele\\n   * b = The number of positive strand reads covering the alternate allele\\n   * c = The number of negative strand reads covering the reference allele\\n   * d = The number of negative strand reads covering the alternate allele\\n\\n   This value takes the score:\\n   \\n   -10 log((a + b)! * (c + d)! * (a + c)! * (b + d)! / (a! b! c! d! n!)\\n\\n   Where n = a + b + c + d.\",\"default\":null},{\"name\":\"rmsMapQ\",\"type\":[\"null\",\"float\"],\"doc\":\"The root mean square of the mapping qualities of reads covering this site.\",\"default\":null},{\"name\":\"mapq0Reads\",\"type\":[\"null\",\"int\"],\"doc\":\"The number of reads at this ", "site with mapping quality equal to 0.\",\"default\":null},{\"name\":\"mqRankSum\",\"type\":[\"null\",\"float\"],\"doc\":\"The Wilcoxon rank-sum test statistic of the mapping quality scores. The mapping\\n   quality scores are separated by whether or not the read supported the reference or the\\n   alternate allele.\",\"default\":null},{\"name\":\"readPositionRankSum\",\"type\":[\"null\",\"float\"],\"doc\":\"The Wilcoxon rank-sum test statistic of the position of the base in the read at this site.\\n   The positions are separated by whether or not the base supports the reference or the\\n   alternate allele.\",\"default\":null},{\"name\":\"genotypePriors\",\"type\":{\"type\":\"array\",\"items\":\"float\"},\"doc\":\"The log scale prior probabilities of the various genotype states at this site.\\n   The number of elements in this array should be equal to the ploidy at this\\n   site, plus 1.\",\"default\":[]},{\"name\":\"genotypePosteriors\",\"type\":{\"type\":\"array\",\"items\":\"float\"},\"doc\":\"The log scaled posterior probabilities of the various genotype states at this site,\\n   in this sample. The number of elements in this array should be equal to the ploidy at\\n   this site, plus 1.\",\"default\":[]},{\"name\":\"vqslod\",\"type\":[\"null\",\"float\"],\"doc\":\"The log-odds ratio of being a true vs. false variant under a trained statistical model.\\n   This model can be a multivariate Gaussian mixture, support vector machine, etc.\",\"default\":null},{\"name\":\"culprit\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"If known, the feature that contributed the most to this variant being classified as\\n   a false variant.\",\"default\":null},{\"name\":\"attributes\",\"type\":{\"type\":\"map\",\"values\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"avro.java.string\":\"String\"},\"doc\":\"Additional feature info that doesn't fit into the standard fields above.\\n   They are all encoded as (string, string) key-value pairs.\",\"default\":{}}]}],\"doc\":\"Statistics collected at this site, if available.\",\"default\":null},{\"name\":\"sampleId\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The unique identifier for this sample. Join with Sample.id for sample metadata.\",\"default\":null},{\"name\":\"sampleDescription\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"A description of this sample.\",\"default\":null},{\"name\":\"processingDescription\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"A string describing the provenance of this sample and the processing applied\\n   in genotyping this sample.\",\"default\":null},{\"name\":\"alleles\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"enum\",\"name\":\"GenotypeAllele\",\"doc\":\"The genotype could not be called.\",\"symbols\":[\"REF\",\"ALT\",\"OTHER_ALT\",\"NO_CALL\"]}},\"doc\":\"An array describing the genotype called at this site. The length of this\\n   array is equal to the ploidy of the sample at this site. This array may\\n   reference OTHER_ALT alleles if this site is multi-allelic in this sample.\",\"default\":[]},{\"name\":\"expectedAlleleDosage\",\"type\":[\"null\",\"float\"],\"doc\":\"The expected dosage of the alternate allele in this sample.\",\"default\":null},{\"name\":\"referenceReadDepth\",\"type\":[\"null\",\"int\"],\"doc\":\"The number of reads that show evidence for the reference at this site.\",\"default\":null},{\"name\":\"alternateReadDepth\",\"type\":[\"null\",\"int\"],\"doc\":\"The number of reads that show evidence for this alternate allele at this site.\",\"default\":null},{\"name\":\"readDepth\",\"type\":[\"null\",\"int\"],\"doc\":\"The total number of reads at this site. May not equal (alternateReadDepth +\\n   referenceReadDepth) if this site shows evidence of multiple alternate alleles.\\n   Analogous to VCF's DP.\",\"default\":null},{\"name\":\"minReadDepth\",\"type\":[\"null\",\"int\"],\"doc\":\"The minimum number of reads seen at this site across samples when joint\\n   calling variants. Analogous to VCF's MIN_DP.\",\"default\":null},{\"name\":\"genotypeQuality\",\"type\":[\"null\",\"int\"],\"doc\":\"The phred-scaled probability that we're correct for this genotype call.\\n   Analogous to VCF's GQ.\",\"default\":null},{\"name\":\"genotypeLikelihoods\",\"type\":{\"type\":\"array\",\"items\":\"double\"},\"doc\":\"Log scaled likelihoods that we have n copies of this alternate allele.\\n   The number of elements in this array should be equal to the ploidy at this\\n   site, plus 1. Analogous to VCF's PL.\",\"default\":[]},{\"name\":\"nonReferenceLikelihoods\",\"type\":{\"type\":\"array\",\"items\":\"double\"},\"doc\":\"Log scaled likelihoods that we have n non-reference alleles at this site.\\n   The number of elements in this array should be equal to the ploidy at this\\n   site, plus 1.\",\"default\":[]},{\"name\":\"strandBiasComponents\",\"type\":{\"type\":\"array\",\"items\":\"int\"},\"doc\":\"Component statistics which comprise the Fisher's Exact Test to detect strand bias.\\n   If populated, this element should have length 4.\",\"default\":[]},{\"name\":\"splitFromMultiAllelic\",\"type\":[\"boolean\",\"null\"],\"doc\":\"We split multi-allelic VCF lines into multiple single-alternate records.\\n   This bit is set if that happened for this record.\",\"default\":false},{\"name\":\"phased\",\"type\":[\"boolean\",\"null\"],\"doc\":\"True if this genotype is phased.\",\"default\":false},{\"name\":\"phaseSetId\",\"type\":[\"null\",\"int\"],\"doc\":\"The ID of this phase set, if this genotype is phased. Should only be populated\\n   if phased == true; else should be null.\",\"default\":null},{\"name\":\"phaseQuality\",\"type\":[\"null\",\"int\"],\"doc\":\"Phred scaled quality score for the phasing of this genotype, if this genotype\\n   is phased. Should only be populated if phased == true; else should be null.\",\"default\":null}]}"});
    private static SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<Genotype> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<Genotype> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    @Deprecated
    public Variant variant;
    @Deprecated
    public String referenceName;
    @Deprecated
    public Long start;
    @Deprecated
    public Long end;
    @Deprecated
    public VariantCallingAnnotations variantCallingAnnotations;
    @Deprecated
    public String sampleId;
    @Deprecated
    public String sampleDescription;
    @Deprecated
    public String processingDescription;
    @Deprecated
    public List<GenotypeAllele> alleles;
    @Deprecated
    public Float expectedAlleleDosage;
    @Deprecated
    public Integer referenceReadDepth;
    @Deprecated
    public Integer alternateReadDepth;
    @Deprecated
    public Integer readDepth;
    @Deprecated
    public Integer minReadDepth;
    @Deprecated
    public Integer genotypeQuality;
    @Deprecated
    public List<Double> genotypeLikelihoods;
    @Deprecated
    public List<Double> nonReferenceLikelihoods;
    @Deprecated
    public List<Integer> strandBiasComponents;
    @Deprecated
    public Boolean splitFromMultiAllelic;
    @Deprecated
    public Boolean phased;
    @Deprecated
    public Integer phaseSetId;
    @Deprecated
    public Integer phaseQuality;
    private static final DatumWriter<Genotype> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<Genotype> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageDecoder<Genotype> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<Genotype> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static Genotype fromByteBuffer(ByteBuffer b) throws IOException {
        return (Genotype)((Object)DECODER.decode(b));
    }

    public Genotype() {
    }

    public Genotype(Variant variant, String referenceName, Long start, Long end, VariantCallingAnnotations variantCallingAnnotations, String sampleId, String sampleDescription, String processingDescription, List<GenotypeAllele> alleles, Float expectedAlleleDosage, Integer referenceReadDepth, Integer alternateReadDepth, Integer readDepth, Integer minReadDepth, Integer genotypeQuality, List<Double> genotypeLikelihoods, List<Double> nonReferenceLikelihoods, List<Integer> strandBiasComponents, Boolean splitFromMultiAllelic, Boolean phased, Integer phaseSetId, Integer phaseQuality) {
        this.variant = variant;
        this.referenceName = referenceName;
        this.start = start;
        this.end = end;
        this.variantCallingAnnotations = variantCallingAnnotations;
        this.sampleId = sampleId;
        this.sampleDescription = sampleDescription;
        this.processingDescription = processingDescription;
        this.alleles = alleles;
        this.expectedAlleleDosage = expectedAlleleDosage;
        this.referenceReadDepth = referenceReadDepth;
        this.alternateReadDepth = alternateReadDepth;
        this.readDepth = readDepth;
        this.minReadDepth = minReadDepth;
        this.genotypeQuality = genotypeQuality;
        this.genotypeLikelihoods = genotypeLikelihoods;
        this.nonReferenceLikelihoods = nonReferenceLikelihoods;
        this.strandBiasComponents = strandBiasComponents;
        this.splitFromMultiAllelic = splitFromMultiAllelic;
        this.phased = phased;
        this.phaseSetId = phaseSetId;
        this.phaseQuality = phaseQuality;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.variant;
            }
            case 1: {
                return this.referenceName;
            }
            case 2: {
                return this.start;
            }
            case 3: {
                return this.end;
            }
            case 4: {
                return this.variantCallingAnnotations;
            }
            case 5: {
                return this.sampleId;
            }
            case 6: {
                return this.sampleDescription;
            }
            case 7: {
                return this.processingDescription;
            }
            case 8: {
                return this.alleles;
            }
            case 9: {
                return this.expectedAlleleDosage;
            }
            case 10: {
                return this.referenceReadDepth;
            }
            case 11: {
                return this.alternateReadDepth;
            }
            case 12: {
                return this.readDepth;
            }
            case 13: {
                return this.minReadDepth;
            }
            case 14: {
                return this.genotypeQuality;
            }
            case 15: {
                return this.genotypeLikelihoods;
            }
            case 16: {
                return this.nonReferenceLikelihoods;
            }
            case 17: {
                return this.strandBiasComponents;
            }
            case 18: {
                return this.splitFromMultiAllelic;
            }
            case 19: {
                return this.phased;
            }
            case 20: {
                return this.phaseSetId;
            }
            case 21: {
                return this.phaseQuality;
            }
        }
        throw new AvroRuntimeException("Bad index");
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.variant = (Variant)((Object)value$);
                break;
            }
            case 1: {
                this.referenceName = (String)value$;
                break;
            }
            case 2: {
                this.start = (Long)value$;
                break;
            }
            case 3: {
                this.end = (Long)value$;
                break;
            }
            case 4: {
                this.variantCallingAnnotations = (VariantCallingAnnotations)((Object)value$);
                break;
            }
            case 5: {
                this.sampleId = (String)value$;
                break;
            }
            case 6: {
                this.sampleDescription = (String)value$;
                break;
            }
            case 7: {
                this.processingDescription = (String)value$;
                break;
            }
            case 8: {
                this.alleles = (List)value$;
                break;
            }
            case 9: {
                this.expectedAlleleDosage = (Float)value$;
                break;
            }
            case 10: {
                this.referenceReadDepth = (Integer)value$;
                break;
            }
            case 11: {
                this.alternateReadDepth = (Integer)value$;
                break;
            }
            case 12: {
                this.readDepth = (Integer)value$;
                break;
            }
            case 13: {
                this.minReadDepth = (Integer)value$;
                break;
            }
            case 14: {
                this.genotypeQuality = (Integer)value$;
                break;
            }
            case 15: {
                this.genotypeLikelihoods = (List)value$;
                break;
            }
            case 16: {
                this.nonReferenceLikelihoods = (List)value$;
                break;
            }
            case 17: {
                this.strandBiasComponents = (List)value$;
                break;
            }
            case 18: {
                this.splitFromMultiAllelic = (Boolean)value$;
                break;
            }
            case 19: {
                this.phased = (Boolean)value$;
                break;
            }
            case 20: {
                this.phaseSetId = (Integer)value$;
                break;
            }
            case 21: {
                this.phaseQuality = (Integer)value$;
                break;
            }
            default: {
                throw new AvroRuntimeException("Bad index");
            }
        }
    }

    public Variant getVariant() {
        return this.variant;
    }

    public void setVariant(Variant value) {
        this.variant = value;
    }

    public String getReferenceName() {
        return this.referenceName;
    }

    public void setReferenceName(String value) {
        this.referenceName = value;
    }

    public Long getStart() {
        return this.start;
    }

    public void setStart(Long value) {
        this.start = value;
    }

    public Long getEnd() {
        return this.end;
    }

    public void setEnd(Long value) {
        this.end = value;
    }

    public VariantCallingAnnotations getVariantCallingAnnotations() {
        return this.variantCallingAnnotations;
    }

    public void setVariantCallingAnnotations(VariantCallingAnnotations value) {
        this.variantCallingAnnotations = value;
    }

    public String getSampleId() {
        return this.sampleId;
    }

    public void setSampleId(String value) {
        this.sampleId = value;
    }

    public String getSampleDescription() {
        return this.sampleDescription;
    }

    public void setSampleDescription(String value) {
        this.sampleDescription = value;
    }

    public String getProcessingDescription() {
        return this.processingDescription;
    }

    public void setProcessingDescription(String value) {
        this.processingDescription = value;
    }

    public List<GenotypeAllele> getAlleles() {
        return this.alleles;
    }

    public void setAlleles(List<GenotypeAllele> value) {
        this.alleles = value;
    }

    public Float getExpectedAlleleDosage() {
        return this.expectedAlleleDosage;
    }

    public void setExpectedAlleleDosage(Float value) {
        this.expectedAlleleDosage = value;
    }

    public Integer getReferenceReadDepth() {
        return this.referenceReadDepth;
    }

    public void setReferenceReadDepth(Integer value) {
        this.referenceReadDepth = value;
    }

    public Integer getAlternateReadDepth() {
        return this.alternateReadDepth;
    }

    public void setAlternateReadDepth(Integer value) {
        this.alternateReadDepth = value;
    }

    public Integer getReadDepth() {
        return this.readDepth;
    }

    public void setReadDepth(Integer value) {
        this.readDepth = value;
    }

    public Integer getMinReadDepth() {
        return this.minReadDepth;
    }

    public void setMinReadDepth(Integer value) {
        this.minReadDepth = value;
    }

    public Integer getGenotypeQuality() {
        return this.genotypeQuality;
    }

    public void setGenotypeQuality(Integer value) {
        this.genotypeQuality = value;
    }

    public List<Double> getGenotypeLikelihoods() {
        return this.genotypeLikelihoods;
    }

    public void setGenotypeLikelihoods(List<Double> value) {
        this.genotypeLikelihoods = value;
    }

    public List<Double> getNonReferenceLikelihoods() {
        return this.nonReferenceLikelihoods;
    }

    public void setNonReferenceLikelihoods(List<Double> value) {
        this.nonReferenceLikelihoods = value;
    }

    public List<Integer> getStrandBiasComponents() {
        return this.strandBiasComponents;
    }

    public void setStrandBiasComponents(List<Integer> value) {
        this.strandBiasComponents = value;
    }

    public Boolean getSplitFromMultiAllelic() {
        return this.splitFromMultiAllelic;
    }

    public void setSplitFromMultiAllelic(Boolean value) {
        this.splitFromMultiAllelic = value;
    }

    public Boolean getPhased() {
        return this.phased;
    }

    public void setPhased(Boolean value) {
        this.phased = value;
    }

    public Integer getPhaseSetId() {
        return this.phaseSetId;
    }

    public void setPhaseSetId(Integer value) {
        this.phaseSetId = value;
    }

    public Integer getPhaseQuality() {
        return this.phaseQuality;
    }

    public void setPhaseQuality(Integer value) {
        this.phaseQuality = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        return new Builder(other);
    }

    public static Builder newBuilder(Genotype other) {
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    public static class Builder
    extends SpecificRecordBuilderBase<Genotype>
    implements RecordBuilder<Genotype> {
        private Variant variant;
        private Variant.Builder variantBuilder;
        private String referenceName;
        private Long start;
        private Long end;
        private VariantCallingAnnotations variantCallingAnnotations;
        private VariantCallingAnnotations.Builder variantCallingAnnotationsBuilder;
        private String sampleId;
        private String sampleDescription;
        private String processingDescription;
        private List<GenotypeAllele> alleles;
        private Float expectedAlleleDosage;
        private Integer referenceReadDepth;
        private Integer alternateReadDepth;
        private Integer readDepth;
        private Integer minReadDepth;
        private Integer genotypeQuality;
        private List<Double> genotypeLikelihoods;
        private List<Double> nonReferenceLikelihoods;
        private List<Integer> strandBiasComponents;
        private Boolean splitFromMultiAllelic;
        private Boolean phased;
        private Integer phaseSetId;
        private Integer phaseQuality;

        private Builder() {
            super(SCHEMA$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)((Object)other.variant))) {
                this.variant = (Variant)((Object)this.data().deepCopy(this.fields()[0].schema(), (Object)other.variant));
                this.fieldSetFlags()[0] = true;
            }
            if (other.hasVariantBuilder()) {
                this.variantBuilder = Variant.newBuilder(other.getVariantBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.referenceName)) {
                this.referenceName = (String)this.data().deepCopy(this.fields()[1].schema(), (Object)other.referenceName);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.start)) {
                this.start = (Long)this.data().deepCopy(this.fields()[2].schema(), (Object)other.start);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.end)) {
                this.end = (Long)this.data().deepCopy(this.fields()[3].schema(), (Object)other.end);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)((Object)other.variantCallingAnnotations))) {
                this.variantCallingAnnotations = (VariantCallingAnnotations)((Object)this.data().deepCopy(this.fields()[4].schema(), (Object)other.variantCallingAnnotations));
                this.fieldSetFlags()[4] = true;
            }
            if (other.hasVariantCallingAnnotationsBuilder()) {
                this.variantCallingAnnotationsBuilder = VariantCallingAnnotations.newBuilder(other.getVariantCallingAnnotationsBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.sampleId)) {
                this.sampleId = (String)this.data().deepCopy(this.fields()[5].schema(), (Object)other.sampleId);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.sampleDescription)) {
                this.sampleDescription = (String)this.data().deepCopy(this.fields()[6].schema(), (Object)other.sampleDescription);
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.processingDescription)) {
                this.processingDescription = (String)this.data().deepCopy(this.fields()[7].schema(), (Object)other.processingDescription);
                this.fieldSetFlags()[7] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], other.alleles)) {
                this.alleles = (List)this.data().deepCopy(this.fields()[8].schema(), other.alleles);
                this.fieldSetFlags()[8] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.expectedAlleleDosage)) {
                this.expectedAlleleDosage = (Float)this.data().deepCopy(this.fields()[9].schema(), (Object)other.expectedAlleleDosage);
                this.fieldSetFlags()[9] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)other.referenceReadDepth)) {
                this.referenceReadDepth = (Integer)this.data().deepCopy(this.fields()[10].schema(), (Object)other.referenceReadDepth);
                this.fieldSetFlags()[10] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)other.alternateReadDepth)) {
                this.alternateReadDepth = (Integer)this.data().deepCopy(this.fields()[11].schema(), (Object)other.alternateReadDepth);
                this.fieldSetFlags()[11] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[12], (Object)other.readDepth)) {
                this.readDepth = (Integer)this.data().deepCopy(this.fields()[12].schema(), (Object)other.readDepth);
                this.fieldSetFlags()[12] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[13], (Object)other.minReadDepth)) {
                this.minReadDepth = (Integer)this.data().deepCopy(this.fields()[13].schema(), (Object)other.minReadDepth);
                this.fieldSetFlags()[13] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[14], (Object)other.genotypeQuality)) {
                this.genotypeQuality = (Integer)this.data().deepCopy(this.fields()[14].schema(), (Object)other.genotypeQuality);
                this.fieldSetFlags()[14] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[15], other.genotypeLikelihoods)) {
                this.genotypeLikelihoods = (List)this.data().deepCopy(this.fields()[15].schema(), other.genotypeLikelihoods);
                this.fieldSetFlags()[15] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[16], other.nonReferenceLikelihoods)) {
                this.nonReferenceLikelihoods = (List)this.data().deepCopy(this.fields()[16].schema(), other.nonReferenceLikelihoods);
                this.fieldSetFlags()[16] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[17], other.strandBiasComponents)) {
                this.strandBiasComponents = (List)this.data().deepCopy(this.fields()[17].schema(), other.strandBiasComponents);
                this.fieldSetFlags()[17] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[18], (Object)other.splitFromMultiAllelic)) {
                this.splitFromMultiAllelic = (Boolean)this.data().deepCopy(this.fields()[18].schema(), (Object)other.splitFromMultiAllelic);
                this.fieldSetFlags()[18] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[19], (Object)other.phased)) {
                this.phased = (Boolean)this.data().deepCopy(this.fields()[19].schema(), (Object)other.phased);
                this.fieldSetFlags()[19] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[20], (Object)other.phaseSetId)) {
                this.phaseSetId = (Integer)this.data().deepCopy(this.fields()[20].schema(), (Object)other.phaseSetId);
                this.fieldSetFlags()[20] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[21], (Object)other.phaseQuality)) {
                this.phaseQuality = (Integer)this.data().deepCopy(this.fields()[21].schema(), (Object)other.phaseQuality);
                this.fieldSetFlags()[21] = true;
            }
        }

        private Builder(Genotype other) {
            super(SCHEMA$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)((Object)other.variant))) {
                this.variant = (Variant)((Object)this.data().deepCopy(this.fields()[0].schema(), (Object)other.variant));
                this.fieldSetFlags()[0] = true;
            }
            this.variantBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.referenceName)) {
                this.referenceName = (String)this.data().deepCopy(this.fields()[1].schema(), (Object)other.referenceName);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.start)) {
                this.start = (Long)this.data().deepCopy(this.fields()[2].schema(), (Object)other.start);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.end)) {
                this.end = (Long)this.data().deepCopy(this.fields()[3].schema(), (Object)other.end);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)((Object)other.variantCallingAnnotations))) {
                this.variantCallingAnnotations = (VariantCallingAnnotations)((Object)this.data().deepCopy(this.fields()[4].schema(), (Object)other.variantCallingAnnotations));
                this.fieldSetFlags()[4] = true;
            }
            this.variantCallingAnnotationsBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.sampleId)) {
                this.sampleId = (String)this.data().deepCopy(this.fields()[5].schema(), (Object)other.sampleId);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.sampleDescription)) {
                this.sampleDescription = (String)this.data().deepCopy(this.fields()[6].schema(), (Object)other.sampleDescription);
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.processingDescription)) {
                this.processingDescription = (String)this.data().deepCopy(this.fields()[7].schema(), (Object)other.processingDescription);
                this.fieldSetFlags()[7] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], other.alleles)) {
                this.alleles = (List)this.data().deepCopy(this.fields()[8].schema(), other.alleles);
                this.fieldSetFlags()[8] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.expectedAlleleDosage)) {
                this.expectedAlleleDosage = (Float)this.data().deepCopy(this.fields()[9].schema(), (Object)other.expectedAlleleDosage);
                this.fieldSetFlags()[9] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)other.referenceReadDepth)) {
                this.referenceReadDepth = (Integer)this.data().deepCopy(this.fields()[10].schema(), (Object)other.referenceReadDepth);
                this.fieldSetFlags()[10] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)other.alternateReadDepth)) {
                this.alternateReadDepth = (Integer)this.data().deepCopy(this.fields()[11].schema(), (Object)other.alternateReadDepth);
                this.fieldSetFlags()[11] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[12], (Object)other.readDepth)) {
                this.readDepth = (Integer)this.data().deepCopy(this.fields()[12].schema(), (Object)other.readDepth);
                this.fieldSetFlags()[12] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[13], (Object)other.minReadDepth)) {
                this.minReadDepth = (Integer)this.data().deepCopy(this.fields()[13].schema(), (Object)other.minReadDepth);
                this.fieldSetFlags()[13] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[14], (Object)other.genotypeQuality)) {
                this.genotypeQuality = (Integer)this.data().deepCopy(this.fields()[14].schema(), (Object)other.genotypeQuality);
                this.fieldSetFlags()[14] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[15], other.genotypeLikelihoods)) {
                this.genotypeLikelihoods = (List)this.data().deepCopy(this.fields()[15].schema(), other.genotypeLikelihoods);
                this.fieldSetFlags()[15] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[16], other.nonReferenceLikelihoods)) {
                this.nonReferenceLikelihoods = (List)this.data().deepCopy(this.fields()[16].schema(), other.nonReferenceLikelihoods);
                this.fieldSetFlags()[16] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[17], other.strandBiasComponents)) {
                this.strandBiasComponents = (List)this.data().deepCopy(this.fields()[17].schema(), other.strandBiasComponents);
                this.fieldSetFlags()[17] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[18], (Object)other.splitFromMultiAllelic)) {
                this.splitFromMultiAllelic = (Boolean)this.data().deepCopy(this.fields()[18].schema(), (Object)other.splitFromMultiAllelic);
                this.fieldSetFlags()[18] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[19], (Object)other.phased)) {
                this.phased = (Boolean)this.data().deepCopy(this.fields()[19].schema(), (Object)other.phased);
                this.fieldSetFlags()[19] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[20], (Object)other.phaseSetId)) {
                this.phaseSetId = (Integer)this.data().deepCopy(this.fields()[20].schema(), (Object)other.phaseSetId);
                this.fieldSetFlags()[20] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[21], (Object)other.phaseQuality)) {
                this.phaseQuality = (Integer)this.data().deepCopy(this.fields()[21].schema(), (Object)other.phaseQuality);
                this.fieldSetFlags()[21] = true;
            }
        }

        public Variant getVariant() {
            return this.variant;
        }

        public Builder setVariant(Variant value) {
            this.validate(this.fields()[0], (Object)value);
            this.variantBuilder = null;
            this.variant = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasVariant() {
            return this.fieldSetFlags()[0];
        }

        public Variant.Builder getVariantBuilder() {
            if (this.variantBuilder == null) {
                if (this.hasVariant()) {
                    this.setVariantBuilder(Variant.newBuilder(this.variant));
                } else {
                    this.setVariantBuilder(Variant.newBuilder());
                }
            }
            return this.variantBuilder;
        }

        public Builder setVariantBuilder(Variant.Builder value) {
            this.clearVariant();
            this.variantBuilder = value;
            return this;
        }

        public boolean hasVariantBuilder() {
            return this.variantBuilder != null;
        }

        public Builder clearVariant() {
            this.variant = null;
            this.variantBuilder = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public String getReferenceName() {
            return this.referenceName;
        }

        public Builder setReferenceName(String value) {
            this.validate(this.fields()[1], value);
            this.referenceName = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasReferenceName() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearReferenceName() {
            this.referenceName = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public Long getStart() {
            return this.start;
        }

        public Builder setStart(Long value) {
            this.validate(this.fields()[2], value);
            this.start = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasStart() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearStart() {
            this.start = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public Long getEnd() {
            return this.end;
        }

        public Builder setEnd(Long value) {
            this.validate(this.fields()[3], value);
            this.end = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasEnd() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearEnd() {
            this.end = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public VariantCallingAnnotations getVariantCallingAnnotations() {
            return this.variantCallingAnnotations;
        }

        public Builder setVariantCallingAnnotations(VariantCallingAnnotations value) {
            this.validate(this.fields()[4], (Object)value);
            this.variantCallingAnnotationsBuilder = null;
            this.variantCallingAnnotations = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasVariantCallingAnnotations() {
            return this.fieldSetFlags()[4];
        }

        public VariantCallingAnnotations.Builder getVariantCallingAnnotationsBuilder() {
            if (this.variantCallingAnnotationsBuilder == null) {
                if (this.hasVariantCallingAnnotations()) {
                    this.setVariantCallingAnnotationsBuilder(VariantCallingAnnotations.newBuilder(this.variantCallingAnnotations));
                } else {
                    this.setVariantCallingAnnotationsBuilder(VariantCallingAnnotations.newBuilder());
                }
            }
            return this.variantCallingAnnotationsBuilder;
        }

        public Builder setVariantCallingAnnotationsBuilder(VariantCallingAnnotations.Builder value) {
            this.clearVariantCallingAnnotations();
            this.variantCallingAnnotationsBuilder = value;
            return this;
        }

        public boolean hasVariantCallingAnnotationsBuilder() {
            return this.variantCallingAnnotationsBuilder != null;
        }

        public Builder clearVariantCallingAnnotations() {
            this.variantCallingAnnotations = null;
            this.variantCallingAnnotationsBuilder = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public String getSampleId() {
            return this.sampleId;
        }

        public Builder setSampleId(String value) {
            this.validate(this.fields()[5], value);
            this.sampleId = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasSampleId() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearSampleId() {
            this.sampleId = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public String getSampleDescription() {
            return this.sampleDescription;
        }

        public Builder setSampleDescription(String value) {
            this.validate(this.fields()[6], value);
            this.sampleDescription = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasSampleDescription() {
            return this.fieldSetFlags()[6];
        }

        public Builder clearSampleDescription() {
            this.sampleDescription = null;
            this.fieldSetFlags()[6] = false;
            return this;
        }

        public String getProcessingDescription() {
            return this.processingDescription;
        }

        public Builder setProcessingDescription(String value) {
            this.validate(this.fields()[7], value);
            this.processingDescription = value;
            this.fieldSetFlags()[7] = true;
            return this;
        }

        public boolean hasProcessingDescription() {
            return this.fieldSetFlags()[7];
        }

        public Builder clearProcessingDescription() {
            this.processingDescription = null;
            this.fieldSetFlags()[7] = false;
            return this;
        }

        public List<GenotypeAllele> getAlleles() {
            return this.alleles;
        }

        public Builder setAlleles(List<GenotypeAllele> value) {
            this.validate(this.fields()[8], value);
            this.alleles = value;
            this.fieldSetFlags()[8] = true;
            return this;
        }

        public boolean hasAlleles() {
            return this.fieldSetFlags()[8];
        }

        public Builder clearAlleles() {
            this.alleles = null;
            this.fieldSetFlags()[8] = false;
            return this;
        }

        public Float getExpectedAlleleDosage() {
            return this.expectedAlleleDosage;
        }

        public Builder setExpectedAlleleDosage(Float value) {
            this.validate(this.fields()[9], value);
            this.expectedAlleleDosage = value;
            this.fieldSetFlags()[9] = true;
            return this;
        }

        public boolean hasExpectedAlleleDosage() {
            return this.fieldSetFlags()[9];
        }

        public Builder clearExpectedAlleleDosage() {
            this.expectedAlleleDosage = null;
            this.fieldSetFlags()[9] = false;
            return this;
        }

        public Integer getReferenceReadDepth() {
            return this.referenceReadDepth;
        }

        public Builder setReferenceReadDepth(Integer value) {
            this.validate(this.fields()[10], value);
            this.referenceReadDepth = value;
            this.fieldSetFlags()[10] = true;
            return this;
        }

        public boolean hasReferenceReadDepth() {
            return this.fieldSetFlags()[10];
        }

        public Builder clearReferenceReadDepth() {
            this.referenceReadDepth = null;
            this.fieldSetFlags()[10] = false;
            return this;
        }

        public Integer getAlternateReadDepth() {
            return this.alternateReadDepth;
        }

        public Builder setAlternateReadDepth(Integer value) {
            this.validate(this.fields()[11], value);
            this.alternateReadDepth = value;
            this.fieldSetFlags()[11] = true;
            return this;
        }

        public boolean hasAlternateReadDepth() {
            return this.fieldSetFlags()[11];
        }

        public Builder clearAlternateReadDepth() {
            this.alternateReadDepth = null;
            this.fieldSetFlags()[11] = false;
            return this;
        }

        public Integer getReadDepth() {
            return this.readDepth;
        }

        public Builder setReadDepth(Integer value) {
            this.validate(this.fields()[12], value);
            this.readDepth = value;
            this.fieldSetFlags()[12] = true;
            return this;
        }

        public boolean hasReadDepth() {
            return this.fieldSetFlags()[12];
        }

        public Builder clearReadDepth() {
            this.readDepth = null;
            this.fieldSetFlags()[12] = false;
            return this;
        }

        public Integer getMinReadDepth() {
            return this.minReadDepth;
        }

        public Builder setMinReadDepth(Integer value) {
            this.validate(this.fields()[13], value);
            this.minReadDepth = value;
            this.fieldSetFlags()[13] = true;
            return this;
        }

        public boolean hasMinReadDepth() {
            return this.fieldSetFlags()[13];
        }

        public Builder clearMinReadDepth() {
            this.minReadDepth = null;
            this.fieldSetFlags()[13] = false;
            return this;
        }

        public Integer getGenotypeQuality() {
            return this.genotypeQuality;
        }

        public Builder setGenotypeQuality(Integer value) {
            this.validate(this.fields()[14], value);
            this.genotypeQuality = value;
            this.fieldSetFlags()[14] = true;
            return this;
        }

        public boolean hasGenotypeQuality() {
            return this.fieldSetFlags()[14];
        }

        public Builder clearGenotypeQuality() {
            this.genotypeQuality = null;
            this.fieldSetFlags()[14] = false;
            return this;
        }

        public List<Double> getGenotypeLikelihoods() {
            return this.genotypeLikelihoods;
        }

        public Builder setGenotypeLikelihoods(List<Double> value) {
            this.validate(this.fields()[15], value);
            this.genotypeLikelihoods = value;
            this.fieldSetFlags()[15] = true;
            return this;
        }

        public boolean hasGenotypeLikelihoods() {
            return this.fieldSetFlags()[15];
        }

        public Builder clearGenotypeLikelihoods() {
            this.genotypeLikelihoods = null;
            this.fieldSetFlags()[15] = false;
            return this;
        }

        public List<Double> getNonReferenceLikelihoods() {
            return this.nonReferenceLikelihoods;
        }

        public Builder setNonReferenceLikelihoods(List<Double> value) {
            this.validate(this.fields()[16], value);
            this.nonReferenceLikelihoods = value;
            this.fieldSetFlags()[16] = true;
            return this;
        }

        public boolean hasNonReferenceLikelihoods() {
            return this.fieldSetFlags()[16];
        }

        public Builder clearNonReferenceLikelihoods() {
            this.nonReferenceLikelihoods = null;
            this.fieldSetFlags()[16] = false;
            return this;
        }

        public List<Integer> getStrandBiasComponents() {
            return this.strandBiasComponents;
        }

        public Builder setStrandBiasComponents(List<Integer> value) {
            this.validate(this.fields()[17], value);
            this.strandBiasComponents = value;
            this.fieldSetFlags()[17] = true;
            return this;
        }

        public boolean hasStrandBiasComponents() {
            return this.fieldSetFlags()[17];
        }

        public Builder clearStrandBiasComponents() {
            this.strandBiasComponents = null;
            this.fieldSetFlags()[17] = false;
            return this;
        }

        public Boolean getSplitFromMultiAllelic() {
            return this.splitFromMultiAllelic;
        }

        public Builder setSplitFromMultiAllelic(Boolean value) {
            this.validate(this.fields()[18], value);
            this.splitFromMultiAllelic = value;
            this.fieldSetFlags()[18] = true;
            return this;
        }

        public boolean hasSplitFromMultiAllelic() {
            return this.fieldSetFlags()[18];
        }

        public Builder clearSplitFromMultiAllelic() {
            this.splitFromMultiAllelic = null;
            this.fieldSetFlags()[18] = false;
            return this;
        }

        public Boolean getPhased() {
            return this.phased;
        }

        public Builder setPhased(Boolean value) {
            this.validate(this.fields()[19], value);
            this.phased = value;
            this.fieldSetFlags()[19] = true;
            return this;
        }

        public boolean hasPhased() {
            return this.fieldSetFlags()[19];
        }

        public Builder clearPhased() {
            this.phased = null;
            this.fieldSetFlags()[19] = false;
            return this;
        }

        public Integer getPhaseSetId() {
            return this.phaseSetId;
        }

        public Builder setPhaseSetId(Integer value) {
            this.validate(this.fields()[20], value);
            this.phaseSetId = value;
            this.fieldSetFlags()[20] = true;
            return this;
        }

        public boolean hasPhaseSetId() {
            return this.fieldSetFlags()[20];
        }

        public Builder clearPhaseSetId() {
            this.phaseSetId = null;
            this.fieldSetFlags()[20] = false;
            return this;
        }

        public Integer getPhaseQuality() {
            return this.phaseQuality;
        }

        public Builder setPhaseQuality(Integer value) {
            this.validate(this.fields()[21], value);
            this.phaseQuality = value;
            this.fieldSetFlags()[21] = true;
            return this;
        }

        public boolean hasPhaseQuality() {
            return this.fieldSetFlags()[21];
        }

        public Builder clearPhaseQuality() {
            this.phaseQuality = null;
            this.fieldSetFlags()[21] = false;
            return this;
        }

        public Genotype build() {
            try {
                Genotype record = new Genotype();
                record.variant = this.variantBuilder != null ? this.variantBuilder.build() : (this.fieldSetFlags()[0] ? this.variant : (Variant)((Object)this.defaultValue(this.fields()[0])));
                record.referenceName = this.fieldSetFlags()[1] ? this.referenceName : (String)this.defaultValue(this.fields()[1]);
                record.start = this.fieldSetFlags()[2] ? this.start : (Long)this.defaultValue(this.fields()[2]);
                Long l = record.end = this.fieldSetFlags()[3] ? this.end : (Long)this.defaultValue(this.fields()[3]);
                record.variantCallingAnnotations = this.variantCallingAnnotationsBuilder != null ? this.variantCallingAnnotationsBuilder.build() : (this.fieldSetFlags()[4] ? this.variantCallingAnnotations : (VariantCallingAnnotations)((Object)this.defaultValue(this.fields()[4])));
                record.sampleId = this.fieldSetFlags()[5] ? this.sampleId : (String)this.defaultValue(this.fields()[5]);
                record.sampleDescription = this.fieldSetFlags()[6] ? this.sampleDescription : (String)this.defaultValue(this.fields()[6]);
                record.processingDescription = this.fieldSetFlags()[7] ? this.processingDescription : (String)this.defaultValue(this.fields()[7]);
                record.alleles = this.fieldSetFlags()[8] ? this.alleles : (List)this.defaultValue(this.fields()[8]);
                record.expectedAlleleDosage = this.fieldSetFlags()[9] ? this.expectedAlleleDosage : (Float)this.defaultValue(this.fields()[9]);
                record.referenceReadDepth = this.fieldSetFlags()[10] ? this.referenceReadDepth : (Integer)this.defaultValue(this.fields()[10]);
                record.alternateReadDepth = this.fieldSetFlags()[11] ? this.alternateReadDepth : (Integer)this.defaultValue(this.fields()[11]);
                record.readDepth = this.fieldSetFlags()[12] ? this.readDepth : (Integer)this.defaultValue(this.fields()[12]);
                record.minReadDepth = this.fieldSetFlags()[13] ? this.minReadDepth : (Integer)this.defaultValue(this.fields()[13]);
                record.genotypeQuality = this.fieldSetFlags()[14] ? this.genotypeQuality : (Integer)this.defaultValue(this.fields()[14]);
                record.genotypeLikelihoods = this.fieldSetFlags()[15] ? this.genotypeLikelihoods : (List)this.defaultValue(this.fields()[15]);
                record.nonReferenceLikelihoods = this.fieldSetFlags()[16] ? this.nonReferenceLikelihoods : (List)this.defaultValue(this.fields()[16]);
                record.strandBiasComponents = this.fieldSetFlags()[17] ? this.strandBiasComponents : (List)this.defaultValue(this.fields()[17]);
                record.splitFromMultiAllelic = this.fieldSetFlags()[18] ? this.splitFromMultiAllelic : (Boolean)this.defaultValue(this.fields()[18]);
                record.phased = this.fieldSetFlags()[19] ? this.phased : (Boolean)this.defaultValue(this.fields()[19]);
                record.phaseSetId = this.fieldSetFlags()[20] ? this.phaseSetId : (Integer)this.defaultValue(this.fields()[20]);
                record.phaseQuality = this.fieldSetFlags()[21] ? this.phaseQuality : (Integer)this.defaultValue(this.fields()[21]);
                return record;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

