/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.formats.avro;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class Reference
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -2346982311820501459L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"Reference\",\"namespace\":\"org.bdgenomics.formats.avro\",\"doc\":\"A reference is a canonical assembled contig, intended to act as a\\n reference coordinate space for other genomic annotations. A single\\n reference might represent the human chromosome 1, for instance.\",\"fields\":[{\"name\":\"name\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The name of this reference in the assembly (e.g., \\\"1\\\").\",\"default\":null},{\"name\":\"length\",\"type\":[\"null\",\"long\"],\"doc\":\"The length of the sequence for this reference.\",\"default\":null},{\"name\":\"md5\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The MD5 checksum uniquely representing this reference as a lower-case\\n   hexadecimal string, calculated as the MD5 of the upper-case sequence\\n   excluding all whitespace characters (equivalent to SQ:M5 in SAM).\",\"default\":null},{\"name\":\"sourceUri\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The URI from which the reference sequence was obtained.\",\"default\":null},{\"name\":\"assembly\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The name of the assembly for this reference (e.g., \\\"hg19\\\").\",\"default\":null},{\"name\":\"sourceAccessions\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},\"doc\":\"All known corresponding accession IDs for this reference in INSDC\\n   (GenBank/ENA/DDBJ), which must include a version number, e.g. GCF_000001405.26.\",\"default\":[]},{\"name\":\"species\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The species that this reference is for.\",\"default\":null},{\"name\":\"index\",\"type\":[\"null\",\"int\"],\"doc\":\"Optional zero-based index of this reference in a SAM file header that it was\\n   read from; helps output SAMs/BAMs with headers in the same order as they\\n   started with, before a conversion to ADAM.\",\"default\":null}]}");
    private static SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<Reference> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<Reference> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    @Deprecated
    public String name;
    @Deprecated
    public Long length;
    @Deprecated
    public String md5;
    @Deprecated
    public String sourceUri;
    @Deprecated
    public String assembly;
    @Deprecated
    public List<String> sourceAccessions;
    @Deprecated
    public String species;
    @Deprecated
    public Integer index;
    private static final DatumWriter<Reference> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<Reference> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageDecoder<Reference> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<Reference> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static Reference fromByteBuffer(ByteBuffer b) throws IOException {
        return (Reference)((Object)DECODER.decode(b));
    }

    public Reference() {
    }

    public Reference(String name, Long length, String md5, String sourceUri, String assembly, List<String> sourceAccessions, String species, Integer index) {
        this.name = name;
        this.length = length;
        this.md5 = md5;
        this.sourceUri = sourceUri;
        this.assembly = assembly;
        this.sourceAccessions = sourceAccessions;
        this.species = species;
        this.index = index;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.name;
            }
            case 1: {
                return this.length;
            }
            case 2: {
                return this.md5;
            }
            case 3: {
                return this.sourceUri;
            }
            case 4: {
                return this.assembly;
            }
            case 5: {
                return this.sourceAccessions;
            }
            case 6: {
                return this.species;
            }
            case 7: {
                return this.index;
            }
        }
        throw new AvroRuntimeException("Bad index");
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.name = (String)value$;
                break;
            }
            case 1: {
                this.length = (Long)value$;
                break;
            }
            case 2: {
                this.md5 = (String)value$;
                break;
            }
            case 3: {
                this.sourceUri = (String)value$;
                break;
            }
            case 4: {
                this.assembly = (String)value$;
                break;
            }
            case 5: {
                this.sourceAccessions = (List)value$;
                break;
            }
            case 6: {
                this.species = (String)value$;
                break;
            }
            case 7: {
                this.index = (Integer)value$;
                break;
            }
            default: {
                throw new AvroRuntimeException("Bad index");
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public Long getLength() {
        return this.length;
    }

    public void setLength(Long value) {
        this.length = value;
    }

    public String getMd5() {
        return this.md5;
    }

    public void setMd5(String value) {
        this.md5 = value;
    }

    public String getSourceUri() {
        return this.sourceUri;
    }

    public void setSourceUri(String value) {
        this.sourceUri = value;
    }

    public String getAssembly() {
        return this.assembly;
    }

    public void setAssembly(String value) {
        this.assembly = value;
    }

    public List<String> getSourceAccessions() {
        return this.sourceAccessions;
    }

    public void setSourceAccessions(List<String> value) {
        this.sourceAccessions = value;
    }

    public String getSpecies() {
        return this.species;
    }

    public void setSpecies(String value) {
        this.species = value;
    }

    public Integer getIndex() {
        return this.index;
    }

    public void setIndex(Integer value) {
        this.index = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        return new Builder(other);
    }

    public static Builder newBuilder(Reference other) {
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    public static class Builder
    extends SpecificRecordBuilderBase<Reference>
    implements RecordBuilder<Reference> {
        private String name;
        private Long length;
        private String md5;
        private String sourceUri;
        private String assembly;
        private List<String> sourceAccessions;
        private String species;
        private Integer index;

        private Builder() {
            super(SCHEMA$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.name)) {
                this.name = (String)this.data().deepCopy(this.fields()[0].schema(), (Object)other.name);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.length)) {
                this.length = (Long)this.data().deepCopy(this.fields()[1].schema(), (Object)other.length);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.md5)) {
                this.md5 = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.md5);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.sourceUri)) {
                this.sourceUri = (String)this.data().deepCopy(this.fields()[3].schema(), (Object)other.sourceUri);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.assembly)) {
                this.assembly = (String)this.data().deepCopy(this.fields()[4].schema(), (Object)other.assembly);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], other.sourceAccessions)) {
                this.sourceAccessions = (List)this.data().deepCopy(this.fields()[5].schema(), other.sourceAccessions);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.species)) {
                this.species = (String)this.data().deepCopy(this.fields()[6].schema(), (Object)other.species);
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.index)) {
                this.index = (Integer)this.data().deepCopy(this.fields()[7].schema(), (Object)other.index);
                this.fieldSetFlags()[7] = true;
            }
        }

        private Builder(Reference other) {
            super(SCHEMA$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.name)) {
                this.name = (String)this.data().deepCopy(this.fields()[0].schema(), (Object)other.name);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.length)) {
                this.length = (Long)this.data().deepCopy(this.fields()[1].schema(), (Object)other.length);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.md5)) {
                this.md5 = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.md5);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.sourceUri)) {
                this.sourceUri = (String)this.data().deepCopy(this.fields()[3].schema(), (Object)other.sourceUri);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.assembly)) {
                this.assembly = (String)this.data().deepCopy(this.fields()[4].schema(), (Object)other.assembly);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], other.sourceAccessions)) {
                this.sourceAccessions = (List)this.data().deepCopy(this.fields()[5].schema(), other.sourceAccessions);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.species)) {
                this.species = (String)this.data().deepCopy(this.fields()[6].schema(), (Object)other.species);
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.index)) {
                this.index = (Integer)this.data().deepCopy(this.fields()[7].schema(), (Object)other.index);
                this.fieldSetFlags()[7] = true;
            }
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String value) {
            this.validate(this.fields()[0], value);
            this.name = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasName() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearName() {
            this.name = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public Long getLength() {
            return this.length;
        }

        public Builder setLength(Long value) {
            this.validate(this.fields()[1], value);
            this.length = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasLength() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearLength() {
            this.length = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public String getMd5() {
            return this.md5;
        }

        public Builder setMd5(String value) {
            this.validate(this.fields()[2], value);
            this.md5 = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasMd5() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearMd5() {
            this.md5 = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public String getSourceUri() {
            return this.sourceUri;
        }

        public Builder setSourceUri(String value) {
            this.validate(this.fields()[3], value);
            this.sourceUri = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasSourceUri() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearSourceUri() {
            this.sourceUri = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public String getAssembly() {
            return this.assembly;
        }

        public Builder setAssembly(String value) {
            this.validate(this.fields()[4], value);
            this.assembly = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasAssembly() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearAssembly() {
            this.assembly = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public List<String> getSourceAccessions() {
            return this.sourceAccessions;
        }

        public Builder setSourceAccessions(List<String> value) {
            this.validate(this.fields()[5], value);
            this.sourceAccessions = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasSourceAccessions() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearSourceAccessions() {
            this.sourceAccessions = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public String getSpecies() {
            return this.species;
        }

        public Builder setSpecies(String value) {
            this.validate(this.fields()[6], value);
            this.species = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasSpecies() {
            return this.fieldSetFlags()[6];
        }

        public Builder clearSpecies() {
            this.species = null;
            this.fieldSetFlags()[6] = false;
            return this;
        }

        public Integer getIndex() {
            return this.index;
        }

        public Builder setIndex(Integer value) {
            this.validate(this.fields()[7], value);
            this.index = value;
            this.fieldSetFlags()[7] = true;
            return this;
        }

        public boolean hasIndex() {
            return this.fieldSetFlags()[7];
        }

        public Builder clearIndex() {
            this.index = null;
            this.fieldSetFlags()[7] = false;
            return this;
        }

        public Reference build() {
            try {
                Reference record = new Reference();
                record.name = this.fieldSetFlags()[0] ? this.name : (String)this.defaultValue(this.fields()[0]);
                record.length = this.fieldSetFlags()[1] ? this.length : (Long)this.defaultValue(this.fields()[1]);
                record.md5 = this.fieldSetFlags()[2] ? this.md5 : (String)this.defaultValue(this.fields()[2]);
                record.sourceUri = this.fieldSetFlags()[3] ? this.sourceUri : (String)this.defaultValue(this.fields()[3]);
                record.assembly = this.fieldSetFlags()[4] ? this.assembly : (String)this.defaultValue(this.fields()[4]);
                record.sourceAccessions = this.fieldSetFlags()[5] ? this.sourceAccessions : (List)this.defaultValue(this.fields()[5]);
                record.species = this.fieldSetFlags()[6] ? this.species : (String)this.defaultValue(this.fields()[6]);
                record.index = this.fieldSetFlags()[7] ? this.index : (Integer)this.defaultValue(this.fields()[7]);
                return record;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

