/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.formats.avro;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.bdgenomics.formats.avro.Alphabet;
import org.bdgenomics.formats.avro.Strand;

@AvroGenerated
public class Slice
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 6768165843391035452L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"Slice\",\"namespace\":\"org.bdgenomics.formats.avro\",\"doc\":\"View of a contiguous region of a sequence.\",\"fields\":[{\"name\":\"name\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Name of the sequence this slice views.\",\"default\":null},{\"name\":\"description\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Description for the sequence this slice views.\",\"default\":null},{\"name\":\"alphabet\",\"type\":[{\"type\":\"enum\",\"name\":\"Alphabet\",\"doc\":\"Protein alphabet.\",\"symbols\":[\"DNA\",\"RNA\",\"PROTEIN\"]},\"null\"],\"doc\":\"Alphabet for the sequence this slice views, defaults to Alphabet.DNA.\",\"default\":\"DNA\"},{\"name\":\"sequence\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Sequence for this slice.\",\"default\":null},{\"name\":\"start\",\"type\":[\"null\",\"long\"],\"doc\":\"Start position for this slice on the sequence this slice views, in zero-based coordinate\\n   system with closed-open intervals.\",\"default\":null},{\"name\":\"end\",\"type\":[\"null\",\"long\"],\"doc\":\"End position for this slice on the sequence this slice views, in zero-based coordinate\\n   system with closed-open intervals.\",\"default\":null},{\"name\":\"strand\",\"type\":[{\"type\":\"enum\",\"name\":\"Strand\",\"doc\":\"Strandedness is relevant, but unknown (\\\"?\\\").\",\"symbols\":[\"FORWARD\",\"REVERSE\",\"INDEPENDENT\",\"UNKNOWN\"]},\"null\"],\"doc\":\"Strand for this slice, if any, defaults to Strand.INDEPENDENT.\",\"default\":\"INDEPENDENT\"},{\"name\":\"length\",\"type\":[\"null\",\"long\"],\"doc\":\"Length of this slice.\",\"default\":null},{\"name\":\"totalLength\",\"type\":[\"null\",\"long\"],\"doc\":\"Length of the sequence this slice views.\",\"default\":null},{\"name\":\"index\",\"type\":[\"null\",\"int\"],\"doc\":\"Index of this slice in a set of slices that covers the sequence this slice views, if any.\",\"default\":null},{\"name\":\"slices\",\"type\":[\"null\",\"int\"],\"doc\":\"Number of slices in a set of slices that covers the sequence this slice views, if any.\",\"default\":null},{\"name\":\"sampleId\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Sample identifier for this slice. Join with Sample.id for sample metadata.\",\"default\":null},{\"name\":\"attributes\",\"type\":{\"type\":\"map\",\"values\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"avro.java.string\":\"String\"},\"doc\":\"Map of attributes.\",\"default\":{}}]}");
    private static SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<Slice> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<Slice> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    @Deprecated
    public String name;
    @Deprecated
    public String description;
    @Deprecated
    public Alphabet alphabet;
    @Deprecated
    public String sequence;
    @Deprecated
    public Long start;
    @Deprecated
    public Long end;
    @Deprecated
    public Strand strand;
    @Deprecated
    public Long length;
    @Deprecated
    public Long totalLength;
    @Deprecated
    public Integer index;
    @Deprecated
    public Integer slices;
    @Deprecated
    public String sampleId;
    @Deprecated
    public Map<String, String> attributes;
    private static final DatumWriter<Slice> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<Slice> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageDecoder<Slice> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<Slice> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static Slice fromByteBuffer(ByteBuffer b) throws IOException {
        return (Slice)((Object)DECODER.decode(b));
    }

    public Slice() {
    }

    public Slice(String name, String description, Alphabet alphabet, String sequence, Long start, Long end, Strand strand, Long length, Long totalLength, Integer index, Integer slices, String sampleId, Map<String, String> attributes) {
        this.name = name;
        this.description = description;
        this.alphabet = alphabet;
        this.sequence = sequence;
        this.start = start;
        this.end = end;
        this.strand = strand;
        this.length = length;
        this.totalLength = totalLength;
        this.index = index;
        this.slices = slices;
        this.sampleId = sampleId;
        this.attributes = attributes;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.name;
            }
            case 1: {
                return this.description;
            }
            case 2: {
                return this.alphabet;
            }
            case 3: {
                return this.sequence;
            }
            case 4: {
                return this.start;
            }
            case 5: {
                return this.end;
            }
            case 6: {
                return this.strand;
            }
            case 7: {
                return this.length;
            }
            case 8: {
                return this.totalLength;
            }
            case 9: {
                return this.index;
            }
            case 10: {
                return this.slices;
            }
            case 11: {
                return this.sampleId;
            }
            case 12: {
                return this.attributes;
            }
        }
        throw new AvroRuntimeException("Bad index");
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.name = (String)value$;
                break;
            }
            case 1: {
                this.description = (String)value$;
                break;
            }
            case 2: {
                this.alphabet = (Alphabet)((Object)value$);
                break;
            }
            case 3: {
                this.sequence = (String)value$;
                break;
            }
            case 4: {
                this.start = (Long)value$;
                break;
            }
            case 5: {
                this.end = (Long)value$;
                break;
            }
            case 6: {
                this.strand = (Strand)((Object)value$);
                break;
            }
            case 7: {
                this.length = (Long)value$;
                break;
            }
            case 8: {
                this.totalLength = (Long)value$;
                break;
            }
            case 9: {
                this.index = (Integer)value$;
                break;
            }
            case 10: {
                this.slices = (Integer)value$;
                break;
            }
            case 11: {
                this.sampleId = (String)value$;
                break;
            }
            case 12: {
                this.attributes = (Map)value$;
                break;
            }
            default: {
                throw new AvroRuntimeException("Bad index");
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public Alphabet getAlphabet() {
        return this.alphabet;
    }

    public void setAlphabet(Alphabet value) {
        this.alphabet = value;
    }

    public String getSequence() {
        return this.sequence;
    }

    public void setSequence(String value) {
        this.sequence = value;
    }

    public Long getStart() {
        return this.start;
    }

    public void setStart(Long value) {
        this.start = value;
    }

    public Long getEnd() {
        return this.end;
    }

    public void setEnd(Long value) {
        this.end = value;
    }

    public Strand getStrand() {
        return this.strand;
    }

    public void setStrand(Strand value) {
        this.strand = value;
    }

    public Long getLength() {
        return this.length;
    }

    public void setLength(Long value) {
        this.length = value;
    }

    public Long getTotalLength() {
        return this.totalLength;
    }

    public void setTotalLength(Long value) {
        this.totalLength = value;
    }

    public Integer getIndex() {
        return this.index;
    }

    public void setIndex(Integer value) {
        this.index = value;
    }

    public Integer getSlices() {
        return this.slices;
    }

    public void setSlices(Integer value) {
        this.slices = value;
    }

    public String getSampleId() {
        return this.sampleId;
    }

    public void setSampleId(String value) {
        this.sampleId = value;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> value) {
        this.attributes = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        return new Builder(other);
    }

    public static Builder newBuilder(Slice other) {
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    public static class Builder
    extends SpecificRecordBuilderBase<Slice>
    implements RecordBuilder<Slice> {
        private String name;
        private String description;
        private Alphabet alphabet;
        private String sequence;
        private Long start;
        private Long end;
        private Strand strand;
        private Long length;
        private Long totalLength;
        private Integer index;
        private Integer slices;
        private String sampleId;
        private Map<String, String> attributes;

        private Builder() {
            super(SCHEMA$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.name)) {
                this.name = (String)this.data().deepCopy(this.fields()[0].schema(), (Object)other.name);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.description)) {
                this.description = (String)this.data().deepCopy(this.fields()[1].schema(), (Object)other.description);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)((Object)other.alphabet))) {
                this.alphabet = (Alphabet)((Object)this.data().deepCopy(this.fields()[2].schema(), (Object)other.alphabet));
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.sequence)) {
                this.sequence = (String)this.data().deepCopy(this.fields()[3].schema(), (Object)other.sequence);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.start)) {
                this.start = (Long)this.data().deepCopy(this.fields()[4].schema(), (Object)other.start);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.end)) {
                this.end = (Long)this.data().deepCopy(this.fields()[5].schema(), (Object)other.end);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)((Object)other.strand))) {
                this.strand = (Strand)((Object)this.data().deepCopy(this.fields()[6].schema(), (Object)other.strand));
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.length)) {
                this.length = (Long)this.data().deepCopy(this.fields()[7].schema(), (Object)other.length);
                this.fieldSetFlags()[7] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.totalLength)) {
                this.totalLength = (Long)this.data().deepCopy(this.fields()[8].schema(), (Object)other.totalLength);
                this.fieldSetFlags()[8] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.index)) {
                this.index = (Integer)this.data().deepCopy(this.fields()[9].schema(), (Object)other.index);
                this.fieldSetFlags()[9] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)other.slices)) {
                this.slices = (Integer)this.data().deepCopy(this.fields()[10].schema(), (Object)other.slices);
                this.fieldSetFlags()[10] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)other.sampleId)) {
                this.sampleId = (String)this.data().deepCopy(this.fields()[11].schema(), (Object)other.sampleId);
                this.fieldSetFlags()[11] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[12], other.attributes)) {
                this.attributes = (Map)this.data().deepCopy(this.fields()[12].schema(), other.attributes);
                this.fieldSetFlags()[12] = true;
            }
        }

        private Builder(Slice other) {
            super(SCHEMA$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.name)) {
                this.name = (String)this.data().deepCopy(this.fields()[0].schema(), (Object)other.name);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.description)) {
                this.description = (String)this.data().deepCopy(this.fields()[1].schema(), (Object)other.description);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)((Object)other.alphabet))) {
                this.alphabet = (Alphabet)((Object)this.data().deepCopy(this.fields()[2].schema(), (Object)other.alphabet));
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.sequence)) {
                this.sequence = (String)this.data().deepCopy(this.fields()[3].schema(), (Object)other.sequence);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.start)) {
                this.start = (Long)this.data().deepCopy(this.fields()[4].schema(), (Object)other.start);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.end)) {
                this.end = (Long)this.data().deepCopy(this.fields()[5].schema(), (Object)other.end);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)((Object)other.strand))) {
                this.strand = (Strand)((Object)this.data().deepCopy(this.fields()[6].schema(), (Object)other.strand));
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.length)) {
                this.length = (Long)this.data().deepCopy(this.fields()[7].schema(), (Object)other.length);
                this.fieldSetFlags()[7] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.totalLength)) {
                this.totalLength = (Long)this.data().deepCopy(this.fields()[8].schema(), (Object)other.totalLength);
                this.fieldSetFlags()[8] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.index)) {
                this.index = (Integer)this.data().deepCopy(this.fields()[9].schema(), (Object)other.index);
                this.fieldSetFlags()[9] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)other.slices)) {
                this.slices = (Integer)this.data().deepCopy(this.fields()[10].schema(), (Object)other.slices);
                this.fieldSetFlags()[10] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)other.sampleId)) {
                this.sampleId = (String)this.data().deepCopy(this.fields()[11].schema(), (Object)other.sampleId);
                this.fieldSetFlags()[11] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[12], other.attributes)) {
                this.attributes = (Map)this.data().deepCopy(this.fields()[12].schema(), other.attributes);
                this.fieldSetFlags()[12] = true;
            }
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String value) {
            this.validate(this.fields()[0], value);
            this.name = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasName() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearName() {
            this.name = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public String getDescription() {
            return this.description;
        }

        public Builder setDescription(String value) {
            this.validate(this.fields()[1], value);
            this.description = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasDescription() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearDescription() {
            this.description = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public Alphabet getAlphabet() {
            return this.alphabet;
        }

        public Builder setAlphabet(Alphabet value) {
            this.validate(this.fields()[2], (Object)value);
            this.alphabet = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasAlphabet() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearAlphabet() {
            this.alphabet = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public String getSequence() {
            return this.sequence;
        }

        public Builder setSequence(String value) {
            this.validate(this.fields()[3], value);
            this.sequence = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasSequence() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearSequence() {
            this.sequence = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public Long getStart() {
            return this.start;
        }

        public Builder setStart(Long value) {
            this.validate(this.fields()[4], value);
            this.start = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasStart() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearStart() {
            this.start = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public Long getEnd() {
            return this.end;
        }

        public Builder setEnd(Long value) {
            this.validate(this.fields()[5], value);
            this.end = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasEnd() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearEnd() {
            this.end = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public Strand getStrand() {
            return this.strand;
        }

        public Builder setStrand(Strand value) {
            this.validate(this.fields()[6], (Object)value);
            this.strand = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasStrand() {
            return this.fieldSetFlags()[6];
        }

        public Builder clearStrand() {
            this.strand = null;
            this.fieldSetFlags()[6] = false;
            return this;
        }

        public Long getLength() {
            return this.length;
        }

        public Builder setLength(Long value) {
            this.validate(this.fields()[7], value);
            this.length = value;
            this.fieldSetFlags()[7] = true;
            return this;
        }

        public boolean hasLength() {
            return this.fieldSetFlags()[7];
        }

        public Builder clearLength() {
            this.length = null;
            this.fieldSetFlags()[7] = false;
            return this;
        }

        public Long getTotalLength() {
            return this.totalLength;
        }

        public Builder setTotalLength(Long value) {
            this.validate(this.fields()[8], value);
            this.totalLength = value;
            this.fieldSetFlags()[8] = true;
            return this;
        }

        public boolean hasTotalLength() {
            return this.fieldSetFlags()[8];
        }

        public Builder clearTotalLength() {
            this.totalLength = null;
            this.fieldSetFlags()[8] = false;
            return this;
        }

        public Integer getIndex() {
            return this.index;
        }

        public Builder setIndex(Integer value) {
            this.validate(this.fields()[9], value);
            this.index = value;
            this.fieldSetFlags()[9] = true;
            return this;
        }

        public boolean hasIndex() {
            return this.fieldSetFlags()[9];
        }

        public Builder clearIndex() {
            this.index = null;
            this.fieldSetFlags()[9] = false;
            return this;
        }

        public Integer getSlices() {
            return this.slices;
        }

        public Builder setSlices(Integer value) {
            this.validate(this.fields()[10], value);
            this.slices = value;
            this.fieldSetFlags()[10] = true;
            return this;
        }

        public boolean hasSlices() {
            return this.fieldSetFlags()[10];
        }

        public Builder clearSlices() {
            this.slices = null;
            this.fieldSetFlags()[10] = false;
            return this;
        }

        public String getSampleId() {
            return this.sampleId;
        }

        public Builder setSampleId(String value) {
            this.validate(this.fields()[11], value);
            this.sampleId = value;
            this.fieldSetFlags()[11] = true;
            return this;
        }

        public boolean hasSampleId() {
            return this.fieldSetFlags()[11];
        }

        public Builder clearSampleId() {
            this.sampleId = null;
            this.fieldSetFlags()[11] = false;
            return this;
        }

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public Builder setAttributes(Map<String, String> value) {
            this.validate(this.fields()[12], value);
            this.attributes = value;
            this.fieldSetFlags()[12] = true;
            return this;
        }

        public boolean hasAttributes() {
            return this.fieldSetFlags()[12];
        }

        public Builder clearAttributes() {
            this.attributes = null;
            this.fieldSetFlags()[12] = false;
            return this;
        }

        public Slice build() {
            try {
                Slice record = new Slice();
                record.name = this.fieldSetFlags()[0] ? this.name : (String)this.defaultValue(this.fields()[0]);
                record.description = this.fieldSetFlags()[1] ? this.description : (String)this.defaultValue(this.fields()[1]);
                record.alphabet = this.fieldSetFlags()[2] ? this.alphabet : (Alphabet)((Object)this.defaultValue(this.fields()[2]));
                record.sequence = this.fieldSetFlags()[3] ? this.sequence : (String)this.defaultValue(this.fields()[3]);
                record.start = this.fieldSetFlags()[4] ? this.start : (Long)this.defaultValue(this.fields()[4]);
                record.end = this.fieldSetFlags()[5] ? this.end : (Long)this.defaultValue(this.fields()[5]);
                record.strand = this.fieldSetFlags()[6] ? this.strand : (Strand)((Object)this.defaultValue(this.fields()[6]));
                record.length = this.fieldSetFlags()[7] ? this.length : (Long)this.defaultValue(this.fields()[7]);
                record.totalLength = this.fieldSetFlags()[8] ? this.totalLength : (Long)this.defaultValue(this.fields()[8]);
                record.index = this.fieldSetFlags()[9] ? this.index : (Integer)this.defaultValue(this.fields()[9]);
                record.slices = this.fieldSetFlags()[10] ? this.slices : (Integer)this.defaultValue(this.fields()[10]);
                record.sampleId = this.fieldSetFlags()[11] ? this.sampleId : (String)this.defaultValue(this.fields()[11]);
                record.attributes = this.fieldSetFlags()[12] ? this.attributes : (Map)this.defaultValue(this.fields()[12]);
                return record;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

