/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.formats.avro;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.bdgenomics.formats.avro.Impact;
import org.bdgenomics.formats.avro.Strand;
import org.bdgenomics.formats.avro.VariantAnnotationMessage;

@AvroGenerated
public class TranscriptEffect
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 8448733277705990337L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"TranscriptEffect\",\"namespace\":\"org.bdgenomics.formats.avro\",\"doc\":\"Annotation of a variant in the context of a feature, typically a transcript.\",\"fields\":[{\"name\":\"alternateAllele\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Alternate allele for this variant annotation.\",\"default\":null},{\"name\":\"effects\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},\"doc\":\"One or more annotations (also referred to as effects or consequences) of the\\n   variant in the context of the feature identified by featureId. Must be\\n   Sequence Ontology (SO, see http://www.sequenceontology.org) term names, e.g.\\n   stop_gained, missense_variant, synonymous_variant, upstream_gene_variant.\",\"default\":[]},{\"name\":\"impact\",\"type\":[\"null\",{\"type\":\"enum\",\"name\":\"Impact\",\"doc\":\"Modifier impact.\",\"symbols\":[\"HIGH\",\"MODERATE\",\"LOW\",\"MODIFIER\"]}],\"doc\":\"Putative impact of the annotation; a simple estimation of putative impact/\\n   deleteriousness.\",\"default\":null},{\"name\":\"geneName\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Common gene name (HGNC), e.g. BRCA2. May be closest gene if annotation\\n   is intergenic.\",\"default\":null},{\"name\":\"geneId\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Gene identifier, e.g. Ensembl Gene identifier, ENSG00000139618. May be\\n   closest gene if annotation is intergenic.\",\"default\":null},{\"name\":\"featureType\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Feature type, may use Sequence Ontology term names. Typically transcript.\",\"default\":null},{\"name\":\"featureId\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Feature identifier, e.g. Ensembl Transcript identifier and version, ENST00000380152.7.\",\"default\":null},{\"name\":\"biotype\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Feature biotype, e.g. Protein coding or Non coding. See http://vega.sanger.ac.uk/info/about/gene_and_transcript_types.html.\",\"default\":null},{\"name\":\"strand\",\"type\":[\"null\",{\"type\":\"enum\",\"name\":\"Strand\",\"doc\":\"Strandedness is relevant, but unknown (\\\"?\\\").\",\"symbols\":[\"FORWARD\",\"REVERSE\",\"INDEPENDENT\",\"UNKNOWN\"]}],\"doc\":\"Feature strand, if known.\",\"default\":null},{\"name\":\"rank\",\"type\":[\"null\",\"int\"],\"doc\":\"Intron or exon rank.\",\"default\":null},{\"name\":\"total\",\"type\":[\"null\",\"int\"],\"doc\":\"Total number of introns or exons.\",\"default\":null},{\"name\":\"genomicHgvs\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"HGVS.g description of the variant. See http://www.hgvs.org/mutnomen/recs-DNA.html.\",\"default\":null},{\"name\":\"transcriptHgvs\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"HGVS.c description of the variant. See http://www.hgvs.org/mutnomen/recs-DNA.html.\",\"default\":null},{\"name\":\"proteinHgvs\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"HGVS.p description of the variant, if coding. See http://www.hgvs.org/mutnomen/recs-prot.html.\",\"default\":null},{\"name\":\"cdnaPosition\",\"type\":[\"null\",\"int\"],\"doc\":\"cDNA sequence position (one based).\",\"default\":null},{\"name\":\"cdnaLength\",\"type\":[\"null\",\"int\"],\"doc\":\"cDNA sequence length in base pairs (one based).\",\"default\":null},{\"name\":\"codingSequencePosition\",\"type\":[\"null\",\"int\"],\"doc\":\"Coding sequence position (one based, includes START and STOP codons).\",\"default\":null},{\"name\":\"codingSequenceLength\",\"type\":[\"null\",\"int\"],\"doc\":\"Coding sequence length in base pairs (one based, includes START and STOP codons).\",\"default\":null},{\"name\":\"referenceCodingSequence\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Coding sequence for the reference allele.\",\"default\":null},{\"name\":\"alternateCodingSequence\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Coding sequence of this alternate allele.\",\"default\":null},{\"name\":\"proteinPosition\",\"type\":[\"null\",\"int\"],\"doc\":\"Protein sequence position (one based, includes START but not STOP).\",\"default\":null},{\"name\":\"proteinLength\",\"type\":[\"null\",\"int\"],\"doc\":\"Protein sequence length in amino acids (one based, includes START but not STOP).\",\"default\":null},{\"name\":\"referenceProteinSequence\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Protein sequence for the reference allele.\",\"default\":null},{\"name\":\"alternateProteinSequence\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Protein sequence of this alternate allele.\",\"default\":null},{\"name\":\"distance\",\"type\":[\"null\",\"int\"],\"doc\":\"Distance in base pairs to the feature.\",\"default\":null},{\"name\":\"messages\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"enum\",\"name\":\"VariantAnnotationMessage\",\"doc\":\"An alternative reference sequence was used to calculate this annotation\\n   (e.g. cancer sample comparing somatic vs. germline). Message code I3.\",\"symbols\":[\"ERROR_CHROMOSOME_NOT_FOUND\",\"ERROR_OUT_OF_CHROMOSOME_RANGE\",\"WARNING_REF_DOES_NOT_MATCH_GENOME\",\"WARNING_SEQUENCE_NOT_AVAILABLE\",\"WARNING_TRANSCRIPT_INCOMPLETE\",\"WARNING_TRANSCRIPT_MULTIPLE_STOP_CODONS\",\"WARNING_TRANSCRIPT_NO_START_CODON\",\"INFO_REALIGN_3_PRIME\",\"INFO_COMPOUND_ANNOTATION\",\"INFO_NON_REFERENCE_ANNOTATION\"]}},\"doc\":\"Zero or more errors, warnings, or informative messages regarding variant annotation accuracy.\",\"default\":[]}]}");
    private static SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<TranscriptEffect> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<TranscriptEffect> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    @Deprecated
    public String alternateAllele;
    @Deprecated
    public List<String> effects;
    @Deprecated
    public Impact impact;
    @Deprecated
    public String geneName;
    @Deprecated
    public String geneId;
    @Deprecated
    public String featureType;
    @Deprecated
    public String featureId;
    @Deprecated
    public String biotype;
    @Deprecated
    public Strand strand;
    @Deprecated
    public Integer rank;
    @Deprecated
    public Integer total;
    @Deprecated
    public String genomicHgvs;
    @Deprecated
    public String transcriptHgvs;
    @Deprecated
    public String proteinHgvs;
    @Deprecated
    public Integer cdnaPosition;
    @Deprecated
    public Integer cdnaLength;
    @Deprecated
    public Integer codingSequencePosition;
    @Deprecated
    public Integer codingSequenceLength;
    @Deprecated
    public String referenceCodingSequence;
    @Deprecated
    public String alternateCodingSequence;
    @Deprecated
    public Integer proteinPosition;
    @Deprecated
    public Integer proteinLength;
    @Deprecated
    public String referenceProteinSequence;
    @Deprecated
    public String alternateProteinSequence;
    @Deprecated
    public Integer distance;
    @Deprecated
    public List<VariantAnnotationMessage> messages;
    private static final DatumWriter<TranscriptEffect> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<TranscriptEffect> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageDecoder<TranscriptEffect> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<TranscriptEffect> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static TranscriptEffect fromByteBuffer(ByteBuffer b) throws IOException {
        return (TranscriptEffect)((Object)DECODER.decode(b));
    }

    public TranscriptEffect() {
    }

    public TranscriptEffect(String alternateAllele, List<String> effects, Impact impact, String geneName, String geneId, String featureType, String featureId, String biotype, Strand strand, Integer rank, Integer total, String genomicHgvs, String transcriptHgvs, String proteinHgvs, Integer cdnaPosition, Integer cdnaLength, Integer codingSequencePosition, Integer codingSequenceLength, String referenceCodingSequence, String alternateCodingSequence, Integer proteinPosition, Integer proteinLength, String referenceProteinSequence, String alternateProteinSequence, Integer distance, List<VariantAnnotationMessage> messages) {
        this.alternateAllele = alternateAllele;
        this.effects = effects;
        this.impact = impact;
        this.geneName = geneName;
        this.geneId = geneId;
        this.featureType = featureType;
        this.featureId = featureId;
        this.biotype = biotype;
        this.strand = strand;
        this.rank = rank;
        this.total = total;
        this.genomicHgvs = genomicHgvs;
        this.transcriptHgvs = transcriptHgvs;
        this.proteinHgvs = proteinHgvs;
        this.cdnaPosition = cdnaPosition;
        this.cdnaLength = cdnaLength;
        this.codingSequencePosition = codingSequencePosition;
        this.codingSequenceLength = codingSequenceLength;
        this.referenceCodingSequence = referenceCodingSequence;
        this.alternateCodingSequence = alternateCodingSequence;
        this.proteinPosition = proteinPosition;
        this.proteinLength = proteinLength;
        this.referenceProteinSequence = referenceProteinSequence;
        this.alternateProteinSequence = alternateProteinSequence;
        this.distance = distance;
        this.messages = messages;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.alternateAllele;
            }
            case 1: {
                return this.effects;
            }
            case 2: {
                return this.impact;
            }
            case 3: {
                return this.geneName;
            }
            case 4: {
                return this.geneId;
            }
            case 5: {
                return this.featureType;
            }
            case 6: {
                return this.featureId;
            }
            case 7: {
                return this.biotype;
            }
            case 8: {
                return this.strand;
            }
            case 9: {
                return this.rank;
            }
            case 10: {
                return this.total;
            }
            case 11: {
                return this.genomicHgvs;
            }
            case 12: {
                return this.transcriptHgvs;
            }
            case 13: {
                return this.proteinHgvs;
            }
            case 14: {
                return this.cdnaPosition;
            }
            case 15: {
                return this.cdnaLength;
            }
            case 16: {
                return this.codingSequencePosition;
            }
            case 17: {
                return this.codingSequenceLength;
            }
            case 18: {
                return this.referenceCodingSequence;
            }
            case 19: {
                return this.alternateCodingSequence;
            }
            case 20: {
                return this.proteinPosition;
            }
            case 21: {
                return this.proteinLength;
            }
            case 22: {
                return this.referenceProteinSequence;
            }
            case 23: {
                return this.alternateProteinSequence;
            }
            case 24: {
                return this.distance;
            }
            case 25: {
                return this.messages;
            }
        }
        throw new AvroRuntimeException("Bad index");
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.alternateAllele = (String)value$;
                break;
            }
            case 1: {
                this.effects = (List)value$;
                break;
            }
            case 2: {
                this.impact = (Impact)((Object)value$);
                break;
            }
            case 3: {
                this.geneName = (String)value$;
                break;
            }
            case 4: {
                this.geneId = (String)value$;
                break;
            }
            case 5: {
                this.featureType = (String)value$;
                break;
            }
            case 6: {
                this.featureId = (String)value$;
                break;
            }
            case 7: {
                this.biotype = (String)value$;
                break;
            }
            case 8: {
                this.strand = (Strand)((Object)value$);
                break;
            }
            case 9: {
                this.rank = (Integer)value$;
                break;
            }
            case 10: {
                this.total = (Integer)value$;
                break;
            }
            case 11: {
                this.genomicHgvs = (String)value$;
                break;
            }
            case 12: {
                this.transcriptHgvs = (String)value$;
                break;
            }
            case 13: {
                this.proteinHgvs = (String)value$;
                break;
            }
            case 14: {
                this.cdnaPosition = (Integer)value$;
                break;
            }
            case 15: {
                this.cdnaLength = (Integer)value$;
                break;
            }
            case 16: {
                this.codingSequencePosition = (Integer)value$;
                break;
            }
            case 17: {
                this.codingSequenceLength = (Integer)value$;
                break;
            }
            case 18: {
                this.referenceCodingSequence = (String)value$;
                break;
            }
            case 19: {
                this.alternateCodingSequence = (String)value$;
                break;
            }
            case 20: {
                this.proteinPosition = (Integer)value$;
                break;
            }
            case 21: {
                this.proteinLength = (Integer)value$;
                break;
            }
            case 22: {
                this.referenceProteinSequence = (String)value$;
                break;
            }
            case 23: {
                this.alternateProteinSequence = (String)value$;
                break;
            }
            case 24: {
                this.distance = (Integer)value$;
                break;
            }
            case 25: {
                this.messages = (List)value$;
                break;
            }
            default: {
                throw new AvroRuntimeException("Bad index");
            }
        }
    }

    public String getAlternateAllele() {
        return this.alternateAllele;
    }

    public void setAlternateAllele(String value) {
        this.alternateAllele = value;
    }

    public List<String> getEffects() {
        return this.effects;
    }

    public void setEffects(List<String> value) {
        this.effects = value;
    }

    public Impact getImpact() {
        return this.impact;
    }

    public void setImpact(Impact value) {
        this.impact = value;
    }

    public String getGeneName() {
        return this.geneName;
    }

    public void setGeneName(String value) {
        this.geneName = value;
    }

    public String getGeneId() {
        return this.geneId;
    }

    public void setGeneId(String value) {
        this.geneId = value;
    }

    public String getFeatureType() {
        return this.featureType;
    }

    public void setFeatureType(String value) {
        this.featureType = value;
    }

    public String getFeatureId() {
        return this.featureId;
    }

    public void setFeatureId(String value) {
        this.featureId = value;
    }

    public String getBiotype() {
        return this.biotype;
    }

    public void setBiotype(String value) {
        this.biotype = value;
    }

    public Strand getStrand() {
        return this.strand;
    }

    public void setStrand(Strand value) {
        this.strand = value;
    }

    public Integer getRank() {
        return this.rank;
    }

    public void setRank(Integer value) {
        this.rank = value;
    }

    public Integer getTotal() {
        return this.total;
    }

    public void setTotal(Integer value) {
        this.total = value;
    }

    public String getGenomicHgvs() {
        return this.genomicHgvs;
    }

    public void setGenomicHgvs(String value) {
        this.genomicHgvs = value;
    }

    public String getTranscriptHgvs() {
        return this.transcriptHgvs;
    }

    public void setTranscriptHgvs(String value) {
        this.transcriptHgvs = value;
    }

    public String getProteinHgvs() {
        return this.proteinHgvs;
    }

    public void setProteinHgvs(String value) {
        this.proteinHgvs = value;
    }

    public Integer getCdnaPosition() {
        return this.cdnaPosition;
    }

    public void setCdnaPosition(Integer value) {
        this.cdnaPosition = value;
    }

    public Integer getCdnaLength() {
        return this.cdnaLength;
    }

    public void setCdnaLength(Integer value) {
        this.cdnaLength = value;
    }

    public Integer getCodingSequencePosition() {
        return this.codingSequencePosition;
    }

    public void setCodingSequencePosition(Integer value) {
        this.codingSequencePosition = value;
    }

    public Integer getCodingSequenceLength() {
        return this.codingSequenceLength;
    }

    public void setCodingSequenceLength(Integer value) {
        this.codingSequenceLength = value;
    }

    public String getReferenceCodingSequence() {
        return this.referenceCodingSequence;
    }

    public void setReferenceCodingSequence(String value) {
        this.referenceCodingSequence = value;
    }

    public String getAlternateCodingSequence() {
        return this.alternateCodingSequence;
    }

    public void setAlternateCodingSequence(String value) {
        this.alternateCodingSequence = value;
    }

    public Integer getProteinPosition() {
        return this.proteinPosition;
    }

    public void setProteinPosition(Integer value) {
        this.proteinPosition = value;
    }

    public Integer getProteinLength() {
        return this.proteinLength;
    }

    public void setProteinLength(Integer value) {
        this.proteinLength = value;
    }

    public String getReferenceProteinSequence() {
        return this.referenceProteinSequence;
    }

    public void setReferenceProteinSequence(String value) {
        this.referenceProteinSequence = value;
    }

    public String getAlternateProteinSequence() {
        return this.alternateProteinSequence;
    }

    public void setAlternateProteinSequence(String value) {
        this.alternateProteinSequence = value;
    }

    public Integer getDistance() {
        return this.distance;
    }

    public void setDistance(Integer value) {
        this.distance = value;
    }

    public List<VariantAnnotationMessage> getMessages() {
        return this.messages;
    }

    public void setMessages(List<VariantAnnotationMessage> value) {
        this.messages = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        return new Builder(other);
    }

    public static Builder newBuilder(TranscriptEffect other) {
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    public static class Builder
    extends SpecificRecordBuilderBase<TranscriptEffect>
    implements RecordBuilder<TranscriptEffect> {
        private String alternateAllele;
        private List<String> effects;
        private Impact impact;
        private String geneName;
        private String geneId;
        private String featureType;
        private String featureId;
        private String biotype;
        private Strand strand;
        private Integer rank;
        private Integer total;
        private String genomicHgvs;
        private String transcriptHgvs;
        private String proteinHgvs;
        private Integer cdnaPosition;
        private Integer cdnaLength;
        private Integer codingSequencePosition;
        private Integer codingSequenceLength;
        private String referenceCodingSequence;
        private String alternateCodingSequence;
        private Integer proteinPosition;
        private Integer proteinLength;
        private String referenceProteinSequence;
        private String alternateProteinSequence;
        private Integer distance;
        private List<VariantAnnotationMessage> messages;

        private Builder() {
            super(SCHEMA$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.alternateAllele)) {
                this.alternateAllele = (String)this.data().deepCopy(this.fields()[0].schema(), (Object)other.alternateAllele);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], other.effects)) {
                this.effects = (List)this.data().deepCopy(this.fields()[1].schema(), other.effects);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)((Object)other.impact))) {
                this.impact = (Impact)((Object)this.data().deepCopy(this.fields()[2].schema(), (Object)other.impact));
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.geneName)) {
                this.geneName = (String)this.data().deepCopy(this.fields()[3].schema(), (Object)other.geneName);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.geneId)) {
                this.geneId = (String)this.data().deepCopy(this.fields()[4].schema(), (Object)other.geneId);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.featureType)) {
                this.featureType = (String)this.data().deepCopy(this.fields()[5].schema(), (Object)other.featureType);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.featureId)) {
                this.featureId = (String)this.data().deepCopy(this.fields()[6].schema(), (Object)other.featureId);
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.biotype)) {
                this.biotype = (String)this.data().deepCopy(this.fields()[7].schema(), (Object)other.biotype);
                this.fieldSetFlags()[7] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)((Object)other.strand))) {
                this.strand = (Strand)((Object)this.data().deepCopy(this.fields()[8].schema(), (Object)other.strand));
                this.fieldSetFlags()[8] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.rank)) {
                this.rank = (Integer)this.data().deepCopy(this.fields()[9].schema(), (Object)other.rank);
                this.fieldSetFlags()[9] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)other.total)) {
                this.total = (Integer)this.data().deepCopy(this.fields()[10].schema(), (Object)other.total);
                this.fieldSetFlags()[10] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)other.genomicHgvs)) {
                this.genomicHgvs = (String)this.data().deepCopy(this.fields()[11].schema(), (Object)other.genomicHgvs);
                this.fieldSetFlags()[11] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[12], (Object)other.transcriptHgvs)) {
                this.transcriptHgvs = (String)this.data().deepCopy(this.fields()[12].schema(), (Object)other.transcriptHgvs);
                this.fieldSetFlags()[12] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[13], (Object)other.proteinHgvs)) {
                this.proteinHgvs = (String)this.data().deepCopy(this.fields()[13].schema(), (Object)other.proteinHgvs);
                this.fieldSetFlags()[13] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[14], (Object)other.cdnaPosition)) {
                this.cdnaPosition = (Integer)this.data().deepCopy(this.fields()[14].schema(), (Object)other.cdnaPosition);
                this.fieldSetFlags()[14] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[15], (Object)other.cdnaLength)) {
                this.cdnaLength = (Integer)this.data().deepCopy(this.fields()[15].schema(), (Object)other.cdnaLength);
                this.fieldSetFlags()[15] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[16], (Object)other.codingSequencePosition)) {
                this.codingSequencePosition = (Integer)this.data().deepCopy(this.fields()[16].schema(), (Object)other.codingSequencePosition);
                this.fieldSetFlags()[16] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[17], (Object)other.codingSequenceLength)) {
                this.codingSequenceLength = (Integer)this.data().deepCopy(this.fields()[17].schema(), (Object)other.codingSequenceLength);
                this.fieldSetFlags()[17] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[18], (Object)other.referenceCodingSequence)) {
                this.referenceCodingSequence = (String)this.data().deepCopy(this.fields()[18].schema(), (Object)other.referenceCodingSequence);
                this.fieldSetFlags()[18] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[19], (Object)other.alternateCodingSequence)) {
                this.alternateCodingSequence = (String)this.data().deepCopy(this.fields()[19].schema(), (Object)other.alternateCodingSequence);
                this.fieldSetFlags()[19] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[20], (Object)other.proteinPosition)) {
                this.proteinPosition = (Integer)this.data().deepCopy(this.fields()[20].schema(), (Object)other.proteinPosition);
                this.fieldSetFlags()[20] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[21], (Object)other.proteinLength)) {
                this.proteinLength = (Integer)this.data().deepCopy(this.fields()[21].schema(), (Object)other.proteinLength);
                this.fieldSetFlags()[21] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[22], (Object)other.referenceProteinSequence)) {
                this.referenceProteinSequence = (String)this.data().deepCopy(this.fields()[22].schema(), (Object)other.referenceProteinSequence);
                this.fieldSetFlags()[22] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[23], (Object)other.alternateProteinSequence)) {
                this.alternateProteinSequence = (String)this.data().deepCopy(this.fields()[23].schema(), (Object)other.alternateProteinSequence);
                this.fieldSetFlags()[23] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[24], (Object)other.distance)) {
                this.distance = (Integer)this.data().deepCopy(this.fields()[24].schema(), (Object)other.distance);
                this.fieldSetFlags()[24] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[25], other.messages)) {
                this.messages = (List)this.data().deepCopy(this.fields()[25].schema(), other.messages);
                this.fieldSetFlags()[25] = true;
            }
        }

        private Builder(TranscriptEffect other) {
            super(SCHEMA$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.alternateAllele)) {
                this.alternateAllele = (String)this.data().deepCopy(this.fields()[0].schema(), (Object)other.alternateAllele);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], other.effects)) {
                this.effects = (List)this.data().deepCopy(this.fields()[1].schema(), other.effects);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)((Object)other.impact))) {
                this.impact = (Impact)((Object)this.data().deepCopy(this.fields()[2].schema(), (Object)other.impact));
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.geneName)) {
                this.geneName = (String)this.data().deepCopy(this.fields()[3].schema(), (Object)other.geneName);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.geneId)) {
                this.geneId = (String)this.data().deepCopy(this.fields()[4].schema(), (Object)other.geneId);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.featureType)) {
                this.featureType = (String)this.data().deepCopy(this.fields()[5].schema(), (Object)other.featureType);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.featureId)) {
                this.featureId = (String)this.data().deepCopy(this.fields()[6].schema(), (Object)other.featureId);
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.biotype)) {
                this.biotype = (String)this.data().deepCopy(this.fields()[7].schema(), (Object)other.biotype);
                this.fieldSetFlags()[7] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)((Object)other.strand))) {
                this.strand = (Strand)((Object)this.data().deepCopy(this.fields()[8].schema(), (Object)other.strand));
                this.fieldSetFlags()[8] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.rank)) {
                this.rank = (Integer)this.data().deepCopy(this.fields()[9].schema(), (Object)other.rank);
                this.fieldSetFlags()[9] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)other.total)) {
                this.total = (Integer)this.data().deepCopy(this.fields()[10].schema(), (Object)other.total);
                this.fieldSetFlags()[10] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)other.genomicHgvs)) {
                this.genomicHgvs = (String)this.data().deepCopy(this.fields()[11].schema(), (Object)other.genomicHgvs);
                this.fieldSetFlags()[11] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[12], (Object)other.transcriptHgvs)) {
                this.transcriptHgvs = (String)this.data().deepCopy(this.fields()[12].schema(), (Object)other.transcriptHgvs);
                this.fieldSetFlags()[12] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[13], (Object)other.proteinHgvs)) {
                this.proteinHgvs = (String)this.data().deepCopy(this.fields()[13].schema(), (Object)other.proteinHgvs);
                this.fieldSetFlags()[13] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[14], (Object)other.cdnaPosition)) {
                this.cdnaPosition = (Integer)this.data().deepCopy(this.fields()[14].schema(), (Object)other.cdnaPosition);
                this.fieldSetFlags()[14] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[15], (Object)other.cdnaLength)) {
                this.cdnaLength = (Integer)this.data().deepCopy(this.fields()[15].schema(), (Object)other.cdnaLength);
                this.fieldSetFlags()[15] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[16], (Object)other.codingSequencePosition)) {
                this.codingSequencePosition = (Integer)this.data().deepCopy(this.fields()[16].schema(), (Object)other.codingSequencePosition);
                this.fieldSetFlags()[16] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[17], (Object)other.codingSequenceLength)) {
                this.codingSequenceLength = (Integer)this.data().deepCopy(this.fields()[17].schema(), (Object)other.codingSequenceLength);
                this.fieldSetFlags()[17] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[18], (Object)other.referenceCodingSequence)) {
                this.referenceCodingSequence = (String)this.data().deepCopy(this.fields()[18].schema(), (Object)other.referenceCodingSequence);
                this.fieldSetFlags()[18] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[19], (Object)other.alternateCodingSequence)) {
                this.alternateCodingSequence = (String)this.data().deepCopy(this.fields()[19].schema(), (Object)other.alternateCodingSequence);
                this.fieldSetFlags()[19] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[20], (Object)other.proteinPosition)) {
                this.proteinPosition = (Integer)this.data().deepCopy(this.fields()[20].schema(), (Object)other.proteinPosition);
                this.fieldSetFlags()[20] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[21], (Object)other.proteinLength)) {
                this.proteinLength = (Integer)this.data().deepCopy(this.fields()[21].schema(), (Object)other.proteinLength);
                this.fieldSetFlags()[21] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[22], (Object)other.referenceProteinSequence)) {
                this.referenceProteinSequence = (String)this.data().deepCopy(this.fields()[22].schema(), (Object)other.referenceProteinSequence);
                this.fieldSetFlags()[22] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[23], (Object)other.alternateProteinSequence)) {
                this.alternateProteinSequence = (String)this.data().deepCopy(this.fields()[23].schema(), (Object)other.alternateProteinSequence);
                this.fieldSetFlags()[23] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[24], (Object)other.distance)) {
                this.distance = (Integer)this.data().deepCopy(this.fields()[24].schema(), (Object)other.distance);
                this.fieldSetFlags()[24] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[25], other.messages)) {
                this.messages = (List)this.data().deepCopy(this.fields()[25].schema(), other.messages);
                this.fieldSetFlags()[25] = true;
            }
        }

        public String getAlternateAllele() {
            return this.alternateAllele;
        }

        public Builder setAlternateAllele(String value) {
            this.validate(this.fields()[0], value);
            this.alternateAllele = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasAlternateAllele() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearAlternateAllele() {
            this.alternateAllele = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public List<String> getEffects() {
            return this.effects;
        }

        public Builder setEffects(List<String> value) {
            this.validate(this.fields()[1], value);
            this.effects = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasEffects() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearEffects() {
            this.effects = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public Impact getImpact() {
            return this.impact;
        }

        public Builder setImpact(Impact value) {
            this.validate(this.fields()[2], (Object)value);
            this.impact = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasImpact() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearImpact() {
            this.impact = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public String getGeneName() {
            return this.geneName;
        }

        public Builder setGeneName(String value) {
            this.validate(this.fields()[3], value);
            this.geneName = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasGeneName() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearGeneName() {
            this.geneName = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public String getGeneId() {
            return this.geneId;
        }

        public Builder setGeneId(String value) {
            this.validate(this.fields()[4], value);
            this.geneId = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasGeneId() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearGeneId() {
            this.geneId = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public String getFeatureType() {
            return this.featureType;
        }

        public Builder setFeatureType(String value) {
            this.validate(this.fields()[5], value);
            this.featureType = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasFeatureType() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearFeatureType() {
            this.featureType = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public String getFeatureId() {
            return this.featureId;
        }

        public Builder setFeatureId(String value) {
            this.validate(this.fields()[6], value);
            this.featureId = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasFeatureId() {
            return this.fieldSetFlags()[6];
        }

        public Builder clearFeatureId() {
            this.featureId = null;
            this.fieldSetFlags()[6] = false;
            return this;
        }

        public String getBiotype() {
            return this.biotype;
        }

        public Builder setBiotype(String value) {
            this.validate(this.fields()[7], value);
            this.biotype = value;
            this.fieldSetFlags()[7] = true;
            return this;
        }

        public boolean hasBiotype() {
            return this.fieldSetFlags()[7];
        }

        public Builder clearBiotype() {
            this.biotype = null;
            this.fieldSetFlags()[7] = false;
            return this;
        }

        public Strand getStrand() {
            return this.strand;
        }

        public Builder setStrand(Strand value) {
            this.validate(this.fields()[8], (Object)value);
            this.strand = value;
            this.fieldSetFlags()[8] = true;
            return this;
        }

        public boolean hasStrand() {
            return this.fieldSetFlags()[8];
        }

        public Builder clearStrand() {
            this.strand = null;
            this.fieldSetFlags()[8] = false;
            return this;
        }

        public Integer getRank() {
            return this.rank;
        }

        public Builder setRank(Integer value) {
            this.validate(this.fields()[9], value);
            this.rank = value;
            this.fieldSetFlags()[9] = true;
            return this;
        }

        public boolean hasRank() {
            return this.fieldSetFlags()[9];
        }

        public Builder clearRank() {
            this.rank = null;
            this.fieldSetFlags()[9] = false;
            return this;
        }

        public Integer getTotal() {
            return this.total;
        }

        public Builder setTotal(Integer value) {
            this.validate(this.fields()[10], value);
            this.total = value;
            this.fieldSetFlags()[10] = true;
            return this;
        }

        public boolean hasTotal() {
            return this.fieldSetFlags()[10];
        }

        public Builder clearTotal() {
            this.total = null;
            this.fieldSetFlags()[10] = false;
            return this;
        }

        public String getGenomicHgvs() {
            return this.genomicHgvs;
        }

        public Builder setGenomicHgvs(String value) {
            this.validate(this.fields()[11], value);
            this.genomicHgvs = value;
            this.fieldSetFlags()[11] = true;
            return this;
        }

        public boolean hasGenomicHgvs() {
            return this.fieldSetFlags()[11];
        }

        public Builder clearGenomicHgvs() {
            this.genomicHgvs = null;
            this.fieldSetFlags()[11] = false;
            return this;
        }

        public String getTranscriptHgvs() {
            return this.transcriptHgvs;
        }

        public Builder setTranscriptHgvs(String value) {
            this.validate(this.fields()[12], value);
            this.transcriptHgvs = value;
            this.fieldSetFlags()[12] = true;
            return this;
        }

        public boolean hasTranscriptHgvs() {
            return this.fieldSetFlags()[12];
        }

        public Builder clearTranscriptHgvs() {
            this.transcriptHgvs = null;
            this.fieldSetFlags()[12] = false;
            return this;
        }

        public String getProteinHgvs() {
            return this.proteinHgvs;
        }

        public Builder setProteinHgvs(String value) {
            this.validate(this.fields()[13], value);
            this.proteinHgvs = value;
            this.fieldSetFlags()[13] = true;
            return this;
        }

        public boolean hasProteinHgvs() {
            return this.fieldSetFlags()[13];
        }

        public Builder clearProteinHgvs() {
            this.proteinHgvs = null;
            this.fieldSetFlags()[13] = false;
            return this;
        }

        public Integer getCdnaPosition() {
            return this.cdnaPosition;
        }

        public Builder setCdnaPosition(Integer value) {
            this.validate(this.fields()[14], value);
            this.cdnaPosition = value;
            this.fieldSetFlags()[14] = true;
            return this;
        }

        public boolean hasCdnaPosition() {
            return this.fieldSetFlags()[14];
        }

        public Builder clearCdnaPosition() {
            this.cdnaPosition = null;
            this.fieldSetFlags()[14] = false;
            return this;
        }

        public Integer getCdnaLength() {
            return this.cdnaLength;
        }

        public Builder setCdnaLength(Integer value) {
            this.validate(this.fields()[15], value);
            this.cdnaLength = value;
            this.fieldSetFlags()[15] = true;
            return this;
        }

        public boolean hasCdnaLength() {
            return this.fieldSetFlags()[15];
        }

        public Builder clearCdnaLength() {
            this.cdnaLength = null;
            this.fieldSetFlags()[15] = false;
            return this;
        }

        public Integer getCodingSequencePosition() {
            return this.codingSequencePosition;
        }

        public Builder setCodingSequencePosition(Integer value) {
            this.validate(this.fields()[16], value);
            this.codingSequencePosition = value;
            this.fieldSetFlags()[16] = true;
            return this;
        }

        public boolean hasCodingSequencePosition() {
            return this.fieldSetFlags()[16];
        }

        public Builder clearCodingSequencePosition() {
            this.codingSequencePosition = null;
            this.fieldSetFlags()[16] = false;
            return this;
        }

        public Integer getCodingSequenceLength() {
            return this.codingSequenceLength;
        }

        public Builder setCodingSequenceLength(Integer value) {
            this.validate(this.fields()[17], value);
            this.codingSequenceLength = value;
            this.fieldSetFlags()[17] = true;
            return this;
        }

        public boolean hasCodingSequenceLength() {
            return this.fieldSetFlags()[17];
        }

        public Builder clearCodingSequenceLength() {
            this.codingSequenceLength = null;
            this.fieldSetFlags()[17] = false;
            return this;
        }

        public String getReferenceCodingSequence() {
            return this.referenceCodingSequence;
        }

        public Builder setReferenceCodingSequence(String value) {
            this.validate(this.fields()[18], value);
            this.referenceCodingSequence = value;
            this.fieldSetFlags()[18] = true;
            return this;
        }

        public boolean hasReferenceCodingSequence() {
            return this.fieldSetFlags()[18];
        }

        public Builder clearReferenceCodingSequence() {
            this.referenceCodingSequence = null;
            this.fieldSetFlags()[18] = false;
            return this;
        }

        public String getAlternateCodingSequence() {
            return this.alternateCodingSequence;
        }

        public Builder setAlternateCodingSequence(String value) {
            this.validate(this.fields()[19], value);
            this.alternateCodingSequence = value;
            this.fieldSetFlags()[19] = true;
            return this;
        }

        public boolean hasAlternateCodingSequence() {
            return this.fieldSetFlags()[19];
        }

        public Builder clearAlternateCodingSequence() {
            this.alternateCodingSequence = null;
            this.fieldSetFlags()[19] = false;
            return this;
        }

        public Integer getProteinPosition() {
            return this.proteinPosition;
        }

        public Builder setProteinPosition(Integer value) {
            this.validate(this.fields()[20], value);
            this.proteinPosition = value;
            this.fieldSetFlags()[20] = true;
            return this;
        }

        public boolean hasProteinPosition() {
            return this.fieldSetFlags()[20];
        }

        public Builder clearProteinPosition() {
            this.proteinPosition = null;
            this.fieldSetFlags()[20] = false;
            return this;
        }

        public Integer getProteinLength() {
            return this.proteinLength;
        }

        public Builder setProteinLength(Integer value) {
            this.validate(this.fields()[21], value);
            this.proteinLength = value;
            this.fieldSetFlags()[21] = true;
            return this;
        }

        public boolean hasProteinLength() {
            return this.fieldSetFlags()[21];
        }

        public Builder clearProteinLength() {
            this.proteinLength = null;
            this.fieldSetFlags()[21] = false;
            return this;
        }

        public String getReferenceProteinSequence() {
            return this.referenceProteinSequence;
        }

        public Builder setReferenceProteinSequence(String value) {
            this.validate(this.fields()[22], value);
            this.referenceProteinSequence = value;
            this.fieldSetFlags()[22] = true;
            return this;
        }

        public boolean hasReferenceProteinSequence() {
            return this.fieldSetFlags()[22];
        }

        public Builder clearReferenceProteinSequence() {
            this.referenceProteinSequence = null;
            this.fieldSetFlags()[22] = false;
            return this;
        }

        public String getAlternateProteinSequence() {
            return this.alternateProteinSequence;
        }

        public Builder setAlternateProteinSequence(String value) {
            this.validate(this.fields()[23], value);
            this.alternateProteinSequence = value;
            this.fieldSetFlags()[23] = true;
            return this;
        }

        public boolean hasAlternateProteinSequence() {
            return this.fieldSetFlags()[23];
        }

        public Builder clearAlternateProteinSequence() {
            this.alternateProteinSequence = null;
            this.fieldSetFlags()[23] = false;
            return this;
        }

        public Integer getDistance() {
            return this.distance;
        }

        public Builder setDistance(Integer value) {
            this.validate(this.fields()[24], value);
            this.distance = value;
            this.fieldSetFlags()[24] = true;
            return this;
        }

        public boolean hasDistance() {
            return this.fieldSetFlags()[24];
        }

        public Builder clearDistance() {
            this.distance = null;
            this.fieldSetFlags()[24] = false;
            return this;
        }

        public List<VariantAnnotationMessage> getMessages() {
            return this.messages;
        }

        public Builder setMessages(List<VariantAnnotationMessage> value) {
            this.validate(this.fields()[25], value);
            this.messages = value;
            this.fieldSetFlags()[25] = true;
            return this;
        }

        public boolean hasMessages() {
            return this.fieldSetFlags()[25];
        }

        public Builder clearMessages() {
            this.messages = null;
            this.fieldSetFlags()[25] = false;
            return this;
        }

        public TranscriptEffect build() {
            try {
                TranscriptEffect record = new TranscriptEffect();
                record.alternateAllele = this.fieldSetFlags()[0] ? this.alternateAllele : (String)this.defaultValue(this.fields()[0]);
                record.effects = this.fieldSetFlags()[1] ? this.effects : (List)this.defaultValue(this.fields()[1]);
                record.impact = this.fieldSetFlags()[2] ? this.impact : (Impact)((Object)this.defaultValue(this.fields()[2]));
                record.geneName = this.fieldSetFlags()[3] ? this.geneName : (String)this.defaultValue(this.fields()[3]);
                record.geneId = this.fieldSetFlags()[4] ? this.geneId : (String)this.defaultValue(this.fields()[4]);
                record.featureType = this.fieldSetFlags()[5] ? this.featureType : (String)this.defaultValue(this.fields()[5]);
                record.featureId = this.fieldSetFlags()[6] ? this.featureId : (String)this.defaultValue(this.fields()[6]);
                record.biotype = this.fieldSetFlags()[7] ? this.biotype : (String)this.defaultValue(this.fields()[7]);
                record.strand = this.fieldSetFlags()[8] ? this.strand : (Strand)((Object)this.defaultValue(this.fields()[8]));
                record.rank = this.fieldSetFlags()[9] ? this.rank : (Integer)this.defaultValue(this.fields()[9]);
                record.total = this.fieldSetFlags()[10] ? this.total : (Integer)this.defaultValue(this.fields()[10]);
                record.genomicHgvs = this.fieldSetFlags()[11] ? this.genomicHgvs : (String)this.defaultValue(this.fields()[11]);
                record.transcriptHgvs = this.fieldSetFlags()[12] ? this.transcriptHgvs : (String)this.defaultValue(this.fields()[12]);
                record.proteinHgvs = this.fieldSetFlags()[13] ? this.proteinHgvs : (String)this.defaultValue(this.fields()[13]);
                record.cdnaPosition = this.fieldSetFlags()[14] ? this.cdnaPosition : (Integer)this.defaultValue(this.fields()[14]);
                record.cdnaLength = this.fieldSetFlags()[15] ? this.cdnaLength : (Integer)this.defaultValue(this.fields()[15]);
                record.codingSequencePosition = this.fieldSetFlags()[16] ? this.codingSequencePosition : (Integer)this.defaultValue(this.fields()[16]);
                record.codingSequenceLength = this.fieldSetFlags()[17] ? this.codingSequenceLength : (Integer)this.defaultValue(this.fields()[17]);
                record.referenceCodingSequence = this.fieldSetFlags()[18] ? this.referenceCodingSequence : (String)this.defaultValue(this.fields()[18]);
                record.alternateCodingSequence = this.fieldSetFlags()[19] ? this.alternateCodingSequence : (String)this.defaultValue(this.fields()[19]);
                record.proteinPosition = this.fieldSetFlags()[20] ? this.proteinPosition : (Integer)this.defaultValue(this.fields()[20]);
                record.proteinLength = this.fieldSetFlags()[21] ? this.proteinLength : (Integer)this.defaultValue(this.fields()[21]);
                record.referenceProteinSequence = this.fieldSetFlags()[22] ? this.referenceProteinSequence : (String)this.defaultValue(this.fields()[22]);
                record.alternateProteinSequence = this.fieldSetFlags()[23] ? this.alternateProteinSequence : (String)this.defaultValue(this.fields()[23]);
                record.distance = this.fieldSetFlags()[24] ? this.distance : (Integer)this.defaultValue(this.fields()[24]);
                record.messages = this.fieldSetFlags()[25] ? this.messages : (List)this.defaultValue(this.fields()[25]);
                return record;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

