/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.formats.avro;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.bdgenomics.formats.avro.VariantAnnotation;

@AvroGenerated
public class Variant
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -1311831129837968037L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"Variant\",\"namespace\":\"org.bdgenomics.formats.avro\",\"doc\":\"Variant.\",\"fields\":[{\"name\":\"referenceName\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The reference this variant exists on. VCF column 1 \\\"CONTIG\\\".\",\"default\":null},{\"name\":\"start\",\"type\":[\"null\",\"long\"],\"doc\":\"The zero-based start position of this variant on the reference.\\n   VCF column 2 \\\"POS\\\" converted to zero-based coordinate system, closed-open intervals.\",\"default\":null},{\"name\":\"end\",\"type\":[\"null\",\"long\"],\"doc\":\"The zero-based, exclusive end position of this variant on the reference.\\n   Calculated by start + referenceAllele.length().\",\"default\":null},{\"name\":\"names\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},\"doc\":\"Zero or more unique names or identifiers for this variant. If this is a dbSNP\\n   variant it is encouraged to use the rs number(s). VCF column 3 \\\"ID\\\" shared across\\n   all alleles in the same VCF record.\",\"default\":[]},{\"name\":\"splitFromMultiAllelic\",\"type\":[\"boolean\",\"null\"],\"doc\":\"We split multi-allelic VCF lines into multiple single-alternate records.\\n   This bit is set if that happened for this record.\",\"default\":false},{\"name\":\"referenceAllele\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"A string describing the reference allele at this site. VCF column 4 \\\"REF\\\".\",\"default\":null},{\"name\":\"alternateAllele\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"A string describing the alternate allele at this site. VCF column 5 \\\"ALT\\\" split\\n   for multi-allelic sites.\",\"default\":null},{\"name\":\"quality\",\"type\":[\"null\",\"double\"],\"doc\":\"The Phred scaled probability that this allele is variant. VCF column 6 \\\"QUAL\\\".\\n   If this record is multi-allelic, this value may be incorrect.\",\"default\":null},{\"name\":\"filtersApplied\",\"type\":[\"null\",\"boolean\"],\"doc\":\"True if filters were applied for this variant. VCF column 7 \\\"FILTER\\\" any value other\\n   than the missing value.\",\"default\":null},{\"name\":\"filtersPassed\",\"type\":[\"null\",\"boolean\"],\"doc\":\"True if all filters for this variant passed. VCF column 7 \\\"FILTER\\\" value PASS.\",\"default\":null},{\"name\":\"filtersFailed\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},\"doc\":\"Zero or more filters that failed for this variant. VCF column 7 \\\"FILTER\\\" shared across\\n   all alleles in the same VCF record.\",\"default\":[]},{\"name\":\"annotation\",\"type\":[\"null\",{\"type\":\"record\",\"name\":\"VariantAnnotation\",\"doc\":\"Variant annotation.\",\"fields\":[{\"name\":\"ancestralAllele\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Ancestral allele, VCF INFO reserved key AA, Number=1, shared across all alternate\\n   alleles in the same VCF record.\",\"default\":null},{\"name\":\"alleleCount\",\"type\":[\"null\",\"int\"],\"doc\":\"Allele count, VCF INFO reserved key AC, Number=A, split for multi-allelic sites into\\n   a single integer value.\",\"default\":null},{\"name\":\"readDepth\",\"type\":[\"null\",\"int\"],\"doc\":\"Total read depth, VCF INFO reserved key AD, Number=R, split for multi-allelic\\n   sites into single integer values for the reference allele (referenceReadDepth) and\\n   the alternate allele (readDepth, this field).\",\"default\":null},{\"name\":\"forwardReadDepth\",\"type\":[\"null\",\"int\"],\"doc\":\"Forward strand read depth, VCF INFO reserved key ADF, Number=R, split for\\n   multi-allelic sites into single integer values for the reference allele\\n   (referenceForwardReadDepth) and the alternate allele (forwardReadDepth, this field).\",\"default\":null},{\"name\":\"reverseReadDepth\",\"type\":[\"null\",\"int\"],\"doc\":\"Reverse strand read depth, VCF INFO reserved key ADR, Number=R, split for\\n   multi-allelic sites into single integer values for the reference allele\\n   (referenceReverseReadDepth) and the alternate allele (reverseReadDepth, this field).\",\"default\":null},{\"name\":\"referenceReadDepth\",\"type\":[\"null\",\"int\"],\"doc\":\"Total read depth, VCF INFO reserved key AD, Number=R, split for multi-allelic\\n   sites into single integer values for the reference allele (referenceReadDepth, this field)\\n   and the alternate allele (readDepth).\",\"default\":null},{\"name\":\"referenceForwardReadDepth\",\"type\":[\"null\",\"int\"],\"doc\":\"Forward strand read depth, VCF INFO reserved key ADF, Number=R, split for\\n   multi-allelic sites into single integer values for the reference allele\\n   (referenceForwardReadDepth, this field) and the alternate allele (forwardReadDepth).\",\"default\":null},{\"name\":\"referenceReverseReadDepth\",\"type\":[\"null\",\"int\"],\"doc\":\"Reverse strand read depth, VCF INFO reserved key ADR, Number=R, split for\\n   multi-allelic sites into single integer values for the reference allele\\n   (referenceReverseReadDepth, this field) and the alternate allele (reverseReadDepth).\",\"default\":null},{\"name\":\"alleleFrequency\",\"type\":[\"null\",\"float\"],\"doc\":\"Minor allele frequency, VCF INFO reserved key AF, Number=A, split for multi-allelic\\n   sites into a single float value. Use this when frequencies are estimated from primary\\n   data, not calculated from called genotypes.\",\"default\":null},{\"name\":\"cigar\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"CIGAR string describing how to align an alternate allele to the reference\\n   allele, VCF INFO reserved key CIGAR, Number=A, split for multi-allelic sites into\\n   a single string value.\",\"default\":null},{\"name\":\"dbSnp\",\"type\":[\"null\",\"boolean\"],\"doc\":\"Membership in dbSNP, VCF INFO reserved key DB, Number=0. Until Number=A and\\n   Number=R flags are supported by the VCF specification, this value is shared\\n   across all alternate alleles in the same VCF record.\",\"default\":null},{\"name\":\"hapMap2\",\"type\":[\"null\",\"boolean\"],\"doc\":\"Membership in HapMap2, VCF INFO reserved key H2, Number=0. Until Number=A and\\n   Number=R flags are supported by the VCF specification, this value is shared\\n   across all alternate alleles in the same VCF record.\",\"default\":null},{\"name\":\"hapMap3\",\"type\":[\"null\",\"boolean\"],\"doc\":\"Membership in HapMap3, VCF INFO reserved key H3, Number=0. Until Number=A and\\n   Number=R flags are supported by the VCF specification, this value is shared\\n   across all alternate alleles in the same VCF record.\",\"default\":null},{\"name\":\"validated\",\"type\":[\"null\",\"boolean\"],\"doc\":\"Validated by follow up experiment, VCF INFO reserved key VALIDATED, Number=0.\\n   Until Number=A and Number=R flags are supported by the VCF specification, this\\n   value is shared across all alternate alleles in the same VCF record.\",\"default\":null},{\"name\":\"thousandGenomes\",\"type\":[\"null\",\"boolean\"],\"doc\":\"Membership in 1000 Genomes, VCF INFO reserved key 1000G, Number=0. Until\\n   Number=A and Number=R flags are supported by the VCF specification, this\\n   value is shared across all alternate alleles in the same VCF record.\",\"default\":null},{\"name\":\"somatic\",\"type\":[\"boolean\",\"null\"],\"doc\":\"True if this variant call is somatic; in this case, the reference allele will\\n   have been observed in another sample. VCF INFO reserved key \\\"SOMATIC\\\", Number=0.\\n   Until Number=A and Number=R flags are supported by the VCF specification, this value\\n   is shared across all alleles in the same VCF record.\",\"default\":false},{\"name\":\"transcriptEffects\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"record\",\"name\":\"TranscriptEffect\",\"doc\":\"Annotation of a variant in the context of a feature, typically a transcript.\",\"fields\":[{\"name\":\"alternateAllele\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Alternate allele for this variant annotation.\",\"default\":null},{\"name\":\"effects\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},\"doc\":\"One or more annotations (also referred to as effects or consequences) of the\\n   variant in the context of the feature identified by featureId. Must be\\n   Sequence Ontology (SO, see http://www.sequenceontology.org) term names, e.g.\\n   stop_gained, missense_variant, synonymous_variant, upstream_gene_variant.\",\"default\":[]},{\"name\":\"impact\",\"type\":[\"null\",{\"type\":\"enum\",\"name\":\"Impact\",\"doc\":\"Modifier impact.\",\"symbols\":[\"HIGH\",\"MODERATE\",\"LOW\",\"MODIFIER\"]}],\"doc\":\"Putative impact of the annotation; a simple estim", new String[]{"ation of putative impact/\\n   deleteriousness.\",\"default\":null},{\"name\":\"geneName\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Common gene name (HGNC), e.g. BRCA2. May be closest gene if annotation\\n   is intergenic.\",\"default\":null},{\"name\":\"geneId\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Gene identifier, e.g. Ensembl Gene identifier, ENSG00000139618. May be\\n   closest gene if annotation is intergenic.\",\"default\":null},{\"name\":\"featureType\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Feature type, may use Sequence Ontology term names. Typically transcript.\",\"default\":null},{\"name\":\"featureId\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Feature identifier, e.g. Ensembl Transcript identifier and version, ENST00000380152.7.\",\"default\":null},{\"name\":\"biotype\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Feature biotype, e.g. Protein coding or Non coding. See http://vega.sanger.ac.uk/info/about/gene_and_transcript_types.html.\",\"default\":null},{\"name\":\"strand\",\"type\":[\"null\",{\"type\":\"enum\",\"name\":\"Strand\",\"doc\":\"Strandedness is relevant, but unknown (\\\"?\\\").\",\"symbols\":[\"FORWARD\",\"REVERSE\",\"INDEPENDENT\",\"UNKNOWN\"]}],\"doc\":\"Feature strand, if known.\",\"default\":null},{\"name\":\"rank\",\"type\":[\"null\",\"int\"],\"doc\":\"Intron or exon rank.\",\"default\":null},{\"name\":\"total\",\"type\":[\"null\",\"int\"],\"doc\":\"Total number of introns or exons.\",\"default\":null},{\"name\":\"genomicHgvs\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"HGVS.g description of the variant. See http://www.hgvs.org/mutnomen/recs-DNA.html.\",\"default\":null},{\"name\":\"transcriptHgvs\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"HGVS.c description of the variant. See http://www.hgvs.org/mutnomen/recs-DNA.html.\",\"default\":null},{\"name\":\"proteinHgvs\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"HGVS.p description of the variant, if coding. See http://www.hgvs.org/mutnomen/recs-prot.html.\",\"default\":null},{\"name\":\"cdnaPosition\",\"type\":[\"null\",\"int\"],\"doc\":\"cDNA sequence position (one based).\",\"default\":null},{\"name\":\"cdnaLength\",\"type\":[\"null\",\"int\"],\"doc\":\"cDNA sequence length in base pairs (one based).\",\"default\":null},{\"name\":\"codingSequencePosition\",\"type\":[\"null\",\"int\"],\"doc\":\"Coding sequence position (one based, includes START and STOP codons).\",\"default\":null},{\"name\":\"codingSequenceLength\",\"type\":[\"null\",\"int\"],\"doc\":\"Coding sequence length in base pairs (one based, includes START and STOP codons).\",\"default\":null},{\"name\":\"referenceCodingSequence\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Coding sequence for the reference allele.\",\"default\":null},{\"name\":\"alternateCodingSequence\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Coding sequence of this alternate allele.\",\"default\":null},{\"name\":\"proteinPosition\",\"type\":[\"null\",\"int\"],\"doc\":\"Protein sequence position (one based, includes START but not STOP).\",\"default\":null},{\"name\":\"proteinLength\",\"type\":[\"null\",\"int\"],\"doc\":\"Protein sequence length in amino acids (one based, includes START but not STOP).\",\"default\":null},{\"name\":\"referenceProteinSequence\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Protein sequence for the reference allele.\",\"default\":null},{\"name\":\"alternateProteinSequence\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Protein sequence of this alternate allele.\",\"default\":null},{\"name\":\"distance\",\"type\":[\"null\",\"int\"],\"doc\":\"Distance in base pairs to the feature.\",\"default\":null},{\"name\":\"messages\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"enum\",\"name\":\"VariantAnnotationMessage\",\"doc\":\"An alternative reference sequence was used to calculate this annotation\\n   (e.g. cancer sample comparing somatic vs. germline). Message code I3.\",\"symbols\":[\"ERROR_CHROMOSOME_NOT_FOUND\",\"ERROR_OUT_OF_CHROMOSOME_RANGE\",\"WARNING_REF_DOES_NOT_MATCH_GENOME\",\"WARNING_SEQUENCE_NOT_AVAILABLE\",\"WARNING_TRANSCRIPT_INCOMPLETE\",\"WARNING_TRANSCRIPT_MULTIPLE_STOP_CODONS\",\"WARNING_TRANSCRIPT_NO_START_CODON\",\"INFO_REALIGN_3_PRIME\",\"INFO_COMPOUND_ANNOTATION\",\"INFO_NON_REFERENCE_ANNOTATION\"]}},\"doc\":\"Zero or more errors, warnings, or informative messages regarding variant annotation accuracy.\",\"default\":[]}]}},\"doc\":\"Zero or more transcript effects, predicted by a tool such as SnpEff or Ensembl VEP,\\n   one per transcript (or other feature). VCF INFO key ANN, split for multi-allelic\\n   sites. See http://snpeff.sourceforge.net/VCFannotationformat_v1.0.pdf.\",\"default\":[]},{\"name\":\"attributes\",\"type\":{\"type\":\"map\",\"values\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"avro.java.string\":\"String\"},\"doc\":\"Additional variant attributes that do not fit into the standard fields above.\\n   The values are stored as strings, even for flag, integer, and float types. VCF\\n   INFO key values with Number=., Number=0, Number=1, and Number=[n] are shared across\\n   all alternate alleles in the same VCF record. VCF INFO key values with Number=A are\\n   split for multi-allelic sites into a single value. VCF INFO key values with Number=R\\n   are split into an array of two values, [reference allele, alternate allele], separated\\n   by commas, e.g. \\\"0,1\\\".\",\"default\":{}}]}],\"doc\":\"Annotation for this variant, if any.\",\"default\":null}]}"});
    private static SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<Variant> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<Variant> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    @Deprecated
    public String referenceName;
    @Deprecated
    public Long start;
    @Deprecated
    public Long end;
    @Deprecated
    public List<String> names;
    @Deprecated
    public Boolean splitFromMultiAllelic;
    @Deprecated
    public String referenceAllele;
    @Deprecated
    public String alternateAllele;
    @Deprecated
    public Double quality;
    @Deprecated
    public Boolean filtersApplied;
    @Deprecated
    public Boolean filtersPassed;
    @Deprecated
    public List<String> filtersFailed;
    @Deprecated
    public VariantAnnotation annotation;
    private static final DatumWriter<Variant> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<Variant> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageDecoder<Variant> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<Variant> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static Variant fromByteBuffer(ByteBuffer b) throws IOException {
        return (Variant)((Object)DECODER.decode(b));
    }

    public Variant() {
    }

    public Variant(String referenceName, Long start, Long end, List<String> names, Boolean splitFromMultiAllelic, String referenceAllele, String alternateAllele, Double quality, Boolean filtersApplied, Boolean filtersPassed, List<String> filtersFailed, VariantAnnotation annotation) {
        this.referenceName = referenceName;
        this.start = start;
        this.end = end;
        this.names = names;
        this.splitFromMultiAllelic = splitFromMultiAllelic;
        this.referenceAllele = referenceAllele;
        this.alternateAllele = alternateAllele;
        this.quality = quality;
        this.filtersApplied = filtersApplied;
        this.filtersPassed = filtersPassed;
        this.filtersFailed = filtersFailed;
        this.annotation = annotation;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.referenceName;
            }
            case 1: {
                return this.start;
            }
            case 2: {
                return this.end;
            }
            case 3: {
                return this.names;
            }
            case 4: {
                return this.splitFromMultiAllelic;
            }
            case 5: {
                return this.referenceAllele;
            }
            case 6: {
                return this.alternateAllele;
            }
            case 7: {
                return this.quality;
            }
            case 8: {
                return this.filtersApplied;
            }
            case 9: {
                return this.filtersPassed;
            }
            case 10: {
                return this.filtersFailed;
            }
            case 11: {
                return this.annotation;
            }
        }
        throw new AvroRuntimeException("Bad index");
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.referenceName = (String)value$;
                break;
            }
            case 1: {
                this.start = (Long)value$;
                break;
            }
            case 2: {
                this.end = (Long)value$;
                break;
            }
            case 3: {
                this.names = (List)value$;
                break;
            }
            case 4: {
                this.splitFromMultiAllelic = (Boolean)value$;
                break;
            }
            case 5: {
                this.referenceAllele = (String)value$;
                break;
            }
            case 6: {
                this.alternateAllele = (String)value$;
                break;
            }
            case 7: {
                this.quality = (Double)value$;
                break;
            }
            case 8: {
                this.filtersApplied = (Boolean)value$;
                break;
            }
            case 9: {
                this.filtersPassed = (Boolean)value$;
                break;
            }
            case 10: {
                this.filtersFailed = (List)value$;
                break;
            }
            case 11: {
                this.annotation = (VariantAnnotation)((Object)value$);
                break;
            }
            default: {
                throw new AvroRuntimeException("Bad index");
            }
        }
    }

    public String getReferenceName() {
        return this.referenceName;
    }

    public void setReferenceName(String value) {
        this.referenceName = value;
    }

    public Long getStart() {
        return this.start;
    }

    public void setStart(Long value) {
        this.start = value;
    }

    public Long getEnd() {
        return this.end;
    }

    public void setEnd(Long value) {
        this.end = value;
    }

    public List<String> getNames() {
        return this.names;
    }

    public void setNames(List<String> value) {
        this.names = value;
    }

    public Boolean getSplitFromMultiAllelic() {
        return this.splitFromMultiAllelic;
    }

    public void setSplitFromMultiAllelic(Boolean value) {
        this.splitFromMultiAllelic = value;
    }

    public String getReferenceAllele() {
        return this.referenceAllele;
    }

    public void setReferenceAllele(String value) {
        this.referenceAllele = value;
    }

    public String getAlternateAllele() {
        return this.alternateAllele;
    }

    public void setAlternateAllele(String value) {
        this.alternateAllele = value;
    }

    public Double getQuality() {
        return this.quality;
    }

    public void setQuality(Double value) {
        this.quality = value;
    }

    public Boolean getFiltersApplied() {
        return this.filtersApplied;
    }

    public void setFiltersApplied(Boolean value) {
        this.filtersApplied = value;
    }

    public Boolean getFiltersPassed() {
        return this.filtersPassed;
    }

    public void setFiltersPassed(Boolean value) {
        this.filtersPassed = value;
    }

    public List<String> getFiltersFailed() {
        return this.filtersFailed;
    }

    public void setFiltersFailed(List<String> value) {
        this.filtersFailed = value;
    }

    public VariantAnnotation getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(VariantAnnotation value) {
        this.annotation = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        return new Builder(other);
    }

    public static Builder newBuilder(Variant other) {
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    public static class Builder
    extends SpecificRecordBuilderBase<Variant>
    implements RecordBuilder<Variant> {
        private String referenceName;
        private Long start;
        private Long end;
        private List<String> names;
        private Boolean splitFromMultiAllelic;
        private String referenceAllele;
        private String alternateAllele;
        private Double quality;
        private Boolean filtersApplied;
        private Boolean filtersPassed;
        private List<String> filtersFailed;
        private VariantAnnotation annotation;
        private VariantAnnotation.Builder annotationBuilder;

        private Builder() {
            super(SCHEMA$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.referenceName)) {
                this.referenceName = (String)this.data().deepCopy(this.fields()[0].schema(), (Object)other.referenceName);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.start)) {
                this.start = (Long)this.data().deepCopy(this.fields()[1].schema(), (Object)other.start);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.end)) {
                this.end = (Long)this.data().deepCopy(this.fields()[2].schema(), (Object)other.end);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], other.names)) {
                this.names = (List)this.data().deepCopy(this.fields()[3].schema(), other.names);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.splitFromMultiAllelic)) {
                this.splitFromMultiAllelic = (Boolean)this.data().deepCopy(this.fields()[4].schema(), (Object)other.splitFromMultiAllelic);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.referenceAllele)) {
                this.referenceAllele = (String)this.data().deepCopy(this.fields()[5].schema(), (Object)other.referenceAllele);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.alternateAllele)) {
                this.alternateAllele = (String)this.data().deepCopy(this.fields()[6].schema(), (Object)other.alternateAllele);
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.quality)) {
                this.quality = (Double)this.data().deepCopy(this.fields()[7].schema(), (Object)other.quality);
                this.fieldSetFlags()[7] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.filtersApplied)) {
                this.filtersApplied = (Boolean)this.data().deepCopy(this.fields()[8].schema(), (Object)other.filtersApplied);
                this.fieldSetFlags()[8] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.filtersPassed)) {
                this.filtersPassed = (Boolean)this.data().deepCopy(this.fields()[9].schema(), (Object)other.filtersPassed);
                this.fieldSetFlags()[9] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], other.filtersFailed)) {
                this.filtersFailed = (List)this.data().deepCopy(this.fields()[10].schema(), other.filtersFailed);
                this.fieldSetFlags()[10] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)((Object)other.annotation))) {
                this.annotation = (VariantAnnotation)((Object)this.data().deepCopy(this.fields()[11].schema(), (Object)other.annotation));
                this.fieldSetFlags()[11] = true;
            }
            if (other.hasAnnotationBuilder()) {
                this.annotationBuilder = VariantAnnotation.newBuilder(other.getAnnotationBuilder());
            }
        }

        private Builder(Variant other) {
            super(SCHEMA$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.referenceName)) {
                this.referenceName = (String)this.data().deepCopy(this.fields()[0].schema(), (Object)other.referenceName);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.start)) {
                this.start = (Long)this.data().deepCopy(this.fields()[1].schema(), (Object)other.start);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.end)) {
                this.end = (Long)this.data().deepCopy(this.fields()[2].schema(), (Object)other.end);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], other.names)) {
                this.names = (List)this.data().deepCopy(this.fields()[3].schema(), other.names);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.splitFromMultiAllelic)) {
                this.splitFromMultiAllelic = (Boolean)this.data().deepCopy(this.fields()[4].schema(), (Object)other.splitFromMultiAllelic);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.referenceAllele)) {
                this.referenceAllele = (String)this.data().deepCopy(this.fields()[5].schema(), (Object)other.referenceAllele);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.alternateAllele)) {
                this.alternateAllele = (String)this.data().deepCopy(this.fields()[6].schema(), (Object)other.alternateAllele);
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.quality)) {
                this.quality = (Double)this.data().deepCopy(this.fields()[7].schema(), (Object)other.quality);
                this.fieldSetFlags()[7] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.filtersApplied)) {
                this.filtersApplied = (Boolean)this.data().deepCopy(this.fields()[8].schema(), (Object)other.filtersApplied);
                this.fieldSetFlags()[8] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.filtersPassed)) {
                this.filtersPassed = (Boolean)this.data().deepCopy(this.fields()[9].schema(), (Object)other.filtersPassed);
                this.fieldSetFlags()[9] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], other.filtersFailed)) {
                this.filtersFailed = (List)this.data().deepCopy(this.fields()[10].schema(), other.filtersFailed);
                this.fieldSetFlags()[10] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)((Object)other.annotation))) {
                this.annotation = (VariantAnnotation)((Object)this.data().deepCopy(this.fields()[11].schema(), (Object)other.annotation));
                this.fieldSetFlags()[11] = true;
            }
            this.annotationBuilder = null;
        }

        public String getReferenceName() {
            return this.referenceName;
        }

        public Builder setReferenceName(String value) {
            this.validate(this.fields()[0], value);
            this.referenceName = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasReferenceName() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearReferenceName() {
            this.referenceName = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public Long getStart() {
            return this.start;
        }

        public Builder setStart(Long value) {
            this.validate(this.fields()[1], value);
            this.start = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasStart() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearStart() {
            this.start = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public Long getEnd() {
            return this.end;
        }

        public Builder setEnd(Long value) {
            this.validate(this.fields()[2], value);
            this.end = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasEnd() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearEnd() {
            this.end = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public List<String> getNames() {
            return this.names;
        }

        public Builder setNames(List<String> value) {
            this.validate(this.fields()[3], value);
            this.names = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasNames() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearNames() {
            this.names = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public Boolean getSplitFromMultiAllelic() {
            return this.splitFromMultiAllelic;
        }

        public Builder setSplitFromMultiAllelic(Boolean value) {
            this.validate(this.fields()[4], value);
            this.splitFromMultiAllelic = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasSplitFromMultiAllelic() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearSplitFromMultiAllelic() {
            this.splitFromMultiAllelic = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public String getReferenceAllele() {
            return this.referenceAllele;
        }

        public Builder setReferenceAllele(String value) {
            this.validate(this.fields()[5], value);
            this.referenceAllele = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasReferenceAllele() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearReferenceAllele() {
            this.referenceAllele = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public String getAlternateAllele() {
            return this.alternateAllele;
        }

        public Builder setAlternateAllele(String value) {
            this.validate(this.fields()[6], value);
            this.alternateAllele = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasAlternateAllele() {
            return this.fieldSetFlags()[6];
        }

        public Builder clearAlternateAllele() {
            this.alternateAllele = null;
            this.fieldSetFlags()[6] = false;
            return this;
        }

        public Double getQuality() {
            return this.quality;
        }

        public Builder setQuality(Double value) {
            this.validate(this.fields()[7], value);
            this.quality = value;
            this.fieldSetFlags()[7] = true;
            return this;
        }

        public boolean hasQuality() {
            return this.fieldSetFlags()[7];
        }

        public Builder clearQuality() {
            this.quality = null;
            this.fieldSetFlags()[7] = false;
            return this;
        }

        public Boolean getFiltersApplied() {
            return this.filtersApplied;
        }

        public Builder setFiltersApplied(Boolean value) {
            this.validate(this.fields()[8], value);
            this.filtersApplied = value;
            this.fieldSetFlags()[8] = true;
            return this;
        }

        public boolean hasFiltersApplied() {
            return this.fieldSetFlags()[8];
        }

        public Builder clearFiltersApplied() {
            this.filtersApplied = null;
            this.fieldSetFlags()[8] = false;
            return this;
        }

        public Boolean getFiltersPassed() {
            return this.filtersPassed;
        }

        public Builder setFiltersPassed(Boolean value) {
            this.validate(this.fields()[9], value);
            this.filtersPassed = value;
            this.fieldSetFlags()[9] = true;
            return this;
        }

        public boolean hasFiltersPassed() {
            return this.fieldSetFlags()[9];
        }

        public Builder clearFiltersPassed() {
            this.filtersPassed = null;
            this.fieldSetFlags()[9] = false;
            return this;
        }

        public List<String> getFiltersFailed() {
            return this.filtersFailed;
        }

        public Builder setFiltersFailed(List<String> value) {
            this.validate(this.fields()[10], value);
            this.filtersFailed = value;
            this.fieldSetFlags()[10] = true;
            return this;
        }

        public boolean hasFiltersFailed() {
            return this.fieldSetFlags()[10];
        }

        public Builder clearFiltersFailed() {
            this.filtersFailed = null;
            this.fieldSetFlags()[10] = false;
            return this;
        }

        public VariantAnnotation getAnnotation() {
            return this.annotation;
        }

        public Builder setAnnotation(VariantAnnotation value) {
            this.validate(this.fields()[11], (Object)value);
            this.annotationBuilder = null;
            this.annotation = value;
            this.fieldSetFlags()[11] = true;
            return this;
        }

        public boolean hasAnnotation() {
            return this.fieldSetFlags()[11];
        }

        public VariantAnnotation.Builder getAnnotationBuilder() {
            if (this.annotationBuilder == null) {
                if (this.hasAnnotation()) {
                    this.setAnnotationBuilder(VariantAnnotation.newBuilder(this.annotation));
                } else {
                    this.setAnnotationBuilder(VariantAnnotation.newBuilder());
                }
            }
            return this.annotationBuilder;
        }

        public Builder setAnnotationBuilder(VariantAnnotation.Builder value) {
            this.clearAnnotation();
            this.annotationBuilder = value;
            return this;
        }

        public boolean hasAnnotationBuilder() {
            return this.annotationBuilder != null;
        }

        public Builder clearAnnotation() {
            this.annotation = null;
            this.annotationBuilder = null;
            this.fieldSetFlags()[11] = false;
            return this;
        }

        public Variant build() {
            try {
                Variant record = new Variant();
                record.referenceName = this.fieldSetFlags()[0] ? this.referenceName : (String)this.defaultValue(this.fields()[0]);
                record.start = this.fieldSetFlags()[1] ? this.start : (Long)this.defaultValue(this.fields()[1]);
                record.end = this.fieldSetFlags()[2] ? this.end : (Long)this.defaultValue(this.fields()[2]);
                record.names = this.fieldSetFlags()[3] ? this.names : (List)this.defaultValue(this.fields()[3]);
                record.splitFromMultiAllelic = this.fieldSetFlags()[4] ? this.splitFromMultiAllelic : (Boolean)this.defaultValue(this.fields()[4]);
                record.referenceAllele = this.fieldSetFlags()[5] ? this.referenceAllele : (String)this.defaultValue(this.fields()[5]);
                record.alternateAllele = this.fieldSetFlags()[6] ? this.alternateAllele : (String)this.defaultValue(this.fields()[6]);
                record.quality = this.fieldSetFlags()[7] ? this.quality : (Double)this.defaultValue(this.fields()[7]);
                record.filtersApplied = this.fieldSetFlags()[8] ? this.filtersApplied : (Boolean)this.defaultValue(this.fields()[8]);
                record.filtersPassed = this.fieldSetFlags()[9] ? this.filtersPassed : (Boolean)this.defaultValue(this.fields()[9]);
                List<String> list = record.filtersFailed = this.fieldSetFlags()[10] ? this.filtersFailed : (List<String>)this.defaultValue(this.fields()[10]);
                record.annotation = this.annotationBuilder != null ? this.annotationBuilder.build() : (this.fieldSetFlags()[11] ? this.annotation : (VariantAnnotation)((Object)this.defaultValue(this.fields()[11])));
                return record;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

