/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.formats.avro;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.bdgenomics.formats.avro.TranscriptEffect;

@AvroGenerated
public class VariantAnnotation
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -1394741076587008796L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"VariantAnnotation\",\"namespace\":\"org.bdgenomics.formats.avro\",\"doc\":\"Variant annotation.\",\"fields\":[{\"name\":\"ancestralAllele\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Ancestral allele, VCF INFO reserved key AA, Number=1, shared across all alternate\\n   alleles in the same VCF record.\",\"default\":null},{\"name\":\"alleleCount\",\"type\":[\"null\",\"int\"],\"doc\":\"Allele count, VCF INFO reserved key AC, Number=A, split for multi-allelic sites into\\n   a single integer value.\",\"default\":null},{\"name\":\"readDepth\",\"type\":[\"null\",\"int\"],\"doc\":\"Total read depth, VCF INFO reserved key AD, Number=R, split for multi-allelic\\n   sites into single integer values for the reference allele (referenceReadDepth) and\\n   the alternate allele (readDepth, this field).\",\"default\":null},{\"name\":\"forwardReadDepth\",\"type\":[\"null\",\"int\"],\"doc\":\"Forward strand read depth, VCF INFO reserved key ADF, Number=R, split for\\n   multi-allelic sites into single integer values for the reference allele\\n   (referenceForwardReadDepth) and the alternate allele (forwardReadDepth, this field).\",\"default\":null},{\"name\":\"reverseReadDepth\",\"type\":[\"null\",\"int\"],\"doc\":\"Reverse strand read depth, VCF INFO reserved key ADR, Number=R, split for\\n   multi-allelic sites into single integer values for the reference allele\\n   (referenceReverseReadDepth) and the alternate allele (reverseReadDepth, this field).\",\"default\":null},{\"name\":\"referenceReadDepth\",\"type\":[\"null\",\"int\"],\"doc\":\"Total read depth, VCF INFO reserved key AD, Number=R, split for multi-allelic\\n   sites into single integer values for the reference allele (referenceReadDepth, this field)\\n   and the alternate allele (readDepth).\",\"default\":null},{\"name\":\"referenceForwardReadDepth\",\"type\":[\"null\",\"int\"],\"doc\":\"Forward strand read depth, VCF INFO reserved key ADF, Number=R, split for\\n   multi-allelic sites into single integer values for the reference allele\\n   (referenceForwardReadDepth, this field) and the alternate allele (forwardReadDepth).\",\"default\":null},{\"name\":\"referenceReverseReadDepth\",\"type\":[\"null\",\"int\"],\"doc\":\"Reverse strand read depth, VCF INFO reserved key ADR, Number=R, split for\\n   multi-allelic sites into single integer values for the reference allele\\n   (referenceReverseReadDepth, this field) and the alternate allele (reverseReadDepth).\",\"default\":null},{\"name\":\"alleleFrequency\",\"type\":[\"null\",\"float\"],\"doc\":\"Minor allele frequency, VCF INFO reserved key AF, Number=A, split for multi-allelic\\n   sites into a single float value. Use this when frequencies are estimated from primary\\n   data, not calculated from called genotypes.\",\"default\":null},{\"name\":\"cigar\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"CIGAR string describing how to align an alternate allele to the reference\\n   allele, VCF INFO reserved key CIGAR, Number=A, split for multi-allelic sites into\\n   a single string value.\",\"default\":null},{\"name\":\"dbSnp\",\"type\":[\"null\",\"boolean\"],\"doc\":\"Membership in dbSNP, VCF INFO reserved key DB, Number=0. Until Number=A and\\n   Number=R flags are supported by the VCF specification, this value is shared\\n   across all alternate alleles in the same VCF record.\",\"default\":null},{\"name\":\"hapMap2\",\"type\":[\"null\",\"boolean\"],\"doc\":\"Membership in HapMap2, VCF INFO reserved key H2, Number=0. Until Number=A and\\n   Number=R flags are supported by the VCF specification, this value is shared\\n   across all alternate alleles in the same VCF record.\",\"default\":null},{\"name\":\"hapMap3\",\"type\":[\"null\",\"boolean\"],\"doc\":\"Membership in HapMap3, VCF INFO reserved key H3, Number=0. Until Number=A and\\n   Number=R flags are supported by the VCF specification, this value is shared\\n   across all alternate alleles in the same VCF record.\",\"default\":null},{\"name\":\"validated\",\"type\":[\"null\",\"boolean\"],\"doc\":\"Validated by follow up experiment, VCF INFO reserved key VALIDATED, Number=0.\\n   Until Number=A and Number=R flags are supported by the VCF specification, this\\n   value is shared across all alternate alleles in the same VCF record.\",\"default\":null},{\"name\":\"thousandGenomes\",\"type\":[\"null\",\"boolean\"],\"doc\":\"Membership in 1000 Genomes, VCF INFO reserved key 1000G, Number=0. Until\\n   Number=A and Number=R flags are supported by the VCF specification, this\\n   value is shared across all alternate alleles in the same VCF record.\",\"default\":null},{\"name\":\"somatic\",\"type\":[\"boolean\",\"null\"],\"doc\":\"True if this variant call is somatic; in this case, the reference allele will\\n   have been observed in another sample. VCF INFO reserved key \\\"SOMATIC\\\", Number=0.\\n   Until Number=A and Number=R flags are supported by the VCF specification, this value\\n   is shared across all alleles in the same VCF record.\",\"default\":false},{\"name\":\"transcriptEffects\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"record\",\"name\":\"TranscriptEffect\",\"doc\":\"Annotation of a variant in the context of a feature, typically a transcript.\",\"fields\":[{\"name\":\"alternateAllele\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Alternate allele for this variant annotation.\",\"default\":null},{\"name\":\"effects\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},\"doc\":\"One or more annotations (also referred to as effects or consequences) of the\\n   variant in the context of the feature identified by featureId. Must be\\n   Sequence Ontology (SO, see http://www.sequenceontology.org) term names, e.g.\\n   stop_gained, missense_variant, synonymous_variant, upstream_gene_variant.\",\"default\":[]},{\"name\":\"impact\",\"type\":[\"null\",{\"type\":\"enum\",\"name\":\"Impact\",\"doc\":\"Modifier impact.\",\"symbols\":[\"HIGH\",\"MODERATE\",\"LOW\",\"MODIFIER\"]}],\"doc\":\"Putative impact of the annotation; a simple estimation of putative impact/\\n   deleteriousness.\",\"default\":null},{\"name\":\"geneName\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Common gene name (HGNC), e.g. BRCA2. May be closest gene if annotation\\n   is intergenic.\",\"default\":null},{\"name\":\"geneId\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Gene identifier, e.g. Ensembl Gene identifier, ENSG00000139618. May be\\n   closest gene if annotation is intergenic.\",\"default\":null},{\"name\":\"featureType\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Feature type, may use Sequence Ontology term names. Typically transcript.\",\"default\":null},{\"name\":\"featureId\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Feature identifier, e.g. Ensembl Transcript identifier and version, ENST00000380152.7.\",\"default\":null},{\"name\":\"biotype\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Feature biotype, e.g. Protein coding or Non coding. See http://vega.sanger.ac.uk/info/about/gene_and_transcript_types.html.\",\"default\":null},{\"name\":\"strand\",\"type\":[\"null\",{\"type\":\"enum\",\"name\":\"Strand\",\"doc\":\"Strandedness is relevant, but unknown (\\\"?\\\").\",\"symbols\":[\"FORWARD\",\"REVERSE\",\"INDEPENDENT\",\"UNKNOWN\"]}],\"doc\":\"Feature strand, if known.\",\"default\":null},{\"name\":\"rank\",\"type\":[\"null\",\"int\"],\"doc\":\"Intron or exon rank.\",\"default\":null},{\"name\":\"total\",\"type\":[\"null\",\"int\"],\"doc\":\"Total number of introns or exons.\",\"default\":null},{\"name\":\"genomicHgvs\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"HGVS.g description of the variant. See http://www.hgvs.org/mutnomen/recs-DNA.html.\",\"default\":null},{\"name\":\"transcriptHgvs\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"HGVS.c description of the variant. See http://www.hgvs.org/mutnomen/recs-DNA.html.\",\"default\":null},{\"name\":\"proteinHgvs\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"HGVS.p description of the variant, if coding. See http://www.hgvs.org/mutnomen/recs-prot.html.\",\"default\":null},{\"name\":\"cdnaPosition\",\"type\":[\"null\",\"int\"],\"doc\":\"cDNA sequence position (one based).\",\"default\":null},{\"name\":\"cdnaLength\",\"type\":[\"null\",\"int\"],\"doc\":\"cDNA sequence length in base pairs (one based).\",\"default\":null},{\"name\":\"codingSequencePosition\",\"type\":[\"null\",\"int\"],\"doc\":\"Coding sequence position (one based, includes START and STOP codons).\",\"de", new String[]{"fault\":null},{\"name\":\"codingSequenceLength\",\"type\":[\"null\",\"int\"],\"doc\":\"Coding sequence length in base pairs (one based, includes START and STOP codons).\",\"default\":null},{\"name\":\"referenceCodingSequence\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Coding sequence for the reference allele.\",\"default\":null},{\"name\":\"alternateCodingSequence\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Coding sequence of this alternate allele.\",\"default\":null},{\"name\":\"proteinPosition\",\"type\":[\"null\",\"int\"],\"doc\":\"Protein sequence position (one based, includes START but not STOP).\",\"default\":null},{\"name\":\"proteinLength\",\"type\":[\"null\",\"int\"],\"doc\":\"Protein sequence length in amino acids (one based, includes START but not STOP).\",\"default\":null},{\"name\":\"referenceProteinSequence\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Protein sequence for the reference allele.\",\"default\":null},{\"name\":\"alternateProteinSequence\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Protein sequence of this alternate allele.\",\"default\":null},{\"name\":\"distance\",\"type\":[\"null\",\"int\"],\"doc\":\"Distance in base pairs to the feature.\",\"default\":null},{\"name\":\"messages\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"enum\",\"name\":\"VariantAnnotationMessage\",\"doc\":\"An alternative reference sequence was used to calculate this annotation\\n   (e.g. cancer sample comparing somatic vs. germline). Message code I3.\",\"symbols\":[\"ERROR_CHROMOSOME_NOT_FOUND\",\"ERROR_OUT_OF_CHROMOSOME_RANGE\",\"WARNING_REF_DOES_NOT_MATCH_GENOME\",\"WARNING_SEQUENCE_NOT_AVAILABLE\",\"WARNING_TRANSCRIPT_INCOMPLETE\",\"WARNING_TRANSCRIPT_MULTIPLE_STOP_CODONS\",\"WARNING_TRANSCRIPT_NO_START_CODON\",\"INFO_REALIGN_3_PRIME\",\"INFO_COMPOUND_ANNOTATION\",\"INFO_NON_REFERENCE_ANNOTATION\"]}},\"doc\":\"Zero or more errors, warnings, or informative messages regarding variant annotation accuracy.\",\"default\":[]}]}},\"doc\":\"Zero or more transcript effects, predicted by a tool such as SnpEff or Ensembl VEP,\\n   one per transcript (or other feature). VCF INFO key ANN, split for multi-allelic\\n   sites. See http://snpeff.sourceforge.net/VCFannotationformat_v1.0.pdf.\",\"default\":[]},{\"name\":\"attributes\",\"type\":{\"type\":\"map\",\"values\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"avro.java.string\":\"String\"},\"doc\":\"Additional variant attributes that do not fit into the standard fields above.\\n   The values are stored as strings, even for flag, integer, and float types. VCF\\n   INFO key values with Number=., Number=0, Number=1, and Number=[n] are shared across\\n   all alternate alleles in the same VCF record. VCF INFO key values with Number=A are\\n   split for multi-allelic sites into a single value. VCF INFO key values with Number=R\\n   are split into an array of two values, [reference allele, alternate allele], separated\\n   by commas, e.g. \\\"0,1\\\".\",\"default\":{}}]}"});
    private static SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<VariantAnnotation> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<VariantAnnotation> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    @Deprecated
    public String ancestralAllele;
    @Deprecated
    public Integer alleleCount;
    @Deprecated
    public Integer readDepth;
    @Deprecated
    public Integer forwardReadDepth;
    @Deprecated
    public Integer reverseReadDepth;
    @Deprecated
    public Integer referenceReadDepth;
    @Deprecated
    public Integer referenceForwardReadDepth;
    @Deprecated
    public Integer referenceReverseReadDepth;
    @Deprecated
    public Float alleleFrequency;
    @Deprecated
    public String cigar;
    @Deprecated
    public Boolean dbSnp;
    @Deprecated
    public Boolean hapMap2;
    @Deprecated
    public Boolean hapMap3;
    @Deprecated
    public Boolean validated;
    @Deprecated
    public Boolean thousandGenomes;
    @Deprecated
    public Boolean somatic;
    @Deprecated
    public List<TranscriptEffect> transcriptEffects;
    @Deprecated
    public Map<String, String> attributes;
    private static final DatumWriter<VariantAnnotation> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<VariantAnnotation> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageDecoder<VariantAnnotation> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<VariantAnnotation> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static VariantAnnotation fromByteBuffer(ByteBuffer b) throws IOException {
        return (VariantAnnotation)((Object)DECODER.decode(b));
    }

    public VariantAnnotation() {
    }

    public VariantAnnotation(String ancestralAllele, Integer alleleCount, Integer readDepth, Integer forwardReadDepth, Integer reverseReadDepth, Integer referenceReadDepth, Integer referenceForwardReadDepth, Integer referenceReverseReadDepth, Float alleleFrequency, String cigar, Boolean dbSnp, Boolean hapMap2, Boolean hapMap3, Boolean validated, Boolean thousandGenomes, Boolean somatic, List<TranscriptEffect> transcriptEffects, Map<String, String> attributes) {
        this.ancestralAllele = ancestralAllele;
        this.alleleCount = alleleCount;
        this.readDepth = readDepth;
        this.forwardReadDepth = forwardReadDepth;
        this.reverseReadDepth = reverseReadDepth;
        this.referenceReadDepth = referenceReadDepth;
        this.referenceForwardReadDepth = referenceForwardReadDepth;
        this.referenceReverseReadDepth = referenceReverseReadDepth;
        this.alleleFrequency = alleleFrequency;
        this.cigar = cigar;
        this.dbSnp = dbSnp;
        this.hapMap2 = hapMap2;
        this.hapMap3 = hapMap3;
        this.validated = validated;
        this.thousandGenomes = thousandGenomes;
        this.somatic = somatic;
        this.transcriptEffects = transcriptEffects;
        this.attributes = attributes;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.ancestralAllele;
            }
            case 1: {
                return this.alleleCount;
            }
            case 2: {
                return this.readDepth;
            }
            case 3: {
                return this.forwardReadDepth;
            }
            case 4: {
                return this.reverseReadDepth;
            }
            case 5: {
                return this.referenceReadDepth;
            }
            case 6: {
                return this.referenceForwardReadDepth;
            }
            case 7: {
                return this.referenceReverseReadDepth;
            }
            case 8: {
                return this.alleleFrequency;
            }
            case 9: {
                return this.cigar;
            }
            case 10: {
                return this.dbSnp;
            }
            case 11: {
                return this.hapMap2;
            }
            case 12: {
                return this.hapMap3;
            }
            case 13: {
                return this.validated;
            }
            case 14: {
                return this.thousandGenomes;
            }
            case 15: {
                return this.somatic;
            }
            case 16: {
                return this.transcriptEffects;
            }
            case 17: {
                return this.attributes;
            }
        }
        throw new AvroRuntimeException("Bad index");
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.ancestralAllele = (String)value$;
                break;
            }
            case 1: {
                this.alleleCount = (Integer)value$;
                break;
            }
            case 2: {
                this.readDepth = (Integer)value$;
                break;
            }
            case 3: {
                this.forwardReadDepth = (Integer)value$;
                break;
            }
            case 4: {
                this.reverseReadDepth = (Integer)value$;
                break;
            }
            case 5: {
                this.referenceReadDepth = (Integer)value$;
                break;
            }
            case 6: {
                this.referenceForwardReadDepth = (Integer)value$;
                break;
            }
            case 7: {
                this.referenceReverseReadDepth = (Integer)value$;
                break;
            }
            case 8: {
                this.alleleFrequency = (Float)value$;
                break;
            }
            case 9: {
                this.cigar = (String)value$;
                break;
            }
            case 10: {
                this.dbSnp = (Boolean)value$;
                break;
            }
            case 11: {
                this.hapMap2 = (Boolean)value$;
                break;
            }
            case 12: {
                this.hapMap3 = (Boolean)value$;
                break;
            }
            case 13: {
                this.validated = (Boolean)value$;
                break;
            }
            case 14: {
                this.thousandGenomes = (Boolean)value$;
                break;
            }
            case 15: {
                this.somatic = (Boolean)value$;
                break;
            }
            case 16: {
                this.transcriptEffects = (List)value$;
                break;
            }
            case 17: {
                this.attributes = (Map)value$;
                break;
            }
            default: {
                throw new AvroRuntimeException("Bad index");
            }
        }
    }

    public String getAncestralAllele() {
        return this.ancestralAllele;
    }

    public void setAncestralAllele(String value) {
        this.ancestralAllele = value;
    }

    public Integer getAlleleCount() {
        return this.alleleCount;
    }

    public void setAlleleCount(Integer value) {
        this.alleleCount = value;
    }

    public Integer getReadDepth() {
        return this.readDepth;
    }

    public void setReadDepth(Integer value) {
        this.readDepth = value;
    }

    public Integer getForwardReadDepth() {
        return this.forwardReadDepth;
    }

    public void setForwardReadDepth(Integer value) {
        this.forwardReadDepth = value;
    }

    public Integer getReverseReadDepth() {
        return this.reverseReadDepth;
    }

    public void setReverseReadDepth(Integer value) {
        this.reverseReadDepth = value;
    }

    public Integer getReferenceReadDepth() {
        return this.referenceReadDepth;
    }

    public void setReferenceReadDepth(Integer value) {
        this.referenceReadDepth = value;
    }

    public Integer getReferenceForwardReadDepth() {
        return this.referenceForwardReadDepth;
    }

    public void setReferenceForwardReadDepth(Integer value) {
        this.referenceForwardReadDepth = value;
    }

    public Integer getReferenceReverseReadDepth() {
        return this.referenceReverseReadDepth;
    }

    public void setReferenceReverseReadDepth(Integer value) {
        this.referenceReverseReadDepth = value;
    }

    public Float getAlleleFrequency() {
        return this.alleleFrequency;
    }

    public void setAlleleFrequency(Float value) {
        this.alleleFrequency = value;
    }

    public String getCigar() {
        return this.cigar;
    }

    public void setCigar(String value) {
        this.cigar = value;
    }

    public Boolean getDbSnp() {
        return this.dbSnp;
    }

    public void setDbSnp(Boolean value) {
        this.dbSnp = value;
    }

    public Boolean getHapMap2() {
        return this.hapMap2;
    }

    public void setHapMap2(Boolean value) {
        this.hapMap2 = value;
    }

    public Boolean getHapMap3() {
        return this.hapMap3;
    }

    public void setHapMap3(Boolean value) {
        this.hapMap3 = value;
    }

    public Boolean getValidated() {
        return this.validated;
    }

    public void setValidated(Boolean value) {
        this.validated = value;
    }

    public Boolean getThousandGenomes() {
        return this.thousandGenomes;
    }

    public void setThousandGenomes(Boolean value) {
        this.thousandGenomes = value;
    }

    public Boolean getSomatic() {
        return this.somatic;
    }

    public void setSomatic(Boolean value) {
        this.somatic = value;
    }

    public List<TranscriptEffect> getTranscriptEffects() {
        return this.transcriptEffects;
    }

    public void setTranscriptEffects(List<TranscriptEffect> value) {
        this.transcriptEffects = value;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> value) {
        this.attributes = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        return new Builder(other);
    }

    public static Builder newBuilder(VariantAnnotation other) {
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    public static class Builder
    extends SpecificRecordBuilderBase<VariantAnnotation>
    implements RecordBuilder<VariantAnnotation> {
        private String ancestralAllele;
        private Integer alleleCount;
        private Integer readDepth;
        private Integer forwardReadDepth;
        private Integer reverseReadDepth;
        private Integer referenceReadDepth;
        private Integer referenceForwardReadDepth;
        private Integer referenceReverseReadDepth;
        private Float alleleFrequency;
        private String cigar;
        private Boolean dbSnp;
        private Boolean hapMap2;
        private Boolean hapMap3;
        private Boolean validated;
        private Boolean thousandGenomes;
        private Boolean somatic;
        private List<TranscriptEffect> transcriptEffects;
        private Map<String, String> attributes;

        private Builder() {
            super(SCHEMA$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.ancestralAllele)) {
                this.ancestralAllele = (String)this.data().deepCopy(this.fields()[0].schema(), (Object)other.ancestralAllele);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.alleleCount)) {
                this.alleleCount = (Integer)this.data().deepCopy(this.fields()[1].schema(), (Object)other.alleleCount);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.readDepth)) {
                this.readDepth = (Integer)this.data().deepCopy(this.fields()[2].schema(), (Object)other.readDepth);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.forwardReadDepth)) {
                this.forwardReadDepth = (Integer)this.data().deepCopy(this.fields()[3].schema(), (Object)other.forwardReadDepth);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.reverseReadDepth)) {
                this.reverseReadDepth = (Integer)this.data().deepCopy(this.fields()[4].schema(), (Object)other.reverseReadDepth);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.referenceReadDepth)) {
                this.referenceReadDepth = (Integer)this.data().deepCopy(this.fields()[5].schema(), (Object)other.referenceReadDepth);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.referenceForwardReadDepth)) {
                this.referenceForwardReadDepth = (Integer)this.data().deepCopy(this.fields()[6].schema(), (Object)other.referenceForwardReadDepth);
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.referenceReverseReadDepth)) {
                this.referenceReverseReadDepth = (Integer)this.data().deepCopy(this.fields()[7].schema(), (Object)other.referenceReverseReadDepth);
                this.fieldSetFlags()[7] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.alleleFrequency)) {
                this.alleleFrequency = (Float)this.data().deepCopy(this.fields()[8].schema(), (Object)other.alleleFrequency);
                this.fieldSetFlags()[8] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.cigar)) {
                this.cigar = (String)this.data().deepCopy(this.fields()[9].schema(), (Object)other.cigar);
                this.fieldSetFlags()[9] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)other.dbSnp)) {
                this.dbSnp = (Boolean)this.data().deepCopy(this.fields()[10].schema(), (Object)other.dbSnp);
                this.fieldSetFlags()[10] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)other.hapMap2)) {
                this.hapMap2 = (Boolean)this.data().deepCopy(this.fields()[11].schema(), (Object)other.hapMap2);
                this.fieldSetFlags()[11] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[12], (Object)other.hapMap3)) {
                this.hapMap3 = (Boolean)this.data().deepCopy(this.fields()[12].schema(), (Object)other.hapMap3);
                this.fieldSetFlags()[12] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[13], (Object)other.validated)) {
                this.validated = (Boolean)this.data().deepCopy(this.fields()[13].schema(), (Object)other.validated);
                this.fieldSetFlags()[13] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[14], (Object)other.thousandGenomes)) {
                this.thousandGenomes = (Boolean)this.data().deepCopy(this.fields()[14].schema(), (Object)other.thousandGenomes);
                this.fieldSetFlags()[14] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[15], (Object)other.somatic)) {
                this.somatic = (Boolean)this.data().deepCopy(this.fields()[15].schema(), (Object)other.somatic);
                this.fieldSetFlags()[15] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[16], other.transcriptEffects)) {
                this.transcriptEffects = (List)this.data().deepCopy(this.fields()[16].schema(), other.transcriptEffects);
                this.fieldSetFlags()[16] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[17], other.attributes)) {
                this.attributes = (Map)this.data().deepCopy(this.fields()[17].schema(), other.attributes);
                this.fieldSetFlags()[17] = true;
            }
        }

        private Builder(VariantAnnotation other) {
            super(SCHEMA$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.ancestralAllele)) {
                this.ancestralAllele = (String)this.data().deepCopy(this.fields()[0].schema(), (Object)other.ancestralAllele);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.alleleCount)) {
                this.alleleCount = (Integer)this.data().deepCopy(this.fields()[1].schema(), (Object)other.alleleCount);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.readDepth)) {
                this.readDepth = (Integer)this.data().deepCopy(this.fields()[2].schema(), (Object)other.readDepth);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.forwardReadDepth)) {
                this.forwardReadDepth = (Integer)this.data().deepCopy(this.fields()[3].schema(), (Object)other.forwardReadDepth);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.reverseReadDepth)) {
                this.reverseReadDepth = (Integer)this.data().deepCopy(this.fields()[4].schema(), (Object)other.reverseReadDepth);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.referenceReadDepth)) {
                this.referenceReadDepth = (Integer)this.data().deepCopy(this.fields()[5].schema(), (Object)other.referenceReadDepth);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.referenceForwardReadDepth)) {
                this.referenceForwardReadDepth = (Integer)this.data().deepCopy(this.fields()[6].schema(), (Object)other.referenceForwardReadDepth);
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.referenceReverseReadDepth)) {
                this.referenceReverseReadDepth = (Integer)this.data().deepCopy(this.fields()[7].schema(), (Object)other.referenceReverseReadDepth);
                this.fieldSetFlags()[7] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.alleleFrequency)) {
                this.alleleFrequency = (Float)this.data().deepCopy(this.fields()[8].schema(), (Object)other.alleleFrequency);
                this.fieldSetFlags()[8] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.cigar)) {
                this.cigar = (String)this.data().deepCopy(this.fields()[9].schema(), (Object)other.cigar);
                this.fieldSetFlags()[9] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)other.dbSnp)) {
                this.dbSnp = (Boolean)this.data().deepCopy(this.fields()[10].schema(), (Object)other.dbSnp);
                this.fieldSetFlags()[10] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)other.hapMap2)) {
                this.hapMap2 = (Boolean)this.data().deepCopy(this.fields()[11].schema(), (Object)other.hapMap2);
                this.fieldSetFlags()[11] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[12], (Object)other.hapMap3)) {
                this.hapMap3 = (Boolean)this.data().deepCopy(this.fields()[12].schema(), (Object)other.hapMap3);
                this.fieldSetFlags()[12] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[13], (Object)other.validated)) {
                this.validated = (Boolean)this.data().deepCopy(this.fields()[13].schema(), (Object)other.validated);
                this.fieldSetFlags()[13] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[14], (Object)other.thousandGenomes)) {
                this.thousandGenomes = (Boolean)this.data().deepCopy(this.fields()[14].schema(), (Object)other.thousandGenomes);
                this.fieldSetFlags()[14] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[15], (Object)other.somatic)) {
                this.somatic = (Boolean)this.data().deepCopy(this.fields()[15].schema(), (Object)other.somatic);
                this.fieldSetFlags()[15] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[16], other.transcriptEffects)) {
                this.transcriptEffects = (List)this.data().deepCopy(this.fields()[16].schema(), other.transcriptEffects);
                this.fieldSetFlags()[16] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[17], other.attributes)) {
                this.attributes = (Map)this.data().deepCopy(this.fields()[17].schema(), other.attributes);
                this.fieldSetFlags()[17] = true;
            }
        }

        public String getAncestralAllele() {
            return this.ancestralAllele;
        }

        public Builder setAncestralAllele(String value) {
            this.validate(this.fields()[0], value);
            this.ancestralAllele = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasAncestralAllele() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearAncestralAllele() {
            this.ancestralAllele = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public Integer getAlleleCount() {
            return this.alleleCount;
        }

        public Builder setAlleleCount(Integer value) {
            this.validate(this.fields()[1], value);
            this.alleleCount = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasAlleleCount() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearAlleleCount() {
            this.alleleCount = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public Integer getReadDepth() {
            return this.readDepth;
        }

        public Builder setReadDepth(Integer value) {
            this.validate(this.fields()[2], value);
            this.readDepth = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasReadDepth() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearReadDepth() {
            this.readDepth = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public Integer getForwardReadDepth() {
            return this.forwardReadDepth;
        }

        public Builder setForwardReadDepth(Integer value) {
            this.validate(this.fields()[3], value);
            this.forwardReadDepth = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasForwardReadDepth() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearForwardReadDepth() {
            this.forwardReadDepth = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public Integer getReverseReadDepth() {
            return this.reverseReadDepth;
        }

        public Builder setReverseReadDepth(Integer value) {
            this.validate(this.fields()[4], value);
            this.reverseReadDepth = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasReverseReadDepth() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearReverseReadDepth() {
            this.reverseReadDepth = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public Integer getReferenceReadDepth() {
            return this.referenceReadDepth;
        }

        public Builder setReferenceReadDepth(Integer value) {
            this.validate(this.fields()[5], value);
            this.referenceReadDepth = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasReferenceReadDepth() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearReferenceReadDepth() {
            this.referenceReadDepth = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public Integer getReferenceForwardReadDepth() {
            return this.referenceForwardReadDepth;
        }

        public Builder setReferenceForwardReadDepth(Integer value) {
            this.validate(this.fields()[6], value);
            this.referenceForwardReadDepth = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasReferenceForwardReadDepth() {
            return this.fieldSetFlags()[6];
        }

        public Builder clearReferenceForwardReadDepth() {
            this.referenceForwardReadDepth = null;
            this.fieldSetFlags()[6] = false;
            return this;
        }

        public Integer getReferenceReverseReadDepth() {
            return this.referenceReverseReadDepth;
        }

        public Builder setReferenceReverseReadDepth(Integer value) {
            this.validate(this.fields()[7], value);
            this.referenceReverseReadDepth = value;
            this.fieldSetFlags()[7] = true;
            return this;
        }

        public boolean hasReferenceReverseReadDepth() {
            return this.fieldSetFlags()[7];
        }

        public Builder clearReferenceReverseReadDepth() {
            this.referenceReverseReadDepth = null;
            this.fieldSetFlags()[7] = false;
            return this;
        }

        public Float getAlleleFrequency() {
            return this.alleleFrequency;
        }

        public Builder setAlleleFrequency(Float value) {
            this.validate(this.fields()[8], value);
            this.alleleFrequency = value;
            this.fieldSetFlags()[8] = true;
            return this;
        }

        public boolean hasAlleleFrequency() {
            return this.fieldSetFlags()[8];
        }

        public Builder clearAlleleFrequency() {
            this.alleleFrequency = null;
            this.fieldSetFlags()[8] = false;
            return this;
        }

        public String getCigar() {
            return this.cigar;
        }

        public Builder setCigar(String value) {
            this.validate(this.fields()[9], value);
            this.cigar = value;
            this.fieldSetFlags()[9] = true;
            return this;
        }

        public boolean hasCigar() {
            return this.fieldSetFlags()[9];
        }

        public Builder clearCigar() {
            this.cigar = null;
            this.fieldSetFlags()[9] = false;
            return this;
        }

        public Boolean getDbSnp() {
            return this.dbSnp;
        }

        public Builder setDbSnp(Boolean value) {
            this.validate(this.fields()[10], value);
            this.dbSnp = value;
            this.fieldSetFlags()[10] = true;
            return this;
        }

        public boolean hasDbSnp() {
            return this.fieldSetFlags()[10];
        }

        public Builder clearDbSnp() {
            this.dbSnp = null;
            this.fieldSetFlags()[10] = false;
            return this;
        }

        public Boolean getHapMap2() {
            return this.hapMap2;
        }

        public Builder setHapMap2(Boolean value) {
            this.validate(this.fields()[11], value);
            this.hapMap2 = value;
            this.fieldSetFlags()[11] = true;
            return this;
        }

        public boolean hasHapMap2() {
            return this.fieldSetFlags()[11];
        }

        public Builder clearHapMap2() {
            this.hapMap2 = null;
            this.fieldSetFlags()[11] = false;
            return this;
        }

        public Boolean getHapMap3() {
            return this.hapMap3;
        }

        public Builder setHapMap3(Boolean value) {
            this.validate(this.fields()[12], value);
            this.hapMap3 = value;
            this.fieldSetFlags()[12] = true;
            return this;
        }

        public boolean hasHapMap3() {
            return this.fieldSetFlags()[12];
        }

        public Builder clearHapMap3() {
            this.hapMap3 = null;
            this.fieldSetFlags()[12] = false;
            return this;
        }

        public Boolean getValidated() {
            return this.validated;
        }

        public Builder setValidated(Boolean value) {
            this.validate(this.fields()[13], value);
            this.validated = value;
            this.fieldSetFlags()[13] = true;
            return this;
        }

        public boolean hasValidated() {
            return this.fieldSetFlags()[13];
        }

        public Builder clearValidated() {
            this.validated = null;
            this.fieldSetFlags()[13] = false;
            return this;
        }

        public Boolean getThousandGenomes() {
            return this.thousandGenomes;
        }

        public Builder setThousandGenomes(Boolean value) {
            this.validate(this.fields()[14], value);
            this.thousandGenomes = value;
            this.fieldSetFlags()[14] = true;
            return this;
        }

        public boolean hasThousandGenomes() {
            return this.fieldSetFlags()[14];
        }

        public Builder clearThousandGenomes() {
            this.thousandGenomes = null;
            this.fieldSetFlags()[14] = false;
            return this;
        }

        public Boolean getSomatic() {
            return this.somatic;
        }

        public Builder setSomatic(Boolean value) {
            this.validate(this.fields()[15], value);
            this.somatic = value;
            this.fieldSetFlags()[15] = true;
            return this;
        }

        public boolean hasSomatic() {
            return this.fieldSetFlags()[15];
        }

        public Builder clearSomatic() {
            this.somatic = null;
            this.fieldSetFlags()[15] = false;
            return this;
        }

        public List<TranscriptEffect> getTranscriptEffects() {
            return this.transcriptEffects;
        }

        public Builder setTranscriptEffects(List<TranscriptEffect> value) {
            this.validate(this.fields()[16], value);
            this.transcriptEffects = value;
            this.fieldSetFlags()[16] = true;
            return this;
        }

        public boolean hasTranscriptEffects() {
            return this.fieldSetFlags()[16];
        }

        public Builder clearTranscriptEffects() {
            this.transcriptEffects = null;
            this.fieldSetFlags()[16] = false;
            return this;
        }

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public Builder setAttributes(Map<String, String> value) {
            this.validate(this.fields()[17], value);
            this.attributes = value;
            this.fieldSetFlags()[17] = true;
            return this;
        }

        public boolean hasAttributes() {
            return this.fieldSetFlags()[17];
        }

        public Builder clearAttributes() {
            this.attributes = null;
            this.fieldSetFlags()[17] = false;
            return this;
        }

        public VariantAnnotation build() {
            try {
                VariantAnnotation record = new VariantAnnotation();
                record.ancestralAllele = this.fieldSetFlags()[0] ? this.ancestralAllele : (String)this.defaultValue(this.fields()[0]);
                record.alleleCount = this.fieldSetFlags()[1] ? this.alleleCount : (Integer)this.defaultValue(this.fields()[1]);
                record.readDepth = this.fieldSetFlags()[2] ? this.readDepth : (Integer)this.defaultValue(this.fields()[2]);
                record.forwardReadDepth = this.fieldSetFlags()[3] ? this.forwardReadDepth : (Integer)this.defaultValue(this.fields()[3]);
                record.reverseReadDepth = this.fieldSetFlags()[4] ? this.reverseReadDepth : (Integer)this.defaultValue(this.fields()[4]);
                record.referenceReadDepth = this.fieldSetFlags()[5] ? this.referenceReadDepth : (Integer)this.defaultValue(this.fields()[5]);
                record.referenceForwardReadDepth = this.fieldSetFlags()[6] ? this.referenceForwardReadDepth : (Integer)this.defaultValue(this.fields()[6]);
                record.referenceReverseReadDepth = this.fieldSetFlags()[7] ? this.referenceReverseReadDepth : (Integer)this.defaultValue(this.fields()[7]);
                record.alleleFrequency = this.fieldSetFlags()[8] ? this.alleleFrequency : (Float)this.defaultValue(this.fields()[8]);
                record.cigar = this.fieldSetFlags()[9] ? this.cigar : (String)this.defaultValue(this.fields()[9]);
                record.dbSnp = this.fieldSetFlags()[10] ? this.dbSnp : (Boolean)this.defaultValue(this.fields()[10]);
                record.hapMap2 = this.fieldSetFlags()[11] ? this.hapMap2 : (Boolean)this.defaultValue(this.fields()[11]);
                record.hapMap3 = this.fieldSetFlags()[12] ? this.hapMap3 : (Boolean)this.defaultValue(this.fields()[12]);
                record.validated = this.fieldSetFlags()[13] ? this.validated : (Boolean)this.defaultValue(this.fields()[13]);
                record.thousandGenomes = this.fieldSetFlags()[14] ? this.thousandGenomes : (Boolean)this.defaultValue(this.fields()[14]);
                record.somatic = this.fieldSetFlags()[15] ? this.somatic : (Boolean)this.defaultValue(this.fields()[15]);
                record.transcriptEffects = this.fieldSetFlags()[16] ? this.transcriptEffects : (List)this.defaultValue(this.fields()[16]);
                record.attributes = this.fieldSetFlags()[17] ? this.attributes : (Map)this.defaultValue(this.fields()[17]);
                return record;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

