/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.formats.avro;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class VariantCallingAnnotations
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 4610292182424272473L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"VariantCallingAnnotations\",\"namespace\":\"org.bdgenomics.formats.avro\",\"doc\":\"This record represents all stats that, inside a VCF, are stored outside of the\\n sample but are computed based on the samples. For instance, MAPQ0 is an aggregate\\n stat computed from all samples and stored inside the INFO line.\",\"fields\":[{\"name\":\"filtersApplied\",\"type\":[\"null\",\"boolean\"],\"doc\":\"True if filters were applied for this genotype call. FORMAT field \\\"FT\\\" any value other\\n   than the missing value.\",\"default\":null},{\"name\":\"filtersPassed\",\"type\":[\"null\",\"boolean\"],\"doc\":\"True if all filters for this genotype call passed. FORMAT field \\\"FT\\\" value PASS.\",\"default\":null},{\"name\":\"filtersFailed\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},\"doc\":\"Zero or more filters that failed for this genotype call from FORMAT field \\\"FT\\\".\",\"default\":[]},{\"name\":\"downsampled\",\"type\":[\"null\",\"boolean\"],\"doc\":\"True if the reads covering this site were randomly downsampled to reduce coverage.\",\"default\":null},{\"name\":\"baseQRankSum\",\"type\":[\"null\",\"float\"],\"doc\":\"The Wilcoxon rank-sum test statistic of the base quality scores. The base quality\\n   scores are separated by whether or not the base supports the reference or the\\n   alternate allele.\",\"default\":null},{\"name\":\"fisherStrandBiasPValue\",\"type\":[\"null\",\"float\"],\"doc\":\"The Fisher's exact test score for the strand bias of the reference and alternate\\n   alleles. Stored as a phred scaled probability. Thus, if:\\n\\n   * a = The number of positive strand reads covering the reference allele\\n   * b = The number of positive strand reads covering the alternate allele\\n   * c = The number of negative strand reads covering the reference allele\\n   * d = The number of negative strand reads covering the alternate allele\\n\\n   This value takes the score:\\n   \\n   -10 log((a + b)! * (c + d)! * (a + c)! * (b + d)! / (a! b! c! d! n!)\\n\\n   Where n = a + b + c + d.\",\"default\":null},{\"name\":\"rmsMapQ\",\"type\":[\"null\",\"float\"],\"doc\":\"The root mean square of the mapping qualities of reads covering this site.\",\"default\":null},{\"name\":\"mapq0Reads\",\"type\":[\"null\",\"int\"],\"doc\":\"The number of reads at this site with mapping quality equal to 0.\",\"default\":null},{\"name\":\"mqRankSum\",\"type\":[\"null\",\"float\"],\"doc\":\"The Wilcoxon rank-sum test statistic of the mapping quality scores. The mapping\\n   quality scores are separated by whether or not the read supported the reference or the\\n   alternate allele.\",\"default\":null},{\"name\":\"readPositionRankSum\",\"type\":[\"null\",\"float\"],\"doc\":\"The Wilcoxon rank-sum test statistic of the position of the base in the read at this site.\\n   The positions are separated by whether or not the base supports the reference or the\\n   alternate allele.\",\"default\":null},{\"name\":\"genotypePriors\",\"type\":{\"type\":\"array\",\"items\":\"float\"},\"doc\":\"The log scale prior probabilities of the various genotype states at this site.\\n   The number of elements in this array should be equal to the ploidy at this\\n   site, plus 1.\",\"default\":[]},{\"name\":\"genotypePosteriors\",\"type\":{\"type\":\"array\",\"items\":\"float\"},\"doc\":\"The log scaled posterior probabilities of the various genotype states at this site,\\n   in this sample. The number of elements in this array should be equal to the ploidy at\\n   this site, plus 1.\",\"default\":[]},{\"name\":\"vqslod\",\"type\":[\"null\",\"float\"],\"doc\":\"The log-odds ratio of being a true vs. false variant under a trained statistical model.\\n   This model can be a multivariate Gaussian mixture, support vector machine, etc.\",\"default\":null},{\"name\":\"culprit\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"If known, the feature that contributed the most to this variant being classified as\\n   a false variant.\",\"default\":null},{\"name\":\"attributes\",\"type\":{\"type\":\"map\",\"values\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"avro.java.string\":\"String\"},\"doc\":\"Additional feature info that doesn't fit into the standard fields above.\\n   They are all encoded as (string, string) key-value pairs.\",\"default\":{}}]}");
    private static SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<VariantCallingAnnotations> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<VariantCallingAnnotations> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    @Deprecated
    public Boolean filtersApplied;
    @Deprecated
    public Boolean filtersPassed;
    @Deprecated
    public List<String> filtersFailed;
    @Deprecated
    public Boolean downsampled;
    @Deprecated
    public Float baseQRankSum;
    @Deprecated
    public Float fisherStrandBiasPValue;
    @Deprecated
    public Float rmsMapQ;
    @Deprecated
    public Integer mapq0Reads;
    @Deprecated
    public Float mqRankSum;
    @Deprecated
    public Float readPositionRankSum;
    @Deprecated
    public List<Float> genotypePriors;
    @Deprecated
    public List<Float> genotypePosteriors;
    @Deprecated
    public Float vqslod;
    @Deprecated
    public String culprit;
    @Deprecated
    public Map<String, String> attributes;
    private static final DatumWriter<VariantCallingAnnotations> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<VariantCallingAnnotations> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageDecoder<VariantCallingAnnotations> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<VariantCallingAnnotations> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static VariantCallingAnnotations fromByteBuffer(ByteBuffer b) throws IOException {
        return (VariantCallingAnnotations)((Object)DECODER.decode(b));
    }

    public VariantCallingAnnotations() {
    }

    public VariantCallingAnnotations(Boolean filtersApplied, Boolean filtersPassed, List<String> filtersFailed, Boolean downsampled, Float baseQRankSum, Float fisherStrandBiasPValue, Float rmsMapQ, Integer mapq0Reads, Float mqRankSum, Float readPositionRankSum, List<Float> genotypePriors, List<Float> genotypePosteriors, Float vqslod, String culprit, Map<String, String> attributes) {
        this.filtersApplied = filtersApplied;
        this.filtersPassed = filtersPassed;
        this.filtersFailed = filtersFailed;
        this.downsampled = downsampled;
        this.baseQRankSum = baseQRankSum;
        this.fisherStrandBiasPValue = fisherStrandBiasPValue;
        this.rmsMapQ = rmsMapQ;
        this.mapq0Reads = mapq0Reads;
        this.mqRankSum = mqRankSum;
        this.readPositionRankSum = readPositionRankSum;
        this.genotypePriors = genotypePriors;
        this.genotypePosteriors = genotypePosteriors;
        this.vqslod = vqslod;
        this.culprit = culprit;
        this.attributes = attributes;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.filtersApplied;
            }
            case 1: {
                return this.filtersPassed;
            }
            case 2: {
                return this.filtersFailed;
            }
            case 3: {
                return this.downsampled;
            }
            case 4: {
                return this.baseQRankSum;
            }
            case 5: {
                return this.fisherStrandBiasPValue;
            }
            case 6: {
                return this.rmsMapQ;
            }
            case 7: {
                return this.mapq0Reads;
            }
            case 8: {
                return this.mqRankSum;
            }
            case 9: {
                return this.readPositionRankSum;
            }
            case 10: {
                return this.genotypePriors;
            }
            case 11: {
                return this.genotypePosteriors;
            }
            case 12: {
                return this.vqslod;
            }
            case 13: {
                return this.culprit;
            }
            case 14: {
                return this.attributes;
            }
        }
        throw new AvroRuntimeException("Bad index");
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.filtersApplied = (Boolean)value$;
                break;
            }
            case 1: {
                this.filtersPassed = (Boolean)value$;
                break;
            }
            case 2: {
                this.filtersFailed = (List)value$;
                break;
            }
            case 3: {
                this.downsampled = (Boolean)value$;
                break;
            }
            case 4: {
                this.baseQRankSum = (Float)value$;
                break;
            }
            case 5: {
                this.fisherStrandBiasPValue = (Float)value$;
                break;
            }
            case 6: {
                this.rmsMapQ = (Float)value$;
                break;
            }
            case 7: {
                this.mapq0Reads = (Integer)value$;
                break;
            }
            case 8: {
                this.mqRankSum = (Float)value$;
                break;
            }
            case 9: {
                this.readPositionRankSum = (Float)value$;
                break;
            }
            case 10: {
                this.genotypePriors = (List)value$;
                break;
            }
            case 11: {
                this.genotypePosteriors = (List)value$;
                break;
            }
            case 12: {
                this.vqslod = (Float)value$;
                break;
            }
            case 13: {
                this.culprit = (String)value$;
                break;
            }
            case 14: {
                this.attributes = (Map)value$;
                break;
            }
            default: {
                throw new AvroRuntimeException("Bad index");
            }
        }
    }

    public Boolean getFiltersApplied() {
        return this.filtersApplied;
    }

    public void setFiltersApplied(Boolean value) {
        this.filtersApplied = value;
    }

    public Boolean getFiltersPassed() {
        return this.filtersPassed;
    }

    public void setFiltersPassed(Boolean value) {
        this.filtersPassed = value;
    }

    public List<String> getFiltersFailed() {
        return this.filtersFailed;
    }

    public void setFiltersFailed(List<String> value) {
        this.filtersFailed = value;
    }

    public Boolean getDownsampled() {
        return this.downsampled;
    }

    public void setDownsampled(Boolean value) {
        this.downsampled = value;
    }

    public Float getBaseQRankSum() {
        return this.baseQRankSum;
    }

    public void setBaseQRankSum(Float value) {
        this.baseQRankSum = value;
    }

    public Float getFisherStrandBiasPValue() {
        return this.fisherStrandBiasPValue;
    }

    public void setFisherStrandBiasPValue(Float value) {
        this.fisherStrandBiasPValue = value;
    }

    public Float getRmsMapQ() {
        return this.rmsMapQ;
    }

    public void setRmsMapQ(Float value) {
        this.rmsMapQ = value;
    }

    public Integer getMapq0Reads() {
        return this.mapq0Reads;
    }

    public void setMapq0Reads(Integer value) {
        this.mapq0Reads = value;
    }

    public Float getMqRankSum() {
        return this.mqRankSum;
    }

    public void setMqRankSum(Float value) {
        this.mqRankSum = value;
    }

    public Float getReadPositionRankSum() {
        return this.readPositionRankSum;
    }

    public void setReadPositionRankSum(Float value) {
        this.readPositionRankSum = value;
    }

    public List<Float> getGenotypePriors() {
        return this.genotypePriors;
    }

    public void setGenotypePriors(List<Float> value) {
        this.genotypePriors = value;
    }

    public List<Float> getGenotypePosteriors() {
        return this.genotypePosteriors;
    }

    public void setGenotypePosteriors(List<Float> value) {
        this.genotypePosteriors = value;
    }

    public Float getVqslod() {
        return this.vqslod;
    }

    public void setVqslod(Float value) {
        this.vqslod = value;
    }

    public String getCulprit() {
        return this.culprit;
    }

    public void setCulprit(String value) {
        this.culprit = value;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> value) {
        this.attributes = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        return new Builder(other);
    }

    public static Builder newBuilder(VariantCallingAnnotations other) {
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    public static class Builder
    extends SpecificRecordBuilderBase<VariantCallingAnnotations>
    implements RecordBuilder<VariantCallingAnnotations> {
        private Boolean filtersApplied;
        private Boolean filtersPassed;
        private List<String> filtersFailed;
        private Boolean downsampled;
        private Float baseQRankSum;
        private Float fisherStrandBiasPValue;
        private Float rmsMapQ;
        private Integer mapq0Reads;
        private Float mqRankSum;
        private Float readPositionRankSum;
        private List<Float> genotypePriors;
        private List<Float> genotypePosteriors;
        private Float vqslod;
        private String culprit;
        private Map<String, String> attributes;

        private Builder() {
            super(SCHEMA$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.filtersApplied)) {
                this.filtersApplied = (Boolean)this.data().deepCopy(this.fields()[0].schema(), (Object)other.filtersApplied);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.filtersPassed)) {
                this.filtersPassed = (Boolean)this.data().deepCopy(this.fields()[1].schema(), (Object)other.filtersPassed);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], other.filtersFailed)) {
                this.filtersFailed = (List)this.data().deepCopy(this.fields()[2].schema(), other.filtersFailed);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.downsampled)) {
                this.downsampled = (Boolean)this.data().deepCopy(this.fields()[3].schema(), (Object)other.downsampled);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.baseQRankSum)) {
                this.baseQRankSum = (Float)this.data().deepCopy(this.fields()[4].schema(), (Object)other.baseQRankSum);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.fisherStrandBiasPValue)) {
                this.fisherStrandBiasPValue = (Float)this.data().deepCopy(this.fields()[5].schema(), (Object)other.fisherStrandBiasPValue);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.rmsMapQ)) {
                this.rmsMapQ = (Float)this.data().deepCopy(this.fields()[6].schema(), (Object)other.rmsMapQ);
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.mapq0Reads)) {
                this.mapq0Reads = (Integer)this.data().deepCopy(this.fields()[7].schema(), (Object)other.mapq0Reads);
                this.fieldSetFlags()[7] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.mqRankSum)) {
                this.mqRankSum = (Float)this.data().deepCopy(this.fields()[8].schema(), (Object)other.mqRankSum);
                this.fieldSetFlags()[8] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.readPositionRankSum)) {
                this.readPositionRankSum = (Float)this.data().deepCopy(this.fields()[9].schema(), (Object)other.readPositionRankSum);
                this.fieldSetFlags()[9] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], other.genotypePriors)) {
                this.genotypePriors = (List)this.data().deepCopy(this.fields()[10].schema(), other.genotypePriors);
                this.fieldSetFlags()[10] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[11], other.genotypePosteriors)) {
                this.genotypePosteriors = (List)this.data().deepCopy(this.fields()[11].schema(), other.genotypePosteriors);
                this.fieldSetFlags()[11] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[12], (Object)other.vqslod)) {
                this.vqslod = (Float)this.data().deepCopy(this.fields()[12].schema(), (Object)other.vqslod);
                this.fieldSetFlags()[12] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[13], (Object)other.culprit)) {
                this.culprit = (String)this.data().deepCopy(this.fields()[13].schema(), (Object)other.culprit);
                this.fieldSetFlags()[13] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[14], other.attributes)) {
                this.attributes = (Map)this.data().deepCopy(this.fields()[14].schema(), other.attributes);
                this.fieldSetFlags()[14] = true;
            }
        }

        private Builder(VariantCallingAnnotations other) {
            super(SCHEMA$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.filtersApplied)) {
                this.filtersApplied = (Boolean)this.data().deepCopy(this.fields()[0].schema(), (Object)other.filtersApplied);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.filtersPassed)) {
                this.filtersPassed = (Boolean)this.data().deepCopy(this.fields()[1].schema(), (Object)other.filtersPassed);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], other.filtersFailed)) {
                this.filtersFailed = (List)this.data().deepCopy(this.fields()[2].schema(), other.filtersFailed);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.downsampled)) {
                this.downsampled = (Boolean)this.data().deepCopy(this.fields()[3].schema(), (Object)other.downsampled);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.baseQRankSum)) {
                this.baseQRankSum = (Float)this.data().deepCopy(this.fields()[4].schema(), (Object)other.baseQRankSum);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.fisherStrandBiasPValue)) {
                this.fisherStrandBiasPValue = (Float)this.data().deepCopy(this.fields()[5].schema(), (Object)other.fisherStrandBiasPValue);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.rmsMapQ)) {
                this.rmsMapQ = (Float)this.data().deepCopy(this.fields()[6].schema(), (Object)other.rmsMapQ);
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.mapq0Reads)) {
                this.mapq0Reads = (Integer)this.data().deepCopy(this.fields()[7].schema(), (Object)other.mapq0Reads);
                this.fieldSetFlags()[7] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.mqRankSum)) {
                this.mqRankSum = (Float)this.data().deepCopy(this.fields()[8].schema(), (Object)other.mqRankSum);
                this.fieldSetFlags()[8] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.readPositionRankSum)) {
                this.readPositionRankSum = (Float)this.data().deepCopy(this.fields()[9].schema(), (Object)other.readPositionRankSum);
                this.fieldSetFlags()[9] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], other.genotypePriors)) {
                this.genotypePriors = (List)this.data().deepCopy(this.fields()[10].schema(), other.genotypePriors);
                this.fieldSetFlags()[10] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[11], other.genotypePosteriors)) {
                this.genotypePosteriors = (List)this.data().deepCopy(this.fields()[11].schema(), other.genotypePosteriors);
                this.fieldSetFlags()[11] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[12], (Object)other.vqslod)) {
                this.vqslod = (Float)this.data().deepCopy(this.fields()[12].schema(), (Object)other.vqslod);
                this.fieldSetFlags()[12] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[13], (Object)other.culprit)) {
                this.culprit = (String)this.data().deepCopy(this.fields()[13].schema(), (Object)other.culprit);
                this.fieldSetFlags()[13] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[14], other.attributes)) {
                this.attributes = (Map)this.data().deepCopy(this.fields()[14].schema(), other.attributes);
                this.fieldSetFlags()[14] = true;
            }
        }

        public Boolean getFiltersApplied() {
            return this.filtersApplied;
        }

        public Builder setFiltersApplied(Boolean value) {
            this.validate(this.fields()[0], value);
            this.filtersApplied = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasFiltersApplied() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearFiltersApplied() {
            this.filtersApplied = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public Boolean getFiltersPassed() {
            return this.filtersPassed;
        }

        public Builder setFiltersPassed(Boolean value) {
            this.validate(this.fields()[1], value);
            this.filtersPassed = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasFiltersPassed() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearFiltersPassed() {
            this.filtersPassed = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public List<String> getFiltersFailed() {
            return this.filtersFailed;
        }

        public Builder setFiltersFailed(List<String> value) {
            this.validate(this.fields()[2], value);
            this.filtersFailed = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasFiltersFailed() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearFiltersFailed() {
            this.filtersFailed = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public Boolean getDownsampled() {
            return this.downsampled;
        }

        public Builder setDownsampled(Boolean value) {
            this.validate(this.fields()[3], value);
            this.downsampled = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasDownsampled() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearDownsampled() {
            this.downsampled = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public Float getBaseQRankSum() {
            return this.baseQRankSum;
        }

        public Builder setBaseQRankSum(Float value) {
            this.validate(this.fields()[4], value);
            this.baseQRankSum = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasBaseQRankSum() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearBaseQRankSum() {
            this.baseQRankSum = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public Float getFisherStrandBiasPValue() {
            return this.fisherStrandBiasPValue;
        }

        public Builder setFisherStrandBiasPValue(Float value) {
            this.validate(this.fields()[5], value);
            this.fisherStrandBiasPValue = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasFisherStrandBiasPValue() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearFisherStrandBiasPValue() {
            this.fisherStrandBiasPValue = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public Float getRmsMapQ() {
            return this.rmsMapQ;
        }

        public Builder setRmsMapQ(Float value) {
            this.validate(this.fields()[6], value);
            this.rmsMapQ = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasRmsMapQ() {
            return this.fieldSetFlags()[6];
        }

        public Builder clearRmsMapQ() {
            this.rmsMapQ = null;
            this.fieldSetFlags()[6] = false;
            return this;
        }

        public Integer getMapq0Reads() {
            return this.mapq0Reads;
        }

        public Builder setMapq0Reads(Integer value) {
            this.validate(this.fields()[7], value);
            this.mapq0Reads = value;
            this.fieldSetFlags()[7] = true;
            return this;
        }

        public boolean hasMapq0Reads() {
            return this.fieldSetFlags()[7];
        }

        public Builder clearMapq0Reads() {
            this.mapq0Reads = null;
            this.fieldSetFlags()[7] = false;
            return this;
        }

        public Float getMqRankSum() {
            return this.mqRankSum;
        }

        public Builder setMqRankSum(Float value) {
            this.validate(this.fields()[8], value);
            this.mqRankSum = value;
            this.fieldSetFlags()[8] = true;
            return this;
        }

        public boolean hasMqRankSum() {
            return this.fieldSetFlags()[8];
        }

        public Builder clearMqRankSum() {
            this.mqRankSum = null;
            this.fieldSetFlags()[8] = false;
            return this;
        }

        public Float getReadPositionRankSum() {
            return this.readPositionRankSum;
        }

        public Builder setReadPositionRankSum(Float value) {
            this.validate(this.fields()[9], value);
            this.readPositionRankSum = value;
            this.fieldSetFlags()[9] = true;
            return this;
        }

        public boolean hasReadPositionRankSum() {
            return this.fieldSetFlags()[9];
        }

        public Builder clearReadPositionRankSum() {
            this.readPositionRankSum = null;
            this.fieldSetFlags()[9] = false;
            return this;
        }

        public List<Float> getGenotypePriors() {
            return this.genotypePriors;
        }

        public Builder setGenotypePriors(List<Float> value) {
            this.validate(this.fields()[10], value);
            this.genotypePriors = value;
            this.fieldSetFlags()[10] = true;
            return this;
        }

        public boolean hasGenotypePriors() {
            return this.fieldSetFlags()[10];
        }

        public Builder clearGenotypePriors() {
            this.genotypePriors = null;
            this.fieldSetFlags()[10] = false;
            return this;
        }

        public List<Float> getGenotypePosteriors() {
            return this.genotypePosteriors;
        }

        public Builder setGenotypePosteriors(List<Float> value) {
            this.validate(this.fields()[11], value);
            this.genotypePosteriors = value;
            this.fieldSetFlags()[11] = true;
            return this;
        }

        public boolean hasGenotypePosteriors() {
            return this.fieldSetFlags()[11];
        }

        public Builder clearGenotypePosteriors() {
            this.genotypePosteriors = null;
            this.fieldSetFlags()[11] = false;
            return this;
        }

        public Float getVqslod() {
            return this.vqslod;
        }

        public Builder setVqslod(Float value) {
            this.validate(this.fields()[12], value);
            this.vqslod = value;
            this.fieldSetFlags()[12] = true;
            return this;
        }

        public boolean hasVqslod() {
            return this.fieldSetFlags()[12];
        }

        public Builder clearVqslod() {
            this.vqslod = null;
            this.fieldSetFlags()[12] = false;
            return this;
        }

        public String getCulprit() {
            return this.culprit;
        }

        public Builder setCulprit(String value) {
            this.validate(this.fields()[13], value);
            this.culprit = value;
            this.fieldSetFlags()[13] = true;
            return this;
        }

        public boolean hasCulprit() {
            return this.fieldSetFlags()[13];
        }

        public Builder clearCulprit() {
            this.culprit = null;
            this.fieldSetFlags()[13] = false;
            return this;
        }

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public Builder setAttributes(Map<String, String> value) {
            this.validate(this.fields()[14], value);
            this.attributes = value;
            this.fieldSetFlags()[14] = true;
            return this;
        }

        public boolean hasAttributes() {
            return this.fieldSetFlags()[14];
        }

        public Builder clearAttributes() {
            this.attributes = null;
            this.fieldSetFlags()[14] = false;
            return this;
        }

        public VariantCallingAnnotations build() {
            try {
                VariantCallingAnnotations record = new VariantCallingAnnotations();
                record.filtersApplied = this.fieldSetFlags()[0] ? this.filtersApplied : (Boolean)this.defaultValue(this.fields()[0]);
                record.filtersPassed = this.fieldSetFlags()[1] ? this.filtersPassed : (Boolean)this.defaultValue(this.fields()[1]);
                record.filtersFailed = this.fieldSetFlags()[2] ? this.filtersFailed : (List)this.defaultValue(this.fields()[2]);
                record.downsampled = this.fieldSetFlags()[3] ? this.downsampled : (Boolean)this.defaultValue(this.fields()[3]);
                record.baseQRankSum = this.fieldSetFlags()[4] ? this.baseQRankSum : (Float)this.defaultValue(this.fields()[4]);
                record.fisherStrandBiasPValue = this.fieldSetFlags()[5] ? this.fisherStrandBiasPValue : (Float)this.defaultValue(this.fields()[5]);
                record.rmsMapQ = this.fieldSetFlags()[6] ? this.rmsMapQ : (Float)this.defaultValue(this.fields()[6]);
                record.mapq0Reads = this.fieldSetFlags()[7] ? this.mapq0Reads : (Integer)this.defaultValue(this.fields()[7]);
                record.mqRankSum = this.fieldSetFlags()[8] ? this.mqRankSum : (Float)this.defaultValue(this.fields()[8]);
                record.readPositionRankSum = this.fieldSetFlags()[9] ? this.readPositionRankSum : (Float)this.defaultValue(this.fields()[9]);
                record.genotypePriors = this.fieldSetFlags()[10] ? this.genotypePriors : (List)this.defaultValue(this.fields()[10]);
                record.genotypePosteriors = this.fieldSetFlags()[11] ? this.genotypePosteriors : (List)this.defaultValue(this.fields()[11]);
                record.vqslod = this.fieldSetFlags()[12] ? this.vqslod : (Float)this.defaultValue(this.fields()[12]);
                record.culprit = this.fieldSetFlags()[13] ? this.culprit : (String)this.defaultValue(this.fields()[13]);
                record.attributes = this.fieldSetFlags()[14] ? this.attributes : (Map)this.defaultValue(this.fields()[14]);
                return record;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

