/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.adam;

import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.spark.rdd.RDD;
import org.bdgenomics.adam.ds.ADAMContext;
import org.bdgenomics.adam.ds.feature.FeatureDataset;
import org.bdgenomics.adam.ds.feature.FeatureDataset$;
import org.bdgenomics.adam.ds.read.ReadDataset;
import org.bdgenomics.adam.ds.read.ReadDataset$;
import org.bdgenomics.adam.ds.sequence.SequenceDataset;
import org.bdgenomics.adam.ds.sequence.SequenceDataset$;
import org.bdgenomics.convert.ConversionStringency;
import org.bdgenomics.convert.Converter;
import org.bdgenomics.formats.avro.Feature;
import org.bdgenomics.formats.avro.Read;
import org.bdgenomics.formats.avro.Sequence;
import org.biojava.nbio.adam.BiojavaAdamContext$;
import org.biojava.nbio.adam.TryWith$;
import org.biojava.nbio.core.sequence.DNASequence;
import org.biojava.nbio.core.sequence.ProteinSequence;
import org.biojava.nbio.core.sequence.RNASequence;
import org.biojava.nbio.core.sequence.compound.AmbiguityDNACompoundSet;
import org.biojava.nbio.core.sequence.compound.AmbiguityRNACompoundSet;
import org.biojava.nbio.core.sequence.io.DNASequenceCreator;
import org.biojava.nbio.core.sequence.io.FastaReader;
import org.biojava.nbio.core.sequence.io.FastaReaderHelper;
import org.biojava.nbio.core.sequence.io.GenbankReader;
import org.biojava.nbio.core.sequence.io.GenbankReaderHelper;
import org.biojava.nbio.core.sequence.io.GenericFastaHeaderParser;
import org.biojava.nbio.core.sequence.io.GenericGenbankHeaderParser;
import org.biojava.nbio.core.sequence.io.RNASequenceCreator;
import org.biojava.nbio.genome.io.fastq.Fastq;
import org.biojava.nbio.genome.io.fastq.SangerFastqReader;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\t\ru!\u0002\u00192\u0011\u0003Qd!\u0002\u001f2\u0011\u0003i\u0004\"B$\u0002\t\u0003A\u0005\"B%\u0002\t\u0003Q\u0005\"\u0003B:\u0003\u0005\u0005I\u0011\u0002B;\r\u0011a\u0014\u0007\u0001'\t\u0011U+!Q1A\u0005\u0002YC\u0001\u0002Y\u0003\u0003\u0002\u0003\u0006Ia\u0016\u0005\tK\u0016\u0011)\u0019!C\u0001M\"Aq0\u0002B\u0001B\u0003%q\r\u0003\u0006\u0002\u0002\u0015\u0011)\u0019!C\u0001\u0003\u0007A!\"!\b\u0006\u0005\u0003\u0005\u000b\u0011BA\u0003\u0011)\ty\"\u0002BC\u0002\u0013\u0005\u0011\u0011\u0005\u0005\u000b\u0003w)!\u0011!Q\u0001\n\u0005\r\u0002BCA\u001f\u000b\t\u0015\r\u0011\"\u0001\u0002@!Q\u0011\u0011J\u0003\u0003\u0002\u0003\u0006I!!\u0011\t\u0015\u0005-SA!b\u0001\n\u0003\ti\u0005\u0003\u0006\u0002R\u0015\u0011\t\u0011)A\u0005\u0003\u001fB!\"a\u0015\u0006\u0005\u000b\u0007I\u0011AA+\u0011)\ty&\u0002B\u0001B\u0003%\u0011q\u000b\u0005\u000b\u0003C*!Q1A\u0005\u0002\u0005\r\u0004BCA4\u000b\t\u0005\t\u0015!\u0003\u0002f!1q)\u0002C\u0001\u0003SBq!a\u001f\u0006\t\u0003\ti\bC\u0004\u0002&\u0016!\t!a*\t\u000f\u0005-V\u0001\"\u0001\u0002.\"9\u00111X\u0003\u0005\u0002\u0005u\u0006bBAa\u000b\u0011\u0005\u00111\u0019\u0005\b\u0003\u000f,A\u0011AAe\u0011\u001d\ti-\u0002C\u0001\u0003\u001fDq!a5\u0006\t\u0003\t)\u000eC\u0004\u0002f\u0016!\t!a:\t\u000f\u0005-X\u0001\"\u0001\u0002n\"9\u0011\u0011_\u0003\u0005\u0002\u0005M\bbBA|\u000b\u0011\u0005\u0011\u0011 \u0005\b\u0003{,A\u0011AA\u0000\u0011\u001d\u0011\u0019!\u0002C\u0001\u0005\u000bAqA!\u0003\u0006\t\u0003\u0011Y\u0001C\u0004\u0003\u0010\u0015!\tA!\u0005\t\u000f\tUQ\u0001\"\u0001\u0003\u0018!9!1D\u0003\u0005\n\tu\u0001b\u0002B\u0017\u000b\u0011%!q\u0006\u0005\b\u0005\u000f*A\u0011\u0002B%\u0011\u001d\u0011y%\u0002C\u0005\u0005#BqAa\u0016\u0006\t\u0013\u0011I\u0006C\u0004\u0003`\u0015!IA!\u0019\t\u000f\t\u0015T\u0001\"\u0003\u0003h!9!1N\u0003\u0005\n\t5\u0014A\u0005\"j_*\fg/Y!eC6\u001cuN\u001c;fqRT!AM\u001a\u0002\t\u0005$\u0017-\u001c\u0006\u0003iU\nAA\u001c2j_*\u0011agN\u0001\bE&|'.\u0019<b\u0015\u0005A\u0014aA8sO\u000e\u0001\u0001CA\u001e\u0002\u001b\u0005\t$A\u0005\"j_*\fg/Y!eC6\u001cuN\u001c;fqR\u001c2!\u0001 E!\ty$)D\u0001A\u0015\u0005\t\u0015!B:dC2\f\u0017BA\"A\u0005\u0019\te.\u001f*fMB\u0011q(R\u0005\u0003\r\u0002\u0013AbU3sS\u0006d\u0017N_1cY\u0016\fa\u0001P5oSRtD#\u0001\u001e\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0007-\u0013\t\b\u0005\u0002<\u000bM!QA\u0010#N!\tq5+D\u0001P\u0015\t\u0001\u0016+A\u0003tY\u001a$$NC\u0001S\u0003!9'/\u001b>{Y\u0016$\u0017B\u0001+P\u0005\u001daunZ4j]\u001e\f!!Y2\u0016\u0003]\u0003\"\u0001\u00170\u000e\u0003eS!AW.\u0002\u0005\u0011\u001c(B\u0001\u001a]\u0015\tiv'\u0001\u0006cI\u001e,gn\\7jGNL!aX-\u0003\u0017\u0005#\u0015)T\"p]R,\u0007\u0010^\u0001\u0004C\u000e\u0004\u0003FA\u0004c!\ty4-\u0003\u0002e\u0001\nIAO]1og&,g\u000e^\u0001\u000ee\u0016\fGmQ8om\u0016\u0014H/\u001a:\u0016\u0003\u001d\u0004B\u0001[6no6\t\u0011N\u0003\u0002k9\u000691m\u001c8wKJ$\u0018B\u00017j\u0005%\u0019uN\u001c<feR,'\u000f\u0005\u0002ok6\tqN\u0003\u0002qc\u0006)a-Y:uc*\u0011!o]\u0001\u0003S>T!\u0001^\u001a\u0002\r\u001d,gn\\7f\u0013\t1xNA\u0003GCN$\u0018\u000f\u0005\u0002y{6\t\u0011P\u0003\u0002{w\u0006!\u0011M\u001e:p\u0015\taH,A\u0004g_Jl\u0017\r^:\n\u0005yL(\u0001\u0002*fC\u0012\faB]3bI\u000e{gN^3si\u0016\u0014\b%\u0001\u000be]\u0006\u001cV-];f]\u000e,7i\u001c8wKJ$XM]\u000b\u0003\u0003\u000b\u0001b\u0001[6\u0002\b\u0005]\u0001\u0003BA\u0005\u0003'i!!a\u0003\u000b\t\u00055\u0011qB\u0001\tg\u0016\fX/\u001a8dK*\u0019\u0011\u0011C\u001a\u0002\t\r|'/Z\u0005\u0005\u0003+\tYAA\u0006E\u001d\u0006\u001bV-];f]\u000e,\u0007c\u0001=\u0002\u001a%\u0019\u00111D=\u0003\u0011M+\u0017/^3oG\u0016\fQ\u0003\u001a8b'\u0016\fX/\u001a8dK\u000e{gN^3si\u0016\u0014\b%\u0001\u000fe]\u0006\u001cV-];f]\u000e,g)Z1ukJ,7oQ8om\u0016\u0014H/\u001a:\u0016\u0005\u0005\r\u0002C\u00025l\u0003\u000f\t)\u0003\u0005\u0004\u0002(\u0005E\u0012QG\u0007\u0003\u0003SQA!a\u000b\u0002.\u0005!Q\u000f^5m\u0015\t\ty#\u0001\u0003kCZ\f\u0017\u0002BA\u001a\u0003S\u0011A\u0001T5tiB\u0019\u00010a\u000e\n\u0007\u0005e\u0012PA\u0004GK\u0006$XO]3\u0002;\u0011t\u0017mU3rk\u0016t7-\u001a$fCR,(/Z:D_:4XM\u001d;fe\u0002\n\u0001\u0004\u001d:pi\u0016LgnU3rk\u0016t7-Z\"p]Z,'\u000f^3s+\t\t\t\u0005\u0005\u0004iW\u0006\r\u0013q\u0003\t\u0005\u0003\u0013\t)%\u0003\u0003\u0002H\u0005-!a\u0004)s_R,\u0017N\\*fcV,gnY3\u00023A\u0014x\u000e^3j]N+\u0017/^3oG\u0016\u001cuN\u001c<feR,'\u000fI\u0001!aJ|G/Z5o'\u0016\fX/\u001a8dK\u001a+\u0017\r^;sKN\u001cuN\u001c<feR,'/\u0006\u0002\u0002PA1\u0001n[A\"\u0003K\t\u0011\u0005\u001d:pi\u0016LgnU3rk\u0016t7-\u001a$fCR,(/Z:D_:4XM\u001d;fe\u0002\nAC\u001d8b'\u0016\fX/\u001a8dK\u000e{gN^3si\u0016\u0014XCAA,!\u0019A7.!\u0017\u0002\u0018A!\u0011\u0011BA.\u0013\u0011\ti&a\u0003\u0003\u0017Is\u0015iU3rk\u0016t7-Z\u0001\u0016e:\f7+Z9vK:\u001cWmQ8om\u0016\u0014H/\u001a:!\u0003q\u0011h.Y*fcV,gnY3GK\u0006$XO]3t\u0007>tg/\u001a:uKJ,\"!!\u001a\u0011\r!\\\u0017\u0011LA\u0013\u0003u\u0011h.Y*fcV,gnY3GK\u0006$XO]3t\u0007>tg/\u001a:uKJ\u0004C#E&\u0002l\u00055\u0014qNA9\u0003g\n)(a\u001e\u0002z!)QK\u0006a\u0001/\")QM\u0006a\u0001O\"9\u0011\u0011\u0001\fA\u0002\u0005\u0015\u0001bBA\u0010-\u0001\u0007\u00111\u0005\u0005\b\u0003{1\u0002\u0019AA!\u0011\u001d\tYE\u0006a\u0001\u0003\u001fBq!a\u0015\u0017\u0001\u0004\t9\u0006C\u0004\u0002bY\u0001\r!!\u001a\u0002\u001d1|\u0017\r\u001a$bgR\f(+Z1egR!\u0011qPAF!\u0011\t\t)a\"\u000e\u0005\u0005\r%bAAC3\u0006!!/Z1e\u0013\u0011\tI)a!\u0003\u0017I+\u0017\r\u001a#bi\u0006\u001cX\r\u001e\u0005\b\u0003\u001b;\u0002\u0019AAH\u0003\u0011\u0001\u0018\r\u001e5\u0011\t\u0005E\u0015q\u0014\b\u0005\u0003'\u000bY\nE\u0002\u0002\u0016\u0002k!!a&\u000b\u0007\u0005e\u0015(\u0001\u0004=e>|GOP\u0005\u0004\u0003;\u0003\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002\"\u0006\r&AB*ue&twMC\u0002\u0002\u001e\u0002\u000bQ\u0003\\8bI\nKwN[1wC\u001a\u000b7\u000f^9SK\u0006$7\u000f\u0006\u0003\u0002\u0000\u0005%\u0006bBAG1\u0001\u0007\u0011qR\u0001\u0014Y>\fGMQ5pU\u00064\u0018MR1ti\u0006$e.\u0019\u000b\u0005\u0003_\u000bI\f\u0005\u0003\u00022\u0006UVBAAZ\u0015\r\ti!W\u0005\u0005\u0003o\u000b\u0019LA\bTKF,XM\\2f\t\u0006$\u0018m]3u\u0011\u001d\ti)\u0007a\u0001\u0003\u001f\u000bq\u0003\\8bI\nKwN[1wC\u001a\u000b7\u000f^1Qe>$X-\u001b8\u0015\t\u0005=\u0016q\u0018\u0005\b\u0003\u001bS\u0002\u0019AAH\u0003Maw.\u00193CS>T\u0017M^1GCN$\u0018M\u00158b)\u0011\ty+!2\t\u000f\u000555\u00041\u0001\u0002\u0010\u0006qAn\\1e\u000f\u0016t'-\u00198l\t:\fG\u0003BAX\u0003\u0017Dq!!$\u001d\u0001\u0004\ty)A\u000bm_\u0006$')[8kCZ\fw)\u001a8cC:\\GI\\1\u0015\t\u0005=\u0016\u0011\u001b\u0005\b\u0003\u001bk\u0002\u0019AAH\u0003Yaw.\u00193HK:\u0014\u0017M\\6E]\u00064U-\u0019;ve\u0016\u001cH\u0003BAl\u0003G\u0004B!!7\u0002`6\u0011\u00111\u001c\u0006\u0004\u0003;L\u0016a\u00024fCR,(/Z\u0005\u0005\u0003C\fYN\u0001\bGK\u0006$XO]3ECR\f7/\u001a;\t\u000f\u00055e\u00041\u0001\u0002\u0010\u0006iBn\\1e\u0005&|'.\u0019<b\u000f\u0016t'-\u00198l\t:\fg)Z1ukJ,7\u000f\u0006\u0003\u0002X\u0006%\bbBAG?\u0001\u0007\u0011qR\u0001\u0013Y>\fGmR3oE\u0006t7\u000e\u0015:pi\u0016Lg\u000e\u0006\u0003\u00020\u0006=\bbBAGA\u0001\u0007\u0011qR\u0001\u001aY>\fGMQ5pU\u00064\u0018mR3oE\u0006t7\u000e\u0015:pi\u0016Lg\u000e\u0006\u0003\u00020\u0006U\bbBAGC\u0001\u0007\u0011qR\u0001\u001bY>\fGmR3oE\u0006t7\u000e\u0015:pi\u0016LgNR3biV\u0014Xm\u001d\u000b\u0005\u0003/\fY\u0010C\u0004\u0002\u000e\n\u0002\r!a$\u0002C1|\u0017\r\u001a\"j_*\fg/Y$f]\n\fgn\u001b)s_R,\u0017N\u001c$fCR,(/Z:\u0015\t\u0005]'\u0011\u0001\u0005\b\u0003\u001b\u001b\u0003\u0019AAH\u00039aw.\u00193HK:\u0014\u0017M\\6S]\u0006$B!a,\u0003\b!9\u0011Q\u0012\u0013A\u0002\u0005=\u0015!\u00067pC\u0012\u0014\u0015n\u001c6bm\u0006<UM\u001c2b].\u0014f.\u0019\u000b\u0005\u0003_\u0013i\u0001C\u0004\u0002\u000e\u0016\u0002\r!a$\u0002-1|\u0017\rZ$f]\n\fgn\u001b*oC\u001a+\u0017\r^;sKN$B!a6\u0003\u0014!9\u0011Q\u0012\u0014A\u0002\u0005=\u0015!\b7pC\u0012\u0014\u0015n\u001c6bm\u0006<UM\u001c2b].\u0014f.\u0019$fCR,(/Z:\u0015\t\u0005]'\u0011\u0004\u0005\b\u0003\u001b;\u0003\u0019AAH\u0003=y\u0007/\u001a8J]B,Ho\u0015;sK\u0006lG\u0003\u0002B\u0010\u0005S\u0001BA!\t\u0003&5\u0011!1\u0005\u0006\u0004e\u00065\u0012\u0002\u0002B\u0014\u0005G\u00111\"\u00138qkR\u001cFO]3b[\"9!1\u0006\u0015A\u0002\u0005=\u0015\u0001\u00034jY\u0016t\u0015-\\3\u0002\u0013I,\u0017\r\u001a$bgR\fH\u0003\u0002B\u0019\u0005\u0007\u0002RAa\r\u0003>5tAA!\u000e\u0003:9!\u0011Q\u0013B\u001c\u0013\u0005\t\u0015b\u0001B\u001e\u0001\u00069\u0001/Y2lC\u001e,\u0017\u0002\u0002B \u0005\u0003\u00121aU3r\u0015\r\u0011Y\u0004\u0011\u0005\b\u0005\u000bJ\u0003\u0019\u0001B\u0010\u0003-Ig\u000e];u'R\u0014X-Y7\u0002\u0019I,\u0017\r\u001a$bgR\fGI\\1\u0015\t\t-#Q\n\t\u0007\u0005g\u0011i$a\u0002\t\u000f\t\u0015#\u00061\u0001\u0003 \u0005\u0001\"/Z1e\r\u0006\u001cH/\u0019)s_R,\u0017N\u001c\u000b\u0005\u0005'\u0012)\u0006\u0005\u0004\u00034\tu\u00121\t\u0005\b\u0005\u000bZ\u0003\u0019\u0001B\u0010\u00031\u0011X-\u00193GCN$\u0018M\u00158b)\u0011\u0011YF!\u0018\u0011\r\tM\"QHA-\u0011\u001d\u0011)\u0005\fa\u0001\u0005?\taB]3bI\u001e+gNY1oW\u0012s\u0017\r\u0006\u0003\u0003L\t\r\u0004b\u0002B#[\u0001\u0007!qD\u0001\u0013e\u0016\fGmR3oE\u0006t7\u000e\u0015:pi\u0016Lg\u000e\u0006\u0003\u0003T\t%\u0004b\u0002B#]\u0001\u0007!qD\u0001\u000fe\u0016\fGmR3oE\u0006t7N\u00158b)\u0011\u0011YFa\u001c\t\u000f\t\u0015s\u00061\u0001\u0003 !)Qk\u0001a\u0001/\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u00119\b\u0005\u0003\u0003z\t}TB\u0001B>\u0015\u0011\u0011i(!\f\u0002\t1\fgnZ\u0005\u0005\u0005\u0003\u0013YH\u0001\u0004PE*,7\r\u001e")
public class BiojavaAdamContext
implements scala.Serializable,
Logging {
    private final transient ADAMContext ac;
    private final Converter<Fastq, Read> readConverter;
    private final Converter<DNASequence, Sequence> dnaSequenceConverter;
    private final Converter<DNASequence, List<Feature>> dnaSequenceFeaturesConverter;
    private final Converter<ProteinSequence, Sequence> proteinSequenceConverter;
    private final Converter<ProteinSequence, List<Feature>> proteinSequenceFeaturesConverter;
    private final Converter<RNASequence, Sequence> rnaSequenceConverter;
    private final Converter<RNASequence, List<Feature>> rnaSequenceFeaturesConverter;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public static BiojavaAdamContext apply(ADAMContext aDAMContext) {
        return BiojavaAdamContext$.MODULE$.apply(aDAMContext);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        BiojavaAdamContext biojavaAdamContext = this;
        synchronized (biojavaAdamContext) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public ADAMContext ac() {
        return this.ac;
    }

    public Converter<Fastq, Read> readConverter() {
        return this.readConverter;
    }

    public Converter<DNASequence, Sequence> dnaSequenceConverter() {
        return this.dnaSequenceConverter;
    }

    public Converter<DNASequence, List<Feature>> dnaSequenceFeaturesConverter() {
        return this.dnaSequenceFeaturesConverter;
    }

    public Converter<ProteinSequence, Sequence> proteinSequenceConverter() {
        return this.proteinSequenceConverter;
    }

    public Converter<ProteinSequence, List<Feature>> proteinSequenceFeaturesConverter() {
        return this.proteinSequenceFeaturesConverter;
    }

    public Converter<RNASequence, Sequence> rnaSequenceConverter() {
        return this.rnaSequenceConverter;
    }

    public Converter<RNASequence, List<Feature>> rnaSequenceFeaturesConverter() {
        return this.rnaSequenceFeaturesConverter;
    }

    public ReadDataset loadFastqReads(String path) {
        return this.loadBiojavaFastqReads(path);
    }

    public ReadDataset loadBiojavaFastqReads(String path) {
        ReadDataset r;
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Loading ").append(path).append(" in FASTQ format as reads with Biojava...").toString());
        Try try_ = TryWith$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.openInputStream(path), (Function1 & Serializable & scala.Serializable)inputStream -> {
            RDD fastqs = this.ac().sc().parallelize(this.readFastq((InputStream)inputStream), this.ac().sc().parallelize$default$2(), ClassTag$.MODULE$.apply(Fastq.class));
            RDD reads = fastqs.map((Function1 & Serializable & scala.Serializable)x$1 -> this.readConverter().convert((Fastq)x$1, ConversionStringency.STRICT, this.logger().logger()), ClassTag$.MODULE$.apply(Read.class));
            return ReadDataset$.MODULE$.apply(reads);
        });
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                throw e;
            }
            throw new MatchError(try_);
        }
        Success success = (Success)try_;
        ReadDataset readDataset = r = (ReadDataset)success.value();
        return readDataset;
    }

    public SequenceDataset loadBiojavaFastaDna(String path) {
        SequenceDataset s2;
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Loading ").append(path).append(" in FASTA format as DNA sequences with Biojava...").toString());
        Try try_ = TryWith$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.openInputStream(path), (Function1 & Serializable & scala.Serializable)inputStream -> {
            RDD dnaSequences = this.ac().sc().parallelize(this.readFastaDna((InputStream)inputStream), this.ac().sc().parallelize$default$2(), ClassTag$.MODULE$.apply(DNASequence.class));
            RDD sequences = dnaSequences.map((Function1 & Serializable & scala.Serializable)x$2 -> this.dnaSequenceConverter().convert((DNASequence)x$2, ConversionStringency.STRICT, this.logger().logger()), ClassTag$.MODULE$.apply(Sequence.class));
            return SequenceDataset$.MODULE$.apply(sequences);
        });
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                throw e;
            }
            throw new MatchError(try_);
        }
        Success success = (Success)try_;
        SequenceDataset sequenceDataset = s2 = (SequenceDataset)success.value();
        return sequenceDataset;
    }

    public SequenceDataset loadBiojavaFastaProtein(String path) {
        SequenceDataset s2;
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Loading ").append(path).append(" in FASTA format as protein sequences with Biojava...").toString());
        Try try_ = TryWith$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.openInputStream(path), (Function1 & Serializable & scala.Serializable)inputStream -> {
            RDD proteinSequences = this.ac().sc().parallelize(this.readFastaProtein((InputStream)inputStream), this.ac().sc().parallelize$default$2(), ClassTag$.MODULE$.apply(ProteinSequence.class));
            RDD sequences = proteinSequences.map((Function1 & Serializable & scala.Serializable)x$3 -> this.proteinSequenceConverter().convert((ProteinSequence)x$3, ConversionStringency.STRICT, this.logger().logger()), ClassTag$.MODULE$.apply(Sequence.class));
            return SequenceDataset$.MODULE$.apply(sequences);
        });
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                throw e;
            }
            throw new MatchError(try_);
        }
        Success success = (Success)try_;
        SequenceDataset sequenceDataset = s2 = (SequenceDataset)success.value();
        return sequenceDataset;
    }

    public SequenceDataset loadBiojavaFastaRna(String path) {
        SequenceDataset s2;
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Loading ").append(path).append(" in FASTA format as RNA sequences with Biojava...").toString());
        Try try_ = TryWith$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.openInputStream(path), (Function1 & Serializable & scala.Serializable)inputStream -> {
            RDD rnaSequences = this.ac().sc().parallelize(this.readFastaRna((InputStream)inputStream), this.ac().sc().parallelize$default$2(), ClassTag$.MODULE$.apply(RNASequence.class));
            RDD sequences = rnaSequences.map((Function1 & Serializable & scala.Serializable)x$4 -> this.rnaSequenceConverter().convert((RNASequence)x$4, ConversionStringency.STRICT, this.logger().logger()), ClassTag$.MODULE$.apply(Sequence.class));
            return SequenceDataset$.MODULE$.apply(sequences);
        });
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                throw e;
            }
            throw new MatchError(try_);
        }
        Success success = (Success)try_;
        SequenceDataset sequenceDataset = s2 = (SequenceDataset)success.value();
        return sequenceDataset;
    }

    public SequenceDataset loadGenbankDna(String path) {
        return this.loadBiojavaGenbankDna(path);
    }

    public SequenceDataset loadBiojavaGenbankDna(String path) {
        SequenceDataset s2;
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(59).append("Loading ").append(path).append(" in Genbank format as DNA sequences with Biojava...").toString());
        Try try_ = TryWith$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.openInputStream(path), (Function1 & Serializable & scala.Serializable)inputStream -> {
            RDD dnaSequences = this.ac().sc().parallelize(this.readGenbankDna((InputStream)inputStream), this.ac().sc().parallelize$default$2(), ClassTag$.MODULE$.apply(DNASequence.class));
            RDD sequences = dnaSequences.map((Function1 & Serializable & scala.Serializable)x$5 -> this.dnaSequenceConverter().convert((DNASequence)x$5, ConversionStringency.STRICT, this.logger().logger()), ClassTag$.MODULE$.apply(Sequence.class));
            return SequenceDataset$.MODULE$.apply(sequences);
        });
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                throw e;
            }
            throw new MatchError(try_);
        }
        Success success = (Success)try_;
        SequenceDataset sequenceDataset = s2 = (SequenceDataset)success.value();
        return sequenceDataset;
    }

    public FeatureDataset loadGenbankDnaFeatures(String path) {
        return this.loadBiojavaGenbankDnaFeatures(path);
    }

    public FeatureDataset loadBiojavaGenbankDnaFeatures(String path) {
        FeatureDataset f;
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("Loading ").append(path).append(" in Genbank format as DNA sequence features with Biojava...").toString());
        Try try_ = TryWith$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.openInputStream(path), (Function1 & Serializable & scala.Serializable)inputStream -> {
            RDD dnaSequences = this.ac().sc().parallelize(this.readGenbankDna((InputStream)inputStream), this.ac().sc().parallelize$default$2(), ClassTag$.MODULE$.apply(DNASequence.class));
            RDD features = dnaSequences.flatMap((Function1 & Serializable & scala.Serializable)x$6 -> JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(this.dnaSequenceFeaturesConverter().convert((DNASequence)x$6, ConversionStringency.STRICT, this.logger().logger())), ClassTag$.MODULE$.apply(Feature.class));
            return FeatureDataset$.MODULE$.apply(features);
        });
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                throw e;
            }
            throw new MatchError(try_);
        }
        Success success = (Success)try_;
        FeatureDataset featureDataset = f = (FeatureDataset)success.value();
        return featureDataset;
    }

    public SequenceDataset loadGenbankProtein(String path) {
        return this.loadBiojavaGenbankProtein(path);
    }

    public SequenceDataset loadBiojavaGenbankProtein(String path) {
        SequenceDataset s2;
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("Loading ").append(path).append(" in Genbank format as protein sequences with Biojava...").toString());
        Try try_ = TryWith$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.openInputStream(path), (Function1 & Serializable & scala.Serializable)inputStream -> {
            RDD proteinSequences = this.ac().sc().parallelize(this.readGenbankProtein((InputStream)inputStream), this.ac().sc().parallelize$default$2(), ClassTag$.MODULE$.apply(ProteinSequence.class));
            RDD sequences = proteinSequences.map((Function1 & Serializable & scala.Serializable)x$7 -> this.proteinSequenceConverter().convert((ProteinSequence)x$7, ConversionStringency.STRICT, this.logger().logger()), ClassTag$.MODULE$.apply(Sequence.class));
            return SequenceDataset$.MODULE$.apply(sequences);
        });
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                throw e;
            }
            throw new MatchError(try_);
        }
        Success success = (Success)try_;
        SequenceDataset sequenceDataset = s2 = (SequenceDataset)success.value();
        return sequenceDataset;
    }

    public FeatureDataset loadGenbankProteinFeatures(String path) {
        return this.loadBiojavaGenbankProteinFeatures(path);
    }

    public FeatureDataset loadBiojavaGenbankProteinFeatures(String path) {
        FeatureDataset f;
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(71).append("Loading ").append(path).append(" in Genbank format as protein sequence features with Biojava...").toString());
        Try try_ = TryWith$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.openInputStream(path), (Function1 & Serializable & scala.Serializable)inputStream -> {
            RDD proteinSequences = this.ac().sc().parallelize(this.readGenbankProtein((InputStream)inputStream), this.ac().sc().parallelize$default$2(), ClassTag$.MODULE$.apply(ProteinSequence.class));
            RDD features = proteinSequences.flatMap((Function1 & Serializable & scala.Serializable)x$8 -> JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(this.proteinSequenceFeaturesConverter().convert((ProteinSequence)x$8, ConversionStringency.STRICT, this.logger().logger())), ClassTag$.MODULE$.apply(Feature.class));
            return FeatureDataset$.MODULE$.apply(features);
        });
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                throw e;
            }
            throw new MatchError(try_);
        }
        Success success = (Success)try_;
        FeatureDataset featureDataset = f = (FeatureDataset)success.value();
        return featureDataset;
    }

    public SequenceDataset loadGenbankRna(String path) {
        return this.loadBiojavaGenbankRna(path);
    }

    public SequenceDataset loadBiojavaGenbankRna(String path) {
        SequenceDataset s2;
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(59).append("Loading ").append(path).append(" in Genbank format as RNA sequences with Biojava...").toString());
        Try try_ = TryWith$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.openInputStream(path), (Function1 & Serializable & scala.Serializable)inputStream -> {
            RDD rnaSequences = this.ac().sc().parallelize(this.readGenbankRna((InputStream)inputStream), this.ac().sc().parallelize$default$2(), ClassTag$.MODULE$.apply(RNASequence.class));
            RDD sequences = rnaSequences.map((Function1 & Serializable & scala.Serializable)x$9 -> this.rnaSequenceConverter().convert((RNASequence)x$9, ConversionStringency.STRICT, this.logger().logger()), ClassTag$.MODULE$.apply(Sequence.class));
            return SequenceDataset$.MODULE$.apply(sequences);
        });
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                throw e;
            }
            throw new MatchError(try_);
        }
        Success success = (Success)try_;
        SequenceDataset sequenceDataset = s2 = (SequenceDataset)success.value();
        return sequenceDataset;
    }

    public FeatureDataset loadGenbankRnaFeatures(String path) {
        return this.loadBiojavaGenbankRnaFeatures(path);
    }

    public FeatureDataset loadBiojavaGenbankRnaFeatures(String path) {
        FeatureDataset f;
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("Loading ").append(path).append(" in Genbank format as RNA sequence features with Biojava...").toString());
        Try try_ = TryWith$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.openInputStream(path), (Function1 & Serializable & scala.Serializable)inputStream -> {
            RDD rnaSequences = this.ac().sc().parallelize(this.readGenbankRna((InputStream)inputStream), this.ac().sc().parallelize$default$2(), ClassTag$.MODULE$.apply(RNASequence.class));
            RDD features = rnaSequences.flatMap((Function1 & Serializable & scala.Serializable)x$10 -> JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(this.rnaSequenceFeaturesConverter().convert((RNASequence)x$10, ConversionStringency.STRICT, this.logger().logger())), ClassTag$.MODULE$.apply(Feature.class));
            return FeatureDataset$.MODULE$.apply(features);
        });
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                throw e;
            }
            throw new MatchError(try_);
        }
        Success success = (Success)try_;
        FeatureDataset featureDataset = f = (FeatureDataset)success.value();
        return featureDataset;
    }

    private InputStream openInputStream(String fileName) {
        Path path = new Path(fileName);
        FileSystem fileSystem = path.getFileSystem(this.ac().sc().hadoopConfiguration());
        CompressionCodecFactory codecFactory = new CompressionCodecFactory(this.ac().sc().hadoopConfiguration());
        CompressionCodec codec = codecFactory.getCodec(path);
        return codec == null ? fileSystem.open(path) : codec.createInputStream((InputStream)fileSystem.open(path));
    }

    private Seq<Fastq> readFastq(InputStream inputStream) {
        SangerFastqReader fastqReader = new SangerFastqReader();
        return JavaConversions$.MODULE$.deprecated$u0020asScalaIterator(fastqReader.read(inputStream).iterator()).toList();
    }

    private Seq<DNASequence> readFastaDna(InputStream inputStream) {
        FastaReader fastaReader = new FastaReader(inputStream, new GenericFastaHeaderParser(), new DNASequenceCreator(AmbiguityDNACompoundSet.getDNACompoundSet()));
        return JavaConversions$.MODULE$.deprecated$u0020asScalaIterator(fastaReader.process().values().iterator()).toList();
    }

    private Seq<ProteinSequence> readFastaProtein(InputStream inputStream) {
        return JavaConversions$.MODULE$.deprecated$u0020asScalaIterator(FastaReaderHelper.readFastaProteinSequence(inputStream).values().iterator()).toList();
    }

    private Seq<RNASequence> readFastaRna(InputStream inputStream) {
        FastaReader fastaReader = new FastaReader(inputStream, new GenericFastaHeaderParser(), new RNASequenceCreator(AmbiguityRNACompoundSet.getRNACompoundSet()));
        return JavaConversions$.MODULE$.deprecated$u0020asScalaIterator(fastaReader.process().values().iterator()).toList();
    }

    private Seq<DNASequence> readGenbankDna(InputStream inputStream) {
        GenbankReader genbankReader = new GenbankReader(inputStream, new GenericGenbankHeaderParser(), new DNASequenceCreator(AmbiguityDNACompoundSet.getDNACompoundSet()));
        return JavaConversions$.MODULE$.deprecated$u0020asScalaIterator(genbankReader.process().values().iterator()).toList();
    }

    private Seq<ProteinSequence> readGenbankProtein(InputStream inputStream) {
        return JavaConversions$.MODULE$.deprecated$u0020asScalaIterator(GenbankReaderHelper.readGenbankProteinSequence(inputStream).values().iterator()).toList();
    }

    private Seq<RNASequence> readGenbankRna(InputStream inputStream) {
        GenbankReader genbankReader = new GenbankReader(inputStream, new GenericGenbankHeaderParser(), new RNASequenceCreator(AmbiguityRNACompoundSet.getRNACompoundSet()));
        return JavaConversions$.MODULE$.deprecated$u0020asScalaIterator(genbankReader.process().values().iterator()).toList();
    }

    public BiojavaAdamContext(ADAMContext ac, Converter<Fastq, Read> readConverter, Converter<DNASequence, Sequence> dnaSequenceConverter, Converter<DNASequence, List<Feature>> dnaSequenceFeaturesConverter, Converter<ProteinSequence, Sequence> proteinSequenceConverter, Converter<ProteinSequence, List<Feature>> proteinSequenceFeaturesConverter, Converter<RNASequence, Sequence> rnaSequenceConverter, Converter<RNASequence, List<Feature>> rnaSequenceFeaturesConverter) {
        this.ac = ac;
        this.readConverter = readConverter;
        this.dnaSequenceConverter = dnaSequenceConverter;
        this.dnaSequenceFeaturesConverter = dnaSequenceFeaturesConverter;
        this.proteinSequenceConverter = proteinSequenceConverter;
        this.proteinSequenceFeaturesConverter = proteinSequenceFeaturesConverter;
        this.rnaSequenceConverter = rnaSequenceConverter;
        this.rnaSequenceFeaturesConverter = rnaSequenceFeaturesConverter;
        Logging.$init$((Logging)this);
    }
}

