/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.adam.convert;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import org.bdgenomics.convert.Converter;
import org.bdgenomics.formats.avro.Feature;
import org.bdgenomics.formats.avro.Read;
import org.bdgenomics.formats.avro.Sequence;
import org.biojava.nbio.adam.convert.BiojavaStrandToBdgenomicsStrand;
import org.biojava.nbio.adam.convert.DnaSequenceToFeatures;
import org.biojava.nbio.adam.convert.DnaSequenceToSequence;
import org.biojava.nbio.adam.convert.FastqToRead;
import org.biojava.nbio.adam.convert.ProteinSequenceToFeatures;
import org.biojava.nbio.adam.convert.ProteinSequenceToSequence;
import org.biojava.nbio.adam.convert.ReadToFastq;
import org.biojava.nbio.adam.convert.RnaSequenceToFeatures;
import org.biojava.nbio.adam.convert.RnaSequenceToSequence;
import org.biojava.nbio.core.sequence.DNASequence;
import org.biojava.nbio.core.sequence.ProteinSequence;
import org.biojava.nbio.core.sequence.RNASequence;
import org.biojava.nbio.core.sequence.Strand;
import org.biojava.nbio.genome.io.fastq.Fastq;

@Immutable
public final class BiojavaModule
extends AbstractModule {
    @Override
    protected void configure() {
    }

    @Provides
    @Singleton
    Converter<Strand, org.bdgenomics.formats.avro.Strand> createBiojavaStrandToBdgenomicsStrand() {
        return new BiojavaStrandToBdgenomicsStrand();
    }

    @Provides
    @Singleton
    Converter<Fastq, Read> createFastqToRead() {
        return new FastqToRead();
    }

    @Provides
    @Singleton
    Converter<Read, Fastq> createReadToFastq() {
        return new ReadToFastq();
    }

    @Provides
    @Singleton
    Converter<DNASequence, List<Feature>> createDnaSequenceToFeatures(Converter<Strand, org.bdgenomics.formats.avro.Strand> strandConverter) {
        return new DnaSequenceToFeatures(strandConverter);
    }

    @Provides
    @Singleton
    Converter<ProteinSequence, List<Feature>> createProteinSequenceToFeatures(Converter<Strand, org.bdgenomics.formats.avro.Strand> strandConverter) {
        return new ProteinSequenceToFeatures(strandConverter);
    }

    @Provides
    @Singleton
    Converter<RNASequence, List<Feature>> createRnaSequenceToFeatures(Converter<Strand, org.bdgenomics.formats.avro.Strand> strandConverter) {
        return new RnaSequenceToFeatures(strandConverter);
    }

    @Provides
    @Singleton
    Converter<DNASequence, Sequence> createDnaSequenceToSequence() {
        return new DnaSequenceToSequence();
    }

    @Provides
    @Singleton
    Converter<ProteinSequence, Sequence> createProteinSequenceToSequence() {
        return new ProteinSequenceToSequence();
    }

    @Provides
    @Singleton
    Converter<RNASequence, Sequence> createRnaSequenceToSequence() {
        return new RnaSequenceToSequence();
    }
}

