/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.adam.convert;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import org.bdgenomics.convert.AbstractConverter;
import org.bdgenomics.convert.ConversionException;
import org.bdgenomics.convert.ConversionStringency;
import org.bdgenomics.convert.Converter;
import org.bdgenomics.formats.avro.Dbxref;
import org.bdgenomics.formats.avro.Feature;
import org.biojava.nbio.adam.convert.ConvertUtils;
import org.biojava.nbio.core.sequence.DNASequence;
import org.biojava.nbio.core.sequence.Strand;
import org.biojava.nbio.core.sequence.features.FeatureInterface;
import org.biojava.nbio.core.sequence.features.Qualifier;
import org.biojava.nbio.core.sequence.location.template.AbstractLocation;
import org.biojava.nbio.core.sequence.location.template.Point;
import org.slf4j.Logger;

@Immutable
final class DnaSequenceToFeatures
extends AbstractConverter<DNASequence, List<Feature>> {
    private final Converter<Strand, org.bdgenomics.formats.avro.Strand> strandConverter;

    DnaSequenceToFeatures(Converter<Strand, org.bdgenomics.formats.avro.Strand> strandConverter) {
        super(DNASequence.class, List.class);
        this.checkNotNull(strandConverter);
        this.strandConverter = strandConverter;
    }

    @Override
    public List<Feature> convert(DNASequence dnaSequence, ConversionStringency stringency, Logger logger) throws ConversionException {
        if (dnaSequence == null) {
            this.warnOrThrow(dnaSequence, "must not be null", null, stringency, logger);
            return null;
        }
        Feature.Builder fb = Feature.newBuilder().setReferenceName(dnaSequence.getAccession().toString());
        int size = dnaSequence.getFeatures().size();
        ArrayList<Feature> features = new ArrayList<Feature>(size);
        for (FeatureInterface feature : dnaSequence.getFeatures()) {
            if (feature.getSource() == null) {
                fb.setSource(feature.getSource());
            } else {
                fb.clearSource();
            }
            if (feature.getType() == null) {
                fb.setFeatureType(feature.getType());
            } else {
                fb.clearFeatureType();
            }
            AbstractLocation location = feature.getLocations();
            if (location == null) {
                fb.clearStart();
                fb.clearEnd();
                fb.clearStrand();
            } else {
                Point start = location.getStart();
                fb.setStart((long)start.getPosition().intValue() - 1L);
                Point end = location.getEnd();
                fb.setEnd((long)end.getPosition());
                Strand strand = location.getStrand();
                if (strand == null) {
                    fb.clearStrand();
                } else {
                    fb.setStrand(this.strandConverter.convert(strand, stringency, logger));
                }
            }
            if (feature.getShortDescription() != null) {
                fb.setName(ConvertUtils.trimNewlines(feature.getShortDescription()));
            } else if (feature.getDescription() != null) {
                fb.setName(ConvertUtils.trimNewlines(feature.getDescription()));
            } else {
                fb.clearName();
            }
            ArrayList<String> notes = new ArrayList<String>();
            ArrayList<Dbxref> dbxrefs = new ArrayList<Dbxref>();
            HashMap<String, String> attributes = new HashMap<String, String>();
            Map<String, List<Qualifier>> qualifiers = feature.getQualifiers();
            for (Map.Entry<String, List<Qualifier>> entry : qualifiers.entrySet()) {
                String key = entry.getKey();
                List<Qualifier> value = entry.getValue();
                StringBuilder sb = new StringBuilder();
                Iterator<Qualifier> i = value.iterator();
                while (i.hasNext()) {
                    String stringValue = ConvertUtils.trimNewlines(i.next().getValue());
                    if ("db_xref".equals(key)) {
                        String[] tokens = stringValue.split(":");
                        if (tokens.length != 2) continue;
                        dbxrefs.add(new Dbxref(tokens[0], tokens[1]));
                        continue;
                    }
                    if ("note".equals(key)) {
                        notes.add(stringValue);
                        continue;
                    }
                    sb.append(stringValue);
                    if (!i.hasNext()) continue;
                    sb.append(",");
                }
                if ("db_xref".equals(key)) {
                    fb.setDbxrefs(dbxrefs);
                    continue;
                }
                if ("note".equals(key)) {
                    fb.setNotes(notes);
                    continue;
                }
                attributes.put(key, sb.toString());
            }
            if (!attributes.isEmpty()) {
                fb.setAttributes(attributes);
            }
            features.add(fb.build());
        }
        return features;
    }
}

