/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.adam.convert;

import javax.annotation.concurrent.Immutable;
import org.bdgenomics.convert.AbstractConverter;
import org.bdgenomics.convert.ConversionException;
import org.bdgenomics.convert.ConversionStringency;
import org.bdgenomics.formats.avro.Alphabet;
import org.bdgenomics.formats.avro.Sequence;
import org.biojava.nbio.adam.convert.ConvertUtils;
import org.biojava.nbio.core.sequence.DNASequence;
import org.slf4j.Logger;

@Immutable
final class DnaSequenceToSequence
extends AbstractConverter<DNASequence, Sequence> {
    DnaSequenceToSequence() {
        super(DNASequence.class, Sequence.class);
    }

    @Override
    public Sequence convert(DNASequence dnaSequence, ConversionStringency stringency, Logger logger) throws ConversionException {
        if (dnaSequence == null) {
            this.warnOrThrow(dnaSequence, "must not be null", null, stringency, logger);
            return null;
        }
        Sequence.Builder sb = Sequence.newBuilder().setName(dnaSequence.getAccession().toString()).setDescription(ConvertUtils.trimNewlines(dnaSequence.getDescription())).setAlphabet(Alphabet.DNA).setSequence(dnaSequence.getSequenceAsString().toUpperCase()).setLength(Long.valueOf(dnaSequence.getLength()));
        return sb.build();
    }
}

