/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.adam.convert;

import javax.annotation.concurrent.Immutable;
import org.bdgenomics.convert.AbstractConverter;
import org.bdgenomics.convert.ConversionException;
import org.bdgenomics.convert.ConversionStringency;
import org.bdgenomics.formats.avro.Alphabet;
import org.bdgenomics.formats.avro.Read;
import org.biojava.nbio.genome.io.fastq.Fastq;
import org.slf4j.Logger;

@Immutable
final class FastqToRead
extends AbstractConverter<Fastq, Read> {
    FastqToRead() {
        super(Fastq.class, Read.class);
    }

    @Override
    public Read convert(Fastq fastq, ConversionStringency stringency, Logger logger) throws ConversionException {
        if (fastq == null) {
            this.warnOrThrow(fastq, "must not be null", null, stringency, logger);
            return null;
        }
        return Read.newBuilder().setName(FastqToRead.nameFromDescription(fastq.getDescription())).setDescription(fastq.getDescription()).setAlphabet(Alphabet.DNA).setSequence(fastq.getSequence().toUpperCase()).setLength(Long.valueOf(fastq.getSequence().length())).setQualityScores(fastq.getQuality()).build();
    }

    static String nameFromDescription(String description) {
        if (description == null) {
            return null;
        }
        if (description.length() == 0) {
            return "";
        }
        int i = description.indexOf(" ");
        return i >= 0 ? description.substring(0, i) : description;
    }
}

