/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.adam.convert;

import javax.annotation.concurrent.Immutable;
import org.bdgenomics.convert.AbstractConverter;
import org.bdgenomics.convert.ConversionException;
import org.bdgenomics.convert.ConversionStringency;
import org.bdgenomics.formats.avro.Alphabet;
import org.bdgenomics.formats.avro.Sequence;
import org.biojava.nbio.adam.convert.ConvertUtils;
import org.biojava.nbio.core.sequence.ProteinSequence;
import org.slf4j.Logger;

@Immutable
final class ProteinSequenceToSequence
extends AbstractConverter<ProteinSequence, Sequence> {
    ProteinSequenceToSequence() {
        super(ProteinSequence.class, Sequence.class);
    }

    @Override
    public Sequence convert(ProteinSequence proteinSequence, ConversionStringency stringency, Logger logger) throws ConversionException {
        if (proteinSequence == null) {
            this.warnOrThrow(proteinSequence, "must not be null", null, stringency, logger);
            return null;
        }
        Sequence.Builder sb = Sequence.newBuilder().setName(proteinSequence.getAccession().toString()).setDescription(ConvertUtils.trimNewlines(proteinSequence.getDescription())).setAlphabet(Alphabet.PROTEIN).setSequence(proteinSequence.getSequenceAsString().toUpperCase()).setLength(Long.valueOf(proteinSequence.getLength()));
        return sb.build();
    }
}

