/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.adam.convert;

import javax.annotation.concurrent.Immutable;
import org.bdgenomics.convert.AbstractConverter;
import org.bdgenomics.convert.ConversionException;
import org.bdgenomics.convert.ConversionStringency;
import org.bdgenomics.formats.avro.Read;
import org.biojava.nbio.genome.io.fastq.Fastq;
import org.biojava.nbio.genome.io.fastq.FastqBuilder;
import org.biojava.nbio.genome.io.fastq.FastqVariant;
import org.slf4j.Logger;

@Immutable
final class ReadToFastq
extends AbstractConverter<Read, Fastq> {
    ReadToFastq() {
        super(Read.class, Fastq.class);
    }

    @Override
    public Fastq convert(Read read, ConversionStringency stringency, Logger logger) throws ConversionException {
        if (read == null) {
            this.warnOrThrow(read, "must not be null", null, stringency, logger);
            return null;
        }
        Fastq fastq = null;
        try {
            fastq = new FastqBuilder().withDescription(ReadToFastq.description(read.getName(), read.getDescription())).withSequence(read.getSequence()).withQuality(read.getQualityScores()).withVariant(FastqVariant.FASTQ_SANGER).build();
        }
        catch (IllegalArgumentException | NullPointerException e) {
            this.warnOrThrow(read, "could not convert read", e, stringency, logger);
        }
        return fastq;
    }

    static String description(String name, String description) {
        if (name == null && description == null) {
            return null;
        }
        if (description == null) {
            return name;
        }
        if (name == null) {
            return description;
        }
        return name + " " + description;
    }
}

