/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.adam.convert;

import javax.annotation.concurrent.Immutable;
import org.bdgenomics.convert.AbstractConverter;
import org.bdgenomics.convert.ConversionException;
import org.bdgenomics.convert.ConversionStringency;
import org.bdgenomics.formats.avro.Alphabet;
import org.bdgenomics.formats.avro.Sequence;
import org.biojava.nbio.adam.convert.ConvertUtils;
import org.biojava.nbio.core.sequence.RNASequence;
import org.slf4j.Logger;

@Immutable
final class RnaSequenceToSequence
extends AbstractConverter<RNASequence, Sequence> {
    RnaSequenceToSequence() {
        super(RNASequence.class, Sequence.class);
    }

    @Override
    public Sequence convert(RNASequence rnaSequence, ConversionStringency stringency, Logger logger) throws ConversionException {
        if (rnaSequence == null) {
            this.warnOrThrow(rnaSequence, "must not be null", null, stringency, logger);
            return null;
        }
        Sequence.Builder sb = Sequence.newBuilder().setName(rnaSequence.getAccession().toString()).setDescription(ConvertUtils.trimNewlines(rnaSequence.getDescription())).setAlphabet(Alphabet.RNA).setSequence(rnaSequence.getSequenceAsString().toUpperCase()).setLength(Long.valueOf(rnaSequence.getLength()));
        return sb.build();
    }
}

