/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.alignment;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.biojava.nbio.alignment.FractionalIdentityScorer;
import org.biojava.nbio.alignment.FractionalSimilarityScorer;
import org.biojava.nbio.alignment.GuideTree;
import org.biojava.nbio.alignment.NeedlemanWunsch;
import org.biojava.nbio.alignment.SimpleGapPenalty;
import org.biojava.nbio.alignment.SimpleProfileProfileAligner;
import org.biojava.nbio.alignment.SmithWaterman;
import org.biojava.nbio.alignment.template.CallablePairwiseSequenceAligner;
import org.biojava.nbio.alignment.template.CallablePairwiseSequenceScorer;
import org.biojava.nbio.alignment.template.CallableProfileProfileAligner;
import org.biojava.nbio.alignment.template.GapPenalty;
import org.biojava.nbio.alignment.template.GuideTreeNode;
import org.biojava.nbio.alignment.template.PairwiseSequenceAligner;
import org.biojava.nbio.alignment.template.PairwiseSequenceScorer;
import org.biojava.nbio.alignment.template.ProfileProfileAligner;
import org.biojava.nbio.core.alignment.matrices.SubstitutionMatrixHelper;
import org.biojava.nbio.core.alignment.template.Profile;
import org.biojava.nbio.core.alignment.template.ProfilePair;
import org.biojava.nbio.core.alignment.template.SequencePair;
import org.biojava.nbio.core.alignment.template.SubstitutionMatrix;
import org.biojava.nbio.core.sequence.compound.AmbiguityDNACompoundSet;
import org.biojava.nbio.core.sequence.compound.AminoAcidCompound;
import org.biojava.nbio.core.sequence.compound.AminoAcidCompoundSet;
import org.biojava.nbio.core.sequence.compound.DNACompoundSet;
import org.biojava.nbio.core.sequence.template.Compound;
import org.biojava.nbio.core.sequence.template.CompoundSet;
import org.biojava.nbio.core.sequence.template.Sequence;
import org.biojava.nbio.core.util.ConcurrencyTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Alignments {
    private static final Logger logger = LoggerFactory.getLogger(Alignments.class);

    private Alignments() {
    }

    public static <S extends Sequence<C>, C extends Compound> List<SequencePair<S, C>> getAllPairsAlignments(List<S> sequences, PairwiseSequenceAlignerType type, GapPenalty gapPenalty, SubstitutionMatrix<C> subMatrix) {
        return Alignments.runPairwiseAligners(Alignments.getAllPairsAligners(sequences, type, gapPenalty, subMatrix));
    }

    public static <S extends Sequence<C>, C extends Compound> Profile<S, C> getMultipleSequenceAlignment(List<S> sequences, Object ... settings) {
        SubstitutionMatrix<Object> temp;
        CompoundSet cs = ((Sequence)sequences.get(0)).getCompoundSet();
        PairwiseSequenceScorerType ps = PairwiseSequenceScorerType.GLOBAL_IDENTITIES;
        GapPenalty gapPenalty = new SimpleGapPenalty();
        SubstitutionMatrix subMatrix = null;
        if (cs == AminoAcidCompoundSet.getAminoAcidCompoundSet()) {
            subMatrix = temp = SubstitutionMatrixHelper.getBlosum62();
        } else if (cs == DNACompoundSet.getDNACompoundSet()) {
            subMatrix = temp = SubstitutionMatrixHelper.getNuc4_4();
        } else if (cs == AmbiguityDNACompoundSet.getDNACompoundSet()) {
            subMatrix = temp = SubstitutionMatrixHelper.getNuc4_4();
        }
        ProfileProfileAlignerType pa = ProfileProfileAlignerType.GLOBAL;
        for (Object o : settings) {
            if (o instanceof PairwiseSequenceScorerType) {
                ps = (PairwiseSequenceScorerType)((Object)o);
                continue;
            }
            if (o instanceof GapPenalty) {
                gapPenalty = (GapPenalty)o;
                continue;
            }
            if (o instanceof SubstitutionMatrix) {
                SubstitutionMatrix temp2;
                if (cs != ((SubstitutionMatrix)o).getCompoundSet()) {
                    throw new IllegalArgumentException("Compound sets of the sequences and substitution matrix must match.");
                }
                subMatrix = temp2 = (SubstitutionMatrix)o;
                continue;
            }
            if (!(o instanceof ProfileProfileAlignerType)) continue;
            pa = (ProfileProfileAlignerType)((Object)o);
        }
        List<PairwiseSequenceScorer<S, C>> scorers = Alignments.getAllPairsScorers(sequences, ps, gapPenalty, subMatrix);
        Alignments.runPairwiseScorers(scorers);
        GuideTree<S, C> tree = new GuideTree<S, C>(sequences, scorers);
        scorers = null;
        Profile<S, AminoAcidCompound> msa = Alignments.getProgressiveAlignment(tree, pa, gapPenalty, subMatrix);
        return msa;
    }

    public static <S extends Sequence<C>, C extends Compound> SequencePair<S, C> getPairwiseAlignment(S query, S target, PairwiseSequenceAlignerType type, GapPenalty gapPenalty, SubstitutionMatrix<C> subMatrix) {
        return Alignments.getPairwiseAligner(query, target, type, gapPenalty, subMatrix).getPair();
    }

    static <S extends Sequence<C>, C extends Compound> List<PairwiseSequenceAligner<S, C>> getAllPairsAligners(List<S> sequences, PairwiseSequenceAlignerType type, GapPenalty gapPenalty, SubstitutionMatrix<C> subMatrix) {
        ArrayList<PairwiseSequenceAligner<S, C>> allPairs = new ArrayList<PairwiseSequenceAligner<S, C>>();
        for (int i = 0; i < sequences.size(); ++i) {
            for (int j = i + 1; j < sequences.size(); ++j) {
                allPairs.add(Alignments.getPairwiseAligner((Sequence)sequences.get(i), (Sequence)sequences.get(j), type, gapPenalty, subMatrix));
            }
        }
        return allPairs;
    }

    public static <S extends Sequence<C>, C extends Compound> List<PairwiseSequenceScorer<S, C>> getAllPairsScorers(List<S> sequences, PairwiseSequenceScorerType type, GapPenalty gapPenalty, SubstitutionMatrix<C> subMatrix) {
        ArrayList<PairwiseSequenceScorer<S, C>> allPairs = new ArrayList<PairwiseSequenceScorer<S, C>>();
        for (int i = 0; i < sequences.size(); ++i) {
            for (int j = i + 1; j < sequences.size(); ++j) {
                allPairs.add(Alignments.getPairwiseScorer((Sequence)sequences.get(i), (Sequence)sequences.get(j), type, gapPenalty, subMatrix));
            }
        }
        return allPairs;
    }

    public static <S extends Sequence<C>, C extends Compound> double[] getAllPairsScores(List<S> sequences, PairwiseSequenceScorerType type, GapPenalty gapPenalty, SubstitutionMatrix<C> subMatrix) {
        return Alignments.runPairwiseScorers(Alignments.getAllPairsScorers(sequences, type, gapPenalty, subMatrix));
    }

    static <E> List<E> getListFromFutures(List<Future<E>> futures) {
        ArrayList<E> list = new ArrayList<E>();
        for (Future<E> f : futures) {
            try {
                list.add(f.get());
            }
            catch (InterruptedException e) {
                logger.error("Interrupted Exception: ", (Throwable)e);
            }
            catch (ExecutionException e) {
                logger.error("Execution Exception: ", (Throwable)e);
            }
        }
        return list;
    }

    public static <S extends Sequence<C>, C extends Compound> PairwiseSequenceAligner<S, C> getPairwiseAligner(S query, S target, PairwiseSequenceAlignerType type, GapPenalty gapPenalty, SubstitutionMatrix<C> subMatrix) {
        if (!query.getCompoundSet().equals(target.getCompoundSet())) {
            throw new IllegalArgumentException("Sequence compound sets must be the same");
        }
        switch (type) {
            default: {
                return new NeedlemanWunsch<S, C>(query, target, gapPenalty, subMatrix);
            }
            case LOCAL: {
                return new SmithWaterman<S, C>(query, target, gapPenalty, subMatrix);
            }
            case GLOBAL_LINEAR_SPACE: 
            case LOCAL_LINEAR_SPACE: 
        }
        throw new UnsupportedOperationException(Alignments.class.getSimpleName() + " does not yet support " + (Object)((Object)type) + " alignment");
    }

    static <S extends Sequence<C>, C extends Compound> double getPairwiseScore(S query, S target, PairwiseSequenceScorerType type, GapPenalty gapPenalty, SubstitutionMatrix<C> subMatrix) {
        return Alignments.getPairwiseScorer(query, target, type, gapPenalty, subMatrix).getScore();
    }

    static <S extends Sequence<C>, C extends Compound> PairwiseSequenceScorer<S, C> getPairwiseScorer(S query, S target, PairwiseSequenceScorerType type, GapPenalty gapPenalty, SubstitutionMatrix<C> subMatrix) {
        switch (type) {
            default: {
                return Alignments.getPairwiseAligner(query, target, PairwiseSequenceAlignerType.GLOBAL, gapPenalty, subMatrix);
            }
            case GLOBAL_IDENTITIES: {
                return new FractionalIdentityScorer<S, C>(Alignments.getPairwiseAligner(query, target, PairwiseSequenceAlignerType.GLOBAL, gapPenalty, subMatrix));
            }
            case GLOBAL_SIMILARITIES: {
                return new FractionalSimilarityScorer<S, C>(Alignments.getPairwiseAligner(query, target, PairwiseSequenceAlignerType.GLOBAL, gapPenalty, subMatrix));
            }
            case LOCAL: {
                return Alignments.getPairwiseAligner(query, target, PairwiseSequenceAlignerType.LOCAL, gapPenalty, subMatrix);
            }
            case LOCAL_IDENTITIES: {
                return new FractionalIdentityScorer<S, C>(Alignments.getPairwiseAligner(query, target, PairwiseSequenceAlignerType.LOCAL, gapPenalty, subMatrix));
            }
            case LOCAL_SIMILARITIES: {
                return new FractionalSimilarityScorer<S, C>(Alignments.getPairwiseAligner(query, target, PairwiseSequenceAlignerType.LOCAL, gapPenalty, subMatrix));
            }
            case KMERS: 
            case WU_MANBER: 
        }
        throw new UnsupportedOperationException(Alignments.class.getSimpleName() + " does not yet support " + (Object)((Object)type) + " scoring");
    }

    static <S extends Sequence<C>, C extends Compound> ProfileProfileAligner<S, C> getProfileProfileAligner(Profile<S, C> profile1, Profile<S, C> profile2, ProfileProfileAlignerType type, GapPenalty gapPenalty, SubstitutionMatrix<C> subMatrix) {
        switch (type) {
            default: {
                return new SimpleProfileProfileAligner<S, C>(profile1, profile2, gapPenalty, subMatrix);
            }
            case GLOBAL_LINEAR_SPACE: 
            case GLOBAL_CONSENSUS: 
            case LOCAL: 
            case LOCAL_LINEAR_SPACE: 
            case LOCAL_CONSENSUS: 
        }
        throw new UnsupportedOperationException(Alignments.class.getSimpleName() + " does not yet support " + (Object)((Object)type) + " alignment");
    }

    static <S extends Sequence<C>, C extends Compound> ProfileProfileAligner<S, C> getProfileProfileAligner(Future<ProfilePair<S, C>> profile1, Future<ProfilePair<S, C>> profile2, ProfileProfileAlignerType type, GapPenalty gapPenalty, SubstitutionMatrix<C> subMatrix) {
        switch (type) {
            default: {
                return new SimpleProfileProfileAligner<S, C>(profile1, profile2, gapPenalty, subMatrix);
            }
            case GLOBAL_LINEAR_SPACE: 
            case GLOBAL_CONSENSUS: 
            case LOCAL: 
            case LOCAL_LINEAR_SPACE: 
            case LOCAL_CONSENSUS: 
        }
        throw new UnsupportedOperationException(Alignments.class.getSimpleName() + " does not yet support " + (Object)((Object)type) + " alignment");
    }

    static <S extends Sequence<C>, C extends Compound> ProfileProfileAligner<S, C> getProfileProfileAligner(Profile<S, C> profile1, Future<ProfilePair<S, C>> profile2, ProfileProfileAlignerType type, GapPenalty gapPenalty, SubstitutionMatrix<C> subMatrix) {
        switch (type) {
            default: {
                return new SimpleProfileProfileAligner<S, C>(profile1, profile2, gapPenalty, subMatrix);
            }
            case GLOBAL_LINEAR_SPACE: 
            case GLOBAL_CONSENSUS: 
            case LOCAL: 
            case LOCAL_LINEAR_SPACE: 
            case LOCAL_CONSENSUS: 
        }
        throw new UnsupportedOperationException(Alignments.class.getSimpleName() + " does not yet support " + (Object)((Object)type) + " alignment");
    }

    static <S extends Sequence<C>, C extends Compound> ProfileProfileAligner<S, C> getProfileProfileAligner(Future<ProfilePair<S, C>> profile1, Profile<S, C> profile2, ProfileProfileAlignerType type, GapPenalty gapPenalty, SubstitutionMatrix<C> subMatrix) {
        switch (type) {
            default: {
                return new SimpleProfileProfileAligner<S, C>(profile1, profile2, gapPenalty, subMatrix);
            }
            case GLOBAL_LINEAR_SPACE: 
            case GLOBAL_CONSENSUS: 
            case LOCAL: 
            case LOCAL_LINEAR_SPACE: 
            case LOCAL_CONSENSUS: 
        }
        throw new UnsupportedOperationException(Alignments.class.getSimpleName() + " does not yet support " + (Object)((Object)type) + " alignment");
    }

    static <S extends Sequence<C>, C extends Compound> ProfilePair<S, C> getProfileProfileAlignment(Profile<S, C> profile1, Profile<S, C> profile2, ProfileProfileAlignerType type, GapPenalty gapPenalty, SubstitutionMatrix<C> subMatrix) {
        return Alignments.getProfileProfileAligner(profile1, profile2, type, gapPenalty, subMatrix).getPair();
    }

    public static <S extends Sequence<C>, C extends Compound> Profile<S, C> getProgressiveAlignment(GuideTree<S, C> tree, ProfileProfileAlignerType type, GapPenalty gapPenalty, SubstitutionMatrix<C> subMatrix) {
        ArrayList<GuideTreeNode<S, C>> innerNodes = new ArrayList<GuideTreeNode<S, C>>();
        for (GuideTreeNode<S, C> n : tree) {
            if (n.getProfile() != null) continue;
            innerNodes.add(n);
        }
        int i = 1;
        int all = innerNodes.size();
        for (GuideTreeNode guideTreeNode : innerNodes) {
            Profile p1 = guideTreeNode.getChild1().getProfile();
            Profile p2 = guideTreeNode.getChild2().getProfile();
            Future pf1 = guideTreeNode.getChild1().getProfileFuture();
            Future pf2 = guideTreeNode.getChild2().getProfileFuture();
            ProfileProfileAligner aligner = p1 != null ? (p2 != null ? Alignments.getProfileProfileAligner(p1, p2, type, gapPenalty, subMatrix) : Alignments.getProfileProfileAligner(p1, pf2, type, gapPenalty, subMatrix)) : (p2 != null ? Alignments.getProfileProfileAligner(pf1, p2, type, gapPenalty, subMatrix) : Alignments.getProfileProfileAligner(pf1, pf2, type, gapPenalty, subMatrix));
            guideTreeNode.setProfileFuture(ConcurrencyTools.submit(new CallableProfileProfileAligner(aligner), String.format("Aligning pair %d of %d", i++, all)));
        }
        for (GuideTreeNode guideTreeNode : innerNodes) {
            try {
                guideTreeNode.setProfile(guideTreeNode.getProfileFuture().get());
            }
            catch (InterruptedException e) {
                logger.error("Interrupted Exception: ", (Throwable)e);
            }
            catch (ExecutionException e) {
                logger.error("Execution Exception: ", (Throwable)e);
            }
        }
        return tree.getRoot().getProfile();
    }

    static <S extends Sequence<C>, C extends Compound> List<SequencePair<S, C>> runPairwiseAligners(List<PairwiseSequenceAligner<S, C>> aligners) {
        int n = 1;
        int all = aligners.size();
        ArrayList futures = new ArrayList();
        for (PairwiseSequenceAligner<S, C> aligner : aligners) {
            futures.add(ConcurrencyTools.submit(new CallablePairwiseSequenceAligner<S, C>(aligner), String.format("Aligning pair %d of %d", n++, all)));
        }
        return Alignments.getListFromFutures(futures);
    }

    public static <S extends Sequence<C>, C extends Compound> double[] runPairwiseScorers(List<PairwiseSequenceScorer<S, C>> scorers) {
        int n = 1;
        int all = scorers.size();
        ArrayList<Future<Future<Double>>> futures = new ArrayList<Future<Future<Double>>>();
        for (PairwiseSequenceScorer<S, C> scorer : scorers) {
            futures.add(ConcurrencyTools.submit(new CallablePairwiseSequenceScorer<S, C>(scorer), String.format("Scoring pair %d of %d", n++, all)));
        }
        List results = Alignments.getListFromFutures(futures);
        double[] scores = new double[results.size()];
        for (int i = 0; i < scores.length; ++i) {
            scores[i] = (Double)results.get(i);
        }
        return scores;
    }

    static <S extends Sequence<C>, C extends Compound> List<ProfilePair<S, C>> runProfileAligners(List<ProfileProfileAligner<S, C>> aligners) {
        int n = 1;
        int all = aligners.size();
        ArrayList futures = new ArrayList();
        for (ProfileProfileAligner<S, C> aligner : aligners) {
            futures.add(ConcurrencyTools.submit(new CallableProfileProfileAligner<S, C>(aligner), String.format("Aligning pair %d of %d", n++, all)));
        }
        return Alignments.getListFromFutures(futures);
    }

    public static enum RefinerType {
        PARTITION_SINGLE,
        PARTITION_SINGLE_ALL,
        PARTITION_TREE,
        PARTITION_TREE_ALL,
        RESCORE_IDENTITIES,
        RESCORE_SIMILARITIES;

    }

    public static enum ProfileProfileAlignerType {
        GLOBAL,
        GLOBAL_LINEAR_SPACE,
        GLOBAL_CONSENSUS,
        LOCAL,
        LOCAL_LINEAR_SPACE,
        LOCAL_CONSENSUS;

    }

    public static enum PairwiseSequenceScorerType {
        GLOBAL,
        GLOBAL_IDENTITIES,
        GLOBAL_SIMILARITIES,
        LOCAL,
        LOCAL_IDENTITIES,
        LOCAL_SIMILARITIES,
        KMERS,
        WU_MANBER;

    }

    public static enum PairwiseSequenceAlignerType {
        GLOBAL,
        GLOBAL_LINEAR_SPACE,
        LOCAL,
        LOCAL_LINEAR_SPACE;

    }

    public static enum PairInProfileScorerType {
        IDENTITIES,
        SIMILARITIES;

    }
}

