/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.core.alignment.matrices;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.StringTokenizer;
import org.biojava.nbio.core.alignment.template.SubstitutionMatrix;
import org.biojava.nbio.core.sequence.compound.AminoAcidCompound;
import org.biojava.nbio.core.sequence.compound.AminoAcidCompoundSet;
import org.biojava.nbio.core.sequence.template.Compound;
import org.biojava.nbio.core.sequence.template.CompoundSet;

public class SimpleSubstitutionMatrix<C extends Compound>
implements SubstitutionMatrix<C>,
Serializable {
    private static final long serialVersionUID = -2645265638108462479L;
    private static final String comment = "#";
    private CompoundSet<C> compoundSet;
    private String description;
    private String name;
    private short[][] matrix;
    private short max;
    private short min;
    private List<C> rows;
    private List<C> cols;

    public static SubstitutionMatrix<AminoAcidCompound> getBlosum62() {
        return new SimpleSubstitutionMatrix<AminoAcidCompound>(AminoAcidCompoundSet.getAminoAcidCompoundSet(), new InputStreamReader(SimpleSubstitutionMatrix.class.getResourceAsStream("/matrices/blosum62.txt")), "blosum62");
    }

    public SimpleSubstitutionMatrix(CompoundSet<C> compoundSet, File fileInput) throws FileNotFoundException {
        this(compoundSet, new BufferedReader(new FileReader(fileInput)), fileInput.getName());
    }

    public SimpleSubstitutionMatrix(CompoundSet<C> compoundSet, Reader input, String name) {
        this(compoundSet, new Scanner(input), name);
    }

    public SimpleSubstitutionMatrix(CompoundSet<C> compoundSet, String matrixInput, String name) {
        this(compoundSet, new Scanner(matrixInput), name);
    }

    public SimpleSubstitutionMatrix(CompoundSet<C> compoundSet, short match, short replace) {
        this.compoundSet = compoundSet;
        this.description = "Identity matrix. All replaces and all matches are treated equally.";
        this.name = "IDENTITY_" + match + "_" + replace;
        this.max = match > replace ? match : replace;
        this.min = match < replace ? match : replace;
        this.cols = compoundSet.getAllCompounds();
        this.rows = this.cols;
        this.matrix = new short[this.rows.size()][this.cols.size()];
        for (int r = 0; r < this.rows.size(); ++r) {
            for (int c = 0; c < this.cols.size(); ++c) {
                try {
                    this.matrix[r][c] = compoundSet.compoundsEquivalent((Compound)this.rows.get(r), (Compound)this.cols.get(c)) ? match : replace;
                    continue;
                }
                catch (UnsupportedOperationException e) {
                    this.matrix[r][c] = r == c ? match : replace;
                }
            }
        }
    }

    private SimpleSubstitutionMatrix(CompoundSet<C> compoundSet, Scanner input, String name) {
        this.compoundSet = compoundSet;
        this.name = name;
        this.max = Short.MIN_VALUE;
        this.min = Short.MAX_VALUE;
        this.rows = new ArrayList<C>();
        this.cols = new ArrayList<C>();
        StringBuilder descriptionIn = new StringBuilder();
        ArrayList<short[]> matrixIn = new ArrayList<short[]>();
        while (input.hasNextLine()) {
            String line = input.nextLine();
            if (line.startsWith(comment)) {
                descriptionIn.append(String.format("%s%n", line));
                continue;
            }
            if (line.trim().isEmpty()) continue;
            StringTokenizer st = new StringTokenizer(line);
            if (this.cols.isEmpty()) {
                while (st.hasMoreTokens()) {
                    this.cols.add(compoundSet.getCompoundForString(st.nextToken()));
                }
                continue;
            }
            this.rows.add(compoundSet.getCompoundForString(st.nextToken()));
            short[] row = new short[this.cols.size()];
            for (int i = 0; i < row.length && st.hasMoreTokens(); ++i) {
                row[i] = Short.parseShort(st.nextToken());
                this.max = this.max > row[i] ? this.max : row[i];
                this.min = this.min < row[i] ? this.min : row[i];
            }
            matrixIn.add(row);
        }
        input.close();
        this.description = descriptionIn.toString();
        this.matrix = new short[this.rows.size()][this.cols.size()];
        for (int i = 0; i < this.rows.size(); ++i) {
            this.matrix[i] = (short[])matrixIn.get(i);
        }
    }

    @Override
    public CompoundSet<C> getCompoundSet() {
        return this.compoundSet;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public short[][] getMatrix() {
        short[][] copy = new short[this.matrix.length][this.matrix[0].length];
        for (int i = 0; i < copy.length; ++i) {
            copy[i] = Arrays.copyOf(this.matrix[i], this.matrix[i].length);
        }
        return copy;
    }

    @Override
    public String getMatrixAsString() {
        StringBuilder s2 = new StringBuilder();
        int lengthCompound = this.compoundSet.getMaxSingleCompoundStringLength();
        int lengthRest = Math.max(Math.max(Short.toString(this.min).length(), Short.toString(this.max).length()), lengthCompound) + 1;
        String padCompound = "%" + Integer.toString(lengthCompound) + "s";
        String padRest = "%" + Integer.toString(lengthRest);
        for (int i = 0; i < lengthCompound; ++i) {
            s2.append(" ");
        }
        for (Compound col : this.cols) {
            s2.append(String.format(padRest + "s", this.compoundSet.getStringForCompound(col)));
        }
        s2.append(String.format("%n", new Object[0]));
        for (Compound row : this.rows) {
            s2.append(String.format(padCompound, this.compoundSet.getStringForCompound(row)));
            for (Compound col : this.cols) {
                s2.append(String.format(padRest + "d", this.getValue(row, col)));
            }
            s2.append(String.format("%n", new Object[0]));
        }
        return s2.toString();
    }

    @Override
    public short getMaxValue() {
        return this.max;
    }

    @Override
    public short getMinValue() {
        return this.min;
    }

    @Override
    public String getName() {
        return this.name;
    }

    private static <C extends Compound> int getIndexOfCompound(List<C> list, C compound) {
        int index = list.indexOf(compound);
        if (index == -1) {
            for (int i = 0; i < list.size(); ++i) {
                if (!compound.equalsIgnoreCase((Compound)list.get(i))) continue;
                index = i;
                break;
            }
        }
        return index;
    }

    @Override
    public short getValue(C from, C to) {
        int row = SimpleSubstitutionMatrix.getIndexOfCompound(this.rows, from);
        int col = SimpleSubstitutionMatrix.getIndexOfCompound(this.cols, to);
        if (row == -1 || col == -1) {
            row = SimpleSubstitutionMatrix.getIndexOfCompound(this.cols, from);
            col = SimpleSubstitutionMatrix.getIndexOfCompound(this.rows, to);
            if (row == -1 || col == -1) {
                return this.min;
            }
        }
        return this.matrix[row][col];
    }

    @Override
    public SubstitutionMatrix<C> normalizeMatrix(short scale) {
        return null;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder();
        StringTokenizer st = new StringTokenizer(this.description, "\n\r");
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            if (!line.startsWith(comment)) {
                s2.append(comment);
            }
            s2.append(String.format("%s%n", line));
        }
        s2.append(this.getMatrixAsString());
        return s2.toString();
    }

    @Override
    public Map<C, Short> getRow(C row) {
        int rowIndex = this.rows.indexOf(row);
        HashMap<Compound, Short> map = new HashMap<Compound, Short>();
        for (int colIndex = 0; colIndex < this.matrix[rowIndex].length; ++colIndex) {
            map.put((Compound)this.cols.get(colIndex), this.matrix[rowIndex][colIndex]);
        }
        return map;
    }

    @Override
    public Map<C, Short> getColumn(C column) {
        int colIndex = this.cols.indexOf(column);
        HashMap<Compound, Short> map = new HashMap<Compound, Short>();
        for (int i = 0; i < this.matrix.length; ++i) {
            map.put((Compound)this.rows.get(i), this.matrix[i][colIndex]);
        }
        return map;
    }
}

