/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.core.search.io.blast;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import org.biojava.nbio.core.search.io.Hit;
import org.biojava.nbio.core.search.io.Hsp;
import org.biojava.nbio.core.search.io.Result;
import org.biojava.nbio.core.search.io.ResultFactory;
import org.biojava.nbio.core.search.io.blast.BlastHitBuilder;
import org.biojava.nbio.core.search.io.blast.BlastHspBuilder;
import org.biojava.nbio.core.search.io.blast.BlastResultBuilder;
import org.biojava.nbio.core.sequence.template.Sequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlastTabularParser
implements ResultFactory {
    private final String blastReference = "Zheng Zhang, Scott Schwartz, Lukas Wagner, and Webb Miller (2000), A greedy algorithm for aligning DNA sequences&quot;, J Comput Biol 2000; 7(1-2):203-14.";
    private static final Logger log = LoggerFactory.getLogger(BlastTabularParser.class);
    private File targetFile;
    private int fileLinesCount;
    private PARSING_CONSISTENCY parsingConsistency = PARSING_CONSISTENCY.IMPROVED;
    int queryIdNumber = 0;
    HashMap<String, String> queryIdMapping = new HashMap();
    String programName = null;
    String queryName = null;
    String databaseFile = null;
    private String queryId;
    private String subjectId;
    private String percIdentity;
    private String alnLength;
    private String mismatchCount;
    private String gapOpenCount;
    private String queryStart;
    private String queryEnd;
    private String subjectStart;
    private String subjectEnd;
    private String evalue;
    private String bitScore;

    @Override
    public List<String> getFileExtensions() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("blasttabular");
        l.add("blasttxt");
        return l;
    }

    @Override
    public void setFile(File f) {
        this.targetFile = f;
    }

    @Override
    public List<Result> createObjects(double maxEScore) throws IOException, ParseException {
        ArrayList<Result> results = new ArrayList<Result>();
        log.info("Query for hits");
        LineNumberReader lnr = new LineNumberReader(new FileReader(this.targetFile));
        lnr.skip(Long.MAX_VALUE);
        this.fileLinesCount = lnr.getLineNumber();
        log.info(this.fileLinesCount + " hits approximately in all results");
        lnr.close();
        FileInputStream fileInputStream = new FileInputStream(this.targetFile);
        Scanner scanner = new Scanner(fileInputStream);
        String line = this.fetchData(scanner);
        int lineNumber = 0;
        while (lineNumber < this.fileLinesCount) {
            try {
                BlastResultBuilder resultBuilder = new BlastResultBuilder();
                resultBuilder.setQueryID(this.queryId).setDbFile(this.databaseFile).setProgram(this.programName).setQueryDef(this.queryName).setReference("Zheng Zhang, Scott Schwartz, Lukas Wagner, and Webb Miller (2000), A greedy algorithm for aligning DNA sequences&quot;, J Comput Biol 2000; 7(1-2):203-14.");
                ArrayList<Hit> hits = new ArrayList<Hit>();
                String currentQueryId = this.queryId;
                while (currentQueryId.equals(this.queryId) && lineNumber < this.fileLinesCount) {
                    BlastHitBuilder hitBuilder = new BlastHitBuilder();
                    ArrayList<Hsp> hsps = new ArrayList<Hsp>();
                    String currentSubjectId = this.subjectId;
                    while (currentSubjectId.equals(this.subjectId) && lineNumber < this.fileLinesCount) {
                        Double d = new Double(this.evalue);
                        if (d > maxEScore) {
                            line = this.fetchData(scanner);
                            ++lineNumber;
                            continue;
                        }
                        BlastHspBuilder hspBuilder = new BlastHspBuilder();
                        hspBuilder.setHspAlignLen(new Integer(this.alnLength)).setHspGaps(new Integer(this.gapOpenCount)).setHspQueryFrom(new Integer(this.queryStart)).setHspQueryTo(new Integer(this.queryEnd)).setHspHitFrom(new Integer(this.subjectStart)).setHspHitTo(new Integer(this.subjectEnd)).setHspEvalue(new Double(this.evalue)).setHspBitScore(new Double(this.bitScore)).setPercentageIdentity(new Double(this.percIdentity) / 100.0).setMismatchCount(new Integer(this.mismatchCount));
                        hsps.add(hspBuilder.createBlastHsp());
                        if (scanner.hasNext()) {
                            line = this.fetchData(scanner);
                        }
                        ++lineNumber;
                    }
                    hits.add(hitBuilder.setHsps(hsps).createBlastHit());
                }
                results.add(resultBuilder.setHits(hits).createBlastResult());
            }
            catch (NumberFormatException e) {
                throw new ParseException("Invalid numeric value met at line " + lineNumber + " in:\n" + line, 0);
            }
        }
        return results;
    }

    private String fetchData(Scanner scanner) {
        String line = scanner.nextLine();
        while (line.startsWith("#")) {
            if (line.matches("#\\s.?BLAST.+")) {
                this.programName = line.replace("#\\s", "");
            }
            if (line.startsWith("# Query:")) {
                this.queryName = line.replace("# Query: ", "");
            }
            if (line.startsWith("# Database:")) {
                this.databaseFile = line.replace("# Database: ", "");
            }
            if (!scanner.hasNext()) {
                return null;
            }
            line = scanner.nextLine();
        }
        boolean headerFound = this.programName != null;
        String[] split = line.split("\\t");
        this.queryId = split[0];
        this.subjectId = split[1];
        this.percIdentity = split[2];
        this.alnLength = split[3];
        this.mismatchCount = split[4];
        this.gapOpenCount = split[5];
        this.queryStart = split[6];
        this.queryEnd = split[7];
        this.subjectStart = split[8];
        this.subjectEnd = split[9];
        this.evalue = split[10];
        this.bitScore = split[11];
        if (this.parsingConsistency == PARSING_CONSISTENCY.IMPROVED && headerFound) {
            if (this.queryIdMapping.get(this.queryId) == null) {
                ++this.queryIdNumber;
                this.queryIdMapping.put(this.queryId, "Query_" + this.queryIdNumber);
            }
            this.queryId = this.queryIdMapping.get(this.queryId);
        }
        if (!headerFound) {
            this.queryName = this.queryId;
        }
        return line;
    }

    @Override
    public void storeObjects(List<Result> results) throws IOException, ParseException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setQueryReferences(List<Sequence> sequences) {
        throw new UnsupportedOperationException("Not supported for this parser.");
    }

    @Override
    public void setDatabaseReferences(List<Sequence> sequences) {
        throw new UnsupportedOperationException("Not supported for this parser.");
    }

    public void setParsingConsistency(PARSING_CONSISTENCY parsingConsistency) {
        this.parsingConsistency = parsingConsistency;
    }

    private static enum PARSING_CONSISTENCY {
        IMPROVED,
        LITERAL;

    }
}

