/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.core.sequence;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import org.biojava.nbio.core.exceptions.CompoundNotFoundException;
import org.biojava.nbio.core.sequence.AccessionID;
import org.biojava.nbio.core.sequence.ChromosomeSequence;
import org.biojava.nbio.core.sequence.DNASequence;
import org.biojava.nbio.core.sequence.ExonComparator;
import org.biojava.nbio.core.sequence.ExonSequence;
import org.biojava.nbio.core.sequence.IntronSequence;
import org.biojava.nbio.core.sequence.Strand;
import org.biojava.nbio.core.sequence.TranscriptSequence;
import org.biojava.nbio.core.sequence.compound.DNACompoundSet;
import org.biojava.nbio.core.sequence.compound.NucleotideCompound;
import org.biojava.nbio.core.sequence.template.CompoundSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneSequence
extends DNASequence {
    private static final Logger logger = LoggerFactory.getLogger(GeneSequence.class);
    private final LinkedHashMap<String, TranscriptSequence> transcriptSequenceHashMap = new LinkedHashMap();
    private final LinkedHashMap<String, IntronSequence> intronSequenceHashMap = new LinkedHashMap();
    private final LinkedHashMap<String, ExonSequence> exonSequenceHashMap = new LinkedHashMap();
    private final ArrayList<IntronSequence> intronSequenceList = new ArrayList();
    private final ArrayList<ExonSequence> exonSequenceList = new ArrayList();
    boolean intronAdded = false;
    private Strand strand = Strand.UNDEFINED;
    private ChromosomeSequence chromosomeSequence;

    public GeneSequence(ChromosomeSequence parentSequence, int begin, int end, Strand strand) {
        this.setCompoundSet(DNACompoundSet.getDNACompoundSet());
        try {
            this.initSequenceStorage(parentSequence.getSequenceAsString());
        }
        catch (CompoundNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
        this.chromosomeSequence = parentSequence;
        this.setParentSequence(parentSequence);
        this.setBioBegin(begin);
        this.setBioEnd(end);
        this.setStrand(strand);
    }

    public GeneSequence(ChromosomeSequence parentSequence, AccessionID accessionId, int begin, int end, Strand strand) {
        this(parentSequence, begin, end, strand);
        this.setAccession(accessionId);
    }

    public ChromosomeSequence getParentChromosomeSequence() {
        return this.chromosomeSequence;
    }

    @Override
    public int getLength() {
        return Math.abs(this.getBioEnd() - this.getBioBegin()) + 1;
    }

    public void addIntronsUsingExons() throws Exception {
        if (this.intronAdded) {
            return;
        }
        if (this.exonSequenceList.size() == 0) {
            return;
        }
        ExonComparator exonComparator = new ExonComparator();
        Collections.sort(this.exonSequenceList, exonComparator);
        int shift = -1;
        if (this.getStrand() == Strand.NEGATIVE) {
            shift = 1;
        }
        int intronIndex = 1;
        for (int i = 0; i < this.exonSequenceList.size() - 1; ++i) {
            ExonSequence exon1 = this.exonSequenceList.get(i);
            ExonSequence exon2 = this.exonSequenceList.get(i + 1);
            AccessionID intronId = new AccessionID(this.getAccession().getID() + "-intron" + intronIndex);
            this.addIntron(intronId, exon1.getBioEnd() - shift, exon2.getBioBegin() + shift);
            ++intronIndex;
        }
    }

    public Strand getStrand() {
        return this.strand;
    }

    public void setStrand(Strand strand) {
        this.strand = strand;
    }

    public TranscriptSequence getTranscript(String accession) {
        return this.transcriptSequenceHashMap.get(accession);
    }

    public LinkedHashMap<String, TranscriptSequence> getTranscripts() {
        return this.transcriptSequenceHashMap;
    }

    public TranscriptSequence removeTranscript(String accession) {
        return (TranscriptSequence)this.transcriptSequenceHashMap.remove(accession);
    }

    public TranscriptSequence addTranscript(AccessionID accession, int begin, int end) throws Exception {
        if (this.transcriptSequenceHashMap.containsKey(accession.getID())) {
            throw new Exception("Duplicate accesion id " + accession.getID());
        }
        TranscriptSequence transcriptSequence = new TranscriptSequence(this, begin, end);
        transcriptSequence.setAccession(accession);
        this.transcriptSequenceHashMap.put(accession.getID(), transcriptSequence);
        return transcriptSequence;
    }

    public IntronSequence removeIntron(String accession) {
        for (IntronSequence intronSequence : this.intronSequenceList) {
            if (!intronSequence.getAccession().getID().equals(accession)) continue;
            this.intronSequenceList.remove(intronSequence);
            this.intronSequenceHashMap.remove(accession);
            return intronSequence;
        }
        return null;
    }

    public IntronSequence addIntron(AccessionID accession, int begin, int end) throws Exception {
        if (this.intronSequenceHashMap.containsKey(accession.getID())) {
            throw new Exception("Duplicate accesion id " + accession.getID());
        }
        this.intronAdded = true;
        IntronSequence intronSequence = new IntronSequence(this, begin, end);
        intronSequence.setAccession(accession);
        this.intronSequenceList.add(intronSequence);
        this.intronSequenceHashMap.put(accession.getID(), intronSequence);
        return intronSequence;
    }

    public ExonSequence removeExon(String accession) {
        for (ExonSequence exonSequence : this.exonSequenceList) {
            if (!exonSequence.getAccession().getID().equals(accession)) continue;
            this.exonSequenceList.remove(exonSequence);
            this.exonSequenceHashMap.remove(accession);
            this.intronSequenceList.clear();
            this.intronSequenceHashMap.clear();
            this.intronAdded = false;
            try {
                this.addIntronsUsingExons();
            }
            catch (Exception e) {
                logger.error("Remove Exon validate() error " + e.getMessage());
            }
            return exonSequence;
        }
        return null;
    }

    public ExonSequence addExon(AccessionID accession, int begin, int end) {
        if (this.exonSequenceHashMap.containsKey(accession.getID())) {
            throw new IllegalArgumentException("Duplicate accession id: " + accession.getID());
        }
        ExonSequence exonSequence = new ExonSequence(this, begin, end);
        exonSequence.setAccession(accession);
        this.exonSequenceList.add(exonSequence);
        this.exonSequenceHashMap.put(accession.getID(), exonSequence);
        return exonSequence;
    }

    public ArrayList<ExonSequence> getExonSequences() {
        return new ArrayList<ExonSequence>(this.exonSequenceList);
    }

    public ArrayList<IntronSequence> getIntronSequences() {
        return new ArrayList<IntronSequence>(this.intronSequenceList);
    }

    public DNASequence getSequence5PrimeTo3Prime() {
        String sequence = this.getSequenceAsString(this.getBioBegin(), this.getBioEnd(), this.getStrand());
        if (this.getStrand() == Strand.NEGATIVE) {
            StringBuilder b = new StringBuilder(this.getLength());
            CompoundSet compoundSet = this.getCompoundSet();
            for (int i = 0; i < sequence.length(); ++i) {
                String nucleotide = String.valueOf(sequence.charAt(i));
                NucleotideCompound nucleotideCompound = (NucleotideCompound)compoundSet.getCompoundForString(nucleotide);
                b.append(nucleotideCompound.getComplement().getShortName());
            }
            sequence = b.toString();
        }
        DNASequence dnaSequence = null;
        try {
            dnaSequence = new DNASequence(sequence.toUpperCase());
            dnaSequence.setAccession(new AccessionID(this.getAccession().getID()));
        }
        catch (CompoundNotFoundException e) {
            logger.error("Could not create new DNA sequence in getSequence5PrimeTo3Prime(). Error: {}", (Object)e.getMessage());
        }
        return dnaSequence;
    }
}

