/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.core.sequence.edits;

import java.util.ArrayList;
import org.biojava.nbio.core.exceptions.CompoundNotFoundException;
import org.biojava.nbio.core.sequence.BasicSequence;
import org.biojava.nbio.core.sequence.storage.JoiningSequenceReader;
import org.biojava.nbio.core.sequence.template.Compound;
import org.biojava.nbio.core.sequence.template.Sequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Edit<C extends Compound> {
    public Sequence<C> edit(Sequence<C> var1);

    public static class Substitute<C extends Compound>
    extends AbstractEdit<C> {
        public Substitute(String sequence, int position) {
            super(position);
            this.setStringSequence(sequence);
        }

        public Substitute(Sequence<C> sequence, int position) {
            super(position);
            this.setSequence(sequence);
        }

        public int getEnd(Sequence<C> sequence) {
            if (this.getEnd() == -1) {
                int start = this.getStart();
                int length = this.getTargetSequence(sequence).getLength();
                return start + length - 1;
            }
            return this.getEnd();
        }

        @Override
        protected Sequence<C> getFivePrime(Sequence<C> editingSequence) {
            int start = this.getStart();
            if (start == 1) {
                return this.getEmptySequence(editingSequence);
            }
            return editingSequence.getSubSequence(1, start - 1);
        }

        @Override
        protected Sequence<C> getThreePrime(Sequence<C> editingSequence) {
            int end = this.getEnd(editingSequence);
            if (end > editingSequence.getLength()) {
                throw new IndexOutOfBoundsException(end + " is greater than the max index of the editing sequence (" + editingSequence.getLength());
            }
            if (end == editingSequence.getLength()) {
                return this.getEmptySequence(editingSequence);
            }
            return editingSequence.getSubSequence(end + 1, editingSequence.getLength());
        }
    }

    public static class Insert<C extends Compound>
    extends AbstractEdit<C> {
        private final boolean singlePosition;

        public Insert(String sequence, int position) {
            super(position, position);
            this.singlePosition = true;
            this.setStringSequence(sequence);
        }

        public Insert(Sequence<C> sequence, int position) {
            super(position, position);
            this.singlePosition = true;
            this.setSequence(sequence);
        }

        public Insert(String sequence, int start, int stop) {
            super(start, stop);
            this.singlePosition = false;
            this.setStringSequence(sequence);
        }

        public Insert(Sequence<C> sequence, int start, int stop) {
            super(start, stop);
            this.singlePosition = false;
            this.setSequence(sequence);
        }

        @Override
        protected Sequence<C> getFivePrime(Sequence<C> editingSequence) {
            if (this.singlePosition) {
                if (this.getStart() == 1) {
                    return this.getEmptySequence(editingSequence);
                }
                if (this.getEnd() == editingSequence.getLength()) {
                    return editingSequence;
                }
                throw new IllegalStateException("Given one position to insert at but this is not the start or end of the Sequence; cannot support this");
            }
            return editingSequence.getSubSequence(1, this.getStart());
        }

        @Override
        protected Sequence<C> getThreePrime(Sequence<C> editingSequence) {
            if (this.singlePosition) {
                if (this.getStart() == 1) {
                    return editingSequence;
                }
                if (this.getEnd() == editingSequence.getLength()) {
                    return this.getEmptySequence(editingSequence);
                }
                throw new IllegalStateException("Given one position to insert at but this is not the start or end of the Sequence; cannot support this");
            }
            return editingSequence.getSubSequence(this.getEnd(), editingSequence.getLength());
        }
    }

    public static class Delete<C extends Compound>
    extends AbstractEdit<C> {
        public Delete(int position) {
            this(position, position);
        }

        public Delete(int start, int end) {
            super(start, end);
            this.setStringSequence("");
        }

        protected int getRealStart() {
            return this.getStart() - 1;
        }

        protected int getRealEnd() {
            return this.getEnd() + 1;
        }

        @Override
        protected Sequence<C> getFivePrime(Sequence<C> editingSequence) {
            int start = this.getRealStart();
            if (start == 0) {
                return this.getEmptySequence(editingSequence);
            }
            return editingSequence.getSubSequence(1, start);
        }

        @Override
        protected Sequence<C> getThreePrime(Sequence<C> editingSequence) {
            int end = this.getRealEnd();
            if (end > editingSequence.getLength()) {
                return this.getEmptySequence(editingSequence);
            }
            return editingSequence.getSubSequence(end, editingSequence.getLength());
        }
    }

    public static abstract class AbstractEdit<C extends Compound>
    implements Edit<C> {
        private static final Logger logger = LoggerFactory.getLogger(AbstractEdit.class);
        private int start = -1;
        private int end = -1;
        private String stringSequence;
        private Sequence<C> sequence;

        protected abstract Sequence<C> getFivePrime(Sequence<C> var1);

        protected abstract Sequence<C> getThreePrime(Sequence<C> var1);

        @Override
        public Sequence<C> edit(Sequence<C> editingSequence) {
            Sequence<C> targetSequence = this.getTargetSequence(editingSequence);
            ArrayList sequences = new ArrayList();
            sequences.add(this.getFivePrime(editingSequence));
            sequences.add(targetSequence);
            sequences.add(this.getThreePrime(editingSequence));
            return new JoiningSequenceReader(sequences);
        }

        public AbstractEdit(int start) {
            this.start = start;
        }

        public AbstractEdit(int start, int end) {
            this.start = start;
            this.end = end;
        }

        protected void setStringSequence(String stringSequence) {
            this.stringSequence = stringSequence;
        }

        protected void setSequence(Sequence<C> sequence) {
            this.sequence = sequence;
        }

        public Sequence<C> getTargetSequence(Sequence<C> editingSequence) {
            if (this.sequence == null && this.stringSequence != null) {
                try {
                    this.sequence = new BasicSequence<C>(this.stringSequence, editingSequence.getCompoundSet());
                }
                catch (CompoundNotFoundException e) {
                    logger.error("Problem setting sequence, some unrecognised compounds: {}", (Object)e.getMessage());
                }
            }
            return this.sequence;
        }

        protected Sequence<C> getEmptySequence(Sequence<C> editingSequence) {
            BasicSequence<C> s2 = null;
            try {
                s2 = new BasicSequence<C>("", editingSequence.getCompoundSet());
            }
            catch (CompoundNotFoundException e) {
                logger.error("Could not construct empty sequence. {}. This is most likely a bug.", (Object)e.getMessage());
            }
            return s2;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }
    }
}

