/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.core.sequence.io.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.biojava.nbio.core.exceptions.ParserException;
import org.biojava.nbio.core.sequence.compound.AmbiguityDNACompoundSet;
import org.biojava.nbio.core.sequence.compound.AmbiguityRNACompoundSet;
import org.biojava.nbio.core.sequence.compound.DNACompoundSet;
import org.biojava.nbio.core.sequence.compound.RNACompoundSet;
import org.biojava.nbio.core.sequence.template.Compound;
import org.biojava.nbio.core.sequence.template.CompoundSet;
import org.biojava.nbio.core.sequence.template.Sequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOUtils {
    private static final Logger logger = LoggerFactory.getLogger(IOUtils.class);
    private static final int BUFFER = 4096;

    public static void close(Closeable c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (IOException e) {
            logger.warn("Cannot close down the given Closeable object", (Throwable)e);
        }
    }

    public static void copy(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
    }

    public static void processReader(BufferedReader br, ReaderProcessor processor) throws ParserException {
        try {
            String line;
            while ((line = br.readLine()) != null) {
                processor.process(line);
            }
        }
        catch (IOException e) {
            throw new ParserException("Could not read from the given BufferedReader");
        }
        finally {
            IOUtils.close(br);
        }
    }

    public static List<String> getList(BufferedReader br) throws ParserException {
        final ArrayList<String> list = new ArrayList<String>();
        IOUtils.processReader(br, new ReaderProcessor(){

            @Override
            public void process(String line) {
                list.add(line);
            }
        });
        return list;
    }

    public static List<String> getList(InputStream is) throws ParserException {
        return IOUtils.getList(new BufferedReader(new InputStreamReader(is)));
    }

    public static List<String> getList(File file) throws IOException {
        return IOUtils.getList(IOUtils.openFile(file));
    }

    public static InputStream openFile(File file) throws IOException {
        if (!file.isFile()) {
            throw new ParserException("The file " + file + " is not a file.");
        }
        String name = file.getName();
        InputStream is = name.endsWith(".gz") ? new GZIPInputStream(new FileInputStream(file)) : new FileInputStream(file);
        return is;
    }

    public static <S extends Sequence<C>, C extends Compound> int getGCGChecksum(List<S> sequences) {
        int check = 0;
        for (Sequence as : sequences) {
            check += IOUtils.getGCGChecksum(as);
        }
        return check % 10000;
    }

    public static <S extends Sequence<C>, C extends Compound> int getGCGChecksum(S sequence) {
        String s2 = sequence.toString().toUpperCase();
        int count = 0;
        int check = 0;
        for (int i = 0; i < s2.length(); ++i) {
            check += ++count * s2.charAt(i);
            if (count != 57) continue;
            count = 0;
        }
        return check % 10000;
    }

    public static <S extends Sequence<C>, C extends Compound> String getGCGHeader(List<S> sequences) {
        StringBuilder header = new StringBuilder();
        Sequence s1 = (Sequence)sequences.get(0);
        header.append(String.format("MSA from BioJava%n%n MSF: %d  Type: %s  Check: %d ..%n%n", s1.getLength(), IOUtils.getGCGType(s1.getCompoundSet()), IOUtils.getGCGChecksum(sequences)));
        String format = " Name: " + IOUtils.getIDFormat(sequences) + " Len: " + s1.getLength() + "  Check: %4d  Weight: 1.0%n";
        for (Sequence as : sequences) {
            header.append(String.format(format, as.getAccession(), IOUtils.getGCGChecksum(as)));
        }
        header.append(String.format("%n//%n%n", new Object[0]));
        return header.toString();
    }

    public static <C extends Compound> String getGCGType(CompoundSet<C> cs) {
        return cs == DNACompoundSet.getDNACompoundSet() || cs == AmbiguityDNACompoundSet.getDNACompoundSet() ? "D" : (cs == RNACompoundSet.getRNACompoundSet() || cs == AmbiguityRNACompoundSet.getRNACompoundSet() ? "R" : "P");
    }

    public static <S extends Sequence<C>, C extends Compound> String getIDFormat(List<S> sequences) {
        int length = 0;
        for (Sequence as : sequences) {
            length = Math.max(length, as.getAccession() == null ? 0 : as.getAccession().toString().length());
        }
        return length == 0 ? null : "%-" + (length + 1) + "s";
    }

    public static String getPDBCharacter(boolean web, char c1, char c2, boolean similar, char c) {
        String s2 = String.valueOf(c);
        return IOUtils.getPDBString(web, c1, c2, similar, s2, s2, s2, s2);
    }

    public static String getPDBConservation(boolean web, char c1, char c2, boolean similar) {
        return IOUtils.getPDBString(web, c1, c2, similar, "|", ".", " ", web ? "&nbsp;" : " ");
    }

    private static String getPDBString(boolean web, char c1, char c2, boolean similar, String m3, String sm, String dm, String qg) {
        if (c1 == c2) {
            return web ? "<span class=\"m\">" + m3 + "</span>" : m3;
        }
        if (similar) {
            return web ? "<span class=\"sm\">" + sm + "</span>" : sm;
        }
        if (c1 == '-' || c2 == '-') {
            return web ? "<span class=\"dm\">" + dm + "</span>" : dm;
        }
        return web ? "<span class=\"qg\">" + qg + "</span>" : qg;
    }

    public static String getPDBLegend() {
        StringBuilder s2 = new StringBuilder();
        s2.append("</pre></div>");
        s2.append("          <div class=\"subText\">");
        s2.append("          <b>Legend:</b>");
        s2.append("          <span class=\"m\">Green</span> - identical residues |");
        s2.append("          <span class=\"sm\">Pink</span> - similar residues | ");
        s2.append("          <span class=\"qg\">Blue</span> - sequence mismatch |");
        s2.append("          <span class=\"dm\">Brown</span> - insertion/deletion |");
        s2.append("      </div>");
        s2.append(String.format("%n", new Object[0]));
        return s2.toString();
    }

    public static void print(String string, File file) throws IOException {
        try (PrintWriter out = null;){
            out = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            out.print(string);
            out.flush();
            out.close();
        }
    }

    public static interface ReaderProcessor {
        public void process(String var1) throws IOException;
    }
}

