/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.core.sequence.loader;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import org.biojava.nbio.core.exceptions.CompoundNotFoundException;
import org.biojava.nbio.core.sequence.compound.AminoAcidCompoundSet;
import org.biojava.nbio.core.sequence.features.AbstractFeature;
import org.biojava.nbio.core.sequence.features.DBReferenceInfo;
import org.biojava.nbio.core.sequence.features.DatabaseReferenceInterface;
import org.biojava.nbio.core.sequence.features.FeatureRetriever;
import org.biojava.nbio.core.sequence.features.FeaturesKeyWordInterface;
import org.biojava.nbio.core.sequence.io.GenbankSequenceParser;
import org.biojava.nbio.core.sequence.io.GenericGenbankHeaderParser;
import org.biojava.nbio.core.sequence.loader.StringProxySequenceReader;
import org.biojava.nbio.core.sequence.template.AbstractSequence;
import org.biojava.nbio.core.sequence.template.Compound;
import org.biojava.nbio.core.sequence.template.CompoundSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenbankProxySequenceReader<C extends Compound>
extends StringProxySequenceReader<C>
implements FeaturesKeyWordInterface,
DatabaseReferenceInterface,
FeatureRetriever {
    private static final Logger logger = LoggerFactory.getLogger(GenbankProxySequenceReader.class);
    private static final String eutilBaseURL = "https://eutils.ncbi.nlm.nih.gov/entrez/eutils/";
    private String genbankDirectoryCache = null;
    private GenbankSequenceParser<AbstractSequence<C>, C> genbankParser;
    private GenericGenbankHeaderParser<AbstractSequence<C>, C> headerParser;
    private String header;
    private Map<String, List<AbstractFeature<AbstractSequence<C>, C>>> features;

    public GenbankProxySequenceReader(String genbankDirectoryCache, String accessionID, CompoundSet<C> compoundSet) throws IOException, InterruptedException, CompoundNotFoundException {
        this.setGenbankDirectoryCache(genbankDirectoryCache);
        this.setCompoundSet(compoundSet);
        String db = compoundSet instanceof AminoAcidCompoundSet ? "protein" : "nuccore";
        BufferedInputStream inStream = this.getBufferedInputStream(accessionID, db);
        this.genbankParser = new GenbankSequenceParser();
        this.setContents(this.genbankParser.getSequence(new BufferedReader(new InputStreamReader(inStream)), 0));
        this.headerParser = this.genbankParser.getSequenceHeaderParser();
        this.header = this.genbankParser.getHeader();
        this.features = this.genbankParser.getFeatures();
        if (compoundSet.getClass().equals(AminoAcidCompoundSet.class) && !this.genbankParser.getCompoundType().equals(compoundSet)) {
            logger.error("Declared compount type {} does not mach the real: {}", (Object)this.genbankParser.getCompoundType().toString(), (Object)compoundSet.toString());
            throw new IOException("Wrong declared compound type for: " + accessionID);
        }
        ((InputStream)inStream).close();
    }

    private BufferedInputStream getBufferedInputStream(String accessionID, String db) throws IOException, InterruptedException {
        BufferedInputStream inStream = null;
        if (this.genbankDirectoryCache != null && this.genbankDirectoryCache.length() > 0) {
            File f = new File(this.genbankDirectoryCache + File.separatorChar + accessionID + ".gb");
            if (f.exists()) {
                logger.debug("Reading: {}", (Object)f.toString());
                inStream = new BufferedInputStream(new FileInputStream(f));
            } else {
                InputStream in = this.getEutilsInputStream(accessionID, db);
                this.copyInputStreamToFile(in, f);
                inStream = new BufferedInputStream(new FileInputStream(f));
            }
        } else {
            inStream = new BufferedInputStream(this.getEutilsInputStream(accessionID, db));
        }
        return inStream;
    }

    private void copyInputStreamToFile(InputStream in, File f) throws IOException, InterruptedException {
        try (FileOutputStream out = new FileOutputStream(f);){
            byte[] buffer = new byte[1024];
            int len = in.read(buffer);
            while (len != -1) {
                out.write(buffer, 0, len);
                len = in.read(buffer);
                if (!Thread.interrupted()) continue;
                in.close();
                out.close();
                throw new InterruptedException();
            }
            in.close();
        }
    }

    private InputStream getEutilsInputStream(String accessionID, String db) throws IOException {
        String genbankURL = "https://eutils.ncbi.nlm.nih.gov/entrez/eutils/efetch.fcgi?db=" + db + "&id=" + accessionID + "&rettype=gb&retmode=text";
        logger.trace("Loading: {}", (Object)genbankURL);
        URL genbank = new URL(genbankURL);
        URLConnection genbankConnection = genbank.openConnection();
        return genbankConnection.getInputStream();
    }

    public String getGenbankDirectoryCache() {
        return this.genbankDirectoryCache;
    }

    public void setGenbankDirectoryCache(String genbankDirectoryCache) {
        File f;
        if (genbankDirectoryCache != null && !(f = new File(genbankDirectoryCache)).exists()) {
            f.mkdirs();
        }
        this.genbankDirectoryCache = genbankDirectoryCache;
    }

    public String getHeader() {
        return this.header;
    }

    public GenericGenbankHeaderParser<AbstractSequence<C>, C> getHeaderParser() {
        return this.headerParser;
    }

    @Override
    public Map<String, List<AbstractFeature<AbstractSequence<C>, C>>> getFeatures() {
        return this.features;
    }

    @Override
    public Map<String, List<DBReferenceInfo>> getDatabaseReferences() {
        return this.genbankParser.getDatabaseReferences();
    }

    @Override
    public List<String> getKeyWords() {
        return this.genbankParser.getKeyWords();
    }
}

