/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.core.sequence.location;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.biojava.nbio.core.exceptions.ParserException;
import org.biojava.nbio.core.sequence.AccessionID;
import org.biojava.nbio.core.sequence.DataSource;
import org.biojava.nbio.core.sequence.Strand;
import org.biojava.nbio.core.sequence.location.InsdcLocations;
import org.biojava.nbio.core.sequence.location.SimpleLocation;
import org.biojava.nbio.core.sequence.location.SimplePoint;
import org.biojava.nbio.core.sequence.location.template.AbstractLocation;
import org.biojava.nbio.core.sequence.location.template.Location;
import org.biojava.nbio.core.sequence.location.template.Point;

public class InsdcParser {
    private boolean isSequenceCircular;
    private long sequenceLength;
    private final DataSource dataSource;
    protected static final Pattern singleLocationPattern = Pattern.compile("(?:([A-Za-z\\.0-9_]*?):)?(<?)(\\d+)(\\.{2}|\\^)?(>?)(\\d+)?(>?)?");
    protected static final Pattern genbankSplitPattern = Pattern.compile("^\\s?(join|order|bond|complement|)\\(?(.+)\\)?");
    protected static final String locationSplitPattern = ",(?=([^\\(|\\)]+\\([^\\(|\\)]+\\))[^\\(|\\)]+)";
    protected Integer featureGlobalStart;
    protected Integer featureGlobalEnd;
    private complexFeaturesAppendEnum complexFeaturesAppendMode = complexFeaturesAppendEnum.HIERARCHICAL;

    public void setComplexFeaturesAppendMode(complexFeaturesAppendEnum complexFeaturesAppendMode) {
        this.complexFeaturesAppendMode = complexFeaturesAppendMode;
    }

    public InsdcParser() {
        this(DataSource.ENA);
    }

    public InsdcParser(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setSequenceCircular(boolean sequenceCircular) {
        this.isSequenceCircular = sequenceCircular;
    }

    public void setSequenceLength(long sequenceLength) {
        this.sequenceLength = sequenceLength;
    }

    public Location parse(String locationString) throws ParserException {
        this.featureGlobalStart = Integer.MAX_VALUE;
        this.featureGlobalEnd = 1;
        List<Location> ll = this.parseLocationString(locationString, 1);
        Location l = ll.size() == 1 ? ll.get(0) : new SimpleLocation((Point)new SimplePoint(this.featureGlobalStart), (Point)new SimplePoint(this.featureGlobalEnd), Strand.UNDEFINED, this.isSequenceCircular, ll);
        return l;
    }

    private List<Location> parseLocationString(String string, int versus) throws ParserException {
        ArrayList<Location> boundedLocationsCollection = new ArrayList<Location>();
        List<String> tokens = this.splitString(string);
        for (String t : tokens) {
            SimpleLocation l;
            int end;
            Matcher m3 = genbankSplitPattern.matcher(t);
            if (!m3.find()) {
                throw new ParserException("Cannot interpret split pattern " + t + "\nin location string:" + string);
            }
            String splitQualifier = m3.group(1);
            String splitString = m3.group(2);
            if (!splitQualifier.isEmpty()) {
                int localVersus = splitQualifier.equalsIgnoreCase("complement") ? -1 : 1;
                List<Location> subLocations = this.parseLocationString(splitString, versus * localVersus);
                switch (this.complexFeaturesAppendMode) {
                    case FLATTEN: {
                        boundedLocationsCollection.addAll(subLocations);
                        break;
                    }
                    case HIERARCHICAL: {
                        if (subLocations.size() == 1) {
                            boundedLocationsCollection.addAll(subLocations);
                            break;
                        }
                        Point min2 = Location.Tools.getMin(subLocations).getStart();
                        Point max = Location.Tools.getMax(subLocations).getEnd();
                        AbstractLocation motherLocation = new SimpleLocation(min2, max);
                        if (splitQualifier.equalsIgnoreCase("join")) {
                            motherLocation = new InsdcLocations.GroupLocation(subLocations);
                        }
                        if (splitQualifier.equalsIgnoreCase("order")) {
                            motherLocation = new InsdcLocations.OrderLocation(subLocations);
                        }
                        if (splitQualifier.equalsIgnoreCase("bond")) {
                            motherLocation = new InsdcLocations.BondLocation(subLocations);
                        }
                        motherLocation.setStrand(this.getGroupLocationStrand(subLocations));
                        boundedLocationsCollection.add(motherLocation);
                    }
                }
                continue;
            }
            m3 = singleLocationPattern.matcher(splitString);
            if (!m3.find()) {
                throw new ParserException("Cannot interpret location pattern " + splitString + "\nin location string:" + string);
            }
            String accession = m3.group(1);
            Strand s2 = versus == 1 ? Strand.POSITIVE : Strand.NEGATIVE;
            int start = Integer.valueOf(m3.group(3));
            int n = end = m3.group(6) == null ? start : Integer.valueOf(m3.group(6));
            if (this.featureGlobalStart > start) {
                this.featureGlobalStart = start;
            }
            if (this.featureGlobalEnd < end) {
                this.featureGlobalEnd = end;
            }
            if (start <= end) {
                l = new SimpleLocation(start, end, s2);
            } else {
                SimpleLocation l5prime = new SimpleLocation(1, end, Strand.UNDEFINED);
                SimpleLocation l3prime = new SimpleLocation(start, (int)this.sequenceLength, Strand.UNDEFINED);
                l = new InsdcLocations.GroupLocation((Point)new SimplePoint(start), (Point)new SimplePoint(end), s2, this.isSequenceCircular, l5prime, l3prime);
            }
            if (m3.group(4) != null && m3.group(4).equals("^")) {
                l.setBetweenCompounds(true);
            }
            if (m3.group(2).equals("<")) {
                l.setPartialOn5prime(true);
            }
            if (m3.group(5) != null && (m3.group(5).equals(">") || m3.group(7).equals(">"))) {
                l.setPartialOn3prime(true);
            }
            if (accession != null && !"".equals(accession)) {
                l.setAccession(new AccessionID(accession));
            }
            boundedLocationsCollection.add(l);
        }
        return boundedLocationsCollection;
    }

    private List<String> splitString(String input) {
        ArrayList<String> result = new ArrayList<String>();
        int start = 0;
        int openedParenthesis = 0;
        for (int current = 0; current < input.length(); ++current) {
            boolean atLastChar;
            if (input.charAt(current) == '(') {
                ++openedParenthesis;
            }
            if (input.charAt(current) == ')') {
                --openedParenthesis;
            }
            boolean bl = atLastChar = current == input.length() - 1;
            if (atLastChar) {
                result.add(input.substring(start));
                continue;
            }
            if (input.charAt(current) != ',' || openedParenthesis != 0) continue;
            result.add(input.substring(start, current));
            start = current + 1;
        }
        return result;
    }

    private Strand getGroupLocationStrand(List<Location> ll) {
        Strand returnStrand = null;
        for (Location l : ll) {
            if (returnStrand == null) {
                returnStrand = l.getStrand();
            }
            if (returnStrand == l.getStrand()) continue;
            return Strand.UNDEFINED;
        }
        return returnStrand;
    }

    static enum complexFeaturesAppendEnum {
        FLATTEN,
        HIERARCHICAL;

    }
}

