/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.core.sequence.location;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.biojava.nbio.core.exceptions.ParserException;
import org.biojava.nbio.core.sequence.AccessionID;
import org.biojava.nbio.core.sequence.Strand;
import org.biojava.nbio.core.sequence.location.InsdcLocations;
import org.biojava.nbio.core.sequence.location.SimpleLocation;
import org.biojava.nbio.core.sequence.location.SimplePoint;
import org.biojava.nbio.core.sequence.location.template.AbstractLocation;
import org.biojava.nbio.core.sequence.location.template.Location;
import org.biojava.nbio.core.sequence.location.template.Point;

public class LocationHelper {
    public static Location location(List<Location> subLocations) {
        return LocationHelper.location(subLocations, "join");
    }

    public static Location location(List<Location> subLocations, String type) {
        AbstractLocation l;
        if (subLocations.size() == 1) {
            return subLocations.get(0);
        }
        boolean circular = LocationHelper.detectCicular(subLocations);
        Strand strand = LocationHelper.detectStrand(subLocations);
        Point start = LocationHelper.detectStart(subLocations);
        Point end = LocationHelper.detectEnd(subLocations, circular);
        if ("join".equals(type)) {
            l = new SimpleLocation(start, end, strand, circular, subLocations);
        } else if ("order".equals(type)) {
            l = new InsdcLocations.OrderLocation(start, end, strand, circular, subLocations);
        } else if ("one-of".equals(type)) {
            l = new InsdcLocations.OneOfLocation(subLocations);
        } else if ("group".equals(type)) {
            l = new InsdcLocations.GroupLocation(start, end, strand, circular, subLocations);
        } else if ("bond".equals(type)) {
            l = new InsdcLocations.BondLocation(subLocations);
        } else {
            throw new ParserException("Unknown join type " + type);
        }
        return l;
    }

    public static Location location(int start, int end, Strand strand, int length) {
        boolean isReverse;
        int min2 = Math.min(start, end);
        boolean bl = isReverse = min2 != start;
        if (isReverse) {
            return new SimpleLocation(new SimplePoint(start).reverse(length), new SimplePoint(end).reverse(length), strand);
        }
        return new SimpleLocation(start, end, strand);
    }

    public static Location circularLocation(int start, int end, Strand strand, int length) {
        boolean isReverse;
        int min2 = Math.min(start, end);
        int max = Math.max(start, end);
        boolean bl = isReverse = min2 != start;
        if (min2 > length) {
            throw new IllegalArgumentException("Cannot process a location whose lowest coordinate is less than the given length " + length);
        }
        if (max <= length) {
            return LocationHelper.location(start, end, strand, length);
        }
        int modStart = LocationHelper.modulateCircularIndex(start, length);
        int modEnd = LocationHelper.modulateCircularIndex(end, length);
        int numberOfPasses = LocationHelper.completeCircularPasses(Math.max(start, end), length);
        if (isReverse) {
            int reversedModStart = new SimplePoint(modStart).reverse(length).getPosition();
            int reversedModEnd = new SimplePoint(modEnd).reverse(length).getPosition();
            modStart = reversedModStart;
            modEnd = reversedModEnd;
            start = reversedModStart;
            end = length * (numberOfPasses + 1) + modEnd;
        }
        ArrayList<Location> locations = new ArrayList<Location>();
        locations.add(new SimpleLocation(modStart, length, strand));
        for (int i = 0; i < numberOfPasses; ++i) {
            locations.add(new SimpleLocation(1, length, strand));
        }
        locations.add(new SimpleLocation(1, modEnd, strand));
        return new SimpleLocation((Point)new SimplePoint(start), (Point)new SimplePoint(end), strand, true, false, locations);
    }

    public static Location getMin(List<Location> locations) {
        return LocationHelper.scanLocations(locations, new LocationPredicate(){

            @Override
            public boolean accept(Location previous, Location current) {
                int res = current.getStart().compareTo(previous.getStart());
                return res < 0;
            }
        });
    }

    public static Location getMax(List<Location> locations) {
        return LocationHelper.scanLocations(locations, new LocationPredicate(){

            @Override
            public boolean accept(Location previous, Location current) {
                int res = current.getEnd().compareTo(previous.getEnd());
                return res > 0;
            }
        });
    }

    private static Location scanLocations(List<Location> locations, LocationPredicate predicate) {
        Location location = null;
        for (Location l : locations) {
            if (location == null) {
                location = l;
                continue;
            }
            if (!predicate.accept(location, l)) continue;
            location = l;
        }
        return location;
    }

    public static int modulateCircularIndex(int index, int seqLength) {
        if (seqLength == 0) {
            return index;
        }
        while (index > seqLength) {
            index -= seqLength;
        }
        return index;
    }

    public static int completeCircularPasses(int index, int seqLength) {
        int count = 0;
        while (index > seqLength) {
            ++count;
            index -= seqLength;
        }
        return count - 1;
    }

    public static boolean detectCicular(List<Location> subLocations) {
        boolean isCircular = false;
        if (!LocationHelper.consistentAccessions(subLocations)) {
            return isCircular;
        }
        int lastMax = 0;
        for (Location sub : subLocations) {
            if (sub.getEnd().getPosition() > lastMax) {
                lastMax = sub.getEnd().getPosition();
                continue;
            }
            isCircular = true;
            break;
        }
        return isCircular;
    }

    public static boolean consistentAccessions(List<Location> subLocations) {
        HashSet<AccessionID> set = new HashSet<AccessionID>();
        for (Location sub : subLocations) {
            set.add(sub.getAccession());
        }
        return set.size() == 1;
    }

    public static Strand detectStrand(List<Location> subLocations) {
        Strand strand = subLocations.get(0).getStrand();
        for (Location sub : subLocations) {
            if (strand == sub.getStrand()) continue;
            strand = Strand.UNDEFINED;
            break;
        }
        return strand;
    }

    public static Point detectStart(List<Location> subLocations) {
        return subLocations.get(0).getStart().clonePoint();
    }

    public static Point detectEnd(List<Location> subLocations, boolean isCircular) {
        int end = 0;
        Point lastPoint = null;
        if (isCircular) {
            for (Location sub : subLocations) {
                lastPoint = sub.getEnd();
                end += lastPoint.getPosition().intValue();
            }
        } else {
            lastPoint = subLocations.get(subLocations.size() - 1).getEnd();
            end = lastPoint.getPosition();
        }
        return new SimplePoint(end, lastPoint.isUnknown(), lastPoint.isUncertain());
    }

    private static interface LocationPredicate {
        public boolean accept(Location var1, Location var2);
    }
}

