/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.core.sequence.storage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.biojava.nbio.core.exceptions.CompoundNotFoundException;
import org.biojava.nbio.core.sequence.AccessionID;
import org.biojava.nbio.core.sequence.template.Compound;
import org.biojava.nbio.core.sequence.template.CompoundSet;
import org.biojava.nbio.core.sequence.template.ProxySequenceReader;
import org.biojava.nbio.core.sequence.template.Sequence;
import org.biojava.nbio.core.sequence.template.SequenceMixin;
import org.biojava.nbio.core.sequence.template.SequenceView;
import org.biojava.nbio.core.util.Equals;

public class JoiningSequenceReader<C extends Compound>
implements ProxySequenceReader<C> {
    private static final boolean BINARY_SEARCH = true;
    private final List<Sequence<C>> sequences;
    private final CompoundSet<C> compoundSet;
    private int[] maxSequenceIndex;
    private int[] minSequenceIndex;

    public JoiningSequenceReader(Sequence<C> ... sequences) {
        this(Arrays.asList(sequences));
    }

    public JoiningSequenceReader(List<Sequence<C>> sequences) {
        this.sequences = this.grepSequences(sequences);
        this.compoundSet = this.grepCompoundSet();
    }

    public JoiningSequenceReader(CompoundSet<C> compoundSet, Sequence<C> ... sequences) {
        this(compoundSet, Arrays.asList(sequences));
    }

    public JoiningSequenceReader(CompoundSet<C> compoundSet, List<Sequence<C>> sequences) {
        this.sequences = this.grepSequences(sequences);
        this.compoundSet = compoundSet;
    }

    private List<Sequence<C>> grepSequences(List<Sequence<C>> sequences) {
        ArrayList<Sequence<C>> seqs = new ArrayList<Sequence<C>>();
        for (Sequence<C> s2 : sequences) {
            if (s2.getLength() == 0) continue;
            seqs.add(s2);
        }
        return seqs;
    }

    private CompoundSet<C> grepCompoundSet() {
        if (this.sequences.isEmpty()) {
            throw new IllegalStateException("Cannot get a CompoundSet because we have no sequences. Set during construction");
        }
        return this.sequences.get(0).getCompoundSet();
    }

    @Override
    public C getCompoundAt(int position) {
        int sequenceIndex = this.getSequenceIndex(position);
        Sequence<C> sequence = this.sequences.get(sequenceIndex);
        int indexInSequence = position - this.getMinSequenceIndex()[sequenceIndex] + 1;
        return sequence.getCompoundAt(indexInSequence);
    }

    @Override
    public CompoundSet<C> getCompoundSet() {
        return this.compoundSet;
    }

    @Override
    public int getLength() {
        int[] maxSeqIndex = this.getMaxSequenceIndex();
        if (maxSeqIndex.length == 0) {
            return 0;
        }
        return maxSeqIndex[maxSeqIndex.length - 1];
    }

    private int getSequenceIndex(int position) {
        return this.binarySearch(position);
    }

    private int[] getMinSequenceIndex() {
        if (this.minSequenceIndex == null) {
            this.initSeqIndexes();
        }
        return this.minSequenceIndex;
    }

    private int[] getMaxSequenceIndex() {
        if (this.maxSequenceIndex == null) {
            this.initSeqIndexes();
        }
        return this.maxSequenceIndex;
    }

    private void initSeqIndexes() {
        this.minSequenceIndex = new int[this.sequences.size()];
        this.maxSequenceIndex = new int[this.sequences.size()];
        int currentMaxIndex = 0;
        int currentMinIndex = 1;
        int lastLength = 0;
        for (int i = 0; i < this.sequences.size(); ++i) {
            this.minSequenceIndex[i] = currentMinIndex += lastLength;
            this.maxSequenceIndex[i] = currentMaxIndex += this.sequences.get(i).getLength();
            lastLength = this.sequences.get(i).getLength();
        }
    }

    private int linearSearch(int position) {
        int[] minSeqIndex = this.getMinSequenceIndex();
        int[] maxSeqIndex = this.getMaxSequenceIndex();
        int length = minSeqIndex.length;
        for (int i = 0; i < length; ++i) {
            if (position < minSeqIndex[i] || position > maxSeqIndex[i]) continue;
            return i;
        }
        throw new IndexOutOfBoundsException("Given position " + position + " does not map into this Sequence");
    }

    private int binarySearch(int position) {
        int[] minSeqIndex = this.getMinSequenceIndex();
        int[] maxSeqIndex = this.getMaxSequenceIndex();
        int low = 0;
        int high = minSeqIndex.length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midMinPosition = minSeqIndex[mid];
            int midMaxPosition = maxSeqIndex[mid];
            if (midMinPosition < position && midMaxPosition < position) {
                low = mid + 1;
                continue;
            }
            if (midMinPosition > position && midMaxPosition > position) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        throw new IndexOutOfBoundsException("Given position " + position + " does not map into this Sequence");
    }

    @Override
    public Iterator<C> iterator() {
        final List<Sequence<C>> localSequences = this.sequences;
        return new Iterator<C>(){
            private Iterator<C> currentSequenceIterator = null;
            private int currentPosition = 0;

            @Override
            public boolean hasNext() {
                if (this.currentSequenceIterator == null) {
                    return !localSequences.isEmpty();
                }
                boolean hasNext = this.currentSequenceIterator.hasNext();
                if (!hasNext) {
                    hasNext = this.currentPosition < JoiningSequenceReader.this.sequences.size();
                }
                return hasNext;
            }

            @Override
            public C next() {
                if (this.currentSequenceIterator == null) {
                    if (localSequences.isEmpty()) {
                        throw new NoSuchElementException("No sequences to iterate over; make sure you call hasNext() before next()");
                    }
                    this.currentSequenceIterator = ((Sequence)localSequences.get(this.currentPosition)).iterator();
                    ++this.currentPosition;
                }
                if (!this.currentSequenceIterator.hasNext()) {
                    this.currentSequenceIterator = ((Sequence)localSequences.get(this.currentPosition)).iterator();
                    ++this.currentPosition;
                }
                return (Compound)this.currentSequenceIterator.next();
            }

            @Override
            public void remove() throws UnsupportedOperationException {
                throw new UnsupportedOperationException("Cannot remove from this Sequence");
            }
        };
    }

    @Override
    public void setCompoundSet(CompoundSet<C> compoundSet) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setContents(String sequence) throws CompoundNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int countCompounds(C ... compounds) {
        return SequenceMixin.countCompounds((Sequence)this, compounds);
    }

    @Override
    public AccessionID getAccession() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<C> getAsList() {
        return SequenceMixin.toList(this);
    }

    public boolean equals(Object o) {
        if (!Equals.classEqual(this, o)) {
            return false;
        }
        Sequence other = (Sequence)o;
        if (other.getCompoundSet() != this.getCompoundSet()) {
            return false;
        }
        List<C> rawCompounds = this.getAsList();
        List otherCompounds = other.getAsList();
        if (rawCompounds.size() != otherCompounds.size()) {
            return false;
        }
        for (int i = 0; i < rawCompounds.size(); ++i) {
            Compound otherCompound;
            Compound myCompound = (Compound)rawCompounds.get(i);
            if (myCompound.equalsIgnoreCase(otherCompound = (Compound)otherCompounds.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        String s2 = this.getSequenceAsString();
        return s2.hashCode();
    }

    @Override
    public int getIndexOf(C compound) {
        return SequenceMixin.indexOf(this, compound);
    }

    @Override
    public int getLastIndexOf(C compound) {
        return SequenceMixin.lastIndexOf(this, compound);
    }

    @Override
    public String getSequenceAsString() {
        return SequenceMixin.toStringBuilder(this).toString();
    }

    @Override
    public SequenceView<C> getSubSequence(Integer start, Integer end) {
        return SequenceMixin.createSubSequence(this, start, end);
    }

    @Override
    public SequenceView<C> getInverse() {
        return SequenceMixin.inverse(this);
    }
}

