/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.core.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleLinkageClusterer {
    private static final Logger logger = LoggerFactory.getLogger(SingleLinkageClusterer.class);
    private double[][] matrix;
    private boolean isScoreMatrix;
    private int numItems;
    private LinkedPair[] dendrogram;
    private ArrayList<Integer> indicesToCheck;

    public SingleLinkageClusterer(double[][] matrix, boolean isScoreMatrix) {
        this.matrix = matrix;
        this.isScoreMatrix = isScoreMatrix;
        if (matrix.length != matrix[0].length) {
            throw new IllegalArgumentException("Distance matrix for clustering must be a square matrix");
        }
        this.numItems = matrix.length;
    }

    public LinkedPair[] getDendrogram() {
        if (this.dendrogram == null) {
            this.clusterIt();
        }
        return this.dendrogram;
    }

    private void clusterIt() {
        this.dendrogram = new LinkedPair[this.numItems - 1];
        logger.debug("Initial matrix: \n" + this.matrixToString());
        for (int m3 = 0; m3 < this.numItems - 1; ++m3) {
            this.updateIndicesToCheck(m3);
            LinkedPair pair = this.getClosestPair();
            this.merge(pair);
            this.dendrogram[m3] = pair;
        }
    }

    private void merge(LinkedPair closestPair) {
        int first = closestPair.getFirst();
        int second = closestPair.getSecond();
        for (int other = 0; other < this.numItems; ++other) {
            this.matrix[Math.min((int)first, (int)other)][Math.max((int)first, (int)other)] = this.link(this.getDistance(first, other), this.getDistance(second, other));
        }
    }

    private double link(double d1, double d2) {
        if (this.isScoreMatrix) {
            return Math.max(d1, d2);
        }
        return Math.min(d1, d2);
    }

    private double getDistance(int first, int second) {
        return this.matrix[Math.min(first, second)][Math.max(first, second)];
    }

    private void updateIndicesToCheck(int m3) {
        if (this.indicesToCheck == null) {
            this.indicesToCheck = new ArrayList(this.numItems);
            for (int i = 0; i < this.numItems; ++i) {
                this.indicesToCheck.add(i);
            }
        }
        if (m3 == 0) {
            return;
        }
        this.indicesToCheck.remove(new Integer(this.dendrogram[m3 - 1].getFirst()));
    }

    private LinkedPair getClosestPair() {
        LinkedPair closestPair = null;
        if (this.isScoreMatrix) {
            double max = 0.0;
            for (int i : this.indicesToCheck) {
                for (int j : this.indicesToCheck) {
                    if (j <= i || !(this.matrix[i][j] >= max)) continue;
                    max = this.matrix[i][j];
                    closestPair = new LinkedPair(i, j, max);
                }
            }
        } else {
            double min2 = Double.MAX_VALUE;
            for (int i : this.indicesToCheck) {
                for (int j : this.indicesToCheck) {
                    if (j <= i || !(this.matrix[i][j] <= min2)) continue;
                    min2 = this.matrix[i][j];
                    closestPair = new LinkedPair(i, j, min2);
                }
            }
        }
        return closestPair;
    }

    public Map<Integer, Set<Integer>> getClusters(double cutoff) {
        if (this.dendrogram == null) {
            this.clusterIt();
        }
        TreeMap clusters = new TreeMap();
        int clusterId = 1;
        for (int i = 0; i < this.numItems - 1; ++i) {
            if (this.isWithinCutoff(i, cutoff)) {
                Object members;
                int firstClusterId = -1;
                int secondClusterId = -1;
                Iterator iterator = clusters.keySet().iterator();
                while (iterator.hasNext()) {
                    int cId = (Integer)iterator.next();
                    members = (Set)clusters.get(cId);
                    if (members.contains(this.dendrogram[i].getFirst())) {
                        firstClusterId = cId;
                    }
                    if (!members.contains(this.dendrogram[i].getSecond())) continue;
                    secondClusterId = cId;
                }
                if (firstClusterId == -1 && secondClusterId == -1) {
                    TreeSet<Integer> members2 = new TreeSet<Integer>();
                    members2.add(this.dendrogram[i].getFirst());
                    members2.add(this.dendrogram[i].getSecond());
                    clusters.put(clusterId, members2);
                    ++clusterId;
                } else if (firstClusterId != -1 && secondClusterId == -1) {
                    ((Set)clusters.get(firstClusterId)).add(this.dendrogram[i].getSecond());
                } else if (secondClusterId != -1 && firstClusterId == -1) {
                    ((Set)clusters.get(secondClusterId)).add(this.dendrogram[i].getFirst());
                } else {
                    int member;
                    Set firstCluster = (Set)clusters.get(firstClusterId);
                    Set secondCluster = (Set)clusters.get(secondClusterId);
                    if (firstCluster.size() < secondCluster.size()) {
                        logger.debug("Joining cluster " + firstClusterId + " to cluster " + secondClusterId);
                        members = firstCluster.iterator();
                        while (members.hasNext()) {
                            member = (Integer)members.next();
                            secondCluster.add(member);
                        }
                        clusters.remove(firstClusterId);
                    } else {
                        logger.debug("Joining cluster " + secondClusterId + " to cluster " + firstClusterId);
                        members = secondCluster.iterator();
                        while (members.hasNext()) {
                            member = (Integer)members.next();
                            firstCluster.add(member);
                        }
                        clusters.remove(secondClusterId);
                    }
                }
                logger.debug("Within cutoff:     " + this.dendrogram[i]);
                continue;
            }
            logger.debug("Not within cutoff: " + this.dendrogram[i]);
        }
        TreeMap<Integer, Set<Integer>> finalClusters = new TreeMap<Integer, Set<Integer>>();
        int newClusterId = 1;
        Iterator secondClusterId = clusters.keySet().iterator();
        while (secondClusterId.hasNext()) {
            int oldClusterId = (Integer)secondClusterId.next();
            finalClusters.put(newClusterId, (Set)clusters.get(oldClusterId));
            ++newClusterId;
        }
        for (int i = 0; i < this.numItems; ++i) {
            boolean isAlreadyClustered = false;
            for (Set cluster : finalClusters.values()) {
                if (!cluster.contains(i)) continue;
                isAlreadyClustered = true;
                break;
            }
            if (isAlreadyClustered) continue;
            TreeSet<Integer> members = new TreeSet<Integer>();
            members.add(i);
            finalClusters.put(newClusterId, members);
            ++newClusterId;
        }
        logger.debug("Clusters: \n" + this.clustersToString(finalClusters));
        return finalClusters;
    }

    private boolean isWithinCutoff(int i, double cutoff) {
        if (this.isScoreMatrix) {
            return this.dendrogram[i].getClosestDistance() > cutoff;
        }
        return this.dendrogram[i].getClosestDistance() < cutoff;
    }

    private String clustersToString(Map<Integer, Set<Integer>> finalClusters) {
        StringBuilder sb = new StringBuilder();
        for (int cId : finalClusters.keySet()) {
            sb.append(cId).append(": ");
            for (int member : finalClusters.get(cId)) {
                sb.append(member).append(" ");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private String matrixToString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.numItems; ++i) {
            for (int j = 0; j < this.numItems; ++j) {
                if (i == j) {
                    sb.append(String.format("%6s ", "x"));
                    continue;
                }
                if (i < j) {
                    if (this.matrix[i][j] == Double.MAX_VALUE) {
                        sb.append(String.format("%6s ", "inf"));
                        continue;
                    }
                    sb.append(String.format(Locale.US, "%6.2f ", this.matrix[i][j]));
                    continue;
                }
                if (this.matrix[j][i] == Double.MAX_VALUE) {
                    sb.append(String.format("%6s ", "inf"));
                    continue;
                }
                sb.append(String.format(Locale.US, "%6.2f ", this.matrix[j][i]));
            }
            sb.append("\n");
        }
        sb.append("\n");
        return sb.toString();
    }

    private class LinkedPair {
        private int first;
        private int second;
        private double closestDistance;

        public LinkedPair(int first, int second, double minDistance) {
            this.first = first;
            this.second = second;
            this.closestDistance = minDistance;
        }

        public int getFirst() {
            return this.first;
        }

        public int getSecond() {
            return this.second;
        }

        public double getClosestDistance() {
            return this.closestDistance;
        }

        public String toString() {
            String closestDistStr = null;
            closestDistStr = this.closestDistance == Double.MAX_VALUE ? String.format("%6s", "inf") : String.format(Locale.US, "%6.2f", this.closestDistance);
            return "[" + this.first + "," + this.second + "-" + closestDistStr + "]";
        }
    }
}

