/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.genome.io.fastq;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import org.biojava.nbio.genome.io.fastq.Fastq;
import org.biojava.nbio.genome.io.fastq.FastqWriter;

abstract class AbstractFastqWriter
implements FastqWriter {
    AbstractFastqWriter() {
    }

    protected abstract Fastq convert(Fastq var1);

    @Override
    public final <T extends Appendable> T append(T appendable, Fastq ... fastq) throws IOException {
        return this.append(appendable, Arrays.asList(fastq));
    }

    @Override
    public final <T extends Appendable> T append(T appendable, Iterable<Fastq> fastq) throws IOException {
        if (appendable == null) {
            throw new IllegalArgumentException("appendable must not be null");
        }
        if (fastq == null) {
            throw new IllegalArgumentException("fastq must not be null");
        }
        for (Fastq f : fastq) {
            if (f == null) continue;
            Fastq converted = this.convert(f);
            appendable.append("@");
            appendable.append(converted.getDescription());
            appendable.append("\n");
            appendable.append(converted.getSequence());
            appendable.append("\n+\n");
            appendable.append(converted.getQuality());
            appendable.append("\n");
        }
        return appendable;
    }

    @Override
    public final void write(File file, Fastq ... fastq) throws IOException {
        this.write(file, Arrays.asList(fastq));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void write(File file, Iterable<Fastq> fastq) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("file must not be null");
        }
        if (fastq == null) {
            throw new IllegalArgumentException("fastq must not be null");
        }
        Writer writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(file));
            this.append(writer, fastq);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public final void write(OutputStream outputStream, Fastq ... fastq) throws IOException {
        this.write(outputStream, Arrays.asList(fastq));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void write(OutputStream outputStream, Iterable<Fastq> fastq) throws IOException {
        if (outputStream == null) {
            throw new IllegalArgumentException("outputStream must not be null");
        }
        if (fastq == null) {
            throw new IllegalArgumentException("fastq must not be null");
        }
        Writer writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter(outputStream));
            this.append(writer, fastq);
        }
        finally {
            if (writer != null) {
                try {
                    writer.flush();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

