/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.genome.io.fastq;

import java.util.ArrayList;
import java.util.List;
import org.biojava.nbio.adam.shaded.com.google.common.collect.ImmutableList;
import org.biojava.nbio.adam.shaded.com.google.common.collect.Lists;
import org.biojava.nbio.core.exceptions.CompoundNotFoundException;
import org.biojava.nbio.core.sequence.DNASequence;
import org.biojava.nbio.core.sequence.compound.NucleotideCompound;
import org.biojava.nbio.core.sequence.features.QualityFeature;
import org.biojava.nbio.core.sequence.features.QuantityFeature;
import org.biojava.nbio.core.sequence.template.AbstractSequence;
import org.biojava.nbio.genome.io.fastq.Fastq;
import org.biojava.nbio.genome.io.fastq.FastqVariant;

public final class FastqTools {
    private FastqTools() {
    }

    public static DNASequence createDNASequence(Fastq fastq) throws CompoundNotFoundException {
        if (fastq == null) {
            throw new IllegalArgumentException("fastq must not be null");
        }
        DNASequence sequence = new DNASequence(fastq.getSequence());
        sequence.setOriginalHeader(fastq.getDescription());
        return sequence;
    }

    public static DNASequence createDNASequenceWithQualityScores(Fastq fastq) throws CompoundNotFoundException {
        DNASequence sequence = FastqTools.createDNASequence(fastq);
        sequence.addFeature(1, sequence.getLength(), FastqTools.createQualityScores(fastq));
        return sequence;
    }

    public static DNASequence createDNASequenceWithErrorProbabilities(Fastq fastq) throws CompoundNotFoundException {
        DNASequence sequence = FastqTools.createDNASequence(fastq);
        sequence.addFeature(1, sequence.getLength(), FastqTools.createErrorProbabilities(fastq));
        return sequence;
    }

    public static DNASequence createDNASequenceWithQualityScoresAndErrorProbabilities(Fastq fastq) throws CompoundNotFoundException {
        DNASequence sequence = FastqTools.createDNASequence(fastq);
        sequence.addFeature(1, sequence.getLength(), FastqTools.createQualityScores(fastq));
        sequence.addFeature(1, sequence.getLength(), FastqTools.createErrorProbabilities(fastq));
        return sequence;
    }

    public static QualityFeature<AbstractSequence<NucleotideCompound>, NucleotideCompound> createQualityScores(Fastq fastq) {
        if (fastq == null) {
            throw new IllegalArgumentException("fastq must not be null");
        }
        QualityFeature<AbstractSequence<NucleotideCompound>, NucleotideCompound> qualityScores = new QualityFeature<AbstractSequence<NucleotideCompound>, NucleotideCompound>("qualityScores", "sequencing");
        qualityScores.setQualities(FastqTools.toList(FastqTools.qualityScores(fastq)));
        return qualityScores;
    }

    public static QuantityFeature<AbstractSequence<NucleotideCompound>, NucleotideCompound> createErrorProbabilities(Fastq fastq) {
        if (fastq == null) {
            throw new IllegalArgumentException("fastq must not be null");
        }
        QuantityFeature<AbstractSequence<NucleotideCompound>, NucleotideCompound> errorProbabilities = new QuantityFeature<AbstractSequence<NucleotideCompound>, NucleotideCompound>("errorProbabilities", "sequencing");
        errorProbabilities.setQuantities(FastqTools.toList(FastqTools.errorProbabilities(fastq)));
        return errorProbabilities;
    }

    public static Iterable<Number> qualityScores(Fastq fastq) {
        if (fastq == null) {
            throw new IllegalArgumentException("fastq must not be null");
        }
        int size = fastq.getQuality().length();
        ArrayList<Integer> qualityScores = Lists.newArrayListWithExpectedSize(size);
        FastqVariant variant = fastq.getVariant();
        for (int i = 0; i < size; ++i) {
            char c = fastq.getQuality().charAt(i);
            qualityScores.add(variant.qualityScore(c));
        }
        return ImmutableList.copyOf(qualityScores);
    }

    public static int[] qualityScores(Fastq fastq, int[] qualityScores) {
        if (fastq == null) {
            throw new IllegalArgumentException("fastq must not be null");
        }
        if (qualityScores == null) {
            throw new IllegalArgumentException("qualityScores must not be null");
        }
        int size = fastq.getQuality().length();
        if (qualityScores.length != size) {
            throw new IllegalArgumentException("qualityScores must be the same length as the FASTQ formatted sequence quality");
        }
        FastqVariant variant = fastq.getVariant();
        for (int i = 0; i < size; ++i) {
            char c = fastq.getQuality().charAt(i);
            qualityScores[i] = variant.qualityScore(c);
        }
        return qualityScores;
    }

    public static Iterable<Number> errorProbabilities(Fastq fastq) {
        if (fastq == null) {
            throw new IllegalArgumentException("fastq must not be null");
        }
        int size = fastq.getQuality().length();
        ArrayList<Double> errorProbabilities = Lists.newArrayListWithExpectedSize(size);
        FastqVariant variant = fastq.getVariant();
        for (int i = 0; i < size; ++i) {
            char c = fastq.getQuality().charAt(i);
            errorProbabilities.add(variant.errorProbability(c));
        }
        return ImmutableList.copyOf(errorProbabilities);
    }

    public static double[] errorProbabilities(Fastq fastq, double[] errorProbabilities) {
        if (fastq == null) {
            throw new IllegalArgumentException("fastq must not be null");
        }
        if (errorProbabilities == null) {
            throw new IllegalArgumentException("errorProbabilities must not be null");
        }
        int size = fastq.getQuality().length();
        if (errorProbabilities.length != size) {
            throw new IllegalArgumentException("errorProbabilities must be the same length as the FASTQ formatted sequence quality");
        }
        FastqVariant variant = fastq.getVariant();
        for (int i = 0; i < size; ++i) {
            char c = fastq.getQuality().charAt(i);
            errorProbabilities[i] = variant.errorProbability(c);
        }
        return errorProbabilities;
    }

    public static Fastq convert(Fastq fastq, FastqVariant variant) {
        if (fastq == null) {
            throw new IllegalArgumentException("fastq must not be null");
        }
        if (variant == null) {
            throw new IllegalArgumentException("variant must not be null");
        }
        if (fastq.getVariant().equals((Object)variant)) {
            return fastq;
        }
        return new Fastq(fastq.getDescription(), fastq.getSequence(), FastqTools.convertQualities(fastq, variant), variant);
    }

    static String convertQualities(Fastq fastq, FastqVariant variant) {
        if (fastq == null) {
            throw new IllegalArgumentException("fastq must not be null");
        }
        if (variant == null) {
            throw new IllegalArgumentException("variant must not be null");
        }
        if (fastq.getVariant().equals((Object)variant)) {
            return fastq.getQuality();
        }
        int size = fastq.getQuality().length();
        double[] errorProbabilities = FastqTools.errorProbabilities(fastq, new double[size]);
        StringBuilder sb = new StringBuilder(size);
        for (int i = 0; i < size; ++i) {
            sb.append(variant.quality(variant.qualityScore(errorProbabilities[i])));
        }
        return sb.toString();
    }

    static <T> List<T> toList(Iterable<? extends T> iterable) {
        if (iterable instanceof List) {
            return (List)iterable;
        }
        return ImmutableList.copyOf(iterable);
    }
}

