/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.genome.parsers.genename;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.biojava.nbio.core.util.InputStreamProvider;
import org.biojava.nbio.genome.parsers.genename.GeneName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneNamesParser {
    private static final Logger logger = LoggerFactory.getLogger(GeneNamesParser.class);
    public static final String DEFAULT_GENENAMES_URL = "https://www.genenames.org/cgi-bin/download?title=HGNC+output+data&hgnc_dbtag=on&col=gd_app_sym&col=gd_app_name&col=gd_status&col=gd_prev_sym&col=gd_prev_name&col=gd_aliases&col=gd_pub_chrom_map&col=gd_pub_acc_ids&col=md_mim_id&col=gd_pub_refseq_ids&col=md_ensembl_id&col=md_prot_id&col=gd_hgnc_id&status=Approved&status_opt=2&where=((gd_pub_chrom_map%20not%20like%20%27%patch%%27%20and%20gd_pub_chrom_map%20not%20like%20%27%ALT_REF%%27)%20or%20gd_pub_chrom_map%20IS%20NULL)%20and%20gd_locus_group%20%3d%20%27protein-coding%20gene%27&order_by=gd_app_sym_sort&format=text&limit=&submit=submit&.cgifields=&.cgifields=chr&.cgifields=status&.cgifields=hgnc_dbtag";

    public static void main(String[] args) {
        try {
            List<GeneName> geneNames = GeneNamesParser.getGeneNames();
            logger.info("got {} gene names", (Object)geneNames.size());
            for (GeneName g2 : geneNames) {
                if (!g2.getApprovedSymbol().equals("FOLH1")) continue;
                logger.info("Gene Name: {}", (Object)g2);
            }
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
        }
    }

    public static List<GeneName> getGeneNames() throws IOException {
        URL url = new URL(DEFAULT_GENENAMES_URL);
        InputStreamProvider prov = new InputStreamProvider();
        InputStream inStream = prov.getInputStream(url);
        return GeneNamesParser.getGeneNames(inStream);
    }

    public static List<GeneName> getGeneNames(InputStream inStream) throws IOException {
        ArrayList<GeneName> geneNames = new ArrayList<GeneName>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inStream));
        String line = reader.readLine();
        while ((line = reader.readLine()) != null) {
            GeneName geneName = GeneNamesParser.getGeneName(line);
            if (geneName == null) continue;
            geneNames.add(geneName);
        }
        geneNames.trimToSize();
        return geneNames;
    }

    private static GeneName getGeneName(String line) {
        if (line == null) {
            return null;
        }
        String[] s2 = line.split("\t");
        if (s2.length != 13) {
            logger.warn("Line does not contain 13 data items, but {}: {}", (Object)s2.length, (Object)line);
            logger.warn(line.replaceAll("\t", "|---|"));
            return null;
        }
        GeneName gn = new GeneName();
        gn.setApprovedSymbol(s2[0]);
        gn.setApprovedName(s2[1]);
        gn.setStatus(s2[2]);
        gn.setPreviousSymbols(s2[3]);
        gn.setPreviousNames(s2[4]);
        gn.setSynonyms(s2[5]);
        gn.setChromosome(s2[6]);
        gn.setAccessionNr(s2[7]);
        gn.setOmimId(s2[8]);
        gn.setRefseqIds(s2[9]);
        gn.setEnsemblGeneId(s2[10]);
        gn.setUniprot(s2[11]);
        gn.setHgncId(s2[12]);
        return gn;
    }
}

