/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.genome.parsers.gff;

import java.util.HashMap;
import org.biojava.nbio.genome.parsers.gff.FeatureI;
import org.biojava.nbio.genome.parsers.gff.Location;

public class Feature
implements FeatureI {
    private Location mLocation;
    private String mSeqname;
    private String mSource;
    private String mType;
    private double mScore;
    private int mFrame;
    private String mAttributes;
    private HashMap<String, String> mUserMap;
    HashMap<String, String> attributeHashMap = new HashMap();

    @Override
    public String seqname() {
        return this.mSeqname;
    }

    public String source() {
        return this.mSource;
    }

    @Override
    public String type() {
        return this.mType;
    }

    @Override
    public Location location() {
        return this.mLocation;
    }

    public double score() {
        return this.mScore;
    }

    public int frame() {
        return this.mFrame;
    }

    public String attributes() {
        return this.mAttributes;
    }

    private Feature() {
    }

    public Feature(Feature feature) {
        this.mSeqname = feature.mSeqname;
        this.mSource = feature.mSource;
        this.mType = feature.mType;
        this.mLocation = feature.mLocation;
        this.mScore = feature.mScore;
        this.mFrame = feature.mFrame;
        this.mAttributes = feature.mAttributes;
        this.initAttributeHashMap();
        this.mUserMap = new HashMap<String, String>(feature.mUserMap);
    }

    public Feature(String seqname, String source, String type, Location location, Double score, int frame, String attributes) {
        this.mSeqname = seqname;
        this.mSource = source;
        this.mType = type;
        this.mLocation = location;
        this.mScore = score;
        this.mFrame = frame;
        this.mAttributes = attributes;
        this.initAttributeHashMap();
        this.mUserMap = new HashMap();
    }

    @Override
    public HashMap<String, String> userData() {
        return this.mUserMap;
    }

    private void initAttributeHashMap() {
        String[] values;
        for (String attribute : values = this.mAttributes.split(";")) {
            attribute = attribute.trim();
            int equalindex = attribute.indexOf("=");
            String splitData = "=";
            if (equalindex == -1) {
                splitData = " ";
            }
            String[] data = attribute.split(splitData);
            String value = "";
            if (data.length >= 2 && data[1].indexOf(34) != -1) {
                value = data[1].replaceAll("\"", "").trim();
            } else if (data.length >= 2) {
                value = data[1].trim();
            }
            this.attributeHashMap.put(data[0].trim(), value);
        }
    }

    @Override
    public String getAttribute(String key) {
        return this.attributeHashMap.get(key);
    }

    public String getAttributeOld(String key) {
        int start = 0;
        int end = this.mAttributes.indexOf(59);
        while (0 < end) {
            int i = this.mAttributes.indexOf(32, start);
            if (0 < i && i < end && this.mAttributes.substring(start, i).equals(key)) {
                if (this.mAttributes.charAt(i + 1) == '\"' && this.mAttributes.charAt(end - 1) == '\"') {
                    return this.mAttributes.substring(i + 2, end - 1);
                }
                return this.mAttributes.substring(i + 1, end);
            }
            start = end + 2;
            end = this.mAttributes.indexOf(59, start);
        }
        return null;
    }

    @Override
    public boolean hasAttribute(String key) {
        return this.attributeHashMap.containsKey(key);
    }

    @Override
    public boolean hasAttribute(String key, String value) {
        String data = this.getAttribute(key);
        if (data == null) {
            return false;
        }
        return data.equals(value);
    }

    @Override
    public String group() {
        int i = this.mAttributes.indexOf(59);
        return i < 0 ? this.mAttributes.trim() : this.mAttributes.substring(0, i).trim();
    }

    @Override
    public String toString() {
        String s2 = this.mSeqname + '\t';
        s2 = s2 + this.mSource + '\t';
        s2 = s2 + this.mType + '\t';
        s2 = s2 + this.mLocation.start() + "\t";
        s2 = s2 + this.mLocation.end() + "\t";
        s2 = s2 + Double.toString(this.mScore) + "\t";
        s2 = this.mFrame == -1 ? s2 + ".\t" : s2 + this.mFrame + "\t";
        s2 = s2 + this.mAttributes;
        return s2;
    }

    @Override
    public HashMap<String, String> getAttributes() {
        return this.attributeHashMap;
    }
}

