/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.genome.parsers.gff;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.biojava.nbio.genome.parsers.gff.Feature;
import org.biojava.nbio.genome.parsers.gff.FeatureList;
import org.biojava.nbio.genome.parsers.gff.Location;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GFF3Reader {
    private static final Logger logger = LoggerFactory.getLogger(GFF3Reader.class);
    private static final Pattern p = Pattern.compile("\t");

    public static FeatureList read(String filename, List<String> indexes) throws IOException {
        return GFF3Reader.read(Paths.get(filename, new String[0]), indexes);
    }

    public static FeatureList read(Path path, List<String> indexes) throws IOException {
        logger.info("Reading: {}", (Object)path.toString());
        FeatureList features = new FeatureList();
        features.addIndexes(indexes);
        BufferedReader br = Files.newBufferedReader(path);
        String s2 = br.readLine();
        while (null != s2) {
            if ((s2 = s2.trim()).length() > 0) {
                if (s2.charAt(0) == '#') {
                    if (s2.startsWith("##fasta")) {
                        break;
                    }
                } else {
                    Feature f = GFF3Reader.parseLine(s2);
                    if (f != null) {
                        features.add(f);
                    }
                }
            }
            s2 = br.readLine();
        }
        br.close();
        return features;
    }

    public static FeatureList read(String filename) throws IOException {
        return GFF3Reader.read(filename, new ArrayList<String>(0));
    }

    public static FeatureList read(Path path) throws IOException {
        return GFF3Reader.read(path, new ArrayList<String>(0));
    }

    private static Feature parseLine(String s2) {
        int frame;
        Double score;
        String[] line = p.split(s2);
        String seqname = line[0].trim();
        String source = line[1].trim();
        String type = line[2].trim();
        String locStart = line[3].trim();
        String locEnd = line[4].trim();
        try {
            score = Double.parseDouble(line[5].trim());
        }
        catch (Exception e) {
            score = 0.0;
        }
        char strand = line[6].trim().charAt(0);
        int locationStart = Integer.parseInt(locStart);
        int locationEnd = Integer.parseInt(locEnd);
        if (locationStart > locationEnd) {
            int temp = locationStart;
            locationStart = locationEnd;
            locationEnd = temp;
        }
        Location location = Location.fromBio(locationStart, locationEnd, strand);
        assert (strand == '-' == location.isNegative());
        try {
            frame = Integer.parseInt(line[7].trim());
        }
        catch (Exception e) {
            frame = -1;
        }
        String attributes = line[8];
        return new Feature(seqname, source, type, location, score, frame, attributes.split("#")[0]);
    }

    public static void main(String[] args) throws Exception {
        long start = System.currentTimeMillis();
        FeatureList listGenes = GFF3Reader.read("/home/melo/workspace/release/stdout.combined.checked2.gtf");
        long stop = System.currentTimeMillis();
        logger.info("Loading = {}", (Object)(stop - start));
    }
}

