/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.genome.parsers.gff;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import org.biojava.nbio.core.sequence.CDSSequence;
import org.biojava.nbio.core.sequence.ChromosomeSequence;
import org.biojava.nbio.core.sequence.GeneSequence;
import org.biojava.nbio.core.sequence.SequenceComparator;
import org.biojava.nbio.core.sequence.TranscriptSequence;
import org.biojava.nbio.genome.GeneFeatureHelper;

public class GFF3Writer {
    public void write(OutputStream outputStream, LinkedHashMap<String, ChromosomeSequence> chromosomeSequenceList) throws Exception {
        outputStream.write("##gff-version 3\n".getBytes());
        for (String key : chromosomeSequenceList.keySet()) {
            ChromosomeSequence chromosomeSequence = chromosomeSequenceList.get(key);
            String gff3line = "";
            for (GeneSequence geneSequence : chromosomeSequence.getGeneSequences().values()) {
                gff3line = key + "\t" + geneSequence.getSource() + "\tgene\t" + geneSequence.getBioBegin() + "\t" + geneSequence.getBioEnd() + "\t";
                Double score = geneSequence.getSequenceScore();
                gff3line = score == null ? gff3line + ".\t" : gff3line + score + "\t";
                gff3line = gff3line + geneSequence.getStrand().getStringRepresentation() + "\t";
                gff3line = gff3line + ".\t";
                gff3line = gff3line + "ID=" + geneSequence.getAccession().getID() + ";Name=" + geneSequence.getAccession().getID();
                gff3line = gff3line + this.getGFF3Note(geneSequence.getNotesList());
                gff3line = gff3line + "\n";
                outputStream.write(gff3line.getBytes());
                int transcriptIndex = 0;
                for (TranscriptSequence transcriptSequence : geneSequence.getTranscripts().values()) {
                    gff3line = key + "\t" + transcriptSequence.getSource() + "\tmRNA\t" + transcriptSequence.getBioBegin() + "\t" + transcriptSequence.getBioEnd() + "\t";
                    score = transcriptSequence.getSequenceScore();
                    gff3line = score == null ? gff3line + ".\t" : gff3line + score + "\t";
                    gff3line = gff3line + transcriptSequence.getStrand().getStringRepresentation() + "\t";
                    gff3line = gff3line + ".\t";
                    String id = geneSequence.getAccession().getID() + "." + ++transcriptIndex;
                    gff3line = gff3line + "ID=" + id + ";Parent=" + geneSequence.getAccession().getID() + ";Name=" + id;
                    gff3line = gff3line + this.getGFF3Note(transcriptSequence.getNotesList());
                    gff3line = gff3line + "\n";
                    outputStream.write(gff3line.getBytes());
                    String transcriptParentName = geneSequence.getAccession().getID() + "." + transcriptIndex;
                    ArrayList<CDSSequence> cdsSequenceList = new ArrayList<CDSSequence>(transcriptSequence.getCDSSequences().values());
                    Collections.sort(cdsSequenceList, new SequenceComparator());
                    for (CDSSequence cdsSequence : cdsSequenceList) {
                        gff3line = key + "\t" + cdsSequence.getSource() + "\tCDS\t" + cdsSequence.getBioBegin() + "\t" + cdsSequence.getBioEnd() + "\t";
                        score = cdsSequence.getSequenceScore();
                        gff3line = score == null ? gff3line + ".\t" : gff3line + score + "\t";
                        gff3line = gff3line + cdsSequence.getStrand().getStringRepresentation() + "\t";
                        gff3line = gff3line + cdsSequence.getPhase() + "\t";
                        gff3line = gff3line + "ID=" + cdsSequence.getAccession().getID() + ";Parent=" + transcriptParentName;
                        gff3line = gff3line + this.getGFF3Note(cdsSequence.getNotesList());
                        gff3line = gff3line + "\n";
                        outputStream.write(gff3line.getBytes());
                    }
                }
            }
        }
    }

    private String getGFF3Note(ArrayList<String> notesList) {
        String notes = "";
        if (notesList.size() > 0) {
            notes = ";Note=";
            int noteindex = 1;
            for (String note : notesList) {
                notes = notes + note;
                if (noteindex >= notesList.size() - 1) continue;
                notes = notes + " ";
            }
        }
        return notes;
    }

    public static void main(String[] args) throws Exception {
        FileOutputStream fo = new FileOutputStream("/Users/Scooter/scripps/dyadic/geneid/geneid/c1-geneid.gff3");
        LinkedHashMap<String, ChromosomeSequence> dnaSequenceList = GeneFeatureHelper.loadFastaAddGeneFeaturesFromGeneIDGFF2(new File("/Users/Scooter/scripps/dyadic/analysis/454Scaffolds/454Scaffolds.fna"), new File("/Users/Scooter/scripps/dyadic/geneid/geneid/c1_geneid.gff"));
        GFF3Writer gff3Writer = new GFF3Writer();
        gff3Writer.write(fo, dnaSequenceList);
        fo.close();
    }
}

